/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.reports.pointintimedata.BasePointInTimeDataReports;
import org.unitime.timetable.util.Constants;

public class RoomUtilization
extends BasePointInTimeDataReports {
    protected ArrayList<Long> iDepartmentIds;
    protected ArrayList<Long> iRoomTypeIds;

    public RoomUtilization() {
        this.getParameters().add(BasePointInTimeDataReports.Parameter.DEPARTMENTS);
        this.getParameters().add(BasePointInTimeDataReports.Parameter.RoomTypes);
    }

    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnRoomDepartmentCode());
        hdr.add(MSG.columnRoomDepartmentAbbreviation());
        hdr.add(MSG.columnRoomDepartmentName());
        hdr.add(MSG.columnBuilding());
        hdr.add(MSG.columnRoom());
        hdr.add(MSG.columnRoomType());
        hdr.add(MSG.columnCapacity());
        hdr.add(MSG.columnStationHours());
        hdr.add(MSG.columnOccupancy());
        hdr.add(MSG.columnOrganizedWeeklyRoomHours());
        hdr.add(MSG.columnNotOrganizedWeeklyRoomHours());
        hdr.add(MSG.columnWeeklyRoomHours());
        hdr.add(MSG.columnOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnWeeklyStudentClassHours());
        this.setHeader(hdr);
    }

    @Override
    public String reportName() {
        return MSG.roomUtilizationReport();
    }

    @Override
    public String reportDescription() {
        return MSG.roomUtilizationReportNote();
    }

    private void addRowForLocation(Location location, LocationHours locationHours) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(location.getControllingDepartment() == null ? "" : location.getControllingDepartment().getDeptCode());
        row.add(location.getControllingDepartment() == null ? "" : location.getControllingDepartment().getAbbreviation());
        row.add(location.getControllingDepartment() == null ? "" : location.getControllingDepartment().getName());
        if (location instanceof NonUniversityLocation) {
            NonUniversityLocation nul = (NonUniversityLocation)location;
            row.add(nul.getName());
            row.add("");
        } else {
            Room r = (Room)location;
            row.add(r.getBuildingAbbv());
            row.add(r.getRoomNumber());
        }
        row.add(location.getRoomTypeLabel());
        row.add(location.getCapacity().toString());
        row.add(Float.toString((float)location.getCapacity().intValue() * locationHours.getWeeklyRoomHours()));
        row.add(Float.toString(locationHours.getWeeklyStudentClassHours() / ((float)location.getCapacity().intValue() * locationHours.getWeeklyRoomHours())));
        row.add(Float.toString(locationHours.getOrganizedWeeklyRoomHours()));
        row.add(Float.toString(locationHours.getNotOrganizedWeeklyRoomHours()));
        row.add(Float.toString(locationHours.getWeeklyRoomHours()));
        row.add(Float.toString(locationHours.getOrganizedWeeklyStudentClassHours()));
        row.add(Float.toString(locationHours.getNotOrganizedWeeklyStudentClassHours()));
        row.add(Float.toString(locationHours.getWeeklyStudentClassHours()));
        this.addDataRow(row);
    }

    public void createRoomUtilizationReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        HashMap<Long, LocationHours> locationUtilization = new HashMap<Long, LocationHours>();
        HashSet<Long> processedClassIds = new HashSet<Long>();
        for (Long deptId : this.getDepartmentIds()) {
            for (PitClass pc : this.findAllPitClassesWithContactHoursForRoomDepartmentAndRoomTypes(deptId, pointInTimeData, hibSession)) {
                if (processedClassIds.contains(pc.getUniqueId())) continue;
                processedClassIds.add(pc.getUniqueId());
                for (Long locationPermanentId : pc.getLocationPermanentIdList()) {
                    LocationHours lh = (LocationHours)locationUtilization.get(locationPermanentId);
                    if (lh == null) {
                        lh = new LocationHours(locationPermanentId, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                        locationUtilization.put(locationPermanentId, lh);
                    }
                    lh.addRoomHours(pc);
                }
            }
        }
        if (pointInTimeData.getSession().getRooms() != null && !pointInTimeData.getSession().getRooms().isEmpty()) {
            HashSet<Location> locations = new HashSet<Location>();
            locations.addAll(pointInTimeData.getSession().getRooms());
            for (Location l : locations) {
                LocationHours lh = (LocationHours)locationUtilization.get(l.getPermanentId());
                if (lh != null && l.getControllingDepartment() != null && this.getDepartmentIds().contains(l.getControllingDepartment().getUniqueId()) && this.getRoomTypeIds().contains(l.getRoomType().getUniqueId())) {
                    this.addRowForLocation(l, lh);
                    continue;
                }
                if (lh == null || l.getControllingDepartment() != null || !this.getRoomTypeIds().contains(l.getRoomType().getUniqueId())) continue;
                this.addRowForLocation(l, lh);
            }
        }
    }

    protected List<PitClass> findAllPitClassesWithContactHoursForRoomDepartmentAndRoomTypes(Long departmentId, PointInTimeData pointInTimeData, Session hibSession) {
        StringBuilder sb = new StringBuilder();
        sb.append("select pc ").append(" from PitClass pc ").append(" where pc.uniqueId in ( select pcm.pitClassEvent.pitClass.uniqueId from PitClassMeeting pcm, Location l inner join l.roomDepts as rd  where pcm.pitClassEvent.pitClass.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pointInTimeData.uniqueId = :pitdUid").append(" and pcm.locationPermanentId = l.permanentId").append(" and l.session.uniqueId = pcm.pitClassEvent.pitClass.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pointInTimeData.session.uniqueId").append(" and rd.department.uniqueId = :deptId").append(" and l.roomType.uniqueId in ( ");
        boolean first = true;
        for (Long rtId : this.getRoomTypeIds()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(rtId.toString());
        }
        sb.append(" ) ) ");
        return hibSession.createQuery(sb.toString(), PitClass.class).setParameter("pitdUid", (Object)pointInTimeData.getUniqueId()).setParameter("deptId", (Object)departmentId).setCacheable(true).list();
    }

    @Override
    protected void parseParameters() {
        super.parseParameters();
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENTS).size() >= 1) {
            this.setDepartmentIds(this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENTS));
        }
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.RoomTypes).size() >= 1) {
            this.setRoomTypeIds(this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.RoomTypes));
        }
    }

    @Override
    protected void runReport(Session hibSession) {
        PointInTimeData pitd = (PointInTimeData)hibSession.createQuery("from PointInTimeData pitd where pitd.uniqueId = :uid", PointInTimeData.class).setParameter("uid", (Object)this.getPointInTimeDataUniqueId()).uniqueResult();
        this.createRoomUtilizationReportFor(pitd, hibSession);
    }

    public ArrayList<Long> getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(ArrayList<Object> departmentIds) {
        this.iDepartmentIds = new ArrayList();
        for (Object o : departmentIds) {
            this.iDepartmentIds.add((Long)o);
        }
    }

    public ArrayList<Long> getRoomTypeIds() {
        return this.iRoomTypeIds;
    }

    public void setRoomTypeIds(ArrayList<Object> roomTypeIds) {
        this.iRoomTypeIds = new ArrayList();
        for (Object o : roomTypeIds) {
            this.iRoomTypeIds.add((Long)o);
        }
    }

    protected class LocationHours {
        private float iWeeklyStudentClassHours = 0.0f;
        private float iOrganizedWeeklyStudentClassHours = 0.0f;
        private float iNotOrganizedWeeklyStudentClassHours = 0.0f;
        private Long iLocationPermanentId;
        private HashSet<Date> organizedPeriods = new HashSet();
        private HashSet<Date> notOrganizedPeriods = new HashSet();
        private HashSet<Date> allPeriods = new HashSet();
        private Float iStandardMinutesInReportingHour;
        private Float iStandardWeeksInReportingTerm;
        private HashSet<Long> classIds = new HashSet();

        public Long getLocationPermanentId() {
            return this.iLocationPermanentId;
        }

        public float getOrganizedWeeklyRoomHours() {
            return (float)Constants.SLOT_LENGTH_MIN * 1.0f * (float)this.organizedPeriods.size() / this.iStandardMinutesInReportingHour.floatValue() / this.iStandardWeeksInReportingTerm.floatValue();
        }

        public float getNotOrganizedWeeklyRoomHours() {
            return (float)Constants.SLOT_LENGTH_MIN * 1.0f * (float)this.notOrganizedPeriods.size() / this.iStandardMinutesInReportingHour.floatValue() / this.iStandardWeeksInReportingTerm.floatValue();
        }

        public float getOrganizedWeeklyStudentClassHours() {
            return this.iOrganizedWeeklyStudentClassHours;
        }

        public float getNotOrganizedWeeklyStudentClassHours() {
            return this.iNotOrganizedWeeklyStudentClassHours;
        }

        public float getWeeklyRoomHours() {
            return (float)Constants.SLOT_LENGTH_MIN * 1.0f * (float)this.allPeriods.size() / this.iStandardMinutesInReportingHour.floatValue() / this.iStandardWeeksInReportingTerm.floatValue();
        }

        public float getWeeklyStudentClassHours() {
            return this.iWeeklyStudentClassHours;
        }

        public LocationHours(Long locationPermanentId, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
            this.iLocationPermanentId = locationPermanentId;
            this.iStandardMinutesInReportingHour = standardMinutesInReportingHour;
            this.iStandardWeeksInReportingTerm = standardWeeksInReportingTerm;
        }

        private void addPeriods(PitClass pitClass) {
            if (pitClass.getPeriodsForLocation(this.getLocationPermanentId()) != null) {
                if (pitClass.isOrganized()) {
                    this.organizedPeriods.addAll(pitClass.getPeriodsForLocation(this.getLocationPermanentId()));
                } else {
                    this.notOrganizedPeriods.addAll(pitClass.getPeriodsForLocation(this.getLocationPermanentId()));
                }
                this.allPeriods.addAll(pitClass.getPeriodsForLocation(this.getLocationPermanentId()));
            }
        }

        public void addRoomHours(PitClass pitClass) {
            if (this.classIds.contains(pitClass.getUniqueId())) {
                throw new Error("Counted class twice:  " + pitClass.getUniqueId().toString());
            }
            this.classIds.add(pitClass.getUniqueId());
            this.addPeriods(pitClass);
            this.iWeeklyStudentClassHours += pitClass.getAllWeeklyStudentClassHoursForLocation(this.getLocationPermanentId(), this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm);
            this.iOrganizedWeeklyStudentClassHours += pitClass.getOrganizedWeeklyStudentClassHoursForLocation(this.getLocationPermanentId(), this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm);
            this.iNotOrganizedWeeklyStudentClassHours += pitClass.getNotOrganizedWeeklyStudentClassHoursForLocation(this.getLocationPermanentId(), this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm);
        }
    }
}

