/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.cpsolver.ifs.util.DistanceMetric;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseTravelTime;
import org.unitime.timetable.model.dao.TravelTimeDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="travel_time")
public class TravelTime
extends BaseTravelTime {
    private static final long serialVersionUID = -5810111960278939304L;

    public static void populateTravelTimes(DistanceMetric metric, Long sessionId, Session hibSession) {
        for (TravelTime time : hibSession.createQuery("from TravelTime where session.uniqueId = :sessionId", TravelTime.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            metric.addTravelTime(time.getLocation1Id(), time.getLocation2Id(), time.getDistance());
        }
    }

    public static void populateTravelTimes(DistanceMetric metric, Long sessionId) {
        Session hibSession = TravelTimeDAO.getInstance().createNewSession();
        TravelTime.populateTravelTimes(metric, sessionId, hibSession);
        hibSession.close();
    }

    public static void populateTravelTimes(DistanceMetric metric, Session hibSession) {
        for (TravelTime time : hibSession.createQuery("from TravelTime", TravelTime.class).setCacheable(true).list()) {
            metric.addTravelTime(time.getLocation1Id(), time.getLocation2Id(), time.getDistance());
        }
    }

    public static void populateTravelTimes(DistanceMetric metric) {
        Session hibSession = TravelTimeDAO.getInstance().createNewSession();
        TravelTime.populateTravelTimes(metric, hibSession);
        hibSession.close();
    }
}

