/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseEvent;
import org.unitime.timetable.model.base.BaseMeeting;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="event")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="event_type", discriminatorType=DiscriminatorType.INTEGER)
public abstract class Event
extends BaseEvent
implements Comparable<Event> {
    private static final long serialVersionUID = 1L;
    public static final int sEventTypeClass = 0;
    public static final int sEventTypeFinalExam = 1;
    public static final int sEventTypeMidtermExam = 2;
    public static final int sEventTypeCourse = 3;
    public static final int sEventTypeSpecial = 4;
    public static final int sEventTypeUnavailable = 5;
    public static final String[] sEventTypes = new String[]{"Class Event", "Final Examination Event", "Midterm Examination Event", "Course Related Event", "Special Event", "Not Available Event"};
    public static final String[] sEventTypesAbbv = new String[]{"Class", "Final Exam", "Midterm Exam", "Course", "Special", "Not Available"};

    public Event() {
    }

    public Event(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public abstract int getEventType();

    @Transient
    public String getEventTypeLabel() {
        return sEventTypes[this.getEventType()];
    }

    @Transient
    public String getEventTypeAbbv() {
        return sEventTypesAbbv[this.getEventType()];
    }

    @Transient
    public abstract Set<Student> getStudents();

    @Transient
    public abstract Collection<StudentClassEnrollment> getStudentClassEnrollments();

    @Transient
    public abstract Collection<Long> getStudentIds();

    @Transient
    public abstract Set<DepartmentalInstructor> getInstructors();

    public static void deleteFromEvents(org.hibernate.Session hibSession, Integer ownerType, Long ownerId) {
        for (RelatedCourseInfo relatedCourse : hibSession.createQuery("select r from CourseEvent e inner join e.relatedCourses r where r.ownerType=:ownerType and r.ownerId=:ownerId", RelatedCourseInfo.class).setParameter("ownerType", (Object)ownerType).setParameter("ownerId", (Object)ownerId).list()) {
            CourseEvent event = relatedCourse.getEvent();
            event.getRelatedCourses().remove(relatedCourse);
            relatedCourse.setOwnerId(null);
            relatedCourse.setCourse(null);
            hibSession.remove((Object)relatedCourse);
            hibSession.merge((Object)event);
        }
    }

    public static void deleteFromEvents(org.hibernate.Session hibSession, Class_ clazz) {
        Event.deleteFromEvents(hibSession, 3, clazz.getUniqueId());
    }

    public static void deleteFromEvents(org.hibernate.Session hibSession, InstrOfferingConfig config) {
        Event.deleteFromEvents(hibSession, 2, config.getUniqueId());
    }

    public static void deleteFromEvents(org.hibernate.Session hibSession, InstructionalOffering offering) {
        Event.deleteFromEvents(hibSession, 0, offering.getUniqueId());
    }

    public static void deleteFromEvents(org.hibernate.Session hibSession, CourseOffering course) {
        Event.deleteFromEvents(hibSession, 1, course.getUniqueId());
    }

    @Override
    public String toString() {
        return this.getEventName();
    }

    public String eventCapacityDisplayString() {
        Object s = "";
        if (this.getMinCapacity() != null) {
            s = (String)s + this.getMinCapacity().toString();
            if (!this.getMaxCapacity().equals(this.getMinCapacity())) {
                s = (String)s + "-" + this.getMaxCapacity().toString();
            }
        }
        return s;
    }

    @Override
    public int compareTo(Event e) {
        if (this.getEventName() != e.getEventName()) {
            return this.getEventName().compareTo(e.getEventName());
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(e.getUniqueId() == null ? -1L : e.getUniqueId());
    }

    @Transient
    public TreeSet<MultiMeeting> getMultiMeetings() {
        return Event.getMultiMeetings(this.getMeetings());
    }

    public static TreeSet<MultiMeeting> getMultiMeetings(Collection meetings) {
        Date now = new Date();
        TreeSet<MultiMeeting> ret = new TreeSet<MultiMeeting>();
        HashSet meetingSet = new HashSet(meetings);
        while (!meetingSet.isEmpty()) {
            BaseMeeting meeting = null;
            for (Meeting m : meetingSet) {
                if (meeting != null && meeting.getMeetingDate().compareTo(m.getMeetingDate()) <= 0) continue;
                meeting = m;
            }
            meetingSet.remove(meeting);
            Hashtable<Long, Meeting> similar = new Hashtable<Long, Meeting>();
            TreeSet<Integer> dow = new TreeSet<Integer>();
            dow.add(((Meeting)meeting).getDayOfWeek());
            boolean past = ((Meeting)meeting).getStartTime().before(now);
            for (Meeting m : meetingSet) {
                if (!ToolBox.equals((Object)m.getEvent().getUniqueId(), (Object)meeting.getEvent().getUniqueId()) || !ToolBox.equals((Object)m.getStartPeriod(), (Object)meeting.getStartPeriod()) || !ToolBox.equals((Object)m.getStartOffset(), (Object)meeting.getStartOffset()) || !ToolBox.equals((Object)m.getStopPeriod(), (Object)meeting.getStopPeriod()) || !ToolBox.equals((Object)m.getStopOffset(), (Object)meeting.getStopOffset()) || !ToolBox.equals((Object)m.getLocationPermanentId(), (Object)meeting.getLocationPermanentId()) || past != m.getStartTime().before(now) || m.isApproved() != ((Meeting)meeting).isApproved()) continue;
                dow.add(m.getDayOfWeek());
                similar.put(m.getMeetingDate().getTime(), m);
            }
            TreeSet<Meeting> multi = new TreeSet<Meeting>();
            multi.add((Meeting)meeting);
            if (!similar.isEmpty()) {
                Calendar c = Calendar.getInstance(Locale.US);
                c.setTimeInMillis(meeting.getMeetingDate().getTime());
                while (true) {
                    c.add(6, 1);
                    if (!dow.contains(c.get(7))) continue;
                    Meeting m = (Meeting)similar.get(c.getTimeInMillis());
                    if (m == null) break;
                    multi.add(m);
                    meetingSet.remove(m);
                }
            }
            ret.add(new MultiMeeting(multi, past));
        }
        return ret;
    }

    @Transient
    public Session getSession() {
        return null;
    }

    public static Hashtable<Event, Set<Long>> findStudentConflicts(Date meetingDate, int startSlot, int endSlot, Set<Long> studentIds) {
        Hashtable<Event, Set<Long>> ret = new Hashtable<Event, Set<Long>>();
        if (studentIds == null || studentIds.isEmpty()) {
            return ret;
        }
        Object students = "";
        int nrStudents = 0;
        for (Long id : studentIds) {
            Set<Long> conf;
            long studentId;
            Event event;
            students = (String)students + (((String)students).length() == 0 ? "" : ",") + id;
            if (++nrStudents != 1000) continue;
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select e, s.student.uniqueId from ClassEvent e inner join e.meetings m inner join e.clazz.studentEnrollments s where m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ")", Object[].class).setParameter("meetingDate", (Object)meetingDate).setParameter("startSlot", (Object)startSlot).setParameter("endSlot", (Object)endSlot).setCacheable(true).list()) {
                event = (Event)o[0];
                studentId = (Long)o[1];
                conf = ret.get(event);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(event, conf);
                }
                conf.add(studentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select e, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and ((o.ownerType=:classType and s.clazz.uniqueId=o.ownerId) or (o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId) or (o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId) or (o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId))", Object[].class).setParameter("meetingDate", (Object)meetingDate).setParameter("startSlot", (Object)startSlot).setParameter("endSlot", (Object)endSlot).setParameter("classType", (Object)3).setParameter("configType", (Object)2).setParameter("courseType", (Object)1).setParameter("offeringType", (Object)0).setCacheable(true).list()) {
                event = (Event)o[0];
                studentId = (Long)o[1];
                conf = ret.get(event);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(event, conf);
                }
                conf.add(studentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select e, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and ((o.ownerType=:classType and s.clazz.uniqueId=o.ownerId) or (o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId) or (o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId) or (o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId))", Object[].class).setParameter("meetingDate", (Object)meetingDate).setParameter("startSlot", (Object)startSlot).setParameter("endSlot", (Object)endSlot).setParameter("classType", (Object)3).setParameter("configType", (Object)2).setParameter("courseType", (Object)1).setParameter("offeringType", (Object)0).setCacheable(true).list()) {
                event = (Event)o[0];
                studentId = (Long)o[1];
                conf = ret.get(event);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(event, conf);
                }
                conf.add(studentId);
            }
            nrStudents = 0;
            students = "";
        }
        if (nrStudents > 0) {
            Event event;
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select e, s.student.uniqueId from ClassEvent e inner join e.meetings m inner join e.clazz.studentEnrollments s where m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ")", Object[].class).setParameter("meetingDate", (Object)meetingDate).setParameter("startSlot", (Object)startSlot).setParameter("endSlot", (Object)endSlot).setCacheable(true).list()) {
                event = (Event)o[0];
                long studentId = (Long)o[1];
                Set<Long> conf = ret.get(event);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(event, conf);
                }
                conf.add(studentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select e, s.student.uniqueId from ExamEvent e inner join e.meetings m inner join e.exam.owners o, StudentClassEnrollment s where m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and ((o.ownerType=:classType and s.clazz.uniqueId=o.ownerId) or (o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId) or (o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId) or (o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId))", Object[].class).setParameter("meetingDate", (Object)meetingDate).setParameter("startSlot", (Object)startSlot).setParameter("endSlot", (Object)endSlot).setParameter("classType", (Object)3).setParameter("configType", (Object)2).setParameter("courseType", (Object)1).setParameter("offeringType", (Object)0).setCacheable(true).list()) {
                event = (Event)o[0];
                long studentId = (Long)o[1];
                Set<Long> conf = ret.get(event);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(event, conf);
                }
                conf.add(studentId);
            }
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select e, s.student.uniqueId from CourseEvent e inner join e.meetings m inner join e.relatedCourses o, StudentClassEnrollment s where e.reqAttendance=true and m.approvalStatus = 1 and m.meetingDate=:meetingDate and m.startPeriod < :endSlot and m.stopPeriod > :startSlot and s.student.uniqueId in (" + (String)students + ") and ((o.ownerType=:classType and s.clazz.uniqueId=o.ownerId) or (o.ownerType=:configType and s.clazz.schedulingSubpart.instrOfferingConfig.uniqueId=o.ownerId) or (o.ownerType=:courseType and s.courseOffering.uniqueId=o.ownerId) or (o.ownerType=:offeringType and s.courseOffering.instructionalOffering.uniqueId=o.ownerId))", Object[].class).setParameter("meetingDate", (Object)meetingDate).setParameter("startSlot", (Object)startSlot).setParameter("endSlot", (Object)endSlot).setParameter("classType", (Object)3).setParameter("configType", (Object)2).setParameter("courseType", (Object)1).setParameter("offeringType", (Object)0).setCacheable(true).list()) {
                event = (Event)o[0];
                long studentId = (Long)o[1];
                Set<Long> conf = ret.get(event);
                if (conf == null) {
                    conf = new HashSet<Long>();
                    ret.put(event, conf);
                }
                conf.add(studentId);
            }
        }
        return ret;
    }

    public static class MultiMeeting
    implements Comparable<MultiMeeting> {
        private TreeSet<Meeting> iMeetings;
        private boolean iPast = false;

        public MultiMeeting(TreeSet<Meeting> meetings, boolean past) {
            this.iMeetings = meetings;
            this.iPast = past;
        }

        @Transient
        public boolean isPast() {
            return this.iPast;
        }

        @Transient
        public TreeSet<Meeting> getMeetings() {
            return this.iMeetings;
        }

        @Override
        public int compareTo(MultiMeeting m) {
            return this.getMeetings().first().compareTo(m.getMeetings().first());
        }

        @Transient
        public String getDays() {
            return this.getDays(Constants.DAY_NAME, Constants.DAY_NAMES_SHORT);
        }

        public String getDays(String[] dayNames, String[] shortDyNames) {
            int nrDays = 0;
            int dayCode = 0;
            for (Meeting meeting : this.getMeetings()) {
                int dc = 0;
                switch (meeting.getDayOfWeek()) {
                    case 2: {
                        dc = Constants.DAY_CODES[0];
                        break;
                    }
                    case 3: {
                        dc = Constants.DAY_CODES[1];
                        break;
                    }
                    case 4: {
                        dc = Constants.DAY_CODES[2];
                        break;
                    }
                    case 5: {
                        dc = Constants.DAY_CODES[3];
                        break;
                    }
                    case 6: {
                        dc = Constants.DAY_CODES[4];
                        break;
                    }
                    case 7: {
                        dc = Constants.DAY_CODES[5];
                        break;
                    }
                    case 1: {
                        dc = Constants.DAY_CODES[6];
                    }
                }
                if (!(dayCode & dc)) {
                    ++nrDays;
                }
                dayCode |= dc;
            }
            Object ret = "";
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
                ret = (String)ret + (nrDays == 1 ? dayNames : shortDyNames)[i];
            }
            return ret;
        }

        public String toString() {
            return this.getDays() + " " + Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT).format(this.getMeetings().first().getMeetingDate()) + (String)(this.getMeetings().size() > 1 ? " - " + Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT).format(this.getMeetings().last().getMeetingDate()) : "") + " " + (String)(this.getMeetings().first().isAllDay() ? "All Day" : this.getMeetings().first().startTime() + " - " + this.getMeetings().first().stopTime()) + (String)(this.getMeetings().first().getLocation() == null ? "" : " " + this.getMeetings().first().getLocation().getLabel());
        }

        public String toShortString() {
            return this.getDays(Constants.DAY_NAMES_SHORT, Constants.DAY_NAMES_SHORT) + " " + Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT).format(this.getMeetings().first().getMeetingDate()) + (String)(this.getMeetings().size() > 1 ? " - " + Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT).format(this.getMeetings().last().getMeetingDate()) : "") + " " + (this.getMeetings().first().isAllDay() ? "All Day" : this.getMeetings().first().startTime()) + (String)(this.getMeetings().first().getLocation() == null ? "" : " " + this.getMeetings().first().getLocation().getLabel());
        }
    }
}

