/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.List;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseCurriculum;
import org.unitime.timetable.model.dao.CurriculumDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="curriculum")
public class Curriculum
extends BaseCurriculum
implements Comparable<Curriculum> {
    private static final long serialVersionUID = 1L;

    public Curriculum() {
    }

    public Curriculum(Long uniqueId) {
        super(uniqueId);
    }

    public static List<Curriculum> findAll(Long sessionId) {
        return CurriculumDAO.getInstance().getSession().createQuery("select c from Curriculum c where c.department.session.uniqueId=:sessionId", Curriculum.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public static List<Curriculum> findByDepartment(Long deptId) {
        return CurriculumDAO.getInstance().getSession().createQuery("select c from Curriculum c where c.department.uniqueId=:deptId", Curriculum.class).setParameter("deptId", (Object)deptId).setCacheable(true).list();
    }

    @Override
    public int compareTo(Curriculum c) {
        int cmp = this.getAbbv().compareToIgnoreCase(c.getAbbv());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(c.getUniqueId() == null ? -1L : c.getUniqueId());
    }

    public boolean isTemplateFor(Curriculum curriculum) {
        if (!curriculum.isMultipleMajors().booleanValue()) {
            return false;
        }
        if (!curriculum.getAcademicArea().equals(this.getAcademicArea())) {
            return false;
        }
        if (curriculum.getMajors().size() <= this.getMajors().size() || this.getMajors().size() > 1) {
            return false;
        }
        return this.getMajors().isEmpty() || curriculum.getMajors().containsAll(this.getMajors());
    }
}

