/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.pointintimedata;

import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.pointintimedata.PointInTimeDataReportsExportToCSV;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.PointInTimeDataReportsInterface;
import org.unitime.timetable.security.SessionContext;

@GwtRpcImplements(value=PointInTimeDataReportsInterface.PITDExecuteRpcRequest.class)
public class PITDExecuteBackend
implements GwtRpcImplementation<PointInTimeDataReportsInterface.PITDExecuteRpcRequest, PointInTimeDataReportsInterface.Table> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('PointInTimeDataReports')")
    public PointInTimeDataReportsInterface.Table execute(PointInTimeDataReportsInterface.PITDExecuteRpcRequest request, SessionContext context) {
        try {
            final PointInTimeDataReportsInterface.Table ret = new PointInTimeDataReportsInterface.Table();
            Exporter.Printer out = new Exporter.Printer(){

                @Override
                public void printLine(String ... fields) throws IOException {
                    ret.add(fields);
                }

                @Override
                public void printHeader(String ... fields) throws IOException {
                    ret.add(fields);
                }

                @Override
                public void hideColumn(int col) {
                }

                @Override
                public String getContentType() {
                    return null;
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            };
            PointInTimeDataReportsExportToCSV.execute(this.sessionContext.getUser(), out, request.getReport(), request.getParameters());
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GwtRpcException(MESSAGES.failedExecution(e.getMessage() + (String)(e.getCause() == null ? "" : " (" + e.getCause().getMessage() + ")")));
        }
    }
}

