/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.Calendar;
import java.util.Locale;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassEditBackend;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=PrefGroupEditInterface.InstructorPreferencesEditRequest.class)
public class InstructorPreferencesBackend
implements GwtRpcImplementation<PrefGroupEditInterface.InstructorPreferencesEditRequest, PrefGroupEditInterface.InstructorPreferencesEditResponse> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public PrefGroupEditInterface.InstructorPreferencesEditResponse execute(PrefGroupEditInterface.InstructorPreferencesEditRequest request, SessionContext context) {
        DepartmentalInstructor next;
        Session hibSession = DepartmentalInstructorDAO.getInstance().getSession();
        DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(request.getId());
        context.checkPermission(instructor, Right.InstructorPreferences);
        if (instructor == null) {
            throw new GwtRpcException(MSG.errorNoInstructorId());
        }
        if (request.getOperation() != null) {
            switch (request.getOperation()) {
                case CLEAR_CLASS_PREFS: {
                    context.checkPermission(instructor, Right.InstructorEditClearPreferences);
                    ClassEditBackend.doClear(instructor.getPreferences(), Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DISTRIBUTION);
                    if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Preferences".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
                        instructor.setUnavailableDays(null);
                    }
                    instructor.setUnavailableOffset(null);
                    hibSession.merge((Object)instructor);
                    hibSession.flush();
                    ChangeLog.addChange(null, context, instructor, ChangeLog.Source.INSTRUCTOR_PREF_EDIT, ChangeLog.Operation.CLEAR_PREF, null, instructor.getDepartment());
                    PrefGroupEditInterface.InstructorPreferencesEditResponse ret = new PrefGroupEditInterface.InstructorPreferencesEditResponse();
                    ret.setUrl("instructor?id=" + instructor.getUniqueId());
                    return ret;
                }
                case UPDATE: 
                case NEXT: 
                case PREVIOUS: {
                    Transaction tx = hibSession.beginTransaction();
                    try {
                        PrefGroupEditInterface.InstructorPreferencesEditResponse data = (PrefGroupEditInterface.InstructorPreferencesEditResponse)request.getPayLoad();
                        if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Preferences".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
                            if (data.hasInstructorUnavailability() && data.getInstructorUnavailability().indexOf(49) >= 0) {
                                String unavailability = data.getInstructorUnavailability();
                                int startMonth = instructor.getDepartment().getSession().getPatternStartMonth();
                                int firstOne = unavailability.indexOf(49) + instructor.getDepartment().getSession().getDayOfYear(1, startMonth);
                                Calendar cal = Calendar.getInstance(Locale.US);
                                cal.setTime(instructor.getDepartment().getSession().getSessionBeginDateTime());
                                instructor.setUnavailableDays(unavailability.substring(unavailability.indexOf(49), unavailability.lastIndexOf(49) + 1));
                                instructor.setUnavailableOffset(cal.get(6) - firstOne - 1);
                            } else {
                                instructor.setUnavailableDays(null);
                                instructor.setUnavailableOffset(null);
                            }
                        }
                        ClassEditBackend.doUpdate(instructor, instructor.getPreferences(), data, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DISTRIBUTION);
                        hibSession.merge((Object)instructor);
                        ChangeLog.addChange(null, context, instructor, ChangeLog.Source.INSTRUCTOR_PREF_EDIT, ChangeLog.Operation.UPDATE, null, instructor.getDepartment());
                        tx.commit();
                        tx = null;
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw new GwtRpcException(e.getMessage(), e);
                    }
                    PrefGroupEditInterface.InstructorPreferencesEditResponse ret = new PrefGroupEditInterface.InstructorPreferencesEditResponse();
                    if (request.getOperation() == PrefGroupEditInterface.Operation.PREVIOUS && ((PrefGroupEditInterface.InstructorPreferencesEditResponse)request.getPayLoad()).getPreviousId() != null) {
                        ret.setUrl("instructorPrefs?id=" + ((PrefGroupEditInterface.InstructorPreferencesEditResponse)request.getPayLoad()).getPreviousId());
                    } else if (request.getOperation() == PrefGroupEditInterface.Operation.NEXT && ((PrefGroupEditInterface.InstructorPreferencesEditResponse)request.getPayLoad()).getNextId() != null) {
                        ret.setUrl("instructorPrefs?id=" + ((PrefGroupEditInterface.InstructorPreferencesEditResponse)request.getPayLoad()).getNextId());
                    } else {
                        ret.setUrl("instructor?id=" + instructor.getUniqueId());
                    }
                    return ret;
                }
            }
        }
        String nameFormat = UserProperty.NameFormat.get(context.getUser());
        PrefGroupEditInterface.InstructorPreferencesEditResponse ret = new PrefGroupEditInterface.InstructorPreferencesEditResponse();
        ret.setId(request.getId());
        ret.setName(instructor.getName(nameFormat));
        ret.setNbrRooms(1);
        if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Preferences".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
            ret.setInstructorUnavailability(instructor.getUnavailablePattern());
        }
        ret.setNextId((next = instructor.getNextDepartmentalInstructor(context, Right.InstructorPreferences)) == null ? null : next.getUniqueId());
        DepartmentalInstructor previous = instructor.getPreviousDepartmentalInstructor(context, Right.InstructorPreferences);
        ret.setPreviousId(previous == null ? null : previous.getUniqueId());
        ret.setCanClearPrefs(context.hasPermission(instructor, Right.InstructorEditClearPreferences));
        ClassEditBackend.fillInPreferences(ret, instructor, context);
        InstructorPreferencesBackend.fillInDistributionPreferences(ret, instructor, context, true);
        BackTracker.markForBack(context, "instructor?id=" + ret.getId(), MSG.backInstructor(ret.getName()), true, false);
        return ret;
    }

    protected static void fillInDistributionPreferences(PrefGroupEditInterface.PrefGroupEditResponse response, PreferenceGroup pg, SessionContext context, boolean fillPrefs) {
        PrefGroupEditInterface.Preferences distPrefs = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.DISTRIBUTION);
        distPrefs.setAllowHard(context.hasPermission(pg, Right.CanUseHardDistributionPrefs));
        for (DistributionType type : DistributionType.findApplicable(pg.getDepartment(), true, false)) {
            PrefGroupEditInterface.IdLabel id = distPrefs.addItem(type.getUniqueId(), type.getLabel(), type.getDescr());
            id.setAllowedPrefs(type.getAllowedPref());
        }
        if (fillPrefs) {
            for (DistributionPref dp : pg.effectivePreferences(DistributionPref.class)) {
                PrefGroupEditInterface.Selection selection = new PrefGroupEditInterface.Selection(dp.getDistributionType().getUniqueId(), dp.getPrefLevel().getUniqueId());
                distPrefs.addSelection(selection);
            }
        }
        response.setDistributionPreferences(distPrefs);
    }
}

