/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassEditBackend;
import org.unitime.timetable.server.instructor.InstructorPreferencesBackend;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=PrefGroupEditInterface.InstructorAssignmentPreferencesEditRequest.class)
public class InstructorAssignmentPreferencesBackend
implements GwtRpcImplementation<PrefGroupEditInterface.InstructorAssignmentPreferencesEditRequest, PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse execute(PrefGroupEditInterface.InstructorAssignmentPreferencesEditRequest request, SessionContext context) {
        DepartmentalInstructor next;
        Session hibSession = DepartmentalInstructorDAO.getInstance().getSession();
        DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(request.getId());
        if (instructor == null) {
            throw new GwtRpcException(MSG.errorNoInstructorId());
        }
        context.checkPermission(instructor.getDepartment(), Right.InstructorAssignmentPreferences);
        if (request.getOperation() != null) {
            switch (request.getOperation()) {
                case CLEAR_CLASS_PREFS: {
                    context.checkPermission(instructor, Right.InstructorClearAssignmentPreferences);
                    ClassEditBackend.doClear(instructor.getPreferences(), Preference.Type.TIME, Preference.Type.DISTRIBUTION, Preference.Type.COURSE);
                    if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Assignments".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
                        instructor.setUnavailableDays(null);
                    }
                    instructor.setUnavailableOffset(null);
                    hibSession.merge((Object)instructor);
                    hibSession.flush();
                    ChangeLog.addChange(null, context, instructor, ChangeLog.Source.INSTRUCTOR_ASSIGNMENT_PREF_EDIT, ChangeLog.Operation.CLEAR_PREF, null, instructor.getDepartment());
                    PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse ret = new PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse();
                    ret.setUrl("instructor?id=" + instructor.getUniqueId());
                    return ret;
                }
                case UPDATE: 
                case NEXT: 
                case PREVIOUS: {
                    Transaction tx = hibSession.beginTransaction();
                    try {
                        PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse data = (PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse)request.getPayLoad();
                        if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Assignments".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
                            if (data.hasInstructorUnavailability() && data.getInstructorUnavailability().indexOf(49) >= 0) {
                                String unavailability = data.getInstructorUnavailability();
                                int startMonth = instructor.getDepartment().getSession().getPatternStartMonth();
                                int firstOne = unavailability.indexOf(49) + instructor.getDepartment().getSession().getDayOfYear(1, startMonth);
                                Calendar cal = Calendar.getInstance(Locale.US);
                                cal.setTime(instructor.getDepartment().getSession().getSessionBeginDateTime());
                                instructor.setUnavailableDays(unavailability.substring(unavailability.indexOf(49), unavailability.lastIndexOf(49) + 1));
                                instructor.setUnavailableOffset(cal.get(6) - firstOne - 1);
                            } else {
                                instructor.setUnavailableDays(null);
                                instructor.setUnavailableOffset(null);
                            }
                        }
                        ClassEditBackend.doUpdate(instructor, instructor.getPreferences(), data, Preference.Type.TIME, Preference.Type.DISTRIBUTION, Preference.Type.COURSE);
                        instructor.setTeachingPreference(data.getTeachingPrefId() == null ? null : (PreferenceLevel)PreferenceLevelDAO.getInstance().get(data.getTeachingPrefId()));
                        instructor.setMaxLoad(data.getMaxTeachingLoad());
                        HashSet<InstructorAttribute> attributes = new HashSet<InstructorAttribute>(instructor.getAttributes());
                        if (data.hasInstructorAttributeIds()) {
                            block6: for (Long attributeId : data.getInstructorAttributeIds()) {
                                Iterator i = attributes.iterator();
                                while (i.hasNext()) {
                                    InstructorAttribute a = (InstructorAttribute)i.next();
                                    if (!a.getUniqueId().equals(attributeId)) continue;
                                    i.remove();
                                    continue block6;
                                }
                                instructor.getAttributes().add((InstructorAttribute)InstructorAttributeDAO.getInstance().get(attributeId));
                            }
                        }
                        instructor.getAttributes().removeAll(attributes);
                        hibSession.merge((Object)instructor);
                        ChangeLog.addChange(null, context, instructor, ChangeLog.Source.INSTRUCTOR_ASSIGNMENT_PREF_EDIT, ChangeLog.Operation.UPDATE, null, instructor.getDepartment());
                        tx.commit();
                        tx = null;
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw new GwtRpcException(e.getMessage(), e);
                    }
                    PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse ret = new PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse();
                    if (request.getOperation() == PrefGroupEditInterface.Operation.PREVIOUS && ((PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse)request.getPayLoad()).getPreviousId() != null) {
                        ret.setUrl("instrAssignmentPrefs?id=" + ((PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse)request.getPayLoad()).getPreviousId());
                    } else if (request.getOperation() == PrefGroupEditInterface.Operation.NEXT && ((PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse)request.getPayLoad()).getNextId() != null) {
                        ret.setUrl("instrAssignmentPrefs?id=" + ((PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse)request.getPayLoad()).getNextId());
                    } else {
                        ret.setUrl("instructor?id=" + instructor.getUniqueId());
                    }
                    return ret;
                }
            }
        }
        String nameFormat = UserProperty.NameFormat.get(context.getUser());
        PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse ret = new PrefGroupEditInterface.InstructorAssignmentPreferencesEditResponse();
        ret.setId(request.getId());
        ret.setName(instructor.getName(nameFormat));
        ret.setNbrRooms(1);
        if (instructor.getTeachingPreference() == null) {
            ret.setTeachingPrefId(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sProhibited).getUniqueId());
        } else {
            ret.setTeachingPrefId(instructor.getTeachingPreference().getUniqueId());
        }
        ret.setMaxTeachingLoad(instructor.getMaxLoad());
        if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Assignments".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
            ret.setInstructorUnavailability(instructor.getUnavailablePattern());
        }
        ret.setNextId((next = instructor.getNextDepartmentalInstructor(context, Right.InstructorAssignmentPreferences)) == null ? null : next.getUniqueId());
        DepartmentalInstructor previous = instructor.getPreviousDepartmentalInstructor(context, Right.InstructorAssignmentPreferences);
        ret.setPreviousId(previous == null ? null : previous.getUniqueId());
        ret.setCanClearPrefs(context.hasPermission(instructor, Right.InstructorClearAssignmentPreferences));
        ClassEditBackend.fillInPreferenceLevels(ret, instructor, context);
        ClassEditBackend.fillInTimePreferences(ret, instructor, null, null, context, true);
        InstructorPreferencesBackend.fillInDistributionPreferences(ret, instructor, context, true);
        InstructorAssignmentPreferencesBackend.fillInCoursePreferences(ret, instructor, context, true);
        for (InstructorAttribute attribute : instructor.getDepartment().getAvailableAttributes()) {
            InstructorInterface.AttributeInterface a = new InstructorInterface.AttributeInterface();
            a.setId(attribute.getUniqueId());
            a.setParentId(attribute.getParentAttribute() == null ? null : attribute.getParentAttribute().getUniqueId());
            a.setParentName(attribute.getParentAttribute() == null ? null : attribute.getParentAttribute().getName());
            a.setCode(attribute.getCode());
            a.setName(attribute.getName());
            if (attribute.getType() != null) {
                InstructorInterface.AttributeTypeInterface t = new InstructorInterface.AttributeTypeInterface();
                t.setId(attribute.getType().getUniqueId());
                t.setAbbreviation(attribute.getType().getReference());
                t.setLabel(attribute.getType().getLabel());
                t.setConjunctive(attribute.getType().isConjunctive());
                t.setRequired(attribute.getType().isRequired());
                a.setType(t);
            }
            if (attribute.getDepartment() != null) {
                InstructorInterface.DepartmentInterface d = new InstructorInterface.DepartmentInterface();
                d.setId(attribute.getDepartment().getUniqueId());
                d.setAbbreviation(attribute.getDepartment().getAbbreviation());
                d.setDeptCode(attribute.getDepartment().getDeptCode());
                d.setLabel(attribute.getDepartment().getName());
                d.setTitle(attribute.getDepartment().getLabel());
                a.setDepartment(d);
            }
            ret.addAttribute(a);
        }
        for (InstructorAttribute a : instructor.getAttributes()) {
            ret.addInstructorAttribute(a.getUniqueId());
        }
        BackTracker.markForBack(context, "instructor?id=" + ret.getId(), MSG.backInstructor(ret.getName()), true, false);
        return ret;
    }

    protected static void fillInCoursePreferences(PrefGroupEditInterface.PrefGroupEditResponse response, PreferenceGroup pg, SessionContext context, boolean fillPrefs) {
        PrefGroupEditInterface.Preferences coursePrefs = new PrefGroupEditInterface.Preferences(PrefGroupEditInterface.PreferenceType.COURSE);
        coursePrefs.setAllowHard(true);
        for (Object o : pg.getAvailableCourses()) {
            CourseOffering course = (CourseOffering)o;
            coursePrefs.addItem(course.getUniqueId(), course.getCourseNameWithTitle(), course.getScheduleBookNote());
        }
        if (fillPrefs) {
            for (InstructorCoursePref dp : pg.effectivePreferences(InstructorCoursePref.class)) {
                PrefGroupEditInterface.Selection selection = new PrefGroupEditInterface.Selection(dp.getCourse().getUniqueId(), dp.getPrefLevel().getUniqueId());
                coursePrefs.addSelection(selection);
            }
        }
        response.setCoursePreferences(coursePrefs);
    }
}

