/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.hql;

import java.io.IOException;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.hql.SavedHqlExportToCSV;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SavedHQLInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SavedHQLParameter;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.security.SessionContext;

@GwtRpcImplements(value=SavedHQLInterface.HQLExecuteRpcRequest.class)
public class HQLExecuteBackend
implements GwtRpcImplementation<SavedHQLInterface.HQLExecuteRpcRequest, SavedHQLInterface.Table> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('HQLReports')")
    public SavedHQLInterface.Table execute(SavedHQLInterface.HQLExecuteRpcRequest request, SessionContext context) {
        try {
            final SavedHQLInterface.Table ret = new SavedHQLInterface.Table();
            Exporter.Printer out = new Exporter.Printer(){

                @Override
                public void printLine(String ... fields) throws IOException {
                    ret.add(fields);
                }

                @Override
                public void printHeader(String ... fields) throws IOException {
                    ret.add(fields);
                }

                @Override
                public void hideColumn(int col) {
                }

                @Override
                public String getContentType() {
                    return null;
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            };
            String query = null;
            ArrayList<SavedHQLParameter> parameters = null;
            if (request.getQuery() != null) {
                query = request.getQuery().getQuery();
                parameters = new ArrayList();
                if (request.getQuery().hasParameters()) {
                    for (SavedHQLInterface.Parameter p : request.getQuery().getParameters()) {
                        SavedHQLParameter parameter = new SavedHQLParameter();
                        parameter.setDefaultValue(p.getDefaultValue());
                        parameter.setLabel(p.getLabel());
                        parameter.setName(p.getName());
                        parameter.setType(p.getType());
                        parameters.add(parameter);
                    }
                }
            } else {
                SavedHQL hql = (SavedHQL)SavedHQLDAO.getInstance().get(request.getQuery().getId());
                query = hql.getQuery();
                parameters = hql.getParameters();
            }
            SavedHqlExportToCSV.execute(this.sessionContext.getUser(), out, query, request.getOptions(), request.getFromRow(), request.getMaxRows(), parameters);
            return ret;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GwtRpcException(MESSAGES.failedExecution(e.getMessage() + (String)(e.getCause() == null ? "" : " (" + e.getCause().getMessage() + ")")));
        }
    }
}

