/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.exams;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ConstantsMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.client.exams.ExamsInterface;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseExam;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.JavascriptFunctions;

@GwtRpcImplements(value=ExamsInterface.ExamDistributionEditRequest.class)
public class ExamDistributionEditBackend
implements GwtRpcImplementation<ExamsInterface.ExamDistributionEditRequest, ExamsInterface.ExamDistributionEditResponse> {
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    protected static final ConstantsMessages CMSG = Localization.create(ConstantsMessages.class);

    @Override
    public ExamsInterface.ExamDistributionEditResponse execute(ExamsInterface.ExamDistributionEditRequest request, SessionContext context) {
        BackTracker.BackItem back;
        Object et;
        Object ex;
        if (request.getPreferenceId() == null) {
            context.checkPermission(Right.ExaminationDistributionPreferenceAdd);
        } else {
            context.checkPermission(request.getPreferenceId(), "DistributionPref", Right.ExaminationDistributionPreferenceEdit);
        }
        if (request.getOperation() == ExamsInterface.ExamDistributionEditRequest.Operation.DELETE) {
            this.deleteDistPref(request.getPreferenceId(), context);
            return null;
        }
        if (request.getOperation() == ExamsInterface.ExamDistributionEditRequest.Operation.SAVE) {
            ExamsInterface.ExamDistributionEditResponse response = request.getData();
            this.updateDistPref(response, context);
            BackTracker.BackItem back2 = BackTracker.getBackItem(context, 1);
            if (back2 != null) {
                response.setBackTitle(back2.getTitle());
                response.setBackUrl(back2.getUrl() + (String)(request.getPreferenceId() == null ? "" : (back2.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=" + request.getPreferenceId() + "&backType=DistributionPref"));
            }
            return response;
        }
        ExamsInterface.ExamDistributionEditResponse response = new ExamsInterface.ExamDistributionEditResponse();
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(false)) {
            response.addPrefLevel(pref.getUniqueId(), pref.getPrefName(), PreferenceLevel.prolog2char(pref.getPrefProlog()));
        }
        for (DistributionType dt : DistributionType.findAll(false, true, true)) {
            response.addDistType(dt.getUniqueId(), dt.getLabel(), dt.getDescr(), dt.getAllowedPref());
        }
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser(), true)) {
            response.addSubject(subject.getUniqueId(), subject.getSubjectAreaAbbreviation(), subject.getLabel());
        }
        DistributionPref dp = request.getPreferenceId() == null ? null : (DistributionPref)DistributionPrefDAO.getInstance().get(request.getPreferenceId());
        TreeSet<SubjectArea> userSubjects = SubjectArea.getUserSubjectAreas(context.getUser());
        if (dp != null) {
            response.setPreferenceId(dp.getUniqueId());
            response.setDistTypeId(dp.getDistributionType().getUniqueId());
            if (response.getDistType(dp.getDistributionType().getUniqueId()) == null) {
                response.addDistType(dp.getDistributionType().getUniqueId(), dp.getDistributionType().getLabel(), dp.getDistributionType().getDescr(), dp.getDistributionType().getAllowedPref());
            }
            response.setPrefLevelId(dp.getPrefLevel().getUniqueId());
            response.setCanDelete(context.hasPermission(dp, Right.ExaminationDistributionPreferenceDelete));
            for (DistributionObject distObj : dp.getOrderedSetOfDistributionObjects()) {
                if (!(distObj.getPrefGroup() instanceof Exam)) continue;
                Exam ex2 = (Exam)distObj.getPrefGroup();
                if (!response.hasExamTypes()) {
                    response.addExamType(ex2.getExamType().getUniqueId(), ex2.getExamType().getLabel(), ex2.getExamType().getReference());
                    response.setExamTypeId(ex2.getExamType().getUniqueId());
                }
                CourseOffering co = null;
                for (ExamOwner owner : new TreeSet<ExamOwner>(ex2.getOwners())) {
                    if (co == null) {
                        co = owner.getCourse();
                    }
                    if (!userSubjects.contains(co.getSubjectArea())) continue;
                    co = owner.getCourse();
                    break;
                }
                if (co == null) continue;
                ExamsInterface.ExamDistributionObjectInterface doi = new ExamsInterface.ExamDistributionObjectInterface();
                doi.setSubjectId(co.getSubjectArea().getUniqueId());
                doi.setSubject(co.getSubjectAreaAbbv());
                doi.setCourseId(co.getUniqueId());
                doi.setCourse(co.getCourseNumberWithTitle());
                doi.setExamId(ex2.getUniqueId());
                doi.setExam(ex2.getLabel());
                response.addDistributionObject(doi);
            }
        } else {
            response.setCanDelete(false);
        }
        if (request.getExamId() != null && (ex = (Exam)ExamDAO.getInstance().get(request.getExamId())) != null) {
            response.addExamType(((BaseExam)ex).getExamType().getUniqueId(), ((BaseExam)ex).getExamType().getLabel(), ((BaseExam)ex).getExamType().getReference());
            response.setExamTypeId(((BaseExam)ex).getExamType().getUniqueId());
            CourseOffering co = null;
            for (ExamOwner owner : new TreeSet<ExamOwner>(((BaseExam)ex).getOwners())) {
                if (co == null) {
                    co = owner.getCourse();
                }
                if (!userSubjects.contains(co.getSubjectArea())) continue;
                co = owner.getCourse();
                break;
            }
            if (co != null) {
                ExamsInterface.ExamDistributionObjectInterface doi = new ExamsInterface.ExamDistributionObjectInterface();
                doi.setSubjectId(co.getSubjectArea().getUniqueId());
                doi.setSubject(co.getSubjectAreaAbbv());
                doi.setCourseId(co.getUniqueId());
                doi.setCourse(co.getCourseNumberWithTitle());
                doi.setExamId(((BasePreferenceGroup)ex).getUniqueId());
                doi.setExam(((Exam)ex).getLabel());
                response.addDistributionObject(doi);
            }
        }
        if (!response.hasExamTypes()) {
            for (ExamType type : ExamType.findAllUsedApplicable(context.getUser(), DepartmentStatusType.Status.ExamEdit)) {
                response.addExamType(type.getUniqueId(), type.getLabel(), type.getReference());
            }
            response.setExamTypeId(request.getTypeId());
        }
        if (response.getExamTypeId() == null && (et = context.getAttribute(SessionAttribute.ExamType)) != null) {
            response.setExamTypeId(Long.valueOf(et.toString()));
        }
        if ((back = BackTracker.getBackItem(context, 1)) != null) {
            response.setBackTitle(back.getTitle());
            response.setBackUrl(back.getUrl() + (String)(request.getPreferenceId() == null ? "" : (back.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=" + request.getPreferenceId() + "&backType=DistributionPref"));
        }
        response.setConfirms(JavascriptFunctions.isJsConfirm(context));
        return response;
    }

    protected void deleteDistPref(Long distPrefId, SessionContext context) {
        Transaction tx = null;
        try {
            DistributionPrefDAO dpDao = DistributionPrefDAO.getInstance();
            org.hibernate.Session hibSession = dpDao.getSession();
            tx = hibSession.getTransaction();
            if (tx == null || !tx.isActive()) {
                tx = hibSession.beginTransaction();
            }
            HashSet<Exam> relatedExams = new HashSet<Exam>();
            DistributionPref dp = (DistributionPref)dpDao.get(Long.valueOf(distPrefId));
            context.checkPermission(dp, Right.ExaminationDistributionPreferenceDelete);
            PreferenceGroup owner = dp.getOwner();
            owner.getPreferences().remove(dp);
            for (DistributionObject dObj : dp.getDistributionObjects()) {
                PreferenceGroup pg = dObj.getPrefGroup();
                if (pg instanceof Exam) {
                    relatedExams.add((Exam)pg);
                }
                pg.getDistributionObjects().remove(dObj);
                hibSession.merge((Object)pg);
            }
            hibSession.remove((Object)dp);
            hibSession.merge((Object)owner);
            for (Exam ex : relatedExams) {
                ChangeLog.addChange(hibSession, context, ex, ChangeLog.Source.DIST_PREF_EDIT, ChangeLog.Operation.DELETE, ex.firstSubjectArea(), ex.firstDepartment());
            }
            if (tx != null && tx.isActive()) {
                tx.commit();
            }
            hibSession.flush();
            hibSession.refresh((Object)owner);
        }
        catch (Exception e) {
            Debug.error(e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected void updateDistPref(ExamsInterface.ExamDistributionEditResponse data, SessionContext context) {
        DistributionPref dp = null;
        DistributionPrefDAO dpDao = DistributionPrefDAO.getInstance();
        Transaction tx = null;
        org.hibernate.Session hibSession = dpDao.getSession();
        HashSet<Exam> relatedExams = new HashSet<Exam>();
        try {
            tx = hibSession.beginTransaction();
            if (data.getPreferenceId() != null) {
                dp = (DistributionPref)DistributionPrefDAO.getInstance().get(data.getPreferenceId(), hibSession);
                context.checkPermission(dp, Right.ExaminationDistributionPreferenceEdit);
                Set<DistributionObject> s = dp.getDistributionObjects();
                for (DistributionObject dObj : s) {
                    PreferenceGroup pg = dObj.getPrefGroup();
                    if (pg instanceof Exam) {
                        relatedExams.add((Exam)pg);
                    }
                    pg.getDistributionObjects().remove(dObj);
                    hibSession.remove((Object)dObj);
                }
                s.clear();
                dp.setDistributionObjects(s);
            } else {
                dp = new DistributionPref();
                context.checkPermission(Right.ExaminationDistributionPreferenceAdd);
            }
            dp.setDistributionType((DistributionType)DistributionTypeDAO.getInstance().get(data.getDistTypeId(), hibSession));
            dp.setGrouping(-1);
            dp.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(data.getPrefLevelId(), hibSession));
            Session owningSession = null;
            ArrayList<DistributionObject> distributionObjects = new ArrayList<DistributionObject>();
            for (int i = 0; i < data.getDistributionObjects().size(); ++i) {
                ExamsInterface.ExamDistributionObjectInterface doi = data.getDistributionObjects().get(i);
                DistributionObject dObj = new DistributionObject();
                Exam exam = (Exam)ExamDAO.getInstance().get(doi.getExamId(), hibSession);
                if (owningSession == null) {
                    owningSession = exam.getSession();
                }
                relatedExams.add(exam);
                dObj.setPrefGroup(exam);
                dObj.setSequenceNumber(i + 1);
                distributionObjects.add(dObj);
            }
            if (owningSession == null) {
                owningSession = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
            }
            dp.setOwner(owningSession);
            if (dp.getUniqueId() == null) {
                hibSession.persist((Object)dp);
            }
            for (DistributionObject dObj : distributionObjects) {
                dObj.setDistributionPref(dp);
                dp.addToDistributionObjects(dObj);
                hibSession.persist((Object)dObj);
                dObj.getPrefGroup().addToDistributionObjects(dObj);
            }
            hibSession.merge((Object)dp);
            for (Exam exam : relatedExams) {
                ChangeLog.addChange(hibSession, context, exam, ChangeLog.Source.DIST_PREF_EDIT, data.getPreferenceId() != null ? ChangeLog.Operation.UPDATE : ChangeLog.Operation.CREATE, exam.firstSubjectArea(), exam.firstDepartment());
            }
            tx.commit();
            hibSession.flush();
            hibSession.refresh((Object)dp.getOwner());
            data.setPreferenceId(dp.getUniqueId());
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            hibSession.clear();
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    @GwtRpcImplements(value=ExamsInterface.ExamDistributionsLookupExams.class)
    @GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
    public static class LookupSubpartsBackend
    implements GwtRpcImplementation<ExamsInterface.ExamDistributionsLookupExams, GwtRpcResponseList<PrefGroupEditInterface.IdLabel>> {
        @Override
        public GwtRpcResponseList<PrefGroupEditInterface.IdLabel> execute(ExamsInterface.ExamDistributionsLookupExams request, SessionContext context) {
            GwtRpcResponseList<PrefGroupEditInterface.IdLabel> ret = new GwtRpcResponseList<PrefGroupEditInterface.IdLabel>();
            TreeSet<Exam> exams = new TreeSet<Exam>(Exam.findExamsOfCourseOffering(request.getCourseId(), request.getExamTypeId()));
            for (Exam ex : exams) {
                ret.add(new PrefGroupEditInterface.IdLabel(ex.getUniqueId(), ex.getLabel(), null));
            }
            return ret;
        }
    }

    @GwtRpcImplements(value=ExamsInterface.ExamDistributionsLookupCourses.class)
    @GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
    public static class LookupCoursesBackend
    implements GwtRpcImplementation<ExamsInterface.ExamDistributionsLookupCourses, GwtRpcResponseList<PrefGroupEditInterface.IdLabel>> {
        @Override
        public GwtRpcResponseList<PrefGroupEditInterface.IdLabel> execute(ExamsInterface.ExamDistributionsLookupCourses request, SessionContext context) {
            GwtRpcResponseList<PrefGroupEditInterface.IdLabel> ret = new GwtRpcResponseList<PrefGroupEditInterface.IdLabel>();
            List courseNumbers = CourseOfferingDAO.getInstance().getSession().createQuery("select co.uniqueId, co.courseNbr, co.title from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false order by co.courseNbr ", Object[].class).setFetchSize(200).setCacheable(true).setParameter("subjectAreaId", (Object)request.getSubjectId()).list();
            for (Object[] o : courseNumbers) {
                ret.add(new PrefGroupEditInterface.IdLabel((Long)o[0], o[1].toString() + (String)(o[2] == null || o[2].toString().isEmpty() ? "" : " - " + String.valueOf(o[2])), null));
            }
            return ret;
        }
    }
}

