/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.CourseOfferingInterface;
import org.unitime.timetable.interfaces.ExternalCourseOfferingEditAction;
import org.unitime.timetable.interfaces.ExternalInstructionalOfferingAddAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.base.BaseOfferingCoordinator;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.OfferingConsentTypeDAO;
import org.unitime.timetable.model.dao.OverrideTypeDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.model.dao.TeachingResponsibilityDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.InstrOfferingPermIdGenerator;

@GwtRpcImplements(value=CourseOfferingInterface.UpdateCourseOfferingRequest.class)
public class UpdateCourseOfferingBackend
implements GwtRpcImplementation<CourseOfferingInterface.UpdateCourseOfferingRequest, CourseOfferingInterface> {
    @Autowired
    Permission<InstructionalOffering> permissionOfferingLockNeeded;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    Logger logger = Logger.getLogger("UpdateCourseOfferingBackend");
    boolean limitedEdit = false;
    boolean updateNote = false;
    boolean updateCoordinators = false;

    @Override
    public CourseOfferingInterface execute(CourseOfferingInterface.UpdateCourseOfferingRequest request, SessionContext context) {
        Boolean hasErrors = false;
        OverrideType prohibitedOverride = OverrideType.findByReference(ApplicationProperty.OfferingWaitListProhibitedOverride.value());
        hasErrors = this.isWaitlistingProhibited(request.getCourseOffering(), prohibitedOverride);
        if (hasErrors.booleanValue()) {
            request.getCourseOffering().setErrorMessage(MSG.errorWaitListingOverrideMustBeProhibited(prohibitedOverride.getLabel()));
            return request.getCourseOffering();
        }
        switch (request.getAction()) {
            case CREATE: {
                context.checkPermission(request.getCourseOffering().getSubjectAreaId(), "SubjectArea", Right.AddCourseOffering);
                CourseOffering courseOffering = this.save(request.getCourseOffering(), context);
                request.getCourseOffering().setInstrOfferingId(courseOffering.getInstructionalOffering().getUniqueId());
                break;
            }
            case UPDATE: {
                if (context.hasPermission(request.getCourseOffering().getId(), "CourseOffering", Right.EditCourseOfferingNote)) {
                    this.updateNote = true;
                }
                if (context.hasPermission(request.getCourseOffering().getId(), "CourseOffering", Right.EditCourseOfferingCoordinators)) {
                    this.updateCoordinators = true;
                }
                if (this.updateNote || this.updateCoordinators) {
                    this.limitedEdit = !context.hasPermission(request.getCourseOffering().getId(), "CourseOffering", Right.EditCourseOffering);
                } else {
                    context.checkPermission(request.getCourseOffering().getId(), "CourseOffering", Right.EditCourseOffering);
                }
                CourseOffering courseOffering = this.update(request.getCourseOffering(), context);
                request.getCourseOffering().setInstrOfferingId(courseOffering.getInstructionalOffering().getUniqueId());
            }
        }
        return request.getCourseOffering();
    }

    private Boolean isWaitlistingProhibited(CourseOfferingInterface courseOfferingInterface, OverrideType prohibitedOverride) {
        if (prohibitedOverride != null && (courseOfferingInterface.getWaitList() == null ? InstructionalOffering.getDefaultWaitListMode().isWaitlist() : courseOfferingInterface.getWaitList().intValue() == InstructionalOffering.OfferingWaitListMode.WaitList.ordinal()) && !courseOfferingInterface.getCourseOverrides().contains(prohibitedOverride.getUniqueId().toString())) {
            return true;
        }
        return false;
    }

    protected CourseOffering update(CourseOfferingInterface courseOfferingInterface, SessionContext context) throws GwtRpcException {
        Transaction tx = null;
        String title = courseOfferingInterface.getTitle();
        String note = courseOfferingInterface.getScheduleBookNote();
        String crsNbr = courseOfferingInterface.getCourseNbr();
        try {
            Session hibSession = CourseOfferingDAO.getInstance().getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            Boolean allowParentCourseOfferings = ApplicationProperty.StudentSchedulingParentCourse.isTrue() && context.hasPermission(Right.EditCourseOfferingAssociatedCourse);
            CourseOffering courseOffering = (CourseOffering)CourseOfferingDAO.getInstance().get(courseOfferingInterface.getId(), hibSession);
            InstructionalOffering io = courseOffering.getInstructionalOffering();
            if (!this.limitedEdit || this.updateNote) {
                courseOffering.setScheduleBookNote(note);
            }
            courseOffering.getDisabledOverrides().clear();
            if (courseOfferingInterface.getCourseOverrides() != null) {
                for (String override : courseOfferingInterface.getCourseOverrides()) {
                    courseOffering.getDisabledOverrides().add((OverrideType)OverrideTypeDAO.getInstance().get(Long.valueOf(override)));
                }
            }
            if (courseOffering.isIsControl().booleanValue()) {
                io.setWaitlistMode(courseOfferingInterface.getWaitList());
                if (this.limitedEdit) {
                    hibSession.merge((Object)io);
                }
            }
            if ((!this.limitedEdit || this.updateCoordinators) && courseOffering.isIsControl().booleanValue()) {
                boolean assignTeachingRequest = Department.isInstructorSchedulingCommitted(courseOffering.getDepartment().getUniqueId());
                if (io.getOfferingCoordinators() == null) {
                    io.setOfferingCoordinators(new HashSet<OfferingCoordinator>());
                }
                ArrayList<OfferingCoordinator> coordinators = new ArrayList<OfferingCoordinator>(io.getOfferingCoordinators());
                for (int i = 0; i < courseOfferingInterface.getSendCoordinators().size(); ++i) {
                    TeachingResponsibility responsibility;
                    CourseOfferingInterface.CoordinatorInterface coordinatorObject = courseOfferingInterface.getSendCoordinators().get(i);
                    String instructorId = coordinatorObject.getInstructorId();
                    String responsibilityId = coordinatorObject.getResponsibilityId();
                    String percShare = coordinatorObject.getPercShare();
                    DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(Long.valueOf(instructorId));
                    TeachingResponsibility teachingResponsibility = responsibility = Constants.BLANK_OPTION_VALUE.equals(responsibilityId) || "-".equals(responsibilityId) ? null : (TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(Long.valueOf(responsibilityId));
                    if (instructor == null) continue;
                    BaseOfferingCoordinator coordinator = null;
                    Iterator<Object> j = coordinators.iterator();
                    while (j.hasNext()) {
                        OfferingCoordinator c = (OfferingCoordinator)j.next();
                        if (!instructor.equals(c.getInstructor())) continue;
                        coordinator = c;
                        j.remove();
                        break;
                    }
                    if (coordinator == null) {
                        coordinator = new OfferingCoordinator();
                        coordinator.setInstructor(instructor);
                        coordinator.setOffering(io);
                        if (assignTeachingRequest) {
                            for (TeachingRequest tr : io.getTeachingRequests()) {
                                if (!tr.getAssignCoordinator().booleanValue() || !tr.getAssignedInstructors().contains(instructor)) continue;
                                coordinator.setTeachingRequest(tr);
                                break;
                            }
                        }
                    }
                    coordinator.setResponsibility(responsibility);
                    try {
                        coordinator.setPercentShare(percShare == null ? 0 : Integer.parseInt(percShare));
                    }
                    catch (NumberFormatException e) {
                        coordinator.setPercentShare(0);
                    }
                    io.getOfferingCoordinators().add((OfferingCoordinator)coordinator);
                    instructor.getOfferingCoordinators().add((OfferingCoordinator)coordinator);
                    if (coordinator.getUniqueId() == null) {
                        hibSession.persist((Object)coordinator);
                        continue;
                    }
                    hibSession.merge((Object)coordinator);
                }
                for (OfferingCoordinator coordinator : coordinators) {
                    coordinator.getInstructor().getOfferingCoordinators().remove(coordinator);
                    io.getOfferingCoordinators().remove(coordinator);
                    hibSession.remove((Object)coordinator);
                }
                Boolean coursesFundingDepartmentsEnabled = ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue();
                if (coursesFundingDepartmentsEnabled.booleanValue()) {
                    if (courseOfferingInterface.getFundingDepartmentId() == null) {
                        courseOffering.setFundingDept(null);
                    } else {
                        Department dept = (Department)DepartmentDAO.getInstance().get(courseOfferingInterface.getFundingDepartmentId(), hibSession);
                        if (dept.equals(courseOffering.getEffectiveFundingDept())) {
                            courseOffering.setFundingDept(null);
                        } else {
                            courseOffering.setFundingDept(dept == null ? null : dept);
                        }
                    }
                }
                if (this.limitedEdit) {
                    hibSession.merge((Object)io);
                }
            }
            if (!this.limitedEdit) {
                CourseOffering dco;
                if (courseOffering.getCourseNbr() != null && !courseOffering.getCourseNbr().equals(crsNbr) && courseOffering.getPermId() == null) {
                    LastLikeCourseDemand llcd2 = null;
                    String permId = InstrOfferingPermIdGenerator.getGenerator().generate((SharedSessionContractImplementor)((SessionImplementor)CourseOfferingDAO.getInstance().getSession()), courseOffering).toString();
                    for (LastLikeCourseDemand llcd2 : courseOffering.getCourseOfferingDemands()) {
                        if (llcd2.getCoursePermId() != null) continue;
                        llcd2.setCoursePermId(permId);
                        hibSession.merge((Object)llcd2);
                    }
                    courseOffering.setPermId(permId);
                }
                courseOffering.setCourseNbr(crsNbr);
                courseOffering.setTitle(title);
                if (courseOfferingInterface.getDemandOfferingId() == null) {
                    courseOffering.setDemandOffering(null);
                } else {
                    CourseOffering dco2 = (CourseOffering)CourseOfferingDAO.getInstance().get(courseOfferingInterface.getDemandOfferingId(), hibSession);
                    courseOffering.setDemandOffering(dco2 == null ? null : dco2);
                }
                Boolean allowAlternativeCourseOfferings = ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue();
                if (allowAlternativeCourseOfferings.booleanValue()) {
                    if (courseOfferingInterface.getAlternativeCourseOfferingId() == null) {
                        courseOffering.setAlternativeOffering(null);
                    } else {
                        dco = (CourseOffering)CourseOfferingDAO.getInstance().get(courseOfferingInterface.getAlternativeCourseOfferingId(), hibSession);
                        courseOffering.setAlternativeOffering(dco == null ? null : dco);
                    }
                }
                if (allowParentCourseOfferings.booleanValue()) {
                    if (courseOfferingInterface.getParentCourseOfferingId() == null) {
                        courseOffering.setParentOffering(null);
                    } else {
                        dco = (CourseOffering)CourseOfferingDAO.getInstance().get(courseOfferingInterface.getParentCourseOfferingId(), hibSession);
                        courseOffering.setParentOffering(dco == null ? null : dco);
                    }
                }
                if (courseOfferingInterface.getCourseTypeId() == null) {
                    courseOffering.setCourseType(null);
                } else {
                    CourseType courseType = (CourseType)CourseTypeDAO.getInstance().get(courseOfferingInterface.getCourseTypeId(), hibSession);
                    courseOffering.setCourseType(courseType == null ? null : courseType);
                }
                if (courseOfferingInterface.getConsent() != null) {
                    courseOffering.setConsentType((OfferingConsentType)OfferingConsentTypeDAO.getInstance().get(courseOfferingInterface.getConsent()));
                } else {
                    courseOffering.setConsentType(null);
                }
                if (courseOfferingInterface.getCreditFormat() == null || courseOfferingInterface.getCreditFormat().length() == 0 || courseOfferingInterface.getCreditFormat().equals(Constants.BLANK_OPTION_VALUE)) {
                    CourseCreditUnitConfig origConfig = courseOffering.getCredit();
                    if (origConfig != null) {
                        courseOffering.setCredit(null);
                        hibSession.remove((Object)origConfig);
                    }
                } else {
                    if (courseOffering.getCredit() != null) {
                        CourseCreditUnitConfig ccuc = courseOffering.getCredit();
                        if (ccuc.getCreditFormat().equals(courseOfferingInterface.getCreditFormat())) {
                            boolean changed = false;
                            if (!ccuc.getCreditType().getUniqueId().equals(courseOfferingInterface.getCreditType())) {
                                changed = true;
                            }
                            if (!ccuc.getCreditUnitType().getUniqueId().equals(courseOfferingInterface.getCreditUnitType())) {
                                changed = true;
                            }
                            if (ccuc instanceof FixedCreditUnitConfig) {
                                FixedCreditUnitConfig fcuc = (FixedCreditUnitConfig)ccuc;
                                if (!fcuc.getFixedUnits().equals(courseOfferingInterface.getUnits())) {
                                    changed = true;
                                }
                            } else if (ccuc instanceof VariableFixedCreditUnitConfig) {
                                VariableRangeCreditUnitConfig vrcuc;
                                VariableFixedCreditUnitConfig vfcuc = (VariableFixedCreditUnitConfig)ccuc;
                                if (!vfcuc.getMinUnits().equals(courseOfferingInterface.getUnits())) {
                                    changed = true;
                                }
                                if (!vfcuc.getMaxUnits().equals(courseOfferingInterface.getMaxUnits())) {
                                    changed = true;
                                }
                                if (vfcuc instanceof VariableRangeCreditUnitConfig && ((vrcuc = (VariableRangeCreditUnitConfig)vfcuc).isFractionalIncrementsAllowed() == null || !vrcuc.isFractionalIncrementsAllowed().equals(courseOfferingInterface.getFractionalIncrementsAllowed()))) {
                                    changed = true;
                                }
                            }
                            if (changed) {
                                CourseCreditUnitConfig origConfig = courseOffering.getCredit();
                                courseOffering.setCredit(null);
                                hibSession.remove((Object)origConfig);
                                courseOffering.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(courseOfferingInterface.getCreditFormat(), courseOfferingInterface.getCreditType(), courseOfferingInterface.getCreditUnitType(), courseOfferingInterface.getUnits(), courseOfferingInterface.getMaxUnits(), courseOfferingInterface.getFractionalIncrementsAllowed(), (Boolean)true));
                                courseOffering.getCredit().setOwner(courseOffering);
                            }
                        } else {
                            CourseCreditUnitConfig origConfig = courseOffering.getCredit();
                            courseOffering.setCredit(null);
                            hibSession.remove((Object)origConfig);
                            courseOffering.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(courseOfferingInterface.getCreditFormat(), courseOfferingInterface.getCreditType(), courseOfferingInterface.getCreditUnitType(), courseOfferingInterface.getUnits(), courseOfferingInterface.getMaxUnits(), courseOfferingInterface.getFractionalIncrementsAllowed(), (Boolean)true));
                            courseOffering.getCredit().setOwner(courseOffering);
                        }
                    } else {
                        courseOffering.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(courseOfferingInterface.getCreditFormat(), courseOfferingInterface.getCreditType(), courseOfferingInterface.getCreditUnitType(), courseOfferingInterface.getUnits(), courseOfferingInterface.getMaxUnits(), courseOfferingInterface.getFractionalIncrementsAllowed(), (Boolean)true));
                        courseOffering.getCredit().setOwner(courseOffering);
                    }
                    if (courseOffering.getCredit() != null) {
                        if (courseOffering.getCredit().getUniqueId() == null) {
                            hibSession.persist((Object)courseOffering.getCredit());
                        } else {
                            hibSession.merge((Object)courseOffering.getCredit());
                        }
                    }
                }
                if (courseOffering.isIsControl().booleanValue()) {
                    io.setByReservationOnly(courseOfferingInterface.getByReservationOnly());
                    try {
                        io.setLastWeekToEnroll(courseOfferingInterface.getLastWeekToEnroll());
                    }
                    catch (Exception e) {
                        io.setLastWeekToEnroll(null);
                    }
                    try {
                        io.setLastWeekToChange(courseOfferingInterface.getLastWeekToChange());
                    }
                    catch (Exception e) {
                        io.setLastWeekToChange(null);
                    }
                    try {
                        io.setLastWeekToDrop(courseOfferingInterface.getLastWeekToDrop());
                    }
                    catch (Exception e) {
                        io.setLastWeekToDrop(null);
                    }
                    io.setNotes(courseOfferingInterface.getNotes() == null || courseOfferingInterface.getNotes().length() <= 2000 ? courseOfferingInterface.getNotes() : courseOfferingInterface.getNotes().substring(0, 2000));
                    hibSession.merge((Object)io);
                }
                if (ApplicationProperty.CourseOfferingEditExternalIds.isTrue()) {
                    courseOffering.setExternalUniqueId(courseOfferingInterface.getExternalId() == null || courseOfferingInterface.getExternalId().isEmpty() ? null : courseOfferingInterface.getExternalId());
                }
            }
            hibSession.merge((Object)courseOffering);
            ChangeLog.addChange(hibSession, context, courseOffering, ChangeLog.Source.COURSE_OFFERING_EDIT, ChangeLog.Operation.UPDATE, courseOffering.getSubjectArea(), courseOffering.getDepartment());
            if (this.limitedEdit && this.permissionOfferingLockNeeded.check(context.getUser(), io)) {
                StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), io.getSessionId(), io.getUniqueId());
            }
            hibSession.flush();
            tx.commit();
            String className = ApplicationProperty.ExternalActionCourseOfferingEdit.value();
            if (className != null && className.trim().length() > 0) {
                if (io == null) {
                    io = courseOffering.getInstructionalOffering();
                }
                ExternalCourseOfferingEditAction editAction = (ExternalCourseOfferingEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                editAction.performExternalCourseOfferingEditAction(io, hibSession);
            }
            return courseOffering;
        }
        catch (Exception e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected CourseOffering save(CourseOfferingInterface courseOfferingInterface, SessionContext context) throws GwtRpcException {
        Transaction tx = null;
        InstructionalOffering io = new InstructionalOffering();
        try {
            String className2;
            String className1;
            Boolean canEditExternalIds;
            Boolean coursesFundingDepartmentsEnabled;
            CourseOffering dco;
            Session hibSession = CourseOfferingDAO.getInstance().getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            Boolean allowParentCourseOfferings = ApplicationProperty.StudentSchedulingParentCourse.isTrue() && context.hasPermission(Right.EditCourseOfferingAssociatedCourse);
            CourseOffering courseOffering = new CourseOffering();
            courseOffering.setCourseNbr(courseOfferingInterface.getCourseNbr());
            courseOffering.setTitle(courseOfferingInterface.getTitle());
            courseOffering.setScheduleBookNote(courseOfferingInterface.getScheduleBookNote());
            SubjectArea subjArea = (SubjectArea)SubjectAreaDAO.getInstance().get(courseOfferingInterface.getSubjectAreaId(), hibSession);
            courseOffering.setSubjectArea(subjArea);
            courseOffering.setSubjectAreaAbbv(subjArea.getSubjectAreaAbbreviation());
            courseOffering.setProjectedDemand(0);
            courseOffering.setDemand(0);
            courseOffering.setNbrExpectedStudents(0);
            courseOffering.setIsControl(true);
            courseOffering.setPermId(InstrOfferingPermIdGenerator.getGenerator().generate((SharedSessionContractImplementor)((SessionImplementor)CourseOfferingDAO.getInstance().getSession()), courseOffering).toString());
            subjArea.getCourseOfferings().add(courseOffering);
            io.setNotOffered(false);
            io.setSession(subjArea.getSession());
            io.generateInstrOfferingPermId();
            io.setWaitlistMode(courseOfferingInterface.getWaitList());
            courseOffering.setInstructionalOffering(io);
            io.addToCourseOfferings(courseOffering);
            courseOffering.setDisabledOverrides(new HashSet<OverrideType>());
            if (courseOfferingInterface.getCourseOverrides() != null) {
                for (String override : courseOfferingInterface.getCourseOverrides()) {
                    courseOffering.getDisabledOverrides().add((OverrideType)OverrideTypeDAO.getInstance().get(Long.valueOf(override)));
                }
            }
            io.setByReservationOnly(courseOfferingInterface.getByReservationOnly());
            io.setLastWeekToChange(courseOfferingInterface.getLastWeekToChange());
            io.setLastWeekToEnroll(courseOfferingInterface.getLastWeekToEnroll());
            io.setLastWeekToDrop(courseOfferingInterface.getLastWeekToDrop());
            io.setNotes(courseOfferingInterface.getNotes() == null || courseOfferingInterface.getNotes().length() <= 2000 ? courseOfferingInterface.getNotes() : courseOfferingInterface.getNotes().substring(0, 2000));
            io.setOfferingCoordinators(new HashSet<OfferingCoordinator>());
            for (int i = 0; i < courseOfferingInterface.getSendCoordinators().size(); ++i) {
                TeachingResponsibility responsibility;
                CourseOfferingInterface.CoordinatorInterface coordinatorObject = courseOfferingInterface.getSendCoordinators().get(i);
                String instructorId = coordinatorObject.getInstructorId();
                String responsibilityId = coordinatorObject.getResponsibilityId();
                String percShare = coordinatorObject.getPercShare();
                DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(Long.valueOf(instructorId));
                TeachingResponsibility teachingResponsibility = responsibility = Constants.BLANK_OPTION_VALUE.equals(responsibilityId) || "-".equals(responsibilityId) ? null : (TeachingResponsibility)TeachingResponsibilityDAO.getInstance().get(Long.valueOf(responsibilityId));
                if (instructor == null) continue;
                OfferingCoordinator coordinator = new OfferingCoordinator();
                coordinator.setInstructor(instructor);
                coordinator.setOffering(io);
                coordinator.setResponsibility(responsibility);
                try {
                    coordinator.setPercentShare(percShare == null ? 0 : Integer.parseInt(percShare));
                }
                catch (NumberFormatException e) {
                    coordinator.setPercentShare(0);
                }
                io.getOfferingCoordinators().add(coordinator);
                instructor.getOfferingCoordinators().add(coordinator);
            }
            if (courseOfferingInterface.getDemandOfferingId() == null) {
                courseOffering.setDemandOffering(null);
            } else {
                CourseOffering dco2 = (CourseOffering)CourseOfferingDAO.getInstance().get(courseOfferingInterface.getDemandOfferingId(), hibSession);
                courseOffering.setDemandOffering(dco2 == null ? null : dco2);
            }
            Boolean allowAlternativeCourseOfferings = ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue();
            if (allowAlternativeCourseOfferings.booleanValue()) {
                if (courseOfferingInterface.getAlternativeCourseOfferingId() == null) {
                    courseOffering.setAlternativeOffering(null);
                } else {
                    dco = (CourseOffering)CourseOfferingDAO.getInstance().get(courseOfferingInterface.getAlternativeCourseOfferingId(), hibSession);
                    courseOffering.setAlternativeOffering(dco == null ? null : dco);
                }
            }
            if (allowParentCourseOfferings.booleanValue()) {
                if (courseOfferingInterface.getParentCourseOfferingId() == null) {
                    courseOffering.setParentOffering(null);
                } else {
                    dco = (CourseOffering)CourseOfferingDAO.getInstance().get(courseOfferingInterface.getParentCourseOfferingId(), hibSession);
                    courseOffering.setParentOffering(dco == null ? null : dco);
                }
            }
            if ((coursesFundingDepartmentsEnabled = Boolean.valueOf(ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue())).booleanValue()) {
                if (courseOfferingInterface.getFundingDepartmentId() == null) {
                    courseOffering.setFundingDept(null);
                } else {
                    Department dept = (Department)DepartmentDAO.getInstance().get(courseOfferingInterface.getFundingDepartmentId(), hibSession);
                    if (dept.equals(courseOffering.getEffectiveFundingDept())) {
                        courseOffering.setFundingDept(null);
                    } else {
                        courseOffering.setFundingDept(dept == null ? null : dept);
                    }
                }
            }
            if ((canEditExternalIds = Boolean.valueOf(ApplicationProperty.CourseOfferingEditExternalIds.isTrue())).booleanValue()) {
                if (courseOfferingInterface.getExternalId() == null || courseOfferingInterface.getExternalId().isEmpty()) {
                    courseOffering.setExternalUniqueId(null);
                } else {
                    courseOffering.setExternalUniqueId(courseOfferingInterface.getExternalId());
                }
            }
            if (courseOfferingInterface.getCourseTypeId() == null) {
                courseOffering.setCourseType(null);
            } else {
                CourseType courseType = (CourseType)CourseTypeDAO.getInstance().get(courseOfferingInterface.getCourseTypeId(), hibSession);
                courseOffering.setCourseType((CourseType)(courseType == null ? null : courseType));
            }
            if (courseOfferingInterface.getConsent() != null) {
                courseOffering.setConsentType((OfferingConsentType)OfferingConsentTypeDAO.getInstance().get(courseOfferingInterface.getConsent()));
            }
            hibSession.persist((Object)io);
            hibSession.persist((Object)courseOffering);
            courseOffering.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(courseOfferingInterface.getCreditFormat(), courseOfferingInterface.getCreditType(), courseOfferingInterface.getCreditUnitType(), courseOfferingInterface.getUnits(), courseOfferingInterface.getMaxUnits(), courseOfferingInterface.getFractionalIncrementsAllowed(), (Boolean)true));
            if (courseOffering.getCredit() != null) {
                courseOffering.getCredit().setOwner(courseOffering);
                hibSession.persist((Object)courseOffering.getCredit());
            }
            for (OfferingCoordinator coordinator : io.getOfferingCoordinators()) {
                hibSession.persist((Object)coordinator);
            }
            hibSession.flush();
            ChangeLog.addChange(hibSession, context, courseOffering, ChangeLog.Source.COURSE_OFFERING_EDIT, ChangeLog.Operation.CREATE, courseOffering.getSubjectArea(), courseOffering.getDepartment());
            tx.commit();
            courseOfferingInterface.setId(courseOffering.getUniqueId());
            if (context.hasPermission(io, Right.OfferingCanLock)) {
                io.getSession().lockOffering(io.getUniqueId());
            }
            if (this.permissionOfferingLockNeeded.check(context.getUser(), io)) {
                StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), io.getSessionId(), io.getUniqueId());
            }
            if ((className1 = ApplicationProperty.ExternalActionInstructionalOfferingAdd.value()) != null && className1.trim().length() > 0) {
                ExternalInstructionalOfferingAddAction addAction = (ExternalInstructionalOfferingAddAction)Class.forName(className1).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                addAction.performExternalInstructionalOfferingAddAction(io, hibSession);
            }
            if ((className2 = ApplicationProperty.ExternalActionCourseOfferingEdit.value()) != null && className2.trim().length() > 0) {
                ExternalCourseOfferingEditAction editAction = (ExternalCourseOfferingEditAction)Class.forName(className2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                editAction.performExternalCourseOfferingEditAction(io, hibSession);
            }
            return courseOffering;
        }
        catch (Exception e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }
}

