/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.CriticalCoursesQuery;
import org.unitime.timetable.onlinesectioning.custom.purdue.DegreeWorksCourseRequests;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;

public class CriticalCoursesExplorers
extends CriticalCoursesQuery {
    protected DegreeWorksCourseRequests iDGW = new DegreeWorksCourseRequests();

    protected boolean isFallBackToDegreeWorks() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.unex.useDgwFallback", "true"));
    }

    protected String getGroupType() {
        return ApplicationProperties.getProperty("banner.unex.groupType", "1st Choice");
    }

    @Override
    protected List<XAreaClassificationMajor> getAreaClasfMajors(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        ArrayList<XAreaClassificationMajor> ret = this.isFallBackToDegreeWorks() ? new ArrayList<XAreaClassificationMajor>() : null;
        String gType = this.getGroupType();
        String clasf = "01";
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.unex.checkClassification", "true")) && student.getMajors() != null) {
            for (XAreaClassificationMajor acm : student.getMajors()) {
                clasf = acm.getClassification();
            }
        }
        for (XStudent.XGroup g : student.getGroups()) {
            if (!gType.equals(g.getType()) || !g.getAbbreviation().contains("-")) continue;
            String area = g.getAbbreviation().substring(0, g.getAbbreviation().indexOf(45));
            String major = g.getAbbreviation().substring(g.getAbbreviation().indexOf(45) + 1);
            if (ret == null) {
                ret = new ArrayList<XAreaClassificationMajor>(student.getMajors());
            }
            ret.add(new XAreaClassificationMajor(area, clasf, major));
        }
        return ret != null ? ret : student.getMajors();
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) {
        return this.getCriticalCourses(server, helper, student, helper.getAction());
    }

    @Override
    public CriticalCoursesProvider.CriticalCourses getCriticalCourses(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId studentId, OnlineSectioningLog.Action.Builder action) {
        if (this.isFallBackToDegreeWorks()) {
            CriticalCoursesProvider.CriticalCourses critQuery = super.getCriticalCourses(server, helper, studentId, action);
            if (critQuery != null && !critQuery.isEmpty()) {
                CriticalCoursesProvider.CriticalCourses critDgw = this.iDGW.getCriticalCourses(server, helper, studentId, action);
                if (critDgw == null || critDgw.isEmpty()) {
                    return critQuery;
                }
                return new CombinedCriticals(critDgw, critQuery);
            }
            return this.iDGW.getCriticalCourses(server, helper, studentId, action);
        }
        return super.getCriticalCourses(server, helper, studentId, action);
    }

    @Override
    public List<DegreePlanInterface> getDegreePlans(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, CourseMatcher matcher) throws SectioningException {
        if (this.isFallBackToDegreeWorks()) {
            List<DegreePlanInterface> plans = super.getDegreePlans(server, helper, student, matcher);
            if (plans == null || plans.isEmpty()) {
                return this.iDGW.getDegreePlans(server, helper, student, matcher);
            }
            List<DegreePlanInterface> dgw = this.iDGW.getDegreePlans(server, helper, student, matcher);
            if (dgw != null) {
                plans.addAll(dgw);
            }
            return plans;
        }
        return super.getDegreePlans(server, helper, student, matcher);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.iDGW.dispose();
    }

    public static class CombinedCriticals
    implements CriticalCoursesProvider.CriticalCourses {
        private CriticalCoursesProvider.CriticalCourses iPrimary;
        private CriticalCoursesProvider.CriticalCourses iSecondary;

        public CombinedCriticals(CriticalCoursesProvider.CriticalCourses primary, CriticalCoursesProvider.CriticalCourses secondary) {
            this.iPrimary = primary;
            this.iSecondary = secondary;
        }

        @Override
        public boolean isEmpty() {
            return this.iPrimary.isEmpty() && this.iSecondary.isEmpty();
        }

        @Override
        public int isCritical(CourseOffering course) {
            int crit = this.iPrimary.isCritical(course);
            if (crit > 0) {
                return crit;
            }
            return this.iSecondary.isCritical(course);
        }

        @Override
        public int isCritical(XCourseId course) {
            int crit = this.iPrimary.isCritical(course);
            if (crit > 0) {
                return crit;
            }
            return this.iSecondary.isCritical(course);
        }
    }
}

