/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;

@MappedSuperclass
public abstract class BasePreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Set<Preference> iPreferences;
    private Set<DistributionObject> iDistributionObjects;

    public BasePreferenceGroup() {
    }

    public BasePreferenceGroup(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="owner", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Preference> getPreferences() {
        return this.iPreferences;
    }

    public void setPreferences(Set<Preference> preferences) {
        this.iPreferences = preferences;
    }

    public void addToPreferences(Preference preference) {
        if (this.iPreferences == null) {
            this.iPreferences = new HashSet<Preference>();
        }
        this.iPreferences.add(preference);
    }

    @Deprecated
    public void addTopreferences(Preference preference) {
        this.addToPreferences(preference);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="prefGroup", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DistributionObject> getDistributionObjects() {
        return this.iDistributionObjects;
    }

    public void setDistributionObjects(Set<DistributionObject> distributionObjects) {
        this.iDistributionObjects = distributionObjects;
    }

    public void addToDistributionObjects(DistributionObject distributionObject) {
        if (this.iDistributionObjects == null) {
            this.iDistributionObjects = new HashSet<DistributionObject>();
        }
        this.iDistributionObjects.add(distributionObject);
    }

    @Deprecated
    public void addTodistributionObjects(DistributionObject distributionObject) {
        this.addToDistributionObjects(distributionObject);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PreferenceGroup)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PreferenceGroup)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PreferenceGroup)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PreferenceGroup[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PreferenceGroup[\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

