/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PitInstrOfferingConfig;
import org.unitime.timetable.model.PitSchedulingSubpart;
import org.unitime.timetable.model.SchedulingSubpart;

@MappedSuperclass
public abstract class BasePitSchedulingSubpart
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iMinutesPerWk;
    private Boolean iStudentAllowOverlap;
    private String iSchedulingSubpartSuffixCache;
    private Float iCredit;
    private String iCourseName;
    private Long iUniqueIdRolledForwardFrom;
    private CourseCreditType iCreditType;
    private CourseCreditUnitType iCreditUnitType;
    private ItypeDesc iItype;
    private SchedulingSubpart iSchedulingSubpart;
    private PitSchedulingSubpart iPitParentSubpart;
    private PitInstrOfferingConfig iPitInstrOfferingConfig;
    private Set<PitSchedulingSubpart> iPitChildSubparts;
    private Set<PitClass> iPitClasses;

    public BasePitSchedulingSubpart() {
    }

    public BasePitSchedulingSubpart(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="min_per_wk", nullable=false, length=4)
    public Integer getMinutesPerWk() {
        return this.iMinutesPerWk;
    }

    public void setMinutesPerWk(Integer minutesPerWk) {
        this.iMinutesPerWk = minutesPerWk;
    }

    @Column(name="student_allow_overlap", nullable=false)
    public Boolean isStudentAllowOverlap() {
        return this.iStudentAllowOverlap;
    }

    @Transient
    public Boolean getStudentAllowOverlap() {
        return this.iStudentAllowOverlap;
    }

    public void setStudentAllowOverlap(Boolean studentAllowOverlap) {
        this.iStudentAllowOverlap = studentAllowOverlap;
    }

    @Column(name="subpart_suffix", nullable=true, length=5)
    public String getSchedulingSubpartSuffixCache() {
        return this.iSchedulingSubpartSuffixCache;
    }

    public void setSchedulingSubpartSuffixCache(String schedulingSubpartSuffixCache) {
        this.iSchedulingSubpartSuffixCache = schedulingSubpartSuffixCache;
    }

    @Column(name="credit", nullable=true)
    public Float getCredit() {
        return this.iCredit;
    }

    public void setCredit(Float credit) {
        this.iCredit = credit;
    }

    @Formula(value="(select concat( concat( sa.subject_area_abbreviation , ' ') , co.course_nbr) from %SCHEMA%.pit_sched_subpart s, %SCHEMA%.pit_instr_offer_config c, %SCHEMA%.pit_instr_offering io, %SCHEMA%.pit_course_offering co, %SCHEMA%.subject_area sa where s.uniqueid=uniqueid and s.pit_config_id=c.uniqueid and c.pit_instr_offr_id=io.uniqueid and co.is_control = %TRUE% and co.pit_instr_offr_id=io.uniqueid and co.subject_area_id=sa.uniqueid)")
    public String getCourseName() {
        return this.iCourseName;
    }

    public void setCourseName(String courseName) {
        this.iCourseName = courseName;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="credit_type", nullable=true)
    public CourseCreditType getCreditType() {
        return this.iCreditType;
    }

    public void setCreditType(CourseCreditType creditType) {
        this.iCreditType = creditType;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="credit_unit_type", nullable=true)
    public CourseCreditUnitType getCreditUnitType() {
        return this.iCreditUnitType;
    }

    public void setCreditUnitType(CourseCreditUnitType creditUnitType) {
        this.iCreditUnitType = creditUnitType;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="itype", nullable=false)
    public ItypeDesc getItype() {
        return this.iItype;
    }

    public void setItype(ItypeDesc itype) {
        this.iItype = itype;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="scheduling_subpart_id", nullable=true)
    public SchedulingSubpart getSchedulingSubpart() {
        return this.iSchedulingSubpart;
    }

    public void setSchedulingSubpart(SchedulingSubpart schedulingSubpart) {
        this.iSchedulingSubpart = schedulingSubpart;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="pit_parent_id", nullable=true)
    public PitSchedulingSubpart getPitParentSubpart() {
        return this.iPitParentSubpart;
    }

    public void setPitParentSubpart(PitSchedulingSubpart pitParentSubpart) {
        this.iPitParentSubpart = pitParentSubpart;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="pit_config_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public PitInstrOfferingConfig getPitInstrOfferingConfig() {
        return this.iPitInstrOfferingConfig;
    }

    public void setPitInstrOfferingConfig(PitInstrOfferingConfig pitInstrOfferingConfig) {
        this.iPitInstrOfferingConfig = pitInstrOfferingConfig;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitParentSubpart", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitSchedulingSubpart> getPitChildSubparts() {
        return this.iPitChildSubparts;
    }

    public void setPitChildSubparts(Set<PitSchedulingSubpart> pitChildSubparts) {
        this.iPitChildSubparts = pitChildSubparts;
    }

    public void addToPitChildSubparts(PitSchedulingSubpart pitSchedulingSubpart) {
        if (this.iPitChildSubparts == null) {
            this.iPitChildSubparts = new HashSet<PitSchedulingSubpart>();
        }
        this.iPitChildSubparts.add(pitSchedulingSubpart);
    }

    @Deprecated
    public void addTopitChildSubparts(PitSchedulingSubpart pitSchedulingSubpart) {
        this.addToPitChildSubparts(pitSchedulingSubpart);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitSchedulingSubpart", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitClass> getPitClasses() {
        return this.iPitClasses;
    }

    public void setPitClasses(Set<PitClass> pitClasses) {
        this.iPitClasses = pitClasses;
    }

    public void addToPitClasses(PitClass pitClass) {
        if (this.iPitClasses == null) {
            this.iPitClasses = new HashSet<PitClass>();
        }
        this.iPitClasses.add(pitClass);
    }

    @Deprecated
    public void addTopitClasses(PitClass pitClass) {
        this.addToPitClasses(pitClass);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitSchedulingSubpart)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitSchedulingSubpart)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitSchedulingSubpart)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitSchedulingSubpart[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitSchedulingSubpart[\n\tCredit: " + this.getCredit() + "\n\tCreditType: " + String.valueOf(this.getCreditType()) + "\n\tCreditUnitType: " + String.valueOf(this.getCreditUnitType()) + "\n\tItype: " + String.valueOf(this.getItype()) + "\n\tMinutesPerWk: " + this.getMinutesPerWk() + "\n\tPitInstrOfferingConfig: " + String.valueOf(this.getPitInstrOfferingConfig()) + "\n\tPitParentSubpart: " + String.valueOf(this.getPitParentSubpart()) + "\n\tSchedulingSubpart: " + String.valueOf(this.getSchedulingSubpart()) + "\n\tSchedulingSubpartSuffixCache: " + this.getSchedulingSubpartSuffixCache() + "\n\tStudentAllowOverlap: " + this.getStudentAllowOverlap() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

