/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.test;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class OnlineSectioningTest
extends Composite {
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private DateTimeFormat iDF = DateTimeFormat.getFormat((String)"HH:mm:ss.SSS");
    private NumberFormat iDecF = NumberFormat.getFormat((String)"00");
    private NumberFormat iAvgF = NumberFormat.getFormat((String)"0.000");
    private UniTimeWidget<UniTimeTextBox> iNbrThreads;
    private UniTimeWidget<UniTimeTextBox> iPin;
    private UniTimeWidget<TextArea> iCourses;
    private UniTimeWidget<TextArea> iStudents;
    private CheckBox iWaitList;
    private UniTimeHeaderPanel iHeader;
    private VerticalPanel iLog;
    private Test[] iTest;
    private Label iAverage;
    private long iTotal = 0L;
    private long iTotalEligibility = 0L;
    private long iTotalLookup = 0L;
    private long iTotalCheck = 0L;
    private long iTotalSectioning = 0L;
    private long iTotalSuggestions = 0L;
    private long iTotalEnrollment = 0L;
    private long iRunTime = 0L;
    private long iStartTime = 0L;
    private int iCount = 0;
    private UniTimeWidget<ListBox> iSessions;

    public OnlineSectioningTest() {
        SimpleForm form = new SimpleForm();
        this.iHeader = new UniTimeHeaderPanel("Online Student Sectioning Test");
        form.addHeaderRow((Widget)this.iHeader);
        this.iNbrThreads = new UniTimeWidget<UniTimeTextBox>(new UniTimeTextBox());
        this.iNbrThreads.getWidget().setText("10");
        this.iNbrThreads.setHint("Number of student simulations to be run in parallel.");
        form.addRow("Number of Threads:", (Widget)this.iNbrThreads);
        this.iSessions = new UniTimeWidget<ListBox>(new ListBox());
        form.addRow("Academic Session:", (Widget)this.iSessions);
        this.iSessions.setHint("An academic session with enabled student sectioning.");
        this.iPin = new UniTimeWidget<UniTimeTextBox>(new UniTimeTextBox());
        form.addRow("PIN:", (Widget)this.iPin);
        LoadingWidget.getInstance().show("Loading...");
        this.iSectioningService.getProperties(null, new AsyncCallback<OnlineSectioningInterface.SectioningProperties>(){

            public void onFailure(Throwable caught) {
                OnlineSectioningTest.this.iHeader.setErrorMessage(caught.getMessage());
                LoadingWidget.getInstance().hide();
                UniTimeNotifications.error(caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(OnlineSectioningInterface.SectioningProperties result) {
                if (!result.isAdmin()) {
                    OnlineSectioningTest.this.iHeader.setErrorMessage("Only administrators can use this page.");
                    LoadingWidget.getInstance().hide();
                    UniTimeNotifications.error("Only administrators can use this page.");
                    return;
                }
                OnlineSectioningTest.this.iSectioningService.listAcademicSessions(true, new AsyncCallback<Collection<AcademicSessionProvider.AcademicSessionInfo>>(){

                    public void onFailure(Throwable caught) {
                        OnlineSectioningTest.this.iSessions.setErrorHint(caught.getMessage());
                        LoadingWidget.getInstance().hide();
                        UniTimeNotifications.error(caught);
                    }

                    public void onSuccess(Collection<AcademicSessionProvider.AcademicSessionInfo> result) {
                        for (AcademicSessionProvider.AcademicSessionInfo s : result) {
                            OnlineSectioningTest.this.iSessions.getWidget().addItem(s.getName(), s.getSessionId().toString());
                        }
                        OnlineSectioningTest.this.iSectioningService.lastAcademicSession(true, new AsyncCallback<AcademicSessionProvider.AcademicSessionInfo>(){

                            public void onSuccess(AcademicSessionProvider.AcademicSessionInfo result) {
                                for (int i = 0; i < OnlineSectioningTest.this.iSessions.getWidget().getItemCount(); ++i) {
                                    if (!OnlineSectioningTest.this.iSessions.getWidget().getValue(i).equals(result.getSessionId().toString())) continue;
                                    OnlineSectioningTest.this.iSessions.getWidget().setSelectedIndex(i);
                                }
                            }

                            public void onFailure(Throwable caught) {
                                OnlineSectioningTest.this.iSessions.setErrorHint(caught.getMessage());
                            }
                        });
                        if (!result.isEmpty()) {
                            OnlineSectioningTest.this.iHeader.setEnabled("start", true);
                        }
                        LoadingWidget.getInstance().hide();
                    }
                });
            }
        });
        this.iWaitList = new CheckBox();
        this.iWaitList.setValue(Boolean.valueOf(false));
        form.addRow("Wait-list:", (Widget)this.iWaitList);
        this.iCourses = new UniTimeWidget<TextArea>(new TextArea());
        this.iCourses.getWidget().setStyleName("unitime-TextArea");
        this.iCourses.getWidget().setVisibleLines(10);
        this.iCourses.getWidget().setCharacterWidth(80);
        this.iCourses.getWidget().setText("");
        this.iCourses.setHint("Courses to be used in the simulations.");
        form.addRow("Courses:", (Widget)this.iCourses);
        this.iStudents = new UniTimeWidget<TextArea>(new TextArea());
        this.iStudents.getWidget().setStyleName("unitime-TextArea");
        this.iStudents.getWidget().setVisibleLines(10);
        this.iStudents.getWidget().setCharacterWidth(80);
        this.iStudents.getWidget().setText("");
        this.iStudents.setHint("Students to be be enrolled in the simulated schedules (student unique ids), no enrollment will be made if empty.");
        form.addRow("Students:", (Widget)this.iStudents);
        this.iAverage = new Label();
        form.addRow("Average:", (Widget)this.iAverage);
        this.iLog = new VerticalPanel();
        form.addRow("Log:", (Widget)this.iLog);
        this.iHeader.addButton("start", "<u>S</u>tart", 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    OnlineSectioningTest.this.iHeader.clearMessage();
                    OnlineSectioningTest.this.iHeader.setEnabled("start", false);
                    OnlineSectioningTest.this.iHeader.setEnabled("stop", true);
                    OnlineSectioningTest.this.iNbrThreads.getWidget().setReadOnly(true);
                    OnlineSectioningTest.this.iCourses.getWidget().setReadOnly(true);
                    OnlineSectioningTest.this.iStudents.getWidget().setReadOnly(true);
                    OnlineSectioningTest.this.startTest();
                }
                catch (Exception e) {
                    OnlineSectioningTest.this.iHeader.setErrorMessage(e.getMessage());
                }
            }
        });
        this.iHeader.addButton("stop", "Sto<u>p</u>", 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    OnlineSectioningTest.this.iHeader.clearMessage();
                    OnlineSectioningTest.this.iHeader.setEnabled("start", true);
                    OnlineSectioningTest.this.iHeader.setEnabled("stop", false);
                    OnlineSectioningTest.this.iNbrThreads.getWidget().setReadOnly(false);
                    OnlineSectioningTest.this.iCourses.getWidget().setReadOnly(false);
                    OnlineSectioningTest.this.iStudents.getWidget().setReadOnly(false);
                    OnlineSectioningTest.this.stopTest();
                }
                catch (Exception e) {
                    OnlineSectioningTest.this.iHeader.setErrorMessage(e.getMessage());
                }
            }
        });
        this.iHeader.setEnabled("start", false);
        this.iHeader.setEnabled("stop", false);
        this.iHeader.addButton("clear", "<u>C</u>lear", 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                OnlineSectioningTest.this.iLog.clear();
            }
        });
        this.initWidget((Widget)form);
    }

    public void updateAverage() {
        if (this.iCount == 0) {
            this.iAverage.setText("");
        } else {
            this.iAverage.setText(this.iAvgF.format(0.001 * (double)this.iTotal / (double)this.iCount) + " s (" + this.iAvgF.format(0.001 * (double)this.iTotalEligibility / (double)this.iCount) + " s eligibility, " + this.iAvgF.format(0.001 * (double)this.iTotalLookup / (double)this.iCount) + " s lookup, " + this.iAvgF.format(0.001 * (double)this.iTotalCheck / (double)this.iCount) + " s check, " + this.iAvgF.format(0.001 * (double)this.iTotalSectioning / (double)this.iCount) + " s sectioning, " + this.iAvgF.format(0.001 * (double)this.iTotalSuggestions / (double)(2 * this.iCount)) + " s suggestions, " + this.iAvgF.format(0.001 * (double)this.iTotalEnrollment / (double)this.iCount) + " s enrollment, average from " + this.iCount + " runs, total runtime " + this.iAvgF.format(0.001 * (double)this.iRunTime) + " s).");
        }
    }

    public void startTest() {
        this.iTotal = 0L;
        this.iTotalEligibility = 0L;
        this.iTotalLookup = 0L;
        this.iTotalCheck = 0L;
        this.iTotalSectioning = 0L;
        this.iTotalSuggestions = 0L;
        this.iTotalEnrollment = 0L;
        this.iCount = 0;
        this.iStartTime = new Date().getTime();
        int nbrTests = Integer.parseInt(this.iNbrThreads.getWidget().getText());
        this.iTest = new Test[nbrTests];
        String[] students = this.iStudents.getWidget().getText().split("\\n");
        for (int i = 0; i < nbrTests; ++i) {
            this.iTest[i] = new Test(1 + i);
            if (i < students.length) {
                try {
                    this.iTest[i].setStudentId(Long.parseLong(students[i]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.iTest[i].scheduleNext();
        }
    }

    public void stopTest() {
        for (int i = 0; i < this.iTest.length; ++i) {
            this.iTest[i].stop();
        }
    }

    public class Test
    extends Timer {
        private int iIndex = 0;
        private boolean iStopped = false;
        private String[] iChoices;
        private OnlineSectioningInterface.StudentSectioningContext iContext = new OnlineSectioningInterface.StudentSectioningContext();

        public Test(int index) {
            this.iIndex = index;
            this.iChoices = OnlineSectioningTest.this.iCourses.getWidget().getText().split("\\n");
            this.iContext.setSessionId(Long.parseLong(OnlineSectioningTest.this.iSessions.getWidget().getValue(OnlineSectioningTest.this.iSessions.getWidget().getSelectedIndex())));
        }

        public void setStudentId(Long studentId) {
            this.iContext.setStudentId(studentId);
        }

        public void run() {
            try {
                final long T0 = new Date().getTime();
                this.checkEligibility(new Callback<OnlineSectioningInterface.EligibilityCheck>(){

                    @Override
                    public void execute(final OnlineSectioningInterface.EligibilityCheck eligibility, Throwable failure) {
                        if (eligibility != null && eligibility.hasMessage()) {
                            Test.this.info("eligibility: " + eligibility.getMessage() + " (enroll: " + eligibility.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL));
                        }
                        final long T1 = new Date().getTime();
                        Test.this.lookupCourses(new ArrayList<String>(), 3 + (int)(Random.nextDouble() * 5.0), new Callback<List<String>>(){

                            @Override
                            public void execute(final List<String> courses, Throwable failure) {
                                final CourseRequestInterface request = new CourseRequestInterface(Test.this.iContext);
                                for (String course : courses) {
                                    CourseRequestInterface.Request r = new CourseRequestInterface.Request();
                                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                                    rc.setCourseName(course);
                                    r.addRequestedCourse(rc);
                                    r.setWaitList(OnlineSectioningTest.this.iWaitList.getValue());
                                    request.getCourses().add(r);
                                }
                                final long T2 = new Date().getTime();
                                Test.this.checkCourses(request, new Callback<CourseRequestInterface.CheckCoursesResponse>(){

                                    @Override
                                    public void execute(CourseRequestInterface.CheckCoursesResponse success, Throwable failure) {
                                        final long T3 = new Date().getTime();
                                        Test.this.section(request, new ArrayList<ClassAssignmentInterface.ClassAssignment>(), new Callback<ClassAssignmentInterface>(){

                                            @Override
                                            public void execute(final ClassAssignmentInterface assignment, Throwable failure) {
                                                final long T4 = new Date().getTime();
                                                Test.this.computeSuggestions(request, assignment, new Callback<List<ClassAssignmentInterface>>(){

                                                    @Override
                                                    public void execute(List<ClassAssignmentInterface> suggestions, Throwable failure) {
                                                        Test.this.computeSuggestions(request, assignment, new Callback<List<ClassAssignmentInterface>>(){

                                                            @Override
                                                            public void execute(List<ClassAssignmentInterface> success, Throwable failure) {
                                                                final long T5 = new Date().getTime();
                                                                Test.this.enroll(request, assignment, eligibility, new Callback<ClassAssignmentInterface>(){

                                                                    @Override
                                                                    public void execute(ClassAssignmentInterface success, Throwable failure) {
                                                                        long T6 = new Date().getTime();
                                                                        Test.this.info("Run completed in " + OnlineSectioningTest.this.iAvgF.format(0.001 * (double)(T6 - T0)) + " s " + String.valueOf(courses) + " (lookup " + OnlineSectioningTest.this.iAvgF.format(0.001 * (double)(T2 - T1)) + " s).");
                                                                        OnlineSectioningTest.this.iTotal += T6 - T0;
                                                                        OnlineSectioningTest.this.iTotalEligibility += T1 - T0;
                                                                        OnlineSectioningTest.this.iTotalLookup += T2 - T1;
                                                                        OnlineSectioningTest.this.iTotalCheck += T3 - T2;
                                                                        OnlineSectioningTest.this.iTotalSectioning += T4 - T3;
                                                                        OnlineSectioningTest.this.iTotalSuggestions += T5 - T4;
                                                                        OnlineSectioningTest.this.iTotalEnrollment += T6 - T5;
                                                                        ++OnlineSectioningTest.this.iCount;
                                                                        OnlineSectioningTest.this.iRunTime = T6 - OnlineSectioningTest.this.iStartTime;
                                                                        OnlineSectioningTest.this.updateAverage();
                                                                        Test.this.scheduleNext();
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                this.error("Failure: " + e.getMessage());
            }
        }

        private void checkEligibility(final Callback<OnlineSectioningInterface.EligibilityCheck> callback) {
            this.debug("checkEligibility()");
            this.iContext.setPin(OnlineSectioningTest.this.iPin.getWidget().getText());
            OnlineSectioningTest.this.iSectioningService.checkEligibility(this.iContext, new AsyncCallback<OnlineSectioningInterface.EligibilityCheck>(){

                public void onSuccess(OnlineSectioningInterface.EligibilityCheck result) {
                    callback.execute(result, null);
                }

                public void onFailure(Throwable caught) {
                    Test.this.warn("&nbsp;&nbsp;checkEligibility() failed: " + caught.getMessage());
                    callback.execute(null, caught);
                }
            });
        }

        public void enroll(CourseRequestInterface request, final ClassAssignmentInterface assignment, OnlineSectioningInterface.EligibilityCheck eligibility, final Callback<ClassAssignmentInterface> callback) {
            if (request.getStudentId() == null || eligibility != null && !eligibility.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL)) {
                callback.execute(null, null);
                return;
            }
            ArrayList<ClassAssignmentInterface.ClassAssignment> assignments = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            for (ClassAssignmentInterface.CourseAssignment cx : assignment.getCourseAssignments()) {
                assignments.addAll(cx.getClassAssignments());
            }
            OnlineSectioningTest.this.iSectioningService.enroll(request, assignments, new AsyncCallback<ClassAssignmentInterface>(){

                public void onFailure(Throwable caught) {
                    Test.this.warn("&nbsp;&nbsp;enroll(" + String.valueOf(assignment.getCourseAssignments()) + ") failed: " + caught.getMessage());
                    callback.execute(null, caught);
                }

                public void onSuccess(ClassAssignmentInterface result) {
                    callback.execute(result, null);
                }
            });
        }

        public void computeSuggestions(final CourseRequestInterface request, final ClassAssignmentInterface assignment, final Callback<List<ClassAssignmentInterface>> callback) {
            ArrayList<ClassAssignmentInterface.ClassAssignment> assignments = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            for (ClassAssignmentInterface.CourseAssignment cx : assignment.getCourseAssignments()) {
                assignments.addAll(cx.getClassAssignments());
            }
            if (assignments.isEmpty()) {
                this.warn("No solution has been found to " + String.valueOf(request.getCourses()) + ".");
                ArrayList<ClassAssignmentInterface> ret = new ArrayList<ClassAssignmentInterface>();
                ret.add(assignment);
                callback.execute(ret, null);
                return;
            }
            int idx = (int)(Random.nextDouble() * (double)assignments.size());
            this.debug("computeSuggestions(" + String.valueOf(request) + "," + String.valueOf(assignments) + "," + idx + ")");
            OnlineSectioningTest.this.iSectioningService.computeSuggestions(request, assignments, idx, null, new AsyncCallback<Collection<ClassAssignmentInterface>>(){

                public void onFailure(Throwable caught) {
                    Test.this.warn("&nbsp;&nbsp;computeSuggestions(" + String.valueOf(request) + ") failed: " + caught.getMessage());
                    ArrayList<ClassAssignmentInterface> ret = new ArrayList<ClassAssignmentInterface>();
                    ret.add(assignment);
                    callback.execute(ret, caught);
                }

                public void onSuccess(Collection<ClassAssignmentInterface> result) {
                    ArrayList<ClassAssignmentInterface> ret = new ArrayList<ClassAssignmentInterface>();
                    ret.add(assignment);
                    ret.addAll(result);
                    callback.execute(ret, null);
                }
            });
        }

        public void section(final CourseRequestInterface request, ArrayList<ClassAssignmentInterface.ClassAssignment> assignment, final Callback<ClassAssignmentInterface> callback) {
            this.debug("section(" + String.valueOf(request) + "," + String.valueOf(assignment) + ")");
            OnlineSectioningTest.this.iSectioningService.section(request, assignment, new AsyncCallback<ClassAssignmentInterface>(){

                public void onFailure(Throwable caught) {
                    Test.this.warn("&nbsp;&nbsp;listClasses(" + String.valueOf(request) + ") failed: " + caught.getMessage());
                    callback.execute(null, caught);
                }

                public void onSuccess(ClassAssignmentInterface result) {
                    callback.execute(result, null);
                }
            });
        }

        private void checkCourses(final CourseRequestInterface request, final Callback<CourseRequestInterface.CheckCoursesResponse> callback) {
            this.debug("checkCourses(" + String.valueOf(request) + ")");
            OnlineSectioningTest.this.iSectioningService.checkCourses(request, new AsyncCallback<CourseRequestInterface.CheckCoursesResponse>(){

                public void onFailure(Throwable caught) {
                    Test.this.warn("&nbsp;&nbsp;checkCourses(" + String.valueOf(request) + ") failed: " + caught.getMessage());
                    callback.execute(null, caught);
                }

                public void onSuccess(CourseRequestInterface.CheckCoursesResponse result) {
                    callback.execute(result, null);
                }
            });
        }

        public void lookupCourses(final List<String> courses, final int nbrCourses, final Callback<List<String>> callback) {
            if (courses.size() >= nbrCourses) {
                callback.execute(courses, null);
            } else {
                while (courses.size() < nbrCourses) {
                    final String course = this.iChoices[(int)(Random.nextDouble() * (double)this.iChoices.length)];
                    if (courses.contains(course)) continue;
                    courses.add(course);
                    this.debug(courses.size() + ". " + course);
                    this.listCourseOfferings(course.substring(0, 1), new Callback<Collection<ClassAssignmentInterface.CourseAssignment>>(){

                        @Override
                        public void execute(Collection<ClassAssignmentInterface.CourseAssignment> success, Throwable failure) {
                            Test.this.listCourseOfferings(course.substring(0, 2), new Callback<Collection<ClassAssignmentInterface.CourseAssignment>>(){

                                @Override
                                public void execute(Collection<ClassAssignmentInterface.CourseAssignment> success, Throwable failure) {
                                    Test.this.listCourseOfferings(course, new Callback<Collection<ClassAssignmentInterface.CourseAssignment>>(){

                                        @Override
                                        public void execute(Collection<ClassAssignmentInterface.CourseAssignment> success, Throwable failure) {
                                            Test.this.retrieveCourseDetails(course, new Callback<String>(){

                                                @Override
                                                public void execute(String success, Throwable failure) {
                                                    Test.this.listClasses(course, new Callback<Collection<ClassAssignmentInterface.ClassAssignment>>(){

                                                        @Override
                                                        public void execute(Collection<ClassAssignmentInterface.ClassAssignment> success, Throwable failure) {
                                                            Test.this.lookupCourses(courses, nbrCourses, callback);
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                        }
                    });
                    break;
                }
            }
        }

        private void listClasses(final String course, final Callback<Collection<ClassAssignmentInterface.ClassAssignment>> callback) {
            this.debug("listClasses(" + course + ")");
            OnlineSectioningTest.this.iSectioningService.listClasses(this.iContext, course, new AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>>(){

                public void onFailure(Throwable caught) {
                    Test.this.warn("&nbsp;&nbsp;listClasses(" + course + ") failed: " + caught.getMessage());
                    callback.execute(null, caught);
                }

                public void onSuccess(Collection<ClassAssignmentInterface.ClassAssignment> result) {
                    callback.execute(result, null);
                }
            });
        }

        private void retrieveCourseDetails(final String course, final Callback<String> callback) {
            this.debug("retrieveCourseDetails(" + course + ")");
            OnlineSectioningTest.this.iSectioningService.retrieveCourseDetails(this.iContext, course, new AsyncCallback<String>(){

                public void onFailure(Throwable caught) {
                    Test.this.warn("&nbsp;&nbsp;retrieveCourseDetails(" + course + ") failed: " + caught.getMessage());
                    callback.execute(null, caught);
                }

                public void onSuccess(String result) {
                    callback.execute(result, null);
                }
            });
        }

        private void listCourseOfferings(final String course, final Callback<Collection<ClassAssignmentInterface.CourseAssignment>> callback) {
            this.debug("listCourseOfferings(" + course + ")");
            OnlineSectioningTest.this.iSectioningService.listCourseOfferings(this.iContext, null, course, 20, new AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>>(){

                public void onFailure(Throwable caught) {
                    Test.this.warn("&nbsp;&nbsp;listCourseOfferings(" + course + ") failed: " + caught.getMessage());
                    callback.execute(null, caught);
                }

                public void onSuccess(Collection<ClassAssignmentInterface.CourseAssignment> result) {
                    callback.execute(result, null);
                }
            });
        }

        public void scheduleNext() {
            if (this.iStopped) {
                return;
            }
            this.schedule(this.iIndex * 100);
        }

        public void stop() {
            this.iStopped = true;
        }

        private HTML message(String message) {
            return new HTML("[" + OnlineSectioningTest.this.iDecF.format((double)this.iIndex) + " " + OnlineSectioningTest.this.iDF.format(new Date()) + "] " + message);
        }

        private void debug(String message) {
        }

        private void info(String message) {
            OnlineSectioningTest.this.iLog.add((Widget)this.message(message));
        }

        private void warn(String message) {
            HTML m = this.message(message);
            m.getElement().getStyle().setColor("orange");
            OnlineSectioningTest.this.iLog.add((Widget)m);
        }

        private void error(String message) {
            HTML m = this.message(message);
            m.getElement().getStyle().setColor("red");
            OnlineSectioningTest.this.iLog.add((Widget)m);
        }
    }

    private static interface Callback<T> {
        public void execute(T var1, Throwable var2);
    }
}

