/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.instructors;

import java.io.IOException;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.XLSPrinter;
import org.unitime.timetable.export.instructors.InstructorsCSV;
import org.unitime.timetable.gwt.client.tables.TableInterface;

@Service(value="org.unitime.timetable.export.Exporter:instructors.xls")
public class InstructorsXLS
extends InstructorsCSV {
    @Override
    public String reference() {
        return "instructors.xls";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        this.exportDataXls(this.getInstructors(helper), helper);
    }

    protected void exportDataXls(TableInterface table, ExportHelper helper) throws IOException {
        XLSPrinter printer = new XLSPrinter(helper.getOutputStream(), false);
        helper.setup(printer.getContentType(), table.getId() + "-" + this.reference(), false);
        printer.getWorkbook().setSheetName(printer.getSheetIndex(), table.getName());
        if (table.getHeader() != null) {
            for (TableInterface.LineInterface line : table.getHeader()) {
                printer.printHeader(line.toCsvLine());
            }
        }
        if (table.getLines() != null) {
            for (TableInterface.LineInterface line : table.getLines()) {
                printer.printLine(printer.toA(line, false));
            }
        }
        printer.flush();
        printer.close();
    }
}

