/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ExamCbsForm;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ui.ExamConflictStatisticsInfo;

@Action(value="ecbs", results={@Result(name={"show"}, type="tiles", location="ecbs.tiles")})
@TilesDefinition(name="ecbs.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination Conflict-Based Statistics"), @TilesPutAttribute(name="body", value="/exam/cbs.jsp"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class ExamCbsAction
extends UniTimeAction<ExamCbsForm> {
    private static final long serialVersionUID = 6759587563290713198L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.ExaminationConflictStatistics);
        if (this.form == null) {
            this.form = new ExamCbsForm();
        }
        if (((ExamCbsForm)this.form).getOp() != null) {
            this.op = ((ExamCbsForm)this.form).getOp();
        }
        if (this.op == null) {
            this.op = MSG.buttonRefresh();
        }
        if (MSG.buttonChange().equals(this.op)) {
            this.sessionContext.getUser().setProperty("Ecbs.limit", String.valueOf(((ExamCbsForm)this.form).getLimit()));
            this.sessionContext.getUser().setProperty("Ecbs.type", String.valueOf(((ExamCbsForm)this.form).getTypeInt()));
        } else {
            ((ExamCbsForm)this.form).reset();
            ((ExamCbsForm)this.form).setTypeInt(Integer.parseInt(this.sessionContext.getUser().getProperty("Ecbs.type", String.valueOf(ExamCbsForm.sDefaultType.ordinal()))));
            ((ExamCbsForm)this.form).setLimit(Double.parseDouble(this.sessionContext.getUser().getProperty("Ecbs.limit", String.valueOf(ExamCbsForm.sDefaultLimit))));
        }
        ExamConflictStatisticsInfo cbs = null;
        if (this.getExaminationSolverService().getSolver() != null) {
            cbs = this.getExaminationSolverService().getSolver().getCbsInfo();
        }
        if (cbs != null) {
            this.request.setAttribute("cbs", (Object)cbs);
        } else if (this.getExaminationSolverService().getSolver() == null) {
            this.request.setAttribute("warning", (Object)MSG.warnCbsNoSolver());
        } else {
            this.request.setAttribute("warning", (Object)MSG.warnNoCbs());
        }
        return "show";
    }

    public void printTable() {
        ExamConflictStatisticsInfo.printHtmlHeader(this.getPageContext().getOut());
        ExamConflictStatisticsInfo cbs = (ExamConflictStatisticsInfo)this.request.getAttribute("cbs");
        cbs.printHtml(this.getPageContext().getOut(), ((ExamCbsForm)this.form).getLimit() / 100.0, ((ExamCbsForm)this.form).getTypeInt(), true);
    }
}

