/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.criteria;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.instructor.criteria.InstructorSchedulingCriterion;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class SameCommon
extends InstructorSchedulingCriterion {
    public SameCommon() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1000000.0;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        Instructor.Context context = (Instructor.Context)value.getInstructor().getContext(assignment);
        double penalty = 0.0;
        int pairs = 0;
        for (TeachingAssignment ta : context.getAssignments()) {
            if (((TeachingRequest.Variable)ta.variable()).equals(value.variable())) continue;
            penalty += ((TeachingRequest.Variable)value.variable()).getRequest().getSameCommonPenalty(((TeachingRequest.Variable)ta.variable()).getRequest());
            ++pairs;
        }
        return pairs == 0 ? 0.0 : penalty / (double)pairs;
    }

    @Override
    public double[] getBounds(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (TeachingRequest.Variable req : variables) {
            if (req.getRequest().isSameCommonProhibited() || req.getRequest().isSameCommonRequired()) continue;
            if (req.getRequest().getSameCommonPreference() < 0) {
                bounds[0] = bounds[0] + (double)req.getRequest().getSameCommonPreference();
                continue;
            }
            bounds[1] = bounds[1] + (double)req.getRequest().getSameCommonPreference();
        }
        return bounds;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        return 0.5 * super.getValue(assignment, variables);
    }

    @Override
    public String getAbbreviation() {
        return "SameCommon";
    }
}

