/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.constraints;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.Section;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class GroupConstraint
extends GlobalConstraint<TeachingRequest.Variable, TeachingAssignment> {
    @Override
    public void computeConflicts(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        for (Distribution d : value.getInstructor().getDistributions()) {
            if (!d.isHard()) continue;
            d.getType().computeConflicts(d, assignment, value, conflicts);
        }
    }

    @Override
    public String getName() {
        return "Distribution";
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static ConstraintTypeInterface getConstraintType(String reference, String name) {
        for (ConstraintType t : ConstraintType.values()) {
            if (t.reference().equals(reference)) {
                if (name == null) {
                    return t;
                }
                return new ParametrizedConstraintType<Object>(t, null, reference).setName(name);
            }
            if (t.creator() == null || !reference.matches(t.reference())) continue;
            if (name == null) {
                return t.creator().create(reference, t.reference());
            }
            return t.creator().create(reference, t.reference()).setName(name);
        }
        return null;
    }

    protected static boolean shareWeeksAndDay(TimeLocation t, BitSet week, int dayCode) {
        boolean matchDay = (t.getDayCode() & dayCode) != 0;
        boolean matchWeek = week == null || t.shareWeeks(week);
        return matchDay && matchWeek;
    }

    protected static Set<TeachingAssignmentSection> getRelevantPlacements(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, int dayCode, Set<TeachingAssignment> conflicts, TeachingRequest.Variable variable, TeachingAssignment value, BitSet week) {
        TreeSet<TeachingAssignmentSection> placements = new TreeSet<TeachingAssignmentSection>(new Comparator<TeachingAssignmentSection>(){

            @Override
            public int compare(TeachingAssignmentSection p1, TeachingAssignmentSection p2) {
                TimeLocation t1 = p1.getTime();
                TimeLocation t2 = p2.getTime();
                if (t1.getStartSlot() < t2.getStartSlot()) {
                    return -1;
                }
                if (t1.getStartSlot() > t2.getStartSlot()) {
                    return 1;
                }
                if (t1.getLength() < t2.getLength()) {
                    return -1;
                }
                if (t1.getLength() > t2.getLength()) {
                    return 1;
                }
                return 0;
            }
        });
        for (TeachingAssignment ta : ((Instructor.Context)instructor.getContext(assignment)).getAssignments()) {
            if (variable != null && ((TeachingRequest.Variable)ta.variable()).equals(variable) || conflicts != null && conflicts.contains(ta)) continue;
            for (Section s : ((TeachingRequest.Variable)ta.variable()).getSections()) {
                if (s.getTime() == null || !GroupConstraint.shareWeeksAndDay(s.getTime(), week, dayCode)) continue;
                placements.add(new TeachingAssignmentSection(ta, s));
            }
        }
        if (value != null) {
            for (Section s : ((TeachingRequest.Variable)value.variable()).getSections()) {
                if (s.getTime() == null || !GroupConstraint.shareWeeksAndDay(s.getTime(), week, dayCode)) continue;
                placements.add(new TeachingAssignmentSection(value, s));
            }
        }
        return placements;
    }

    protected static List<Block> mergeToBlocks(Collection<TeachingAssignmentSection> sorted, int maxBreakBetweenBTB) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (TeachingAssignmentSection placement : sorted) {
            boolean added = false;
            for (int j = 0; j < blocks.size(); ++j) {
                if (!((Block)blocks.get(j)).addSection(placement)) continue;
                added = true;
            }
            if (added) continue;
            Block block = new Block(maxBreakBetweenBTB);
            block.addSection(placement);
            blocks.add(block);
        }
        return blocks;
    }

    protected static List<Block> getBlocks(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, int dayCode, Set<TeachingAssignment> conflicts, TeachingRequest.Variable variable, TeachingAssignment value, BitSet week, int maxBreakBetweenBTB) {
        return GroupConstraint.mergeToBlocks(GroupConstraint.getRelevantPlacements(assignment, instructor, dayCode, conflicts, variable, value, week), maxBreakBetweenBTB);
    }

    protected static boolean isCorectDayOfWeek(TeachingAssignment value, int dayCode) {
        if (value == null) {
            return true;
        }
        for (Section section : ((TeachingRequest.Variable)value.variable()).getSections()) {
            if (section.getTime() == null || dayCode != 0 && (dayCode & section.getTime().getDayCode()) == 0) continue;
            return true;
        }
        return false;
    }

    protected static boolean isCorectDayAndWeek(TeachingAssignment value, int dayCode, BitSet week) {
        if (value == null) {
            return true;
        }
        for (Section section : ((TeachingRequest.Variable)value.variable()).getSections()) {
            if (section.getTime() == null || dayCode != 0 && (dayCode & section.getTime().getDayCode()) == 0 || !section.getTime().getWeekCode().intersects(week)) continue;
            return true;
        }
        return false;
    }

    public static class Block {
        private int startSlotCurrentBlock = -1;
        private int endSlotCurrentBlock = -1;
        private int maxSlotsBetweenBackToBack = 4;
        private List<TeachingAssignmentSection> sections = new ArrayList<TeachingAssignmentSection>();

        public Block(int maxSlotsBetweenBTB) {
            this.maxSlotsBetweenBackToBack = maxSlotsBetweenBTB;
        }

        public boolean addSection(TeachingAssignmentSection section) {
            if (section == null) {
                return false;
            }
            TimeLocation t = section.getTime();
            if (t == null) {
                return false;
            }
            if (this.sections.isEmpty()) {
                this.sections.add(section);
                this.startSlotCurrentBlock = t.getStartSlot();
                this.endSlotCurrentBlock = t.getStartSlot() + t.getLength();
                return true;
            }
            if (t.getStartSlot() == this.startSlotCurrentBlock) {
                this.sections.add(section);
                int tEnd = t.getStartSlot() + t.getLength();
                if (tEnd > this.endSlotCurrentBlock) {
                    this.endSlotCurrentBlock = tEnd;
                }
                return true;
            }
            if (this.endSlotCurrentBlock + this.maxSlotsBetweenBackToBack >= t.getStartSlot() && t.getStartSlot() >= this.startSlotCurrentBlock) {
                this.sections.add(section);
                int tEnd = t.getStartSlot() + t.getLength();
                if (tEnd > this.endSlotCurrentBlock) {
                    this.endSlotCurrentBlock = tEnd;
                }
                return true;
            }
            return false;
        }

        public boolean haveSameStartTime() {
            if (!this.sections.isEmpty()) {
                int startSlot = this.sections.get(0).getTime().getStartSlot();
                for (TeachingAssignmentSection p : this.getSections()) {
                    if (p.getTime().getStartSlot() == startSlot) continue;
                    return false;
                }
            }
            return true;
        }

        public int getStartSlotCurrentBlock() {
            return this.startSlotCurrentBlock;
        }

        public int getEndSlotCurrentBlock() {
            return this.endSlotCurrentBlock;
        }

        public int getNbrPlacements() {
            return this.sections.size();
        }

        public List<TeachingAssignmentSection> getSections() {
            return this.sections;
        }

        public int getLengthInSlots() {
            return this.endSlotCurrentBlock - this.startSlotCurrentBlock;
        }

        public boolean contains(TeachingAssignment ta) {
            for (TeachingAssignmentSection tas : this.getSections()) {
                if (!tas.getTeachingAssignment().equals(ta)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "[" + this.startSlotCurrentBlock + ", " + this.endSlotCurrentBlock + "] PlacementsNbr: " + this.getNbrPlacements();
        }
    }

    static class TeachingAssignmentSection {
        private TeachingAssignment iTeachingAssignment;
        private Section iSection;

        TeachingAssignmentSection(TeachingAssignment ta, Section section) {
            this.iTeachingAssignment = ta;
            this.iSection = section;
        }

        public TeachingAssignment getTeachingAssignment() {
            return this.iTeachingAssignment;
        }

        public Section getSection() {
            return this.iSection;
        }

        public TimeLocation getTime() {
            return this.getSection().getTime();
        }

        public int hashCode() {
            return this.getTeachingAssignment().hashCode() ^ this.getSection().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TeachingAssignmentSection)) {
                return false;
            }
            TeachingAssignmentSection tas = (TeachingAssignmentSection)o;
            return tas.getTeachingAssignment().equals(this.getTeachingAssignment()) && tas.getSection().equals(this.getSection());
        }
    }

    public static enum ConstraintType implements ConstraintTypeInterface
    {
        SAME_DAYS("SAME_DAYS", "Same Days", new SimpleTimeCheck(){

            @Override
            public boolean isSatisfied(Distribution d, TimeLocation t1, TimeLocation t2) {
                return this.sameDays(t1.getDaysArray(), t2.getDaysArray());
            }

            @Override
            public boolean isViolated(Distribution d, TimeLocation t1, TimeLocation t2) {
                return !t1.shareDays(t2);
            }

            private boolean sameDays(int[] days1, int[] days2) {
                if (days2.length < days1.length) {
                    return this.sameDays(days2, days1);
                }
                int i2 = 0;
                for (int i1 = 0; i1 < days1.length; ++i1) {
                    block4: {
                        int d1 = days1[i1];
                        do {
                            if (i2 == days2.length) {
                                return false;
                            }
                            int d2 = days2[i2];
                            if (d1 == d2) break block4;
                        } while (++i2 != days2.length);
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
        }),
        SAME_START("SAME_START", "Same Start Time", new SimpleTimeCheck(){

            @Override
            public boolean isSatisfied(Distribution d, TimeLocation t1, TimeLocation t2) {
                return t1.getStartSlot() % 288 == t2.getStartSlot() % 288;
            }

            @Override
            public boolean isViolated(Distribution d, TimeLocation t1, TimeLocation t2) {
                return t1.getStartSlot() % 288 != t2.getStartSlot() % 288;
            }
        }),
        SAME_ROOM("SAME_ROOM", "Same Room", new SimpleCheck(){

            @Override
            public boolean isSatisfied(Distribution d, Section s1, Section s2) {
                return s1.isSameRoom(s2);
            }

            @Override
            public boolean isViolated(Distribution d, Section s1, Section s2) {
                return !s1.isSameRoom(s2);
            }
        }),
        MAX_HRS_DAY("MAX_HRS_DAY\\(([0-9\\.]+)\\)", "At Most N Hours A Day", new Check(){

            protected int nrSlotsADay(Set<TeachingAssignment> assignments, BitSet week, int dayCode, TeachingRequest.Variable variable, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                HashSet<Integer> slots = new HashSet<Integer>();
                for (TeachingAssignment ta : assignments) {
                    if (variable != null && variable.equals(ta.variable()) || conflicts != null && conflicts.contains(ta)) continue;
                    for (Section section : ((TeachingRequest.Variable)ta.variable()).getSections()) {
                        TimeLocation t = section.getTime();
                        if (t == null || (t.getDayCode() & dayCode) == 0 || week != null && !t.shareWeeks(week)) continue;
                        for (int i = 0; i < t.getLength(); ++i) {
                            slots.add(i + t.getStartSlot());
                        }
                    }
                }
                if (value != null) {
                    for (Section section : ((TeachingRequest.Variable)value.variable()).getSections()) {
                        TimeLocation t = section.getTime();
                        if (t == null || (t.getDayCode() & dayCode) == 0 || week != null && !t.shareWeeks(week)) continue;
                        for (int i = 0; i < t.getLength(); ++i) {
                            slots.add(i + t.getStartSlot());
                        }
                    }
                }
                return slots.size();
            }

            @Override
            public double getValue(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
                Integer max = (Integer)d.getParameter();
                Set<TeachingAssignment> assignments = ((Instructor.Context)instructor.getContext(assignment)).getAssignments();
                double over = 0.0;
                for (int dayCode : Constants.DAY_CODES) {
                    for (BitSet week : instructor.getModel().getWeeks()) {
                        if (value == null) {
                            over += (double)Math.max(0, this.nrSlotsADay(assignments, week, dayCode, null, null, null) - max);
                            continue;
                        }
                        int before = Math.max(0, this.nrSlotsADay(assignments, week, dayCode, (TeachingRequest.Variable)value.variable(), null, null) - max);
                        int after = Math.max(0, this.nrSlotsADay(assignments, week, dayCode, (TeachingRequest.Variable)value.variable(), value, null) - max);
                        over += (double)(after - before);
                    }
                }
                return over / (60.0 * (double)instructor.getModel().getWeeks().size());
            }

            @Override
            public void computeConflicts(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                Integer max = (Integer)d.getParameter();
                Set<TeachingAssignment> assignments = ((Instructor.Context)value.getInstructor().getContext(assignment)).getAssignments();
                for (int dayCode : Constants.DAY_CODES) {
                    block1: for (BitSet week : value.getInstructor().getModel().getWeeks()) {
                        if (this.nrSlotsADay(assignments, week, dayCode, (TeachingRequest.Variable)value.variable(), value, conflicts) <= max) continue;
                        ArrayList<TeachingAssignment> adepts = new ArrayList<TeachingAssignment>();
                        for (TeachingAssignment ta : assignments) {
                            if (((TeachingRequest.Variable)ta.variable()).equals(value.variable()) || conflicts.contains(ta)) continue;
                            boolean hasDate = false;
                            for (Section section : ((TeachingRequest.Variable)ta.variable()).getSections()) {
                                TimeLocation t = section.getTime();
                                if (t == null || (t.getDayCode() & dayCode) == 0 || !t.shareWeeks(week)) continue;
                                hasDate = true;
                                break;
                            }
                            if (!hasDate) continue;
                            adepts.add(ta);
                        }
                        do {
                            if (adepts.isEmpty()) {
                                conflicts.add(value);
                                continue block1;
                            }
                            TeachingAssignment conflict = (TeachingAssignment)ToolBox.random(adepts);
                            adepts.remove(conflict);
                            conflicts.add(conflict);
                        } while (this.nrSlotsADay(assignments, week, dayCode, (TeachingRequest.Variable)value.variable(), value, conflicts) > max);
                    }
                }
            }
        }, new ConstraintCreator<Integer>(){

            @Override
            public ParametrizedConstraintType<Integer> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    double hours = Double.parseDouble(matcher.group(1));
                    int slots = (int)Math.round(12.0 * hours);
                    return new ParametrizedConstraintType<Integer>(MAX_HRS_DAY, slots, reference).setName("At Most " + matcher.group(1) + " Hours A Day");
                }
                return null;
            }
        }),
        SAME_WEEKS("SAME_WEEKS", "Same Weeks", new SimpleTimeCheck(){

            @Override
            public boolean isSatisfied(Distribution d, TimeLocation t1, TimeLocation t2) {
                return t1.getWeekCode().equals(t2.getWeekCode());
            }

            @Override
            public boolean isViolated(Distribution d, TimeLocation t1, TimeLocation t2) {
                return !t1.shareWeeks(t2);
            }
        }),
        WORKDAY("WORKDAY\\(([0-9\\.]+)\\)", "Work Day", new SimpleTimeCheck(){

            @Override
            public boolean isSatisfied(Distribution d, TimeLocation t1, TimeLocation t2) {
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return true;
                }
                Integer parameter = (Integer)d.getParameter();
                return Math.max(t1.getStartSlot() + t1.getLength(), t2.getStartSlot() + t2.getLength()) - Math.min(t1.getStartSlot(), t2.getStartSlot()) <= parameter;
            }
        }, new ConstraintCreator<Integer>(){

            @Override
            public ParametrizedConstraintType<Integer> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    double hours = Double.parseDouble(matcher.group(1));
                    int slots = (int)Math.round(12.0 * hours);
                    return new ParametrizedConstraintType<Integer>(WORKDAY, slots, reference).setName(matcher.group(1) + " Hour Work Day");
                }
                return null;
            }
        }),
        MIN_GAP("MIN_GAP\\(([0-9\\.]+)\\)", "Mininal Gap Between Classes", new SimpleTimeCheck(){

            @Override
            public boolean isSatisfied(Distribution d, TimeLocation t1, TimeLocation t2) {
                if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
                    return true;
                }
                Integer parameter = (Integer)d.getParameter();
                return t1.getStartSlot() + t1.getLength() + parameter <= t2.getStartSlot() || t2.getStartSlot() + t2.getLength() + parameter <= t1.getStartSlot();
            }
        }, new ConstraintCreator<Integer>(){

            @Override
            public ParametrizedConstraintType<Integer> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    double hours = Double.parseDouble(matcher.group(1));
                    int slots = (int)Math.round(12.0 * hours);
                    return new ParametrizedConstraintType<Integer>(MIN_GAP, slots, reference).setName("At Least " + matcher.group(1) + " Hours Between Classes");
                }
                return null;
            }
        }),
        MAX_BLOCK("_(MaxBlock):([0-9]+):([0-9]+)_", "Max Block", new Check(){

            @Override
            public double getValue(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
                int[] params = (int[])d.getParameter();
                int maxBlockSlotsBTB = params[0];
                int maxBreakBetweenBTB = params[1];
                double penalty = 0.0;
                for (int dayCode : Constants.DAY_CODES) {
                    for (BitSet week : instructor.getModel().getWeeks()) {
                        List<Block> blocks = GroupConstraint.getBlocks(assignment, instructor, dayCode, null, value == null ? null : (TeachingRequest.Variable)value.variable(), value, week, maxBreakBetweenBTB);
                        for (Block block : blocks) {
                            if (block.getNbrPlacements() == 1 || block.haveSameStartTime() || block.getLengthInSlots() <= maxBlockSlotsBTB) continue;
                            int blockLengthPenalty = block.getLengthInSlots() / maxBlockSlotsBTB;
                            penalty += (double)blockLengthPenalty;
                        }
                    }
                }
                return penalty / (5.0 * (double)instructor.getModel().getWeeks().size());
            }

            @Override
            public void computeConflicts(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                int[] params = (int[])d.getParameter();
                int maxBlockSlotsBTB = params[0];
                int maxBreakBetweenBTB = params[1];
                List<BitSet> weeks = value.getInstructor().getModel().getWeeks();
                for (int dayCode : Constants.DAY_CODES) {
                    for (BitSet week : weeks) {
                        boolean isProblem = false;
                        do {
                            isProblem = false;
                            List<Block> blocks = GroupConstraint.getBlocks(assignment, value.getInstructor(), dayCode, conflicts, (TeachingRequest.Variable)value.variable(), value, week, maxBreakBetweenBTB);
                            for (Block block : blocks) {
                                if (!block.contains(value)) continue;
                                HashSet<TeachingAssignment> adepts = new HashSet<TeachingAssignment>();
                                if (block.getNbrPlacements() == 1 || block.haveSameStartTime() || block.getLengthInSlots() <= maxBlockSlotsBTB) continue;
                                for (TeachingAssignmentSection tas : block.getSections()) {
                                    adepts.add(tas.getTeachingAssignment());
                                }
                                adepts.remove(value);
                                isProblem = true;
                                TeachingAssignment conflict = (TeachingAssignment)ToolBox.random(adepts);
                                if (conflict == null) continue;
                                conflicts.add(conflict);
                            }
                        } while (isProblem);
                    }
                }
            }
        }, new ConstraintCreator<int[]>(){

            @Override
            public ParametrizedConstraintType<int[]> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    int maxBlockSlotsBTB = Integer.parseInt(matcher.group(2)) / Constants.SLOT_LENGTH_MIN;
                    int maxBreakBetweenBTB = Integer.parseInt(matcher.group(3)) / Constants.SLOT_LENGTH_MIN;
                    return new ParametrizedConstraintType<int[]>(MAX_BLOCK, new int[]{maxBlockSlotsBTB, maxBreakBetweenBTB}, reference).setName("Max " + (double)maxBlockSlotsBTB / 12.0 + "h Blocks");
                }
                return null;
            }
        }),
        MAX_BREAKS("_(MaxBreaks):([0-9]+):([0-9]+)_", "Max Breaks", new Check(){

            @Override
            public double getValue(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
                int[] params = (int[])d.getParameter();
                int maxBlocksOnADay = params[0];
                int maxBreakBetweenBTB = params[1];
                double penalty = 0.0;
                for (int dayCode : Constants.DAY_CODES) {
                    Iterator<BitSet> iterator = instructor.getModel().getWeeks().iterator();
                    while (iterator.hasNext()) {
                        BitSet week;
                        List<Block> blocks = GroupConstraint.getBlocks(assignment, instructor, dayCode, null, value == null ? null : (TeachingRequest.Variable)value.variable(), value, week = iterator.next(), maxBreakBetweenBTB);
                        if (blocks.size() <= maxBlocksOnADay) continue;
                        penalty += (double)(blocks.size() - maxBlocksOnADay);
                    }
                }
                return penalty / (5.0 * (double)instructor.getModel().getWeeks().size());
            }

            @Override
            public void computeConflicts(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                int[] params = (int[])d.getParameter();
                int maxBlocksOnADay = params[0];
                int maxBreakBetweenBTB = params[1];
                List<BitSet> weeks = value.getInstructor().getModel().getWeeks();
                for (int dayCode : Constants.DAY_CODES) {
                    for (BitSet week : weeks) {
                        List<Block> blocks = GroupConstraint.getBlocks(assignment, value.getInstructor(), dayCode, conflicts, (TeachingRequest.Variable)value.variable(), value, week, maxBreakBetweenBTB);
                        while (blocks.size() > maxBlocksOnADay) {
                            ArrayList<Block> adepts = new ArrayList<Block>();
                            int size = 0;
                            for (Block block : blocks) {
                                if (block.contains(value)) continue;
                                if (adepts.isEmpty() || size > block.getSections().size()) {
                                    adepts.clear();
                                    adepts.add(block);
                                    size = block.getSections().size();
                                    continue;
                                }
                                if (size != block.getSections().size()) continue;
                                adepts.add(block);
                            }
                            Block block = (Block)ToolBox.random(adepts);
                            blocks.remove(block);
                            for (TeachingAssignmentSection tas : block.getSections()) {
                                if (!tas.getTeachingAssignment().equals(assignment.getValue((TeachingRequest.Variable)tas.getTeachingAssignment().variable()))) continue;
                                conflicts.add(tas.getTeachingAssignment());
                            }
                        }
                    }
                }
            }
        }, new ConstraintCreator<int[]>(){

            @Override
            public ParametrizedConstraintType<int[]> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    int maxBlocksOnADay = 1 + Integer.parseInt(matcher.group(2));
                    int maxBreakBetweenBTB = Integer.parseInt(matcher.group(3)) / Constants.SLOT_LENGTH_MIN;
                    return new ParametrizedConstraintType<int[]>(MAX_BREAKS, new int[]{maxBlocksOnADay, maxBreakBetweenBTB}, reference).setName(maxBlocksOnADay == 1 ? "No Break" : (maxBlocksOnADay == 2 ? "Max 1 Break" : "Max " + (maxBlocksOnADay - 1) + " Breaks"));
                }
                return null;
            }
        }),
        MAX_DAYS("_(MaxDays):([0-9]+)_", "Max Days", new Check(){

            protected boolean hasDay(BitSet week, int dayOfWeek, Section section) {
                if (section.getTime() == null || !section.getTime().getWeekCode().intersects(week)) {
                    return false;
                }
                return (section.getTime().getDayCode() & Constants.DAY_CODES[dayOfWeek]) != 0;
            }

            protected boolean hasDay(BitSet week, int dayOfWeek, TeachingAssignment ta) {
                for (Section section : ((TeachingRequest.Variable)ta.variable()).getSections()) {
                    if (!this.hasDay(week, dayOfWeek, section)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public double getValue(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
                Integer maxDays = (Integer)d.getParameter();
                Set<TeachingAssignment> assignments = ((Instructor.Context)instructor.getContext(assignment)).getAssignments();
                double penalty = 0.0;
                for (BitSet week : instructor.getModel().getWeeks()) {
                    HashSet<Integer> days = new HashSet<Integer>();
                    for (TeachingAssignment ta : assignments) {
                        if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable())) continue;
                        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                            if (!this.hasDay(week, day, ta)) continue;
                            days.add(day);
                        }
                    }
                    if (value != null) {
                        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                            if (!this.hasDay(week, day, value) || !days.add(day) || days.size() <= maxDays) continue;
                            penalty += 1.0;
                        }
                        continue;
                    }
                    penalty += (double)Math.max(0, days.size() - maxDays);
                }
                return penalty / (Math.max(1.0, 5.0 - (double)maxDays.intValue()) * (double)instructor.getModel().getWeeks().size());
            }

            @Override
            public void computeConflicts(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                Integer maxDays = (Integer)d.getParameter();
                Set<TeachingAssignment> assignments = ((Instructor.Context)value.getInstructor().getContext(assignment)).getAssignments();
                block0: for (BitSet week : value.getInstructor().getModel().getWeeks()) {
                    HashSet<Integer> selectedDays = new HashSet<Integer>();
                    for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                        if (!this.hasDay(week, day, value)) continue;
                        selectedDays.add(day);
                    }
                    if (selectedDays.isEmpty()) continue;
                    if (selectedDays.size() > maxDays) {
                        conflicts.add(value);
                        continue;
                    }
                    block2: while (true) {
                        HashSet<Integer> otherDays = new HashSet<Integer>();
                        for (TeachingAssignment ta : assignments) {
                            if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable()) || conflicts.contains(ta)) continue;
                            for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                                if (selectedDays.contains(day) || !this.hasDay(week, day, ta)) continue;
                                otherDays.add(day);
                            }
                        }
                        if (otherDays.size() + selectedDays.size() <= maxDays) continue block0;
                        int day = (Integer)ToolBox.random(otherDays);
                        Iterator<TeachingAssignment> iterator = assignments.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            TeachingAssignment ta = iterator.next();
                            if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable()) || conflicts.contains(ta) || !this.hasDay(week, day, ta)) continue;
                            conflicts.add(ta);
                        }
                        break;
                    }
                }
            }
        }, new ConstraintCreator<Integer>(){

            @Override
            public ParametrizedConstraintType<Integer> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    int maxDays = Integer.parseInt(matcher.group(2));
                    return new ParametrizedConstraintType<Integer>(MAX_DAYS, maxDays, reference).setName(maxDays == 1 ? "Max 1 Day" : "Max " + maxDays + " Days");
                }
                return null;
            }
        }),
        BREAK("_(Break):([0-9]+):([0-9]+):([0-9]+)_", "Break", new Check(){

            @Override
            public double getValue(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
                int[] params = (int[])d.getParameter();
                int breakStart = params[0];
                int breakEnd = params[1];
                int breakLength = params[2];
                double penalty = 0.0;
                for (int dayCode : Constants.DAY_CODES) {
                    for (BitSet week : instructor.getModel().getWeeks()) {
                        Block block2;
                        List<Block> blocks = GroupConstraint.getBlocks(assignment, instructor, dayCode, null, value == null ? null : (TeachingRequest.Variable)value.variable(), value, week, breakLength);
                        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
                        for (Block block2 : blocks) {
                            if (block2.getStartSlotCurrentBlock() > breakEnd || block2.getEndSlotCurrentBlock() < breakStart) continue;
                            matchingBlocks.add(block2);
                        }
                        int size = matchingBlocks.size();
                        if (size != 1) continue;
                        block2 = (Block)matchingBlocks.get(0);
                        if (value != null && !block2.contains(value) || block2.getStartSlotCurrentBlock() - breakStart >= breakLength || breakEnd - block2.getEndSlotCurrentBlock() >= breakLength) continue;
                        penalty += 1.0;
                    }
                }
                return penalty / (5.0 * (double)instructor.getModel().getWeeks().size());
            }

            @Override
            public void computeConflicts(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                int[] params = (int[])d.getParameter();
                int breakStart = params[0];
                int breakEnd = params[1];
                int breakLength = params[2];
                for (int dayCode : Constants.DAY_CODES) {
                    block1: for (BitSet week : value.getInstructor().getModel().getWeeks()) {
                        while (true) {
                            Block block2;
                            List<Block> blocks = GroupConstraint.getBlocks(assignment, value.getInstructor(), dayCode, conflicts, (TeachingRequest.Variable)value.variable(), value, week, breakLength);
                            ArrayList<Block> matchingBlocks = new ArrayList<Block>();
                            for (Block block2 : blocks) {
                                if (block2.getStartSlotCurrentBlock() > breakEnd || block2.getEndSlotCurrentBlock() < breakStart) continue;
                                matchingBlocks.add(block2);
                            }
                            int size = matchingBlocks.size();
                            if (size != 1) continue;
                            block2 = (Block)matchingBlocks.get(0);
                            if (!block2.contains(value) || block2.getStartSlotCurrentBlock() - breakStart >= breakLength || breakEnd - block2.getEndSlotCurrentBlock() >= breakLength) continue block1;
                            ArrayList<TeachingAssignmentSection> adepts = new ArrayList<TeachingAssignmentSection>();
                            for (TeachingAssignmentSection p : block2.getSections()) {
                                if (p.getTime().getStartSlot() > breakEnd || p.getTime().getStartSlot() + p.getTime().getLength() < breakStart) continue;
                                adepts.add(p);
                            }
                            if (adepts.size() <= 0) continue block1;
                            conflicts.add(((TeachingAssignmentSection)ToolBox.random(adepts)).getTeachingAssignment());
                        }
                    }
                }
            }
        }, new ConstraintCreator<int[]>(){

            @Override
            public ParametrizedConstraintType<int[]> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    int breakStart = Integer.parseInt(matcher.group(2));
                    int breakEnd = Integer.parseInt(matcher.group(3));
                    int breakLength = Integer.parseInt(matcher.group(4)) / Constants.SLOT_LENGTH_MIN;
                    return new ParametrizedConstraintType<int[]>(BREAK, new int[]{breakStart, breakEnd, breakLength}, reference).setName(breakEnd * 5 + " Min Break");
                }
                return null;
            }
        }),
        MAX_WEEKS("_(MaxWeeks):([0-9]+):([0-9]+)_", "Max Weeks", new Check(){

            @Override
            public double getValue(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
                int[] params = (int[])d.getParameter();
                int maxWeeks = params[0];
                int dayCode = params[1];
                if (value != null && !GroupConstraint.isCorectDayOfWeek(value, dayCode)) {
                    return 0.0;
                }
                Set<TeachingAssignment> assignments = ((Instructor.Context)instructor.getContext(assignment)).getAssignments();
                double penalty = 0.0;
                HashSet<BitSet> weeks = new HashSet<BitSet>();
                for (BitSet week : instructor.getModel().getWeeks()) {
                    for (TeachingAssignment ta : assignments) {
                        if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable()) || !GroupConstraint.isCorectDayAndWeek(ta, dayCode, week)) continue;
                        weeks.add(week);
                    }
                }
                if (value != null) {
                    for (BitSet week : instructor.getModel().getWeeks()) {
                        if (!GroupConstraint.isCorectDayAndWeek(value, dayCode, week) || !weeks.add(week) || weeks.size() <= maxWeeks) continue;
                        penalty += 1.0;
                    }
                } else {
                    penalty += Math.max(0.0, (double)(weeks.size() - maxWeeks));
                }
                return penalty / Math.max(1.0, (double)(instructor.getModel().getWeeks().size() - maxWeeks));
            }

            @Override
            public void computeConflicts(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                int[] params = (int[])d.getParameter();
                int maxWeeks = params[0];
                int dayCode = params[1];
                if (!GroupConstraint.isCorectDayOfWeek(value, dayCode)) {
                    return;
                }
                HashSet<BitSet> selectedWeeks = new HashSet<BitSet>();
                for (BitSet week : value.getInstructor().getModel().getWeeks()) {
                    if (!GroupConstraint.isCorectDayAndWeek(value, dayCode, week)) continue;
                    selectedWeeks.add(week);
                }
                if (selectedWeeks.size() > maxWeeks) {
                    conflicts.add(value);
                    return;
                }
                Set<TeachingAssignment> assignments = ((Instructor.Context)value.getInstructor().getContext(assignment)).getAssignments();
                block1: while (true) {
                    TeachingAssignment ta;
                    HashSet<BitSet> otherWeeks = new HashSet<BitSet>();
                    for (BitSet week : value.getInstructor().getModel().getWeeks()) {
                        if (selectedWeeks.contains(week)) continue;
                        for (TeachingAssignment ta2 : assignments) {
                            if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta2.variable()) || conflicts.contains(ta2) || !GroupConstraint.isCorectDayAndWeek(ta2, dayCode, week)) continue;
                            otherWeeks.add(week);
                        }
                    }
                    if (otherWeeks.size() + selectedWeeks.size() <= maxWeeks) break;
                    BitSet week = (BitSet)ToolBox.random(otherWeeks);
                    Iterator<TeachingAssignment> iterator = assignments.iterator();
                    do {
                        if (!iterator.hasNext()) continue block1;
                        ta = iterator.next();
                    } while (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable()) || conflicts.contains(ta) || !GroupConstraint.isCorectDayAndWeek(ta, dayCode, week));
                    conflicts.add(ta);
                }
            }
        }, new ConstraintCreator<int[]>(){

            @Override
            public ParametrizedConstraintType<int[]> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    int maxWeeks = Integer.parseInt(matcher.group(2));
                    int dayCode = Integer.parseInt(matcher.group(3));
                    return new ParametrizedConstraintType<int[]>(MAX_WEEKS, new int[]{maxWeeks, dayCode}, reference).setName("Max " + maxWeeks + " Weeks");
                }
                return null;
            }
        }),
        MAX_HOLES("_(MaxHoles):([0-9]+)_", "Max Holes", new Check(){

            int countHoles(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, int dayCode, Set<TeachingAssignment> conflicts, TeachingRequest.Variable variable, TeachingAssignment value, BitSet week) {
                Set<TeachingAssignmentSection> placements = GroupConstraint.getRelevantPlacements(assignment, instructor, dayCode, conflicts, variable, value, week);
                int lastSlot = -1;
                int holes = 0;
                for (TeachingAssignmentSection placement : placements) {
                    if (lastSlot >= 0 && placement.getTime().getStartSlot() > lastSlot) {
                        holes += placement.getTime().getStartSlot() - lastSlot;
                    }
                    lastSlot = Math.max(lastSlot, placement.getTime().getStartSlot() + placement.getTime().getLength());
                }
                return holes;
            }

            @Override
            public double getValue(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
                int[] params = (int[])d.getParameter();
                int maxHolesOnADay = params[0];
                double penalty = 0.0;
                for (int dayCode : Constants.DAY_CODES) {
                    for (BitSet week : instructor.getModel().getWeeks()) {
                        if (value != null && !GroupConstraint.isCorectDayAndWeek(value, dayCode, week)) continue;
                        if (value == null) {
                            penalty += (double)Math.max(0, this.countHoles(assignment, instructor, dayCode, null, null, null, week) - maxHolesOnADay);
                            continue;
                        }
                        int before = Math.max(0, this.countHoles(assignment, instructor, dayCode, null, (TeachingRequest.Variable)value.variable(), null, week) - maxHolesOnADay);
                        int after = Math.max(0, this.countHoles(assignment, instructor, dayCode, null, (TeachingRequest.Variable)value.variable(), value, week) - maxHolesOnADay);
                        penalty += (double)(after - before);
                    }
                }
                return penalty / (60.0 * (double)instructor.getModel().getWeeks().size());
            }

            @Override
            public void computeConflicts(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                int[] params = (int[])d.getParameter();
                int maxHolesOnADay = params[0];
                for (int dayCode : Constants.DAY_CODES) {
                    for (BitSet week : value.getInstructor().getModel().getWeeks()) {
                        if (!GroupConstraint.isCorectDayAndWeek(value, dayCode, week)) continue;
                        int penalty = this.countHoles(assignment, value.getInstructor(), dayCode, conflicts, (TeachingRequest.Variable)value.variable(), value, week);
                        while (penalty > maxHolesOnADay) {
                            ArrayList<TeachingAssignmentSection> adepts = new ArrayList<TeachingAssignmentSection>();
                            for (TeachingAssignmentSection placement : GroupConstraint.getRelevantPlacements(assignment, value.getInstructor(), dayCode, conflicts, (TeachingRequest.Variable)value.variable(), value, week)) {
                                if (placement.getTeachingAssignment().equals(value)) continue;
                                HashSet<TeachingAssignment> test = new HashSet<TeachingAssignment>(conflicts);
                                test.add(placement.getTeachingAssignment());
                                int newPenalty = this.countHoles(assignment, value.getInstructor(), dayCode, test, (TeachingRequest.Variable)value.variable(), value, week);
                                if (newPenalty > penalty) continue;
                                adepts.add(placement);
                            }
                            if (adepts.isEmpty()) {
                                conflicts.add(value);
                                return;
                            }
                            conflicts.add(((TeachingAssignmentSection)ToolBox.random(adepts)).getTeachingAssignment());
                            penalty = this.countHoles(assignment, value.getInstructor(), dayCode, conflicts, (TeachingRequest.Variable)value.variable(), value, week);
                        }
                    }
                }
            }
        }, new ConstraintCreator<int[]>(){

            @Override
            public ParametrizedConstraintType<int[]> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    int maxHolesOnADay = Integer.parseInt(matcher.group(2)) / Constants.SLOT_LENGTH_MIN;
                    return new ParametrizedConstraintType<int[]>(MAX_HOLES, new int[]{maxHolesOnADay}, reference).setName("Max " + (double)maxHolesOnADay / 12.0 + " Free Hours");
                }
                return null;
            }
        }),
        MAX_HALF_DAYS("_(MaxHalfDays):([0-9]+)_", "Max Half-Days", new Check(){
            private Integer iNoonSlot = null;

            protected boolean hasHalfDay(BitSet week, int dayOfWeek, Section section, boolean morning) {
                if (section.getTime() == null || !section.getTime().getWeekCode().intersects(week)) {
                    return false;
                }
                if ((section.getTime().getDayCode() & Constants.DAY_CODES[dayOfWeek]) == 0) {
                    return false;
                }
                if (morning) {
                    return section.getTime().getStartSlot() < this.iNoonSlot;
                }
                return section.getTime().getStartSlot() >= this.iNoonSlot;
            }

            protected boolean hasHalfDay(BitSet week, int dayOfWeek, TeachingAssignment ta, boolean morning) {
                for (Section section : ((TeachingRequest.Variable)ta.variable()).getSections()) {
                    if (!this.hasHalfDay(week, dayOfWeek, section, morning)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public double getValue(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
                if (this.iNoonSlot == null) {
                    this.iNoonSlot = instructor.getModel().getProperties().getPropertyInteger("General.HalfDaySlot", 144);
                }
                int[] params = (int[])d.getParameter();
                int maxHalfDays = params[0];
                double penalty = 0.0;
                Set<TeachingAssignment> assignments = ((Instructor.Context)instructor.getContext(assignment)).getAssignments();
                for (BitSet week : instructor.getModel().getWeeks()) {
                    HashSet<Integer> mornings = new HashSet<Integer>();
                    HashSet<Integer> afternoons = new HashSet<Integer>();
                    for (TeachingAssignment ta : assignments) {
                        if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable())) continue;
                        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                            if (this.hasHalfDay(week, day, ta, true)) {
                                mornings.add(day);
                            }
                            if (!this.hasHalfDay(week, day, ta, false)) continue;
                            afternoons.add(day);
                        }
                    }
                    if (value != null) {
                        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                            if (this.hasHalfDay(week, day, value, true) && mornings.add(day) && mornings.size() + afternoons.size() > maxHalfDays) {
                                penalty += 1.0;
                            }
                            if (!this.hasHalfDay(week, day, value, false) || !afternoons.add(day) || mornings.size() + afternoons.size() <= maxHalfDays) continue;
                            penalty += 1.0;
                        }
                        continue;
                    }
                    penalty += (double)Math.max(0, mornings.size() + afternoons.size() - maxHalfDays);
                }
                return penalty / (Math.max(1.0, 10.0 - (double)maxHalfDays) * (double)instructor.getModel().getWeeks().size());
            }

            @Override
            public void computeConflicts(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                if (this.iNoonSlot == null) {
                    this.iNoonSlot = value.getInstructor().getModel().getProperties().getPropertyInteger("General.HalfDaySlot", 144);
                }
                int[] params = (int[])d.getParameter();
                int maxHalfDays = params[0];
                Set<TeachingAssignment> assignments = ((Instructor.Context)value.getInstructor().getContext(assignment)).getAssignments();
                block0: for (BitSet week : value.getInstructor().getModel().getWeeks()) {
                    HashSet<Integer> selectedHalfDays = new HashSet<Integer>();
                    for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                        if (this.hasHalfDay(week, day, value, true)) {
                            selectedHalfDays.add(2 * day);
                        }
                        if (!this.hasHalfDay(week, day, value, false)) continue;
                        selectedHalfDays.add(2 * day + 1);
                    }
                    if (selectedHalfDays.size() == 0) continue;
                    if (selectedHalfDays.size() > maxHalfDays) {
                        conflicts.add(value);
                        continue;
                    }
                    block2: while (true) {
                        HashSet<Integer> otherHalfDays = new HashSet<Integer>();
                        for (TeachingAssignment ta : assignments) {
                            if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable()) || conflicts.contains(ta)) continue;
                            for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                                if (!selectedHalfDays.contains(2 * day) && this.hasHalfDay(week, day, ta, true)) {
                                    otherHalfDays.add(2 * day);
                                }
                                if (selectedHalfDays.contains(2 * day + 1) || !this.hasHalfDay(week, day, ta, false)) continue;
                                otherHalfDays.add(2 * day + 1);
                            }
                        }
                        if (selectedHalfDays.size() + otherHalfDays.size() <= maxHalfDays) continue block0;
                        int halfday = (Integer)ToolBox.random(otherHalfDays);
                        int day = halfday / 2;
                        boolean morning = halfday % 2 == 0;
                        Iterator<TeachingAssignment> iterator = assignments.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            TeachingAssignment ta = iterator.next();
                            if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable()) || conflicts.contains(ta) || !this.hasHalfDay(week, day, ta, morning)) continue;
                            conflicts.add(ta);
                        }
                        break;
                    }
                }
            }
        }, new ConstraintCreator<int[]>(){

            @Override
            public ParametrizedConstraintType<int[]> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    int maxHalfDays = Integer.parseInt(matcher.group(2));
                    return new ParametrizedConstraintType<int[]>(MAX_HALF_DAYS, new int[]{maxHalfDays}, reference).setName("Max " + maxHalfDays + " Half-Days");
                }
                return null;
            }
        }),
        MAX_CONSECUTIVE_DAYS("_(MaxConsDays):([0-9]+)_", "Max Consecutive Days", new Check(){

            protected boolean hasDay(BitSet week, int dayOfWeek, Section section) {
                if (section.getTime() == null || !section.getTime().getWeekCode().intersects(week)) {
                    return false;
                }
                return (section.getTime().getDayCode() & Constants.DAY_CODES[dayOfWeek]) != 0;
            }

            protected boolean hasDay(BitSet week, int dayOfWeek, TeachingAssignment ta) {
                for (Section section : ((TeachingRequest.Variable)ta.variable()).getSections()) {
                    if (!this.hasDay(week, dayOfWeek, section)) continue;
                    return true;
                }
                return false;
            }

            protected int countDays(TreeSet<Integer> days) {
                if (days.isEmpty()) {
                    return 0;
                }
                return days.last() - days.first() + 1;
            }

            protected int countDays(TreeSet<Integer> days1, TreeSet<Integer> days2) {
                if (days1.isEmpty()) {
                    return this.countDays(days2);
                }
                if (days2.isEmpty()) {
                    return this.countDays(days1);
                }
                return Math.max(days1.last(), days2.last()) - Math.min(days1.first(), days2.first()) + 1;
            }

            @Override
            public double getValue(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
                int[] params = (int[])d.getParameter();
                int maxDays = params[0];
                double penalty = 0.0;
                Set<TeachingAssignment> assignments = ((Instructor.Context)instructor.getContext(assignment)).getAssignments();
                for (BitSet week : instructor.getModel().getWeeks()) {
                    TreeSet<Integer> days = new TreeSet<Integer>();
                    for (TeachingAssignment ta : assignments) {
                        if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable())) continue;
                        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                            if (!this.hasDay(week, day, ta)) continue;
                            days.add(day);
                        }
                    }
                    if (value != null) {
                        int before = Math.max(0, this.countDays(days) - maxDays);
                        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                            if (!this.hasDay(week, day, value)) continue;
                            days.add(day);
                        }
                        int after = Math.max(0, this.countDays(days) - maxDays);
                        penalty += (double)(after - before);
                        continue;
                    }
                    penalty += (double)Math.max(0, this.countDays(days) - maxDays);
                }
                return penalty / (Math.max(1.0, 5.0 - (double)maxDays) * (double)instructor.getModel().getWeeks().size());
            }

            @Override
            public void computeConflicts(Distribution d, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
                int[] params = (int[])d.getParameter();
                int maxDays = params[0];
                Set<TeachingAssignment> assignments = ((Instructor.Context)value.getInstructor().getContext(assignment)).getAssignments();
                block0: for (BitSet week : value.getInstructor().getModel().getWeeks()) {
                    TreeSet<Integer> selectedDays = new TreeSet<Integer>();
                    for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                        if (!this.hasDay(week, day, value)) continue;
                        selectedDays.add(day);
                    }
                    if (selectedDays.isEmpty()) continue;
                    if (this.countDays(selectedDays) > maxDays) {
                        conflicts.add(value);
                        continue;
                    }
                    block2: while (true) {
                        TreeSet<Integer> otherDays = new TreeSet<Integer>();
                        for (TeachingAssignment ta : assignments) {
                            if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable()) || conflicts.contains(ta)) continue;
                            for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
                                if (selectedDays.contains(day) || !this.hasDay(week, day, ta)) continue;
                                otherDays.add(day);
                            }
                        }
                        if (this.countDays(selectedDays, otherDays) <= maxDays) continue block0;
                        int day = ToolBox.random(1) == 0 ? otherDays.first().intValue() : otherDays.last().intValue();
                        Iterator<TeachingAssignment> iterator = assignments.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            TeachingAssignment ta = iterator.next();
                            if (value != null && ((TeachingRequest.Variable)value.variable()).equals(ta.variable()) || conflicts.contains(ta) || !this.hasDay(week, day, ta)) continue;
                            conflicts.add(ta);
                        }
                        break;
                    }
                }
            }
        }, new ConstraintCreator<int[]>(){

            @Override
            public ParametrizedConstraintType<int[]> create(String reference, String regexp) {
                Matcher matcher = Pattern.compile(regexp).matcher(reference);
                if (matcher.find()) {
                    int maxDays = Integer.parseInt(matcher.group(2));
                    return new ParametrizedConstraintType<int[]>(MAX_CONSECUTIVE_DAYS, new int[]{maxDays}, reference).setName("Max " + maxDays + " Consecutive Days");
                }
                return null;
            }
        });

        private String iReference;
        private String iName;
        private Check iCheck = null;
        private ConstraintCreator<?> iCretor = null;

        private ConstraintType(String reference, String name, Check check) {
            this.iReference = reference;
            this.iName = name;
            this.iCheck = check;
        }

        private ConstraintType(String reference, String name, Check check, ConstraintCreator<?> creator) {
            this.iReference = reference;
            this.iName = name;
            this.iCheck = check;
            this.iCretor = creator;
        }

        @Override
        public ConstraintType type() {
            return this;
        }

        @Override
        public String reference() {
            return this.iReference;
        }

        @Override
        public String getName() {
            return this.iName;
        }

        @Override
        public double getValue(Distribution distribution, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
            return this.iCheck.getValue(distribution, assignment, instructor, value);
        }

        @Override
        public void computeConflicts(Distribution distribution, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
            this.iCheck.computeConflicts(distribution, assignment, value, conflicts);
        }

        private Check check() {
            return this.iCheck;
        }

        private ConstraintCreator<?> creator() {
            return this.iCretor;
        }
    }

    public static class ParametrizedConstraintType<P>
    implements ConstraintTypeInterface {
        private String iReference;
        private ConstraintType iType;
        private P iParameter;
        private String iName;

        public ParametrizedConstraintType(ConstraintType type, P parameter, String reference) {
            this.iType = type;
            this.iParameter = parameter;
            this.iReference = reference;
        }

        public ParametrizedConstraintType<P> setName(String name) {
            this.iName = name;
            return this;
        }

        @Override
        public double getValue(Distribution distribution, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
            return this.iType.check().getValue(distribution, assignment, instructor, value);
        }

        @Override
        public void computeConflicts(Distribution distribution, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
            this.iType.check().computeConflicts(distribution, assignment, value, conflicts);
        }

        public P getParameter() {
            return this.iParameter;
        }

        @Override
        public ConstraintType type() {
            return this.iType;
        }

        @Override
        public String reference() {
            return this.iReference;
        }

        @Override
        public String getName() {
            return this.iName == null ? this.iType.getName() : this.iName;
        }
    }

    public static interface ConstraintTypeInterface
    extends Check {
        public ConstraintType type();

        public String reference();

        public String getName();
    }

    public static interface ConstraintCreator<P> {
        public ParametrizedConstraintType<P> create(String var1, String var2);
    }

    public static abstract class SimpleTimeCheck
    extends SimpleCheck {
        public abstract boolean isSatisfied(Distribution var1, TimeLocation var2, TimeLocation var3);

        public boolean isViolated(Distribution d, TimeLocation t1, TimeLocation t2) {
            return true;
        }

        @Override
        public boolean isSatisfied(Distribution d, Section s1, Section s2) {
            if (s1.getTime() == null || s2.getTime() == null) {
                return true;
            }
            return this.isSatisfied(d, s1.getTime(), s2.getTime());
        }

        @Override
        public boolean isViolated(Distribution d, Section s1, Section s2) {
            if (s1.getTime() == null || s2.getTime() == null) {
                return true;
            }
            return this.isViolated(d, s1.getTime(), s2.getTime());
        }
    }

    public static abstract class SimpleCheck
    extends PairCheck {
        public abstract boolean isSatisfied(Distribution var1, Section var2, Section var3);

        public boolean isViolated(Distribution d, Section s1, Section s2) {
            return true;
        }

        @Override
        public boolean isSatisfied(Distribution distribution, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, Section s1, Section s2) {
            return this.isSatisfied(distribution, s1, s2);
        }

        @Override
        public boolean isViolated(Distribution distribution, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, Section s1, Section s2) {
            return this.isViolated(distribution, s1, s2);
        }
    }

    public static abstract class PairCheck
    implements Check {
        public abstract boolean isSatisfied(Distribution var1, Assignment<TeachingRequest.Variable, TeachingAssignment> var2, Instructor var3, Section var4, Section var5);

        public abstract boolean isViolated(Distribution var1, Assignment<TeachingRequest.Variable, TeachingAssignment> var2, Instructor var3, Section var4, Section var5);

        @Override
        public double getValue(Distribution distribution, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Instructor instructor, TeachingAssignment value) {
            int ret = 0;
            Set<TeachingAssignment> assignments = ((Instructor.Context)instructor.getContext(assignment)).getAssignments();
            if (value == null) {
                for (TeachingAssignment ta1 : assignments) {
                    for (Section s1 : ((TeachingRequest.Variable)ta1.variable()).getSections()) {
                        for (TeachingAssignment ta2 : ((Instructor.Context)instructor.getContext(assignment)).getAssignments()) {
                            for (Section s2 : ((TeachingRequest.Variable)ta2.variable()).getSections()) {
                                if (s1.equals(s2)) continue;
                                if (distribution.isPositive()) {
                                    if (this.isSatisfied(distribution, assignment, instructor, s1, s2)) continue;
                                    ++ret;
                                    continue;
                                }
                                if (this.isViolated(distribution, assignment, instructor, s1, s2)) continue;
                                ++ret;
                            }
                        }
                    }
                }
            } else {
                for (Section s1 : ((TeachingRequest.Variable)value.variable()).getSections()) {
                    for (TeachingAssignment ta2 : assignments) {
                        for (Section s2 : ((TeachingRequest.Variable)ta2.variable()).getSections()) {
                            if (s1.equals(s2)) continue;
                            if (distribution.isPositive()) {
                                if (this.isSatisfied(distribution, assignment, instructor, s1, s2)) continue;
                                ++ret;
                                continue;
                            }
                            if (this.isViolated(distribution, assignment, instructor, s1, s2)) continue;
                            ++ret;
                        }
                    }
                }
            }
            if (ret == 0) {
                return 0.0;
            }
            int n = assignments.size() + (value == null || assignment.getValue((TeachingRequest.Variable)value.variable()) != null ? 0 : 1);
            return 2.0 * (double)ret / (double)(n * (n - 1));
        }

        @Override
        public void computeConflicts(Distribution distribution, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
            for (Section s1 : ((TeachingRequest.Variable)value.variable()).getSections()) {
                for (TeachingAssignment ta2 : ((Instructor.Context)value.getInstructor().getContext(assignment)).getAssignments()) {
                    for (Section s2 : ((TeachingRequest.Variable)ta2.variable()).getSections()) {
                        if (s1.equals(s2)) continue;
                        if (distribution.isPositive()) {
                            if (this.isSatisfied(distribution, assignment, value.getInstructor(), s1, s2)) continue;
                            conflicts.add(ta2);
                            continue;
                        }
                        if (this.isViolated(distribution, assignment, value.getInstructor(), s1, s2)) continue;
                        conflicts.add(ta2);
                    }
                }
            }
        }
    }

    public static interface Check {
        public void computeConflicts(Distribution var1, Assignment<TeachingRequest.Variable, TeachingAssignment> var2, TeachingAssignment var3, Set<TeachingAssignment> var4);

        public double getValue(Distribution var1, Assignment<TeachingRequest.Variable, TeachingAssignment> var2, Instructor var3, TeachingAssignment var4);
    }

    public static class Distribution {
        ConstraintTypeInterface iType;
        boolean iRequired = false;
        boolean iProhibited = false;
        int iPenalty = 0;

        public Distribution(ConstraintTypeInterface type, String preference) {
            this.iType = type;
            this.iRequired = "R".equals(preference);
            this.iProhibited = "P".equals(preference);
            this.iPenalty = Constants.preference2preferenceLevel(preference);
        }

        public ConstraintTypeInterface getType() {
            return this.iType;
        }

        public int getPenalty() {
            return this.iPenalty;
        }

        public boolean isRequired() {
            return this.iRequired;
        }

        public boolean isProhibited() {
            return this.iProhibited;
        }

        public boolean isHard() {
            return this.isRequired() || this.isProhibited();
        }

        public String getPreference() {
            if (this.isRequired()) {
                return "R";
            }
            if (this.isProhibited()) {
                return "P";
            }
            return Constants.preferenceLevel2preference(this.getPenalty());
        }

        public boolean isPositive() {
            if (this.isRequired()) {
                return true;
            }
            if (this.isProhibited()) {
                return false;
            }
            return this.getPenalty() <= 0;
        }

        public <P> P getParameter() {
            if (this.iType instanceof ParametrizedConstraintType) {
                return ((ParametrizedConstraintType)this.iType).getParameter();
            }
            return null;
        }
    }
}

