/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.permissions;

import org.springframework.stereotype.Service;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;

@Service(value="permissionExaminationStatus")
public class SimpleExaminationPermission
implements Permission.PermissionExamination {
    @Override
    public boolean check(UserContext user, Session session) {
        return this.check(user, session, null, new DepartmentStatusType.Status[0]);
    }

    @Override
    public boolean check(UserContext user, Session session, ExamType examType, DepartmentStatusType.Status ... status) {
        if (user == null || user.getCurrentAuthority() == null || session == null) {
            return false;
        }
        UserAuthority authority = user.getCurrentAuthority();
        if (!authority.hasRight(Right.SessionIndependent) && !authority.hasQualifier(session)) {
            return false;
        }
        if (!authority.hasRight(Right.AllowTestSessions) && (session.getStatusType() == null || session.getStatusType().isTestSession())) {
            return false;
        }
        if (examType == null) {
            boolean checkDefaultStatus = false;
            for (ExamType et : ExamType.findAllUsed(session.getUniqueId())) {
                ExamStatus examStatus = ExamStatus.findStatus(session.getUniqueId(), et.getUniqueId());
                if (examStatus != null) {
                    if (!this.checkManager(authority, examStatus, status) || !this.checkStatus(authority, examStatus.effectiveStatus(), status)) continue;
                    return true;
                }
                checkDefaultStatus = true;
            }
            if (!checkDefaultStatus) {
                return false;
            }
        }
        ExamStatus examStatus = examType == null ? null : ExamStatus.findStatus(session.getUniqueId(), examType.getUniqueId());
        DepartmentStatusType type = examStatus == null ? session.getStatusType() : examStatus.effectiveStatus();
        return this.checkManager(authority, examStatus, status) && this.checkStatus(authority, type, status);
    }

    @Override
    public boolean check(UserContext user, Department department, ExamType examType, DepartmentStatusType.Status ... status) {
        DepartmentStatusType type;
        if (!this.check(user, department.getSession(), examType, status)) {
            return false;
        }
        UserAuthority authority = user.getCurrentAuthority();
        if (!authority.hasRight(Right.DepartmentIndependent) && !authority.hasQualifier(department)) {
            return false;
        }
        if (status.length > 0 && !authority.hasRight(Right.StatusIndependent) && (type = department.getStatusType()) != null) {
            for (DepartmentStatusType.Status s : status) {
                if (!type.can(s)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Class<Session> type() {
        return Session.class;
    }

    public boolean checkManager(UserAuthority authority, ExamStatus examStatus, DepartmentStatusType.Status ... status) {
        if (examStatus == null || authority.hasRight(Right.StatusIndependent) || !authority.hasRight(Right.ExaminationSolver)) {
            return true;
        }
        if (!examStatus.getManagers().isEmpty()) {
            for (TimetableManager m : examStatus.getManagers()) {
                if (!authority.hasQualifier(m)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean checkStatus(UserAuthority authority, DepartmentStatusType type, DepartmentStatusType.Status ... status) {
        if (authority.hasRight(Right.StatusIndependent) || status.length == 0) {
            return true;
        }
        if (type != null) {
            for (DepartmentStatusType.Status s : status) {
                if (!type.can(s)) continue;
                return true;
            }
        }
        return false;
    }
}

