/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.online.selection.ResectioningWeights;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.interfaces.ExternalClassNameHelperInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.WaitListComparatorProvider;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequestComparator;
import org.unitime.timetable.onlinesectioning.updates.CheckOfferingAction;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;
import org.unitime.timetable.onlinesectioning.updates.InstructorEmail;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;
import org.unitime.timetable.onlinesectioning.updates.PersistExpectedSpacesAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;
import org.unitime.timetable.onlinesectioning.updates.WaitlistedOnlineSectioningAction;

public class ReloadOfferingAction
extends WaitlistedOnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private List<Long> iOfferingIds;

    public ReloadOfferingAction forOfferings(Long ... offeringIds) {
        this.iOfferingIds = new ArrayList<Long>();
        for (Long offeringId : offeringIds) {
            this.iOfferingIds.add(offeringId);
        }
        return this;
    }

    public ReloadOfferingAction forOfferings(List<Long> offeringIds) {
        this.iOfferingIds = offeringIds;
        return this;
    }

    public List<Long> getOfferingIds() {
        return this.iOfferingIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (ApplicationProperty.OnlineSchedulingGradableIType.isTrue() && Class_.getExternalClassNameHelper() != null) {
            if (Class_.getExternalClassNameHelper() instanceof ExternalClassNameHelperInterface.HasGradableSubpartCache) {
                helper.setGradableSubpartsProvider(((ExternalClassNameHelperInterface.HasGradableSubpartCache)((Object)Class_.getExternalClassNameHelper())).getGradableSubparts(this.getOfferingIds(), helper.getHibSession()));
            } else if (Class_.getExternalClassNameHelper() instanceof ExternalClassNameHelperInterface.HasGradableSubpart) {
                helper.setGradableSubpartsProvider((ExternalClassNameHelperInterface.HasGradableSubpart)((Object)Class_.getExternalClassNameHelper()));
            }
        }
        if (Class_.getExternalClassNameHelper() != null) {
            if (Class_.getExternalClassNameHelper() instanceof ExternalClassNameHelperInterface.HasClassNamesCache) {
                helper.setExternalClassNameHelper(((ExternalClassNameHelperInterface.HasClassNamesCache)((Object)Class_.getExternalClassNameHelper())).getClassNamesCache(this.getOfferingIds(), helper.getHibSession()));
            } else {
                helper.setExternalClassNameHelper(Class_.getExternalClassNameHelper());
            }
        }
        HashSet<Long> recheck = new HashSet<Long>();
        for (Long offeringId : this.getOfferingIds()) {
            helper.getAction().addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(offeringId).setType(OnlineSectioningLog.Entity.EntityType.OFFERING));
            List studentIds = helper.getHibSession().createQuery("select distinct cr.courseDemand.student.uniqueId from CourseRequest cr where cr.courseOffering.instructionalOffering.uniqueId = :offeringId and cr.courseDemand.waitlist = true", Long.class).setParameter("offeringId", (Object)offeringId).list();
            studentIds.addAll(helper.getHibSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId", Long.class).setParameter("offeringId", (Object)offeringId).list());
            OnlineSectioningServer.Lock lock = server.lockOffering(offeringId, studentIds, this.name());
            try {
                helper.beginTransaction();
                try {
                    this.reloadOffering(server, helper, offeringId, recheck);
                    helper.commitTransaction();
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    if (e instanceof SectioningException) {
                        throw (SectioningException)e;
                    }
                    throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                }
            }
            finally {
                lock.release();
            }
        }
        if (!recheck.isEmpty()) {
            server.execute(server.createAction(CheckOfferingAction.class).forOfferings(recheck), helper.getUser());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void reloadOffering(OnlineSectioningServer server, OnlineSectioningHelper helper, Long offeringId, Set<Long> recheckOfferingIds) {
        Object enrollment;
        if (recheckOfferingIds != null) {
            recheckOfferingIds.remove(offeringId);
        }
        HashMap<Long, Student> newStudents = new HashMap<Long, Student>();
        for (Student student : helper.getHibSession().createQuery("select distinct s from Student s left join s.courseDemands as cd left join cd.courseRequests as cr left join fetch s.classEnrollments as e left join fetch s.areaClasfMajors as acm left join fetch s.waitlists as w left join fetch s.groups as g left join fetch s.notes as n where cr.courseOffering.instructionalOffering.uniqueId = :offeringId", Student.class).setParameter("offeringId", (Object)offeringId).list()) {
            newStudents.put(student.getUniqueId(), student);
        }
        for (Student student : helper.getHibSession().createQuery("select distinct s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cr.courseOffering as co left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch s.areaClasfMajors as acm left join fetch s.waitlists as w left join fetch s.groups as g left join fetch s.notes as n where e.courseOffering.instructionalOffering.uniqueId = :offeringId and e.courseRequest is null", Student.class).setParameter("offeringId", (Object)offeringId).list()) {
            newStudents.put(student.getUniqueId(), student);
        }
        if (server.needPersistExpectedSpaces(offeringId)) {
            PersistExpectedSpacesAction.persistExpectedSpaces(offeringId, false, server, helper);
        }
        XOffering oldOffering = server.getOffering(offeringId);
        XEnrollments oldEnrollments = server.getEnrollments(offeringId);
        XOffering newOffering = null;
        InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId, helper.getHibSession());
        ArrayList<XDistribution> distributions = new ArrayList<XDistribution>();
        if (io != null && io.isAllowStudentScheduling()) {
            List distPrefs = helper.getHibSession().createQuery("select distinct p from DistributionPref p inner join p.distributionObjects o, Department d, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering io where p.distributionType.reference in (:ref1, :ref2) and d.session.uniqueId = :sessionId and io.uniqueId = :offeringId and (o.prefGroup = c or o.prefGroup = c.schedulingSubpart) and p.owner = d and p.prefLevel.prefProlog = :pref", DistributionPref.class).setParameter("ref1", (Object)GroupConstraint.ConstraintType.LINKED_SECTIONS.reference()).setParameter("ref2", (Object)"NO_CONFLICT").setParameter("pref", (Object)PreferenceLevel.sRequired).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).setParameter("offeringId", (Object)offeringId).list();
            if (!distPrefs.isEmpty()) {
                for (DistributionPref pref : distPrefs) {
                    int n = 0;
                    for (Collection<Class_> collection : ReloadAllData.getSections(pref)) {
                        XDistributionType type = XDistributionType.IngoreConflicts;
                        if (GroupConstraint.ConstraintType.LINKED_SECTIONS.reference().equals(pref.getDistributionType().getReference())) {
                            type = XDistributionType.LinkedSections;
                        }
                        XDistribution distribution = new XDistribution(type, pref.getUniqueId(), n++, collection);
                        distributions.add(distribution);
                    }
                }
            }
            if ((newOffering = ReloadAllData.loadOffering(io, distributions, server, helper)) != null) {
                server.update(newOffering);
            } else if (oldOffering != null) {
                server.remove(oldOffering);
            }
            List infos = helper.getHibSession().createQuery("select i.clazz.uniqueId, i.nbrExpectedStudents from SectioningInfo i where i.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :offeringId", Object[].class).setParameter("offeringId", (Object)offeringId).list();
            XExpectations expectations = new XExpectations(offeringId);
            for (Object[] info : infos) {
                Long l = (Long)info[0];
                Double expected = (Double)info[1];
                expectations.setExpectedSpace(l, expected);
            }
            server.update(expectations);
        } else if (oldOffering != null) {
            server.remove(oldOffering);
        }
        this.checkForInstructorChanges(oldOffering, newOffering, server, helper);
        ArrayList<XStudent[]> students = new ArrayList<XStudent[]>();
        if (oldEnrollments != null) {
            HashSet checked = new HashSet();
            for (XRequest xRequest : oldEnrollments.getRequests()) {
                void var16_31;
                XStudent newStudent;
                if (!checked.add(xRequest.getStudentId())) continue;
                XStudent oldStudent = server.getStudent(xRequest.getStudentId());
                Student student = (Student)newStudents.get(oldStudent.getStudentId());
                if (student == null) {
                    Student student2 = (Student)StudentDAO.getInstance().get(oldStudent.getStudentId(), helper.getHibSession());
                }
                XStudent xStudent = newStudent = var16_31 == null ? null : ReloadAllData.loadStudent((Student)var16_31, null, server, helper, WaitList.WaitListType.RELOAD);
                if (newStudent != null) {
                    server.update(newStudent, true);
                } else {
                    server.remove(oldStudent);
                }
                students.add(new XStudent[]{oldStudent, newStudent});
                newStudents.remove(oldStudent.getStudentId());
            }
        }
        for (Object student : newStudents.values()) {
            XStudent xStudent = server.getStudent(((BaseStudent)student).getUniqueId());
            XStudent newStudent = ReloadAllData.loadStudent((Student)student, null, server, helper, WaitList.WaitListType.RELOAD);
            if (newStudent != null) {
                server.update(newStudent, true);
            } else if (xStudent != null) {
                server.remove(xStudent);
            }
            students.add(new XStudent[]{xStudent, newStudent});
        }
        if (!server.getAcademicSession().isSectioningEnabled()) {
            return;
        }
        if (!CustomStudentEnrollmentHolder.isAllowWaitListing()) {
            return;
        }
        if (newOffering == null && oldOffering == null) {
            return;
        }
        if (newOffering != null && !newOffering.isReSchedule()) {
            HashSet<XCourse> courseIds = new HashSet<XCourse>();
            if (newOffering != null) {
                courseIds.addAll(newOffering.getCourses());
            }
            if (oldOffering != null) {
                courseIds.addAll(oldOffering.getCourses());
            }
            for (XCourseId xCourseId : courseIds) {
                for (XStudent[] xStudentArray : students) {
                    Iterator oldStudent = xStudentArray[0];
                    XCourseRequest oldRequest = this.getRequest((XStudent)((Object)oldStudent), xCourseId);
                    XEnrollment oldEnrollment = this.getEnrollment(oldRequest, offeringId);
                    XStudent newStudent = xStudentArray[1];
                    XCourseRequest newRequest = this.getRequest(newStudent, xCourseId);
                    XEnrollment newEnrollment = this.getEnrollment(newRequest, offeringId);
                    if (newEnrollment == null || oldEnrollment == null || ReloadOfferingAction.isVerySame(newEnrollment.getCourseId(), newOffering.getSections(newEnrollment), oldOffering.getSections(oldEnrollment))) continue;
                    server.execute(server.createAction(NotifyStudentAction.class).forStudent(server.getStudent(oldStudent == null ? newStudent.getStudentId() : ((XStudentId)((Object)oldStudent)).getStudentId())).fromAction(this.name()).withType(StudentSectioningStatus.NotificationType.CourseChangeSchedule).oldEnrollment(oldOffering, xCourseId, oldEnrollment), helper.getUser());
                }
            }
            return;
        }
        WaitListComparatorProvider cmp = (WaitListComparatorProvider)Customization.WaitListComparatorProvider.getProvider();
        TreeSet<SectioningRequest> queue = new TreeSet<SectioningRequest>(cmp == null ? new SectioningRequestComparator() : cmp.getComparator(server, helper));
        HashSet<XCourse> hashSet = new HashSet<XCourse>();
        if (newOffering != null) {
            hashSet.addAll(newOffering.getCourses());
        }
        if (oldOffering != null) {
            hashSet.addAll(oldOffering.getCourses());
        }
        if (server.getConfig().getPropertyBoolean("Enrollment.ReSchedulingEnabled", false) || server.getConfig().getPropertyBoolean("Enrollment.ReSchedulingOnUnlock", false)) {
            for (XCourseId xCourseId : hashSet) {
                for (XStudent[] student : students) {
                    oldStudent = student[0];
                    oldRequest = this.getRequest(oldStudent, xCourseId);
                    oldEnrollment = this.getEnrollment(oldRequest, offeringId);
                    newStudent = student[1];
                    newRequest = this.getRequest(newStudent, xCourseId);
                    newEnrollment = this.getEnrollment(newRequest, offeringId);
                    if (oldRequest == null && newRequest == null) continue;
                    if (!this.hasReSchedulingStatus(newStudent == null ? oldStudent : newStudent, server)) {
                        if (newEnrollment == null || oldEnrollment == null || ReloadOfferingAction.isVerySame(newEnrollment.getCourseId(), newOffering.getSections(newEnrollment), oldOffering.getSections(oldEnrollment))) continue;
                        server.execute(server.createAction(NotifyStudentAction.class).forStudent(server.getStudent(oldStudent == null ? newStudent.getStudentId() : oldStudent.getStudentId())).fromAction(this.name()).withType(StudentSectioningStatus.NotificationType.CourseChangeSchedule).oldEnrollment(oldOffering, xCourseId, oldEnrollment), helper.getUser());
                        continue;
                    }
                    action = helper.addAction(this, server.getAcademicSession());
                    action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student[0] == null ? student[1].getStudentId() : student[0].getStudentId()).setExternalId(student[0] == null ? student[1].getExternalId() : student[0].getExternalId()).setName(student[0] == null ? student[1].getName() : student[0].getName()));
                    action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(offeringId).setName(newOffering == null ? oldOffering.getName() : newOffering.getName()).setType(OnlineSectioningLog.Entity.EntityType.OFFERING));
                    action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(xCourseId.getCourseId()).setName(xCourseId.getCourseName()).setType(OnlineSectioningLog.Entity.EntityType.COURSE));
                    if (oldEnrollment != null) {
                        enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                        enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                        for (Long l : oldEnrollment.getSectionIds()) {
                            enrollment.addSection(OnlineSectioningHelper.toProto(oldOffering.getSection(l), oldEnrollment));
                        }
                        action.addEnrollment(enrollment);
                        if (newRequest == null) {
                            action.addRequest(OnlineSectioningHelper.toProto(oldRequest));
                        }
                    }
                    if (newRequest == null) {
                        action.setResult(OnlineSectioningLog.Action.ResultType.NULL);
                        Exception exception = null;
                        if (oldEnrollment != null && CustomStudentEnrollmentHolder.hasProvider()) {
                            try {
                                CustomStudentEnrollmentHolder.getProvider().resection(server, helper, new SectioningRequest(newOffering, newRequest, xCourseId, newStudent, SectioningRequest.ReschedulingReason.NO_REQUEST, this.getStudentPriority(newStudent, server, helper), action).setOldOffering(oldOffering).setOldStudent(oldStudent).setOldRequest(oldRequest).setLastEnrollment(oldEnrollment), null);
                            }
                            catch (Exception ex) {
                                action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                                helper.error(xCourseId.getCourseName() + ": " + (ex.getMessage() == null ? "Unable to drop student." : ex.getMessage()), ex, action);
                                exception = ex;
                            }
                        }
                        action.setEndTime(System.currentTimeMillis());
                        if (oldEnrollment == null) continue;
                        NotifyStudentAction notifyAction = server.createAction(NotifyStudentAction.class).forStudent(server.getStudent(oldStudent == null ? newStudent.getStudentId() : oldStudent.getStudentId())).fromAction(this.name()).withType(StudentSectioningStatus.NotificationType.CourseChangeEnrollment).oldEnrollment(oldOffering, xCourseId, oldEnrollment).rescheduling(SectioningRequest.ReschedulingReason.NO_REQUEST);
                        if (exception != null) {
                            notifyAction.failedEnrollment(oldOffering, xCourseId, null, exception);
                        }
                        server.execute(notifyAction, helper.getUser());
                        continue;
                    }
                    action.addRequest(OnlineSectioningHelper.toProto(newRequest));
                    if (oldEnrollment == null && newEnrollment == null) {
                        if (!this.isWaitListed(newStudent, newRequest, newOffering == null ? oldOffering : newOffering, server, helper)) continue;
                        queue.add(new SectioningRequest(newOffering, newRequest, xCourseId, newStudent, null, this.getStudentPriority(newStudent, server, helper), action).setOldOffering(oldOffering).setOldRequest(oldRequest).setOldStudent(oldStudent));
                        continue;
                    }
                    SectioningRequest.ReschedulingReason check = null;
                    if (newEnrollment != null && oldEnrollment != null && (check = this.check(newOffering, xCourseId, distributions, newStudent, newEnrollment, server)) == null) {
                        enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                        ((OnlineSectioningLog.Enrollment.Builder)enrollment).setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                        for (Object assignment : newOffering.getSections(newEnrollment)) {
                            ((OnlineSectioningLog.Enrollment.Builder)enrollment).addSection(OnlineSectioningHelper.toProto((XSection)assignment, newEnrollment));
                        }
                        action.addEnrollment((OnlineSectioningLog.Enrollment.Builder)enrollment);
                        action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                        if (CustomStudentEnrollmentHolder.hasProvider()) {
                            try {
                                CustomStudentEnrollmentHolder.getProvider().resection(server, helper, new SectioningRequest(newOffering, newRequest, xCourseId, newStudent, null, this.getStudentPriority(newStudent, server, helper), action).setOldOffering(oldOffering).setOldStudent(oldStudent).setOldRequest(oldRequest).setLastEnrollment(oldEnrollment), newEnrollment);
                            }
                            catch (Exception exception) {
                                action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                                helper.error(xCourseId.getCourseName() + ": " + (exception.getMessage() == null ? "Unable to resection student." : exception.getMessage()), exception, action);
                            }
                        }
                        action.setEndTime(System.currentTimeMillis());
                        if (!ReloadOfferingAction.isVerySame(newEnrollment.getCourseId(), newOffering.getSections(newEnrollment), oldOffering.getSections(oldEnrollment))) {
                            server.execute(server.createAction(NotifyStudentAction.class).forStudent(server.getStudent(oldStudent == null ? newStudent.getStudentId() : oldStudent.getStudentId())).fromAction(this.name()).withType(StudentSectioningStatus.NotificationType.CourseChangeSchedule).oldEnrollment(oldOffering, xCourseId, oldEnrollment), helper.getUser());
                        }
                        if (newOffering == null || !newEnrollment.equals(newRequest.getWaitListSwapWithCourseOffering()) || !this.isWaitListed(newStudent, newRequest, newOffering, server, helper)) continue;
                        queue.add(new SectioningRequest(newOffering, newRequest, xCourseId, newStudent, null, this.getStudentPriority(newStudent, server, helper), action).setOldOffering(oldOffering).setOldRequest(oldRequest).setOldStudent(oldStudent).setLastEnrollment(oldEnrollment).setNewEnrollment(newEnrollment));
                        continue;
                    }
                    newRequest = server.assign(newRequest, null);
                    queue.add(new SectioningRequest(newOffering, newRequest, xCourseId, newStudent, check, this.getStudentPriority(newStudent, server, helper), action).setOldOffering(oldOffering).setOldRequest(oldRequest).setOldStudent(oldStudent).setLastEnrollment(oldEnrollment).setNewEnrollment(newEnrollment));
                }
            }
        } else if (newOffering != null) {
            for (XCourseId xCourseId : hashSet) {
                for (XStudent[] student : students) {
                    oldStudent = student[0];
                    oldRequest = this.getRequest(oldStudent, xCourseId);
                    oldEnrollment = this.getEnrollment(oldRequest, offeringId);
                    newStudent = student[1];
                    newRequest = this.getRequest(newStudent, xCourseId);
                    newEnrollment = this.getEnrollment(newRequest, offeringId);
                    if (newRequest != null && newStudent.canAssign(newRequest, OnlineSectioningInterface.WaitListMode.WaitList) && this.isWaitListed(student[1], newRequest, newOffering, server, helper)) {
                        action = helper.addAction(this, server.getAcademicSession());
                        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student[0] == null ? student[1].getStudentId() : student[0].getStudentId()).setExternalId(student[0] == null ? student[1].getExternalId() : student[0].getExternalId()).setName(student[0] == null ? student[1].getName() : student[0].getName()));
                        action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(offeringId).setName(newOffering.getName()).setType(OnlineSectioningLog.Entity.EntityType.OFFERING));
                        action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(xCourseId.getCourseId()).setName(xCourseId.getCourseName()).setType(OnlineSectioningLog.Entity.EntityType.COURSE));
                        if (oldEnrollment != null) {
                            enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                            enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                            for (Long l : oldEnrollment.getSectionIds()) {
                                enrollment.addSection(OnlineSectioningHelper.toProto(oldOffering.getSection(l), oldEnrollment));
                            }
                            action.addEnrollment(enrollment);
                        }
                        action.addRequest(OnlineSectioningHelper.toProto(newRequest));
                        queue.add(new SectioningRequest(newOffering, newRequest, xCourseId, newStudent, null, this.getStudentPriority(newStudent, server, helper), action).setOldOffering(oldOffering).setOldRequest(oldRequest).setOldStudent(oldStudent).setLastEnrollment(oldEnrollment).setNewEnrollment(newEnrollment));
                        continue;
                    }
                    if (newEnrollment == null || oldEnrollment == null || ReloadOfferingAction.isVerySame(newEnrollment.getCourseId(), newOffering.getSections(newEnrollment), oldOffering.getSections(oldEnrollment))) continue;
                    server.execute(server.createAction(NotifyStudentAction.class).forStudent(server.getStudent(oldStudent == null ? newStudent.getStudentId() : oldStudent.getStudentId())).fromAction(this.name()).withType(StudentSectioningStatus.NotificationType.CourseChangeSchedule).oldEnrollment(oldOffering, xCourseId, oldEnrollment), helper.getUser());
                }
            }
        }
        boolean lockStudents = server.getConfig().getPropertyBoolean(this.name() + ".LockStudents", true);
        if (!queue.isEmpty()) {
            DataProperties dataProperties = server.getConfig();
            ResectioningWeights w = new ResectioningWeights(dataProperties);
            StudentQuality sq = new StudentQuality(server.getDistanceMetric(), dataProperties);
            Date ts = new Date();
            int index = 1;
            for (SectioningRequest r : queue) {
                void var28_72;
                XOffering dropOffering;
                helper.debug("Resectioning " + String.valueOf(r.getRequest()) + " (was " + String.valueOf(r.getLastEnrollment() == null ? "not assigned" : r.getLastEnrollment().getSectionIds()) + ")", r.getAction());
                long c0 = OnlineSectioningHelper.getCpuTime();
                r.getAction().setStartTime(System.currentTimeMillis());
                r.getAction().addOptionBuilder().setKey("Index").setValue(index + " of " + queue.size());
                ++index;
                if (r.isRescheduling()) {
                    r.getAction().addOptionBuilder().setKey("Issue").setValue(r.getReschedulingReason().name());
                }
                XEnrollment dropEnrollment = r.getDropEnrollment();
                XEnrollment e = r.resection(server, w, sq, helper);
                if (dropEnrollment != null && (dropOffering = server.getOffering(dropEnrollment.getOfferingId())) != null) {
                    OnlineSectioningLog.Enrollment.Builder builder = OnlineSectioningLog.Enrollment.newBuilder();
                    builder.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                    for (Long sectionId : dropEnrollment.getSectionIds()) {
                        builder.addSection(OnlineSectioningHelper.toProto(dropOffering.getSection(sectionId), dropEnrollment));
                    }
                    r.getAction().addEnrollment(builder);
                }
                if (e != null) {
                    e.setTimeStamp(ts);
                    enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                    ((OnlineSectioningLog.Enrollment.Builder)enrollment).setType(OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED);
                    for (Long sectionId : e.getSectionIds()) {
                        ((OnlineSectioningLog.Enrollment.Builder)enrollment).addSection(OnlineSectioningHelper.toProto(newOffering.getSection(sectionId), e));
                    }
                    r.getAction().addEnrollment((OnlineSectioningLog.Enrollment.Builder)enrollment);
                }
                if (e == null && !r.isRescheduling()) {
                    r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                    r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                    r.getAction().setEndTime(System.currentTimeMillis());
                    continue;
                }
                if (CustomStudentEnrollmentHolder.hasProvider()) {
                    try {
                        e = CustomStudentEnrollmentHolder.getProvider().resection(server, helper, r, e);
                    }
                    catch (Exception ex) {
                        r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                        helper.warn(r.getCourseId().getCourseName() + ": " + (ex.getMessage() == null ? "Unable to resection student." : ex.getMessage()), r.getAction());
                        if (r.getNewEnrollment() != null) {
                            server.assign(r.getRequest(), r.getNewEnrollment());
                        }
                        r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                        r.getAction().setEndTime(System.currentTimeMillis());
                        if (!ApplicationProperty.OnlineSchedulingEmailConfirmationWhenFailed.isTrue()) continue;
                        server.execute(server.createAction(NotifyStudentAction.class).forStudent(server.getStudent(r.getRequest().getStudentId())).fromAction(this.name()).withType(StudentSectioningStatus.NotificationType.CourseChangeEnrollmentFailed).failedEnrollment(newOffering, r.getCourseId(), e, ex).dropEnrollment(dropEnrollment).oldEnrollment(oldOffering, r.getCourseId(), r.getLastEnrollment()).rescheduling(r.getReschedulingReason()), helper.getUser());
                        continue;
                    }
                }
                if (e == null && r.getLastEnrollment() == null) {
                    r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FALSE);
                    r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                    r.getAction().setEndTime(System.currentTimeMillis());
                    continue;
                }
                if (dropEnrollment != null) {
                    server.assign(r.getDropRequest(), null);
                }
                if (e != null) {
                    r.setRequest(server.assign(r.getRequest(), e));
                }
                helper.debug("New: " + String.valueOf(e == null ? "not assigned" : e.getSectionIds()), r.getAction());
                Date dropTS = null;
                Session session = helper.getHibSession();
                Transaction tx = null;
                if (!lockStudents) {
                    Session session2 = new _RootDAO().createNewSession();
                    tx = session2.beginTransaction();
                }
                OnlineSectioningInterface.WaitListMode wlMode = OnlineSectioningInterface.WaitListMode.None;
                try {
                    CourseOffering co;
                    Student student = (Student)StudentDAO.getInstance().get(r.getRequest().getStudentId(), (Session)var28_72);
                    wlMode = student.getWaitListMode();
                    HashMap<Long, Object> enrollmentMap = new HashMap<Long, Object>();
                    String approvedBy = null;
                    Date approvedDate = null;
                    Iterator<StudentClassEnrollment> i = student.getClassEnrollments().iterator();
                    while (i.hasNext()) {
                        StudentClassEnrollment enrl = i.next();
                        if (enrl.getCourseRequest() != null && enrl.getCourseRequest().getCourseDemand().getUniqueId().equals(r.getRequest().getRequestId()) || enrl.getCourseOffering() != null && enrl.getCourseOffering().getUniqueId().equals(r.getCourseId().getCourseId())) {
                            helper.debug("Deleting " + enrl.getClazz().getClassLabel(), r.getAction());
                            if (dropTS == null || enrl.getTimestamp() != null && enrl.getTimestamp().before(dropTS)) {
                                dropTS = enrl.getTimestamp();
                            }
                            enrollmentMap.put(enrl.getClazz().getUniqueId(), enrl);
                            if (approvedBy == null && enrl.getApprovedBy() != null) {
                                approvedBy = enrl.getApprovedBy();
                                approvedDate = enrl.getApprovedDate();
                            }
                            enrl.getClazz().getStudentEnrollments().remove(enrl);
                            var28_72.remove((Object)enrl);
                            i.remove();
                            continue;
                        }
                        if (dropEnrollment == null || !dropEnrollment.getCourseId().equals(enrl.getCourseOffering().getUniqueId())) continue;
                        helper.debug("Deleting " + enrl.getClazz().getClassLabel(), r.getAction());
                        enrl.getClazz().getStudentEnrollments().remove(enrl);
                        var28_72.remove((Object)enrl);
                        i.remove();
                    }
                    BaseCourseDemand cd = null;
                    block31: for (CourseDemand x : student.getCourseDemands()) {
                        for (CourseRequest courseRequest : x.getCourseRequests()) {
                            if (!courseRequest.getCourseOffering().getInstructionalOffering().getUniqueId().equals(offeringId)) continue;
                            cd = x;
                            break block31;
                        }
                    }
                    if (r.getRequest().getEnrollment() != null) {
                        cr = null;
                        Object co2 = null;
                        if (co2 == null) {
                            for (CourseOffering courseOffering : io.getCourseOfferings()) {
                                if (!courseOffering.getUniqueId().equals(r.getRequest().getEnrollment().getCourseId())) continue;
                                co2 = courseOffering;
                            }
                        }
                        for (Long l : r.getRequest().getEnrollment().getSectionIds()) {
                            Class_ clazz = (Class_)Class_DAO.getInstance().get(l, (Session)var28_72);
                            if (cd != null && cr == null) {
                                for (CourseRequest courseRequest : cd.getCourseRequests()) {
                                    if (!courseRequest.getCourseOffering().getInstructionalOffering().getUniqueId().equals(offeringId)) continue;
                                    cr = courseRequest;
                                    break;
                                }
                            }
                            if (co2 == null) {
                                co2 = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                            }
                            StudentClassEnrollment enrl = new StudentClassEnrollment();
                            enrl.setClazz(clazz);
                            clazz.getStudentEnrollments().add(enrl);
                            enrl.setCourseOffering((CourseOffering)co2);
                            enrl.setCourseRequest(cr);
                            StudentClassEnrollment studentClassEnrollment = (StudentClassEnrollment)enrollmentMap.get(l);
                            enrl.setTimestamp(studentClassEnrollment != null ? studentClassEnrollment.getTimestamp() : ts);
                            enrl.setChangedBy(studentClassEnrollment != null ? studentClassEnrollment.getChangedBy() : (helper.getUser() == null ? StudentClassEnrollment.SystemChange.SYSTEM.toString() : helper.getUser().getExternalId()));
                            enrl.setStudent(student);
                            enrl.setApprovedBy(approvedBy);
                            enrl.setApprovedDate(approvedDate);
                            student.getClassEnrollments().add(enrl);
                            var28_72.persist((Object)enrl);
                            helper.debug("Adding " + enrl.getClazz().getClassLabel(), r.getAction());
                        }
                        if (cd != null && cd.isWaitlist().booleanValue()) {
                            cd.setWaitlist(false);
                            var28_72.merge((Object)cd);
                            student.addWaitList((CourseOffering)co2, WaitList.WaitListType.WAIT_LIST_PORCESSING, false, helper.getUser().getExternalId(), ts, (Session)var28_72);
                        } else if (cd != null) {
                            student.addWaitList((CourseOffering)co2, WaitList.WaitListType.RE_BATCH_ON_RELOAD, false, helper.getUser().getExternalId(), ts, (Session)var28_72);
                        }
                        if (r.getRequest().isWaitlist()) {
                            r.setRequest(server.waitlist(r.getRequest(), false));
                        }
                    } else if (r.getOffering().isWaitList() && this.hasWaitListingStatus(r.getStudent(), server)) {
                        if (cd != null && !cd.isWaitlist().booleanValue()) {
                            CourseRequest courseRequest = cr = r.getCourseId() == null ? null : ((CourseDemand)cd).getCourseRequest(r.getCourseId().getCourseId());
                            if (cr != null && cr.getOrder() > 0) {
                                for (CourseRequest courseRequest2 : cd.getCourseRequests()) {
                                    if (courseRequest2.getOrder() >= cr.getOrder()) continue;
                                    courseRequest2.setOrder(courseRequest2.getOrder() + 1);
                                    var28_72.merge((Object)courseRequest2);
                                }
                                cr.setOrder(0);
                                var28_72.merge((Object)cr);
                            }
                            if (cd.isAlternative().booleanValue()) {
                                int priority = cd.getPriority();
                                for (CourseDemand courseDemand : cd.getStudent().getCourseDemands()) {
                                    if (!courseDemand.isAlternative().booleanValue() || courseDemand.getPriority() >= cd.getPriority()) continue;
                                    if (priority > courseDemand.getPriority()) {
                                        priority = courseDemand.getPriority();
                                    }
                                    courseDemand.setPriority(1 + courseDemand.getPriority());
                                    var28_72.merge((Object)courseDemand);
                                }
                                cd.setPriority(priority);
                                cd.setAlternative(false);
                            }
                            cd.setWaitlistedTimeStamp(dropTS == null ? ts : dropTS);
                            cd.setWaitlist(true);
                            cd.setWaitListSwapWithCourseOffering(null);
                            var28_72.merge((Object)cd);
                            student.addWaitList((CourseOffering)CourseOfferingDAO.getInstance().get(r.getCourseId().getCourseId(), (Session)var28_72), WaitList.WaitListType.WAIT_LIST_PORCESSING, true, helper.getUser().getExternalId(), ts, (Session)var28_72);
                        }
                        if (!r.getRequest().isWaitlist()) {
                            int n;
                            r.getRequest().setWaitListedTimeStamp(dropTS == null ? ts : dropTS);
                            r.getRequest().setWaitListSwapWithCourseOffering(null);
                            boolean otherRequestsChanged = false;
                            XStudent xs = r.getStudent();
                            XCourseId xCourseId = r.getCourseId();
                            int n2 = n = xCourseId == null ? -1 : r.getRequest().getCourseIds().indexOf(xCourseId);
                            if (n > 0) {
                                r.getRequest().getCourseIds().remove(n);
                                r.getRequest().getCourseIds().add(0, xCourseId);
                                otherRequestsChanged = true;
                            }
                            if (r.getRequest().isAlternative()) {
                                int priority = r.getRequest().getPriority();
                                for (XRequest xRequest : xs.getRequests()) {
                                    if (!xRequest.isAlternative() || xRequest.getPriority() >= cd.getPriority()) continue;
                                    if (priority > xRequest.getPriority()) {
                                        priority = xRequest.getPriority();
                                    }
                                    xRequest.setPriority(1 + xRequest.getPriority());
                                }
                                r.getRequest().setPriority(priority);
                                r.getRequest().setAlternative(false);
                                otherRequestsChanged = true;
                            }
                            if (otherRequestsChanged) {
                                r.getRequest().setWaitlist(true);
                                server.update(xs, true);
                            } else {
                                r.setRequest(server.waitlist(r.getRequest(), true));
                            }
                        }
                    } else if (r.getLastEnrollment() != null && (co = (CourseOffering)CourseOfferingDAO.getInstance().get(r.getLastEnrollment().getCourseId(), (Session)var28_72)) != null) {
                        student.addWaitList(co, WaitList.WaitListType.RE_BATCH_ON_RELOAD, false, helper.getUser().getExternalId(), ts, (Session)var28_72);
                    }
                    var28_72.merge((Object)student);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception ex) {
                    if (dropEnrollment != null) {
                        server.assign(r.getDropRequest(), dropEnrollment);
                    }
                    server.assign(r.getRequest(), r.getLastEnrollment());
                    r.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                    helper.error((r.getCourseId() == null ? newOffering.getName() : r.getCourseId().getCourseName()) + ": " + (ex.getMessage() == null ? "Unable to resection student." : ex.getMessage()), ex, r.getAction());
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                finally {
                    if (!lockStudents) {
                        var28_72.close();
                    }
                }
                EnrollStudent.updateSpace(server, r.getRequest().getEnrollment() == null ? null : SectioningRequest.convert(r.getStudent(), r.getRequest(), server, newOffering, r.getRequest().getEnrollment(), wlMode, helper), r.getLastEnrollment() == null ? null : SectioningRequest.convert(r.getOldStudent(), r.getOldRequest(), server, oldOffering, r.getLastEnrollment(), wlMode, helper), newOffering, oldOffering);
                server.persistExpectedSpaces(offeringId);
                server.execute(server.createAction(NotifyStudentAction.class).forStudent(server.getStudent(r.getRequest().getStudentId())).fromAction(this.name()).withType(StudentSectioningStatus.NotificationType.CourseChangeEnrollment).oldEnrollment(oldOffering, r.getCourseId(), r.getLastEnrollment()).dropEnrollment(dropEnrollment).rescheduling(r.getReschedulingReason()), helper.getUser());
                if (recheckOfferingIds != null && dropEnrollment != null && CheckOfferingAction.isCheckNeeded(server, helper, dropEnrollment, e != null && e.getOfferingId().equals(dropEnrollment.getOfferingId()) ? e : null)) {
                    recheckOfferingIds.add(dropEnrollment.getOfferingId());
                }
                r.getAction().setResult(e == null ? OnlineSectioningLog.Action.ResultType.NULL : OnlineSectioningLog.Action.ResultType.SUCCESS);
                r.getAction().setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
                r.getAction().setEndTime(System.currentTimeMillis());
            }
        }
    }

    protected XCourseRequest getRequest(XStudent student, XCourseId course) {
        if (student == null) {
            return null;
        }
        for (XRequest r : student.getRequests()) {
            if (!(r instanceof XCourseRequest)) continue;
            XCourseRequest cr = (XCourseRequest)r;
            for (XCourseId c : cr.getCourseIds()) {
                if (!c.equals(course)) continue;
                return cr;
            }
        }
        return null;
    }

    protected XEnrollment getEnrollment(XCourseRequest cr, Long offeringId) {
        if (cr != null && cr.getEnrollment() != null && offeringId.equals(cr.getEnrollment().getOfferingId())) {
            return cr.getEnrollment();
        }
        return null;
    }

    public SectioningRequest.ReschedulingReason check(XOffering offering, XCourseId course, Collection<XDistribution> distributions, XStudent student, XEnrollment enrollment, OnlineSectioningServer server) {
        List<XSection> sections = offering.getSections(enrollment);
        XConfig config = offering.getConfig(enrollment.getConfigId());
        if (sections.size() != config.getSubparts().size()) {
            for (XSection s1 : sections) {
                if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
                return SectioningRequest.ReschedulingReason.MULTIPLE_CONFIGS;
            }
            return sections.size() < config.getSubparts().size() ? SectioningRequest.ReschedulingReason.MISSING_CLASS : SectioningRequest.ReschedulingReason.MULTIPLE_ENRLS;
        }
        boolean ignoreBreakTime = server.getConfig().getPropertyBoolean("ReScheduling.IgnoreBreakTimeConflicts", false);
        for (XSection s1 : sections) {
            for (XSection s2 : sections) {
                if (s1.getSectionId() < s2.getSectionId() && s1.isOverlapping(distributions, s2, ignoreBreakTime)) {
                    return SectioningRequest.ReschedulingReason.TIME_CONFLICT;
                }
                if (s1.getSectionId().equals(s2.getSectionId()) || !s1.getSubpartId().equals(s2.getSubpartId())) continue;
                return SectioningRequest.ReschedulingReason.CLASS_LINK;
            }
            if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
            return SectioningRequest.ReschedulingReason.MULTIPLE_CONFIGS;
        }
        if (!offering.isAllowOverlap(student, enrollment.getConfigId(), enrollment, sections) && !server.getConfig().getPropertyBoolean("Enrollment.CanKeepTimeConflict", false)) {
            for (XRequest r : student.getRequests()) {
                XOffering other;
                XCourseRequest cr;
                if (!(r instanceof XCourseRequest) || (cr = (XCourseRequest)r).getEnrollment() == null || course.getCourseId().equals(cr.getEnrollment().getCourseId()) || (other = server.getOffering(cr.getEnrollment().getOfferingId())) == null) continue;
                List<XSection> assignment = other.getSections(cr.getEnrollment());
                if (other.isAllowOverlap(student, cr.getEnrollment().getConfigId(), cr.getEnrollment(), assignment)) continue;
                for (XSection section : sections) {
                    if (!section.isOverlapping(offering.getDistributions(), assignment, ignoreBreakTime)) continue;
                    return SectioningRequest.ReschedulingReason.TIME_CONFLICT;
                }
            }
        }
        if (!server.getConfig().getPropertyBoolean("Enrollment.CanKeepCancelledClass", false)) {
            for (XSection section : sections) {
                if (!section.isCancelled()) continue;
                return SectioningRequest.ReschedulingReason.CLASS_CANCELLED;
            }
        }
        return null;
    }

    public static boolean sameRooms(XSection s, List<XRoom> rooms) {
        if (s.getRooms() == null && rooms == null) {
            return true;
        }
        if (s.getRooms() == null || rooms == null) {
            return false;
        }
        return s.getRooms().size() == rooms.size() && s.getRooms().containsAll(rooms);
    }

    public static boolean sameTime(XSection s, XTime t) {
        if (s.getTime() == null && t == null) {
            return true;
        }
        if (s.getTime() == null || t == null) {
            return false;
        }
        return s.getTime().getSlot() == t.getSlot() && s.getTime().getLength() == t.getLength() && s.getTime().getDays() == t.getDays() && ToolBox.equals((Object)s.getTime().getDatePatternName(), (Object)t.getDatePatternName());
    }

    public static boolean sameName(Long courseId, XSection s1, XSection s2) {
        return s1.getName(courseId).equals(s2.getName(courseId));
    }

    public static boolean isVerySame(Long courseId, List<XSection> e1, List<XSection> e2) {
        if (e1.size() != e2.size()) {
            return false;
        }
        block0: for (XSection s1 : e1) {
            for (XSection s2 : e2) {
                if (!ReloadOfferingAction.sameName(courseId, s1, s2) || !ReloadOfferingAction.sameTime(s1, s2.getTime()) || !ReloadOfferingAction.sameRooms(s1, s2.getRooms())) continue;
                if (!s1.isCancelled() || s2.isCancelled()) continue block0;
                break;
            }
            return false;
        }
        return true;
    }

    @Override
    public String name() {
        return "reload-offering";
    }

    protected void checkForInstructorChanges(XOffering oldOffering, XOffering newOffering, OnlineSectioningServer server, final OnlineSectioningHelper helper) {
        InstructorEmail.InstructorChange ip;
        if (!ApplicationProperty.NotificationsInstructorChanges.isTrue()) {
            return;
        }
        if (ApplicationProperty.NotificationsInstructorChangesCheckDates.isTrue() && !NotifyStudentAction.checkNotificationDates(server.getAcademicSession())) {
            return;
        }
        HashMap<String, InstructorEmail.InstructorChange> instructors = new HashMap<String, InstructorEmail.InstructorChange>();
        if (oldOffering != null) {
            for (XConfig config : oldOffering.getConfigs()) {
                for (XSubpart subpart : config.getSubparts()) {
                    for (XSection section : subpart.getSections()) {
                        for (XInstructor instructor : section.getAllInstructors()) {
                            if (instructor.getExternalId() == null || instructor.getExternalId().isEmpty()) continue;
                            ip = (InstructorEmail.InstructorChange)instructors.get(instructor.getExternalId());
                            if (ip == null) {
                                ip = new InstructorEmail.InstructorChange();
                                instructors.put(instructor.getExternalId(), ip);
                            }
                            ip.setOldOffering(oldOffering);
                            ip.setOldInstructor(instructor);
                            ip.addOldSection(section);
                        }
                    }
                }
            }
        }
        if (newOffering != null) {
            for (XConfig config : newOffering.getConfigs()) {
                for (XSubpart subpart : config.getSubparts()) {
                    for (XSection section : subpart.getSections()) {
                        for (XInstructor instructor : section.getAllInstructors()) {
                            if (instructor.getExternalId() == null || instructor.getExternalId().isEmpty()) continue;
                            ip = (InstructorEmail.InstructorChange)instructors.get(instructor.getExternalId());
                            if (ip == null) {
                                ip = new InstructorEmail.InstructorChange();
                                instructors.put(instructor.getExternalId(), ip);
                            }
                            ip.setNewOffering(newOffering);
                            ip.setNewInstructor(instructor);
                            ip.addNewSection(section);
                        }
                    }
                }
            }
        }
        boolean checkTime = ApplicationProperty.NotificationsInstructorChangesCheckTime.isTrue();
        boolean checkRoom = ApplicationProperty.NotificationsInstructorChangesCheckRoom.isTrue();
        boolean checkAssignment = ApplicationProperty.NotificationsInstructorChangesCheckAssignment.isTrue();
        boolean checkCancellations = ApplicationProperty.NotificationsInstructorChangesCheckCancellations.isTrue();
        boolean checkShare = ApplicationProperty.NotificationsInstructorChangesCheckShare.isTrue();
        for (InstructorEmail.InstructorChange ic : instructors.values()) {
            if (!ic.hasEmail() || !ic.hasChange(checkTime, checkRoom, checkAssignment, checkCancellations, checkShare)) continue;
            server.execute(server.createAction(InstructorEmail.class).forChange(ic), helper.getUser(), new OnlineSectioningServer.ServerCallback<Boolean>(){

                @Override
                public void onFailure(Throwable exception) {
                    helper.error("Instructor email failed: " + exception.getMessage(), exception);
                }

                @Override
                public void onSuccess(Boolean result) {
                }
            });
        }
    }

    protected static class StudentPair {
        XStudent iOldStudent;
        XStudent iNewStudent;

        StudentPair(XStudent oldStudent, XStudent newStudent) {
            this.iOldStudent = oldStudent;
            this.iNewStudent = newStudent;
        }

        public XStudent getNewStudent() {
            return this.iNewStudent;
        }

        public boolean hasNewStudent() {
            return this.iNewStudent != null;
        }

        public XStudent getOldStudent() {
            return this.iOldStudent;
        }

        public boolean hasOldStudent() {
            return this.iOldStudent != null;
        }
    }
}

