/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.util.Collection;
import java.util.List;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.AdvisorCourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.PurdueCourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.SimplifiedCourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;

public class TwoPhaseCourseRequestValidationProvider
implements CourseRequestsValidationProvider,
AdvisorCourseRequestsValidationProvider {
    SimplifiedCourseRequestsValidationProvider iSimplifiedValidation = new SimplifiedCourseRequestsValidationProvider();
    PurdueCourseRequestsValidationProvider iFullValidation = new PurdueCourseRequestsValidationProvider();

    public boolean isFullValidation(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        String mode = ApplicationProperties.getProperty("purdue.specreg.courseReqValMode", "assistant");
        if ("simplified".equals(mode) || "simple".equals(mode)) {
            return false;
        }
        if ("full".equals(mode)) {
            return true;
        }
        if ("assistant".equals(mode)) {
            return server != null && !(server instanceof DatabaseServer);
        }
        if ("online".equals(mode)) {
            return server != null && server.getAcademicSession().isSectioningEnabled();
        }
        if ("published".equals(mode)) {
            if (server == null || server.getAcademicSession() == null) {
                return false;
            }
            Session session = (Session)SessionDAO.getInstance().get(server.getAcademicSession().getUniqueId(), helper.getHibSession());
            return session != null && session.canNoRoleReportClass();
        }
        return server != null && !(server instanceof DatabaseServer);
    }

    public CourseRequestsValidationProvider getCRVP(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.isFullValidation(server, helper)) {
            return this.iFullValidation;
        }
        return this.iSimplifiedValidation;
    }

    public AdvisorCourseRequestsValidationProvider getACRVP(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.isFullValidation(server, helper)) {
            return this.iFullValidation;
        }
        return this.iSimplifiedValidation;
    }

    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, Student student) throws SectioningException {
        this.getCRVP(server, helper).checkEligibility(server, helper, check, student);
    }

    @Override
    public void check(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        this.getCRVP(server, helper).check(server, helper, request);
    }

    @Override
    public boolean updateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        return this.getCRVP(server, helper).updateStudent(server, helper, student, action);
    }

    @Override
    public boolean revalidateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        return this.getCRVP(server, helper).revalidateStudent(server, helper, student, action);
    }

    @Override
    public void validate(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        this.getCRVP(server, helper).validate(server, helper, request, response);
    }

    @Override
    public void submit(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        this.getCRVP(server, helper).submit(server, helper, request);
    }

    @Override
    public Collection<Long> updateStudents(OnlineSectioningServer server, OnlineSectioningHelper helper, List<Student> students) throws SectioningException {
        return this.getCRVP(server, helper).updateStudents(server, helper, students);
    }

    @Override
    public void validateAdvisorRecommendations(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.AdvisingStudentDetails request, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        this.getACRVP(server, helper).validateAdvisorRecommendations(server, helper, request, response);
    }

    @Override
    public void dispose() {
        this.iFullValidation.dispose();
        this.iSimplifiedValidation.dispose();
    }
}

