/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom;

import java.util.ArrayList;
import java.util.Collection;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class RequestStudentUpdates
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    Collection<Long> iStudentIds = null;

    public RequestStudentUpdates forStudents(Collection<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!CustomStudentEnrollmentHolder.isCanRequestUpdates()) {
            throw new SectioningException(MSG.exceptionRequestStudentUpdateNotAllowed());
        }
        ArrayList<XStudent> students = new ArrayList<XStudent>();
        for (Long studentId : this.iStudentIds) {
            XStudent student = server.getStudent(studentId);
            if (student == null) continue;
            OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession());
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName()));
            students.add(student);
        }
        return CustomStudentEnrollmentHolder.getProvider().requestUpdate(server, helper, students);
    }

    @Override
    public String name() {
        return "request-update";
    }
}

