/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;

@MappedSuperclass
public abstract class BaseRoomGroupPref
extends Preference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iRoomIndex;
    private RoomGroup iRoomGroup;

    public BaseRoomGroupPref() {
    }

    public BaseRoomGroupPref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="room_idx", nullable=true)
    public Integer getRoomIndex() {
        return this.iRoomIndex;
    }

    public void setRoomIndex(Integer roomIndex) {
        this.iRoomIndex = roomIndex;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="room_group_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public RoomGroup getRoomGroup() {
        return this.iRoomGroup;
    }

    public void setRoomGroup(RoomGroup roomGroup) {
        this.iRoomGroup = roomGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomGroupPref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RoomGroupPref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RoomGroupPref)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "RoomGroupPref[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "RoomGroupPref[\n\tNote: " + this.getNote() + "\n\tOwner: " + String.valueOf(this.getOwner()) + "\n\tPrefLevel: " + String.valueOf(this.getPrefLevel()) + "\n\tRoomGroup: " + String.valueOf(this.getRoomGroup()) + "\n\tRoomIndex: " + this.getRoomIndex() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

