/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ExamLocationPref;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;

@MappedSuperclass
public abstract class BaseExamLocationPref
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Location iLocation;
    private PreferenceLevel iPrefLevel;
    private ExamPeriod iExamPeriod;

    public BaseExamLocationPref() {
    }

    public BaseExamLocationPref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="location_id", nullable=false)
    public Location getLocation() {
        return this.iLocation;
    }

    public void setLocation(Location location) {
        this.iLocation = location;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pref_level_id", nullable=false)
    public PreferenceLevel getPrefLevel() {
        return this.iPrefLevel;
    }

    public void setPrefLevel(PreferenceLevel prefLevel) {
        this.iPrefLevel = prefLevel;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="period_id", nullable=false)
    public ExamPeriod getExamPeriod() {
        return this.iExamPeriod;
    }

    public void setExamPeriod(ExamPeriod examPeriod) {
        this.iExamPeriod = examPeriod;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamLocationPref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExamLocationPref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExamLocationPref)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ExamLocationPref[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ExamLocationPref[\n\tExamPeriod: " + String.valueOf(this.getExamPeriod()) + "\n\tLocation: " + String.valueOf(this.getLocation()) + "\n\tPrefLevel: " + String.valueOf(this.getPrefLevel()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

