/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.constraint.ConfigLimit;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.reservation.Reservation;

public class SectionLimit
extends GlobalConstraint<Request, Enrollment> {
    private static double sNominalWeight = 1.0E-5;
    private boolean iPreferDummyStudents = false;
    private boolean iPreferPriorityStudents = true;

    public SectionLimit(DataProperties cfg) {
        this.iPreferDummyStudents = cfg.getPropertyBoolean("SectionLimit.PreferDummyStudents", false);
        this.iPreferPriorityStudents = cfg.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection.AllIn", true);
    }

    public static double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        return section.getEnrollmentWeight(assignment, request) + request.getWeight() - Math.max(section.getMaxEnrollmentWeight(assignment), request.getWeight()) + sNominalWeight;
    }

    public static double getUnreservedSpace(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        return section.getUnreservedSpace(assignment, request) - request.getWeight() + Math.max(section.getMaxEnrollmentWeight(assignment), request.getWeight()) - sNominalWeight;
    }

    private boolean hasSectionReservation(Enrollment enrollment, Section section) {
        Reservation reservation = enrollment.getReservation();
        if (reservation == null) {
            return false;
        }
        Set<Section> sections = reservation.getSections(section.getSubpart());
        return sections != null && sections.contains(section);
    }

    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return;
        }
        if (!enrollment.isCourseRequest()) {
            return;
        }
        for (Section section : enrollment.getSections()) {
            double enrlWeight;
            Object conflict;
            ArrayList<Enrollment> adepts;
            if (enrollment.getConfig().getOffering().hasReservations() && !this.hasSectionReservation(enrollment, section)) {
                if (section.getTotalUnreservedSpace() < enrollment.getRequest().getWeight()) {
                    conflicts.add(enrollment);
                    return;
                }
                double unreserved = SectionLimit.getUnreservedSpace(assignment, section, enrollment.getRequest());
                if (unreserved < 0.0) {
                    adepts = new ArrayList(section.getEnrollments(assignment).size());
                    for (Enrollment e : section.getEnrollments(assignment)) {
                        if (e.getRequest().equals(enrollment.getRequest()) || e.getReservation() != null && e.getReservation().canBatchAssignOverLimit() || this.hasSectionReservation(e, section)) continue;
                        if (conflicts.contains(e)) {
                            unreserved += e.getRequest().getWeight();
                            continue;
                        }
                        adepts.add(e);
                    }
                    while (unreserved < 0.0) {
                        if (adepts.isEmpty()) {
                            conflicts.add(enrollment);
                            return;
                        }
                        conflict = new ConfigLimit.Adepts(this.iPreferDummyStudents, this.iPreferPriorityStudents, adepts, assignment).get();
                        adepts.remove(conflict);
                        unreserved += ((Enrollment)conflict).getRequest().getWeight();
                        conflicts.add((Enrollment)conflict);
                    }
                }
            }
            if (section.getLimit() < 0 || (enrlWeight = SectionLimit.getEnrollmentWeight(assignment, section, enrollment.getRequest())) <= (double)section.getLimit()) continue;
            adepts = new ArrayList<Enrollment>(section.getEnrollments(assignment).size());
            for (Enrollment e : section.getEnrollments(assignment)) {
                if (e.getRequest().equals(enrollment.getRequest())) continue;
                if (conflicts.contains(e)) {
                    enrlWeight -= e.getRequest().getWeight();
                    continue;
                }
                adepts.add(e);
            }
            while (enrlWeight > (double)section.getLimit()) {
                if (adepts.isEmpty()) {
                    conflicts.add(enrollment);
                    return;
                }
                conflict = new ConfigLimit.Adepts(this.iPreferDummyStudents, this.iPreferPriorityStudents, adepts, assignment).get();
                adepts.remove(conflict);
                enrlWeight -= ((Enrollment)conflict).getRequest().getWeight();
                conflicts.add((Enrollment)conflict);
            }
        }
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return false;
        }
        if (!enrollment.isCourseRequest()) {
            return false;
        }
        for (Section section : enrollment.getSections()) {
            double enrlWeight;
            if (enrollment.getConfig().getOffering().hasReservations() && !this.hasSectionReservation(enrollment, section) && (section.getTotalUnreservedSpace() < enrollment.getRequest().getWeight() || SectionLimit.getUnreservedSpace(assignment, section, enrollment.getRequest()) < 0.0)) {
                return true;
            }
            if (section.getLimit() < 0 || !((enrlWeight = SectionLimit.getEnrollmentWeight(assignment, section, enrollment.getRequest())) > (double)section.getLimit())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "SectionLimit";
    }
}

