/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import biweekly.util.VersionNumber;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Version
extends ICalProperty {
    public static final VersionNumber VCAL = new VersionNumber(ICalVersion.V1_0.getVersion());
    public static final VersionNumber ICAL = new VersionNumber(ICalVersion.V2_0.getVersion());
    private VersionNumber minVersion;
    private VersionNumber maxVersion;

    public Version(ICalVersion version) {
        this(version == null ? null : version.getVersion());
    }

    public Version(String version) {
        this(null, version);
    }

    public Version(String minVersion, String maxVersion) {
        this(minVersion == null ? null : new VersionNumber(minVersion), maxVersion == null ? null : new VersionNumber(maxVersion));
    }

    private Version(VersionNumber minVersion, VersionNumber maxVersion) {
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public Version(Version original) {
        super(original);
        this.minVersion = original.minVersion;
        this.maxVersion = original.maxVersion;
    }

    public static Version v1_0() {
        return new Version(ICalVersion.V1_0);
    }

    public static Version v2_0() {
        return new Version(ICalVersion.V2_0);
    }

    public boolean isV1_0() {
        return VCAL.equals(this.maxVersion);
    }

    public boolean isV2_0() {
        return ICAL.equals(this.maxVersion);
    }

    public VersionNumber getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(VersionNumber minVersion) {
        this.minVersion = minVersion;
    }

    public VersionNumber getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(VersionNumber maxVersion) {
        this.maxVersion = maxVersion;
    }

    public ICalVersion toICalVersion() {
        if (this.minVersion == null && this.maxVersion != null) {
            return ICalVersion.get(this.maxVersion.toString());
        }
        return null;
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (this.maxVersion == null) {
            warnings.add(new ValidationWarning(35, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("minVersion", this.minVersion);
        values.put("maxVersion", this.maxVersion);
        return values;
    }

    @Override
    public Version copy() {
        return new Version(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.maxVersion == null ? 0 : this.maxVersion.hashCode());
        result = 31 * result + (this.minVersion == null ? 0 : this.minVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Version other = (Version)obj;
        if (this.maxVersion == null ? other.maxVersion != null : !this.maxVersion.equals(other.maxVersion)) {
            return false;
        }
        return !(this.minVersion == null ? other.minVersion != null : !this.minVersion.equals(other.minVersion));
    }
}

