/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.codegen.server;

import com.google.gwt.codegen.server.StringGenerator;

class PlainStringGenerator
extends StringGenerator {
    private boolean firstExpression = true;

    PlainStringGenerator(StringBuilder buf) {
        super(buf);
    }

    @Override
    protected void afterExpression(StringGenerator.Type type) {
        this.firstExpression = false;
    }

    @Override
    protected void beforeExpression(StringGenerator.Type type) {
        if (this.firstExpression) {
            if (type == StringGenerator.Type.PRIMITIVE) {
                this.buf.append("\"\" + ");
            }
        } else {
            this.buf.append(" + ");
        }
    }

    @Override
    protected void finishOutput() {
        if (this.firstExpression) {
            this.buf.append("\"\"");
        }
    }

    @Override
    protected void forceStringPrefix() {
        if (this.firstExpression) {
            this.buf.append("\"\" + ");
        }
    }

    @Override
    protected void forceStringSuffix() {
    }
}

