/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.MapTileCache;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;

public class StaticMapServlet
extends HttpServlet {
    protected static Log sLog = LogFactory.getLog(StaticMapServlet.class);
    private static final long serialVersionUID = 1L;
    private static int sTileSize = 256;

    protected SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized BufferedImage fetchTile(int zoom, int x, int y, HttpServletRequest request) throws MalformedURLException, IOException {
        byte[] cached = MapTileCache.get(zoom, x, y);
        if (cached == null) {
            Object referer = ApplicationProperty.UniTimeUrl.value();
            if (referer == null) {
                referer = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getRequestURI().substring(0, request.getRequestURI().lastIndexOf(47));
            }
            String agent = request.getHeader("User-Agent");
            String tileURL = ApplicationProperty.RoomUseLeafletMapTiles.value().replace("{s}", String.valueOf((char)(97 + ToolBox.random((int)3)))).replace("{z}", String.valueOf(zoom)).replace("{x}", String.valueOf(x)).replace("{y}", String.valueOf(y));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (InputStream in = null;){
                int n;
                URLConnection con = new URL(tileURL).openConnection();
                if (referer != null) {
                    con.setRequestProperty("REFERER", (String)referer);
                }
                if (agent != null) {
                    con.setRequestProperty("User-Agent", agent);
                }
                in = con.getInputStream();
                byte[] byteChunk = new byte[4096];
                while ((n = in.read(byteChunk)) > 0) {
                    out.write(byteChunk, 0, n);
                }
            }
            cached = out.toByteArray();
            MapTileCache.put(zoom, x, y, cached);
        }
        return ImageIO.read(new ByteArrayInputStream(cached));
    }

    protected double lonToTile(double lon, int zoom) {
        return (lon + 180.0) / 360.0 * Math.pow(2.0, zoom);
    }

    protected double latToTile(double lat, int zoom) {
        return (1.0 - Math.log(Math.tan(lat * Math.PI / 180.0) + 1.0 / Math.cos(lat * Math.PI / 180.0)) / Math.PI) / 2.0 * Math.pow(2.0, zoom);
    }

    protected BufferedImage createBaseMap(int width, int height, double lat, double lon, int zoom, HttpServletRequest request) throws MalformedURLException, IOException {
        double centerX = this.lonToTile(lon, zoom);
        double centerY = this.latToTile(lat, zoom);
        int startX = (int)Math.floor(centerX - (double)width / 2.0 / (double)sTileSize);
        int startY = (int)Math.floor(centerY - (double)height / 2.0 / (double)sTileSize);
        int endX = (int)Math.ceil(centerX + (double)width / 2.0 / (double)sTileSize);
        int endY = (int)Math.ceil(centerY + (double)height / 2.0 / (double)sTileSize);
        double offsetX = -Math.floor((centerX - Math.floor(centerX)) * (double)sTileSize);
        double offsetY = -Math.floor((centerY - Math.floor(centerY)) * (double)sTileSize);
        offsetX += Math.floor((double)width / 2.0);
        offsetY += Math.floor((double)height / 2.0);
        offsetX += Math.floor((double)startX - Math.floor(centerX)) * (double)sTileSize;
        offsetY += Math.floor((double)startY - Math.floor(centerY)) * (double)sTileSize;
        BufferedImage result = new BufferedImage(width, height, 1);
        Graphics g = result.getGraphics();
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                BufferedImage tile = this.fetchTile(zoom, x, y, request);
                if (tile == null) continue;
                int destX = (x - startX) * sTileSize + (int)offsetX;
                int destY = (y - startY) * sTileSize + (int)offsetY;
                g.drawImage(tile, destX, destY, null);
            }
        }
        BufferedImage shadow = ImageIO.read(StaticMapServlet.class.getClassLoader().getResourceAsStream("org/unitime/timetable/server/resources/marker-shadow.png"));
        g.drawImage(shadow, width / 2 - 12, height / 2 - 41, null);
        BufferedImage marker = ImageIO.read(StaticMapServlet.class.getClassLoader().getResourceAsStream("org/unitime/timetable/server/resources/marker.png"));
        g.drawImage(marker, width / 2 - 12, height / 2 - 41, null);
        return result;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String tile = request.getParameter("tile");
        if (tile != null) {
            String[] params = tile.split(",");
            BufferedImage image = this.fetchTile(Integer.valueOf(params[0]), Integer.valueOf(params[1]), Integer.valueOf(params[2]), request);
            if (image == null) {
                response.sendError(500, "Failed to fetch a tile, please check the logs for more details.");
                return;
            }
            response.setContentType("image/png");
            response.setDateHeader("Date", System.currentTimeMillis());
            response.setDateHeader("Expires", System.currentTimeMillis() + 604800000L);
            response.setHeader("Cache-control", "public, max-age=604800");
            ImageIO.write((RenderedImage)image, "PNG", (OutputStream)response.getOutputStream());
            return;
        }
        String center = request.getParameter("center");
        int zoom = Integer.parseInt(request.getParameter("zoom"));
        String size = request.getParameter("size");
        double lat = Double.parseDouble(center.split(",")[0]);
        double lon = Double.parseDouble(center.split(",")[1]);
        int width = Integer.parseInt(size.split("[,x]")[0]);
        int height = Integer.parseInt(size.split("[,x]")[1]);
        BufferedImage image = this.createBaseMap(width, height, lat, lon, zoom, request);
        response.setContentType("image/png");
        response.setDateHeader("Date", System.currentTimeMillis());
        response.setDateHeader("Expires", System.currentTimeMillis() + 604800000L);
        response.setHeader("Cache-control", "public, max-age=604800");
        ImageIO.write((RenderedImage)image, "PNG", (OutputStream)response.getOutputStream());
    }
}

