/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.SolverInfoDef;
import org.unitime.timetable.model.dao.SolverInfoDefDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=solverInfoDef]")
public class SolverInfoDefs
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageSolverInfoDef(), MESSAGES.pageSolverInfoDefs());
    }

    @Override
    @PreAuthorize(value="checkPermission('SolutionInformationDefinitions')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 300, 100, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 1000, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldImplementation(), SimpleEditInterface.FieldType.text, 300, 250, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(0);
        for (SolverInfoDef def : SolverInfoDefDAO.getInstance().findAll()) {
            boolean implementationExist = false;
            try {
                if (def.getImplementation() != null && def.getImplementation().startsWith("org.unitime.timetable.solver.ui.") && Class.forName(def.getImplementation()) != null) {
                    implementationExist = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            SimpleEditInterface.Record r = data.addRecord(def.getUniqueId());
            r.setField(0, def.getName(), !implementationExist);
            r.setField(1, def.getDescription());
            r.setField(2, def.getImplementation(), !implementationExist);
            r.setDeletable(!implementationExist);
        }
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('SolutionInformationDefinitions')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (SolverInfoDef def : SolverInfoDefDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(def.getUniqueId());
            if (r == null) {
                this.delete(def, context, hibSession);
                continue;
            }
            this.update(def, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('SolutionInformationDefinitions')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        SolverInfoDef def = new SolverInfoDef();
        def.setName(record.getField(0));
        def.setDescription(record.getField(1));
        def.setImplementation(record.getField(2));
        hibSession.persist((Object)def);
        record.setUniqueId(def.getUniqueId());
        ChangeLog.addChange(hibSession, context, def, def.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(SolverInfoDef def, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (def == null) {
            return;
        }
        if (ToolBox.equals((Object)def.getName(), (Object)record.getField(0)) && ToolBox.equals((Object)def.getDescription(), (Object)record.getField(1)) && ToolBox.equals((Object)def.getImplementation(), (Object)record.getField(2))) {
            return;
        }
        def.setName(record.getField(0));
        def.setDescription(record.getField(1));
        def.setImplementation(record.getField(2));
        hibSession.merge((Object)def);
        ChangeLog.addChange(hibSession, context, def, def.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('SolutionInformationDefinitions')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((SolverInfoDef)SolverInfoDefDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(SolverInfoDef def, SessionContext context, Session hibSession) {
        if (def == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, def, def.getName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)def);
    }

    @Override
    @PreAuthorize(value="checkPermission('SolutionInformationDefinitions')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((SolverInfoDef)SolverInfoDefDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

