/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.unitime.timetable.gwt.client.admin.AdminCookie;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class BuildingsTable
extends UniTimeTable<RoomInterface.BuildingInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private RoomInterface.BuildingsColumn iSortBy = null;
    private boolean iAsc = true;

    public BuildingsTable() {
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final RoomInterface.BuildingsColumn col : RoomInterface.BuildingsColumn.values()) {
            final UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(col));
            if (BuildingComparator.isApplicable(col)) {
                RoomsTable.SortOperation op = new RoomsTable.SortOperation(){

                    public void execute() {
                        BuildingsTable.this.doSort(col);
                    }

                    @Override
                    public boolean isApplicable() {
                        return BuildingsTable.this.getRowCount() > 1 && h.isVisible();
                    }

                    @Override
                    public boolean hasSeparator() {
                        return false;
                    }

                    @Override
                    public String getName() {
                        return MESSAGES.opSortBy(this.getColumnName());
                    }

                    @Override
                    public String getColumnName() {
                        return h.getHTML().replace("<br>", " ");
                    }
                };
                h.addOperation(op);
            }
            header.add(h);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(AdminCookie.getInstance().getSortBuildingsBy());
    }

    public String getColumnName(RoomInterface.BuildingsColumn column) {
        switch (column) {
            case ABBREVIATION: {
                return MESSAGES.colAbbreviation();
            }
            case EXTERNAL_ID: {
                return MESSAGES.colExternalId();
            }
            case NAME: {
                return MESSAGES.colName();
            }
            case COORDINATES: {
                return MESSAGES.colCoordinates();
            }
        }
        return column.name();
    }

    public Widget getColumnWidget(RoomInterface.BuildingsColumn column, RoomInterface.BuildingInterface building) {
        switch (column) {
            case ABBREVIATION: {
                return new Label(building.getAbbreviation() == null ? "" : building.getAbbreviation());
            }
            case EXTERNAL_ID: {
                return new Label(building.getExternalId() == null ? "" : building.getExternalId());
            }
            case NAME: {
                return new Label(building.getName() == null ? "" : building.getName());
            }
            case COORDINATES: {
                if (!building.hasCoordinates()) {
                    return new Label();
                }
                return new Label(MESSAGES.coordinates(building.getX(), building.getY()));
            }
        }
        return null;
    }

    protected void addRow(RoomInterface.BuildingInterface building) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        for (RoomInterface.BuildingsColumn col : RoomInterface.BuildingsColumn.values()) {
            line.add(this.getColumnWidget(col, building));
        }
        this.addRow(building, line);
    }

    public void setData(List<RoomInterface.BuildingInterface> buildings) {
        this.clearTable(1);
        if (buildings != null) {
            for (RoomInterface.BuildingInterface building : buildings) {
                this.addRow(building);
            }
        }
        this.sort();
    }

    protected void doSort(RoomInterface.BuildingsColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        AdminCookie.getInstance().setSortBuildingsBy(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = RoomInterface.BuildingsColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = RoomInterface.BuildingsColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        UniTimeTableHeader header = this.getHeader(this.iSortBy.ordinal());
        this.sort(header, new BuildingComparator(this.iSortBy, true), this.iAsc);
    }

    public static class BuildingComparator
    implements Comparator<RoomInterface.BuildingInterface> {
        private RoomInterface.BuildingsColumn iColumn;
        private boolean iAsc;

        public BuildingComparator(RoomInterface.BuildingsColumn column, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
        }

        public int compareById(RoomInterface.BuildingInterface r1, RoomInterface.BuildingInterface r2) {
            return this.compare(r1.getId(), r2.getId());
        }

        public int compareByName(RoomInterface.BuildingInterface r1, RoomInterface.BuildingInterface r2) {
            return this.compare(r1.getName(), r2.getName());
        }

        public int compareByAbbreviation(RoomInterface.BuildingInterface r1, RoomInterface.BuildingInterface r2) {
            return this.compare(r1.getAbbreviation(), r2.getAbbreviation());
        }

        public int compareByExternalId(RoomInterface.BuildingInterface r1, RoomInterface.BuildingInterface r2) {
            return this.compare(r1.getExternalId(), r2.getExternalId());
        }

        protected int compareByColumn(RoomInterface.BuildingInterface r1, RoomInterface.BuildingInterface r2) {
            switch (this.iColumn) {
                case NAME: {
                    return this.compareByName(r1, r2);
                }
                case ABBREVIATION: {
                    return this.compareByAbbreviation(r1, r2);
                }
                case EXTERNAL_ID: {
                    return this.compareByExternalId(r1, r2);
                }
            }
            return this.compareByAbbreviation(r1, r2);
        }

        public static boolean isApplicable(RoomInterface.BuildingsColumn column) {
            switch (column) {
                case ABBREVIATION: 
                case EXTERNAL_ID: 
                case NAME: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(RoomInterface.BuildingInterface r1, RoomInterface.BuildingInterface r2) {
            int cmp = this.compareByColumn(r1, r2);
            if (cmp == 0) {
                cmp = this.compareByAbbreviation(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareById(r1, r2);
            }
            return this.iAsc ? cmp : -cmp;
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }
    }
}

