/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.instructor.AttributesCell;
import org.unitime.timetable.gwt.client.instructor.InstructorAvailabilityWidget;
import org.unitime.timetable.gwt.client.instructor.InstructorExternalIdCell;
import org.unitime.timetable.gwt.client.instructor.InstructorNameCell;
import org.unitime.timetable.gwt.client.instructor.ObjectivesCell;
import org.unitime.timetable.gwt.client.instructor.PreferenceCell;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class InstructorDetails
extends SimpleForm
implements HasValue<Integer> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final StudentSectioningMessages SECTMSG = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static NumberFormat sTeachingLoadFormat = NumberFormat.getFormat((String)CONSTANTS.teachingLoadFormat());
    protected InstructorInterface.TeachingRequestsPagePropertiesResponse iProperties;
    private InstructorExternalIdCell iExternalId;
    private InstructorNameCell iName;
    private Label iAssignedLoad;
    private AttributesCell iAttributes;
    private PreferenceCell iCoursePrefs;
    private PreferenceCell iDistPrefs;
    private InstructorAvailabilityWidget iTimePrefs;
    private ObjectivesCell iObjectives;
    private UniTimeTable<InstructorInterface.ClassInfo> iEnrollmentsTable;
    private UniTimeTable<InstructorInterface.TeachingRequestInfo> iRequestsTable;
    private int iAttributesRow;
    private int iCoursePrefsRow;
    private int iEnrollmentsRow;
    private int iDistPrefsRow;
    private int iRequestsRow;
    private int iObjectivesRow;

    public InstructorDetails(InstructorInterface.TeachingRequestsPagePropertiesResponse properties) {
        this.iProperties = properties;
        this.removeStyleName("unitime-NotPrintableBottomLine");
        this.addHeaderRow(MESSAGES.headerInstructor());
        this.iExternalId = new InstructorExternalIdCell(properties);
        this.addRow(MESSAGES.propExternalId(), (Widget)this.iExternalId);
        this.iName = new InstructorNameCell(properties);
        this.addRow(MESSAGES.propInstructorName(), (Widget)this.iName);
        this.iAssignedLoad = new Label();
        this.addRow(MESSAGES.propAssignedLoad(), (Widget)this.iAssignedLoad);
        this.iAttributes = new AttributesCell();
        this.iAttributesRow = this.addRow(MESSAGES.propInstructorAttributes(), (Widget)this.iAttributes);
        this.iCoursePrefs = new PreferenceCell(properties);
        this.iCoursePrefsRow = this.addRow(MESSAGES.propCoursePreferences(), (Widget)this.iCoursePrefs);
        this.iTimePrefs = new InstructorAvailabilityWidget();
        this.addRow(MESSAGES.propTimePreferences(), (Widget)this.iTimePrefs);
        this.iEnrollmentsTable = new UniTimeTable();
        this.iEnrollmentsTable.addStyleName("enrollments");
        ArrayList<UniTimeTableHeader> enrlHeader = new ArrayList<UniTimeTableHeader>();
        enrlHeader.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        enrlHeader.add(new UniTimeTableHeader(MESSAGES.colSection()));
        enrlHeader.add(new UniTimeTableHeader(MESSAGES.colTime()));
        enrlHeader.add(new UniTimeTableHeader(MESSAGES.colDate()));
        enrlHeader.add(new UniTimeTableHeader(MESSAGES.colRoom()));
        enrlHeader.add(new UniTimeTableHeader(MESSAGES.colRole()));
        this.iEnrollmentsTable.addRow(null, enrlHeader);
        this.iEnrollmentsRow = this.addRow(MESSAGES.propEnrollments(), (Widget)this.iEnrollmentsTable);
        this.iDistPrefs = new PreferenceCell(properties);
        this.iDistPrefsRow = this.addRow(MESSAGES.propDistributionPreferences(), (Widget)this.iDistPrefs);
        this.iRequestsTable = new UniTimeTable();
        this.iRequestsTable.addStyleName("assignments");
        ArrayList<UniTimeTableHeader> reqHeader = new ArrayList<UniTimeTableHeader>();
        reqHeader.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        reqHeader.add(new UniTimeTableHeader(MESSAGES.colSection()));
        reqHeader.add(new UniTimeTableHeader(MESSAGES.colTime()));
        reqHeader.add(new UniTimeTableHeader(MESSAGES.colDate()));
        reqHeader.add(new UniTimeTableHeader(MESSAGES.colRoom()));
        reqHeader.add(new UniTimeTableHeader(MESSAGES.colTeachingLoad()));
        reqHeader.add(new UniTimeTableHeader(MESSAGES.colAttributePreferences()));
        reqHeader.add(new UniTimeTableHeader(MESSAGES.colInstructorPreferences()));
        reqHeader.add(new UniTimeTableHeader(MESSAGES.colObjectives()));
        this.iRequestsTable.addRow(null, reqHeader);
        this.iRequestsRow = this.addRow(MESSAGES.propAssignments(), (Widget)this.iRequestsTable);
        this.iObjectives = new ObjectivesCell(properties);
        this.iObjectivesRow = this.addRow(MESSAGES.propObjectives(), (Widget)this.iObjectives);
        this.iRequestsTable.setAllowSelection(true);
        this.iRequestsTable.setAllowMultiSelect(false);
        this.iRequestsTable.addMouseClickListener(new UniTimeTable.MouseClickListener<InstructorInterface.TeachingRequestInfo>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<InstructorInterface.TeachingRequestInfo> event) {
                if (event.getRow() > 0) {
                    InstructorDetails.this.iRequestsTable.setSelected(event.getRow(), true);
                    ValueChangeEvent.fire((HasValueChangeHandlers)InstructorDetails.this, (Object)(event.getRow() - 1));
                }
            }
        });
    }

    public void setInstructor(InstructorInterface.InstructorInfo instructor) {
        ArrayList<Object> line;
        this.iExternalId.setValue(instructor);
        this.iName.setValue(instructor);
        this.iAssignedLoad.setText(sTeachingLoadFormat.format((double)instructor.getAssignedLoad()) + " / " + sTeachingLoadFormat.format((double)instructor.getMaxLoad()));
        this.iAttributes.clear();
        if (instructor.getAttributes().isEmpty()) {
            this.getRowFormatter().setVisible(this.iAttributesRow, false);
        } else {
            this.iAttributes.setValue(instructor.getAttributes());
            this.getRowFormatter().setVisible(this.iAttributesRow, true);
        }
        if (instructor.getCoursePreferences().isEmpty()) {
            this.iCoursePrefs.clear();
            this.getRowFormatter().setVisible(this.iCoursePrefsRow, false);
        } else {
            this.iCoursePrefs.setValue(instructor.getCoursePreferences());
            this.getRowFormatter().setVisible(this.iCoursePrefsRow, true);
        }
        InstructorAvailabilityWidget.InstructorAvailabilityModel model = this.iProperties.getInstructorAvailabilityModel();
        model.setPattern(instructor.getAvailability());
        this.iTimePrefs.setValue(model);
        if (instructor.getDistributionPreferences().isEmpty()) {
            this.iDistPrefs.clear();
            this.getRowFormatter().setVisible(this.iDistPrefsRow, false);
        } else {
            this.iDistPrefs.setValue(instructor.getDistributionPreferences());
            this.getRowFormatter().setVisible(this.iDistPrefsRow, true);
        }
        this.iEnrollmentsTable.clearTable(1);
        if (instructor.getEnrollments().isEmpty()) {
            this.getRowFormatter().setVisible(this.iEnrollmentsRow, false);
        } else {
            for (InstructorInterface.ClassInfo e : instructor.getEnrollments()) {
                line = new ArrayList<Object>();
                line.add(new Label(e.getCourse()));
                line.add(new Label(e.getType() + (String)(e.getExternalId() == null ? "" : " " + e.getExternalId())));
                line.add(new HTML(e.getTime() == null ? SECTMSG.arrangeHours() : e.getTime()));
                line.add(new HTML(e.getDate() == null ? SECTMSG.noDate() : e.getDate()));
                line.add(new HTML(e.getRoom() == null ? SECTMSG.noRoom() : e.getRoom()));
                line.add(new Label(e.isInstructor() ? MESSAGES.enrollmentRoleInstructor() : MESSAGES.enrollmentRoleStudent()));
                this.iEnrollmentsTable.addRow(e, line);
            }
            this.getRowFormatter().setVisible(this.iEnrollmentsRow, true);
        }
        this.iRequestsTable.clearTable(1);
        this.iObjectives.clear();
        if (instructor.getAssignedRequests().isEmpty()) {
            this.getRowFormatter().setVisible(this.iRequestsRow, false);
            this.getRowFormatter().setVisible(this.iObjectivesRow, false);
        } else {
            for (InstructorInterface.TeachingRequestInfo request : instructor.getAssignedRequests()) {
                line = new ArrayList();
                P course = new P("course");
                course.setText(request.getCourse().getCourseName());
                line.add((Object)course);
                P section = new P("sections");
                P time = new P("times");
                P date = new P("dates");
                P room = new P("rooms");
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    P p = new P("section");
                    p.setText(s.getSectionType() + (String)(s.getExternalId() == null ? "" : " " + s.getExternalId()));
                    if (s.isCommon()) {
                        p.addStyleName("common");
                    }
                    section.add((Widget)p);
                    P t = new P("time");
                    t.setHTML(s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime());
                    if (s.isCommon()) {
                        t.addStyleName("common");
                    }
                    time.add((Widget)t);
                    P d = new P("date");
                    d.setHTML(s.getDate() == null ? SECTMSG.noDate() : s.getDate());
                    if (s.isCommon()) {
                        d.addStyleName("common");
                    }
                    date.add((Widget)d);
                    P r = new P("room");
                    r.setHTML(s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom());
                    if (s.isCommon()) {
                        r.addStyleName("common");
                    }
                    room.add((Widget)r);
                }
                line.add((Object)section);
                line.add((Object)time);
                line.add((Object)date);
                line.add((Object)room);
                line.add(new Label(sTeachingLoadFormat.format((double)request.getLoad())));
                line.add((Object)new PreferenceCell(this.iProperties, request.getAttributePreferences()));
                line.add((Object)new PreferenceCell(this.iProperties, request.getInstructorPreferences()));
                line.add((Object)new ObjectivesCell(this.iProperties, request.getValues()));
                int row = this.iRequestsTable.addRow(request, line);
                if (!request.isConflict()) continue;
                this.iRequestsTable.getRowFormatter().addStyleName(row, "enrollment-conflict");
            }
            this.iObjectives.setValue(instructor.getValues());
            this.getRowFormatter().setVisible(this.iRequestsRow, true);
            this.getRowFormatter().setVisible(this.iObjectivesRow, true);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Integer> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Integer getValue() {
        int row = this.iRequestsTable.getSelectedRow();
        if (row < 1) {
            return null;
        }
        return row - 1;
    }

    public void setValue(Integer value) {
        this.setValue(value, false);
    }

    public void setValue(Integer value, boolean fireEvents) {
        if (value == null) {
            int row = this.iRequestsTable.getSelectedRow();
            if (row >= 0) {
                this.iRequestsTable.setSelected(row, false);
            }
        } else {
            this.iRequestsTable.setSelected(value + 1, true);
        }
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }
}

