/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.events.UniTimeFilterBox;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;

public class EventFilterBox
extends UniTimeFilterBox<EventInterface.EventFilterRpcRequest> {
    private ListBox iSponsors;
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static DateTimeFormat sDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.filterDateFormat());
    private static DateTimeFormat sLocalDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
    private FilterBox.CustomFilter iOther = null;
    private AriaSuggestBox iRequested;
    private FilterBox.Chip iLastRequested = null;
    private ListBox iServices;

    public EventFilterBox(AcademicSessionProvider session) {
        super(session, false);
        this.addFilter(new FilterBox.StaticSimpleFilter("type", MESSAGES.tagEventType(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                if ("class".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventTypeShort()[0];
                } else if ("final exam".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventTypeShort()[1];
                } else if ("midterm exam".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventTypeShort()[2];
                } else if ("course".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventTypeShort()[3];
                } else if ("special".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventTypeShort()[4];
                } else if ("not available".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventTypeShort()[5];
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        this.iSponsors = new ListBox();
        this.iSponsors.setMultipleSelect(true);
        this.iSponsors.setWidth("100%");
        this.iSponsors.setVisibleItemCount(3);
        this.addFilter(new FilterBox.CustomFilter("sponsor", MESSAGES.tagSponsor(), new Widget[]{this.iSponsors}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    for (int i = 0; i < EventFilterBox.this.iSponsors.getItemCount(); ++i) {
                        FilterBox.Chip chip = new FilterBox.Chip("sponsor", EventFilterBox.this.iSponsors.getValue(i)).withTranslatedCommand(MESSAGES.tagSponsor());
                        String name = EventFilterBox.this.iSponsors.getItemText(i);
                        if (EventFilterBox.this.iSponsors.getValue(i).toLowerCase().startsWith(text.toLowerCase())) {
                            suggestions.add(new FilterBox.Suggestion(name, chip));
                            continue;
                        }
                        if (text.length() <= 2 || !name.toLowerCase().contains(" " + text.toLowerCase())) continue;
                        suggestions.add(new FilterBox.Suggestion(name, chip));
                    }
                    callback.onSuccess(suggestions);
                }
            }

            @Override
            public boolean isVisible() {
                return EventFilterBox.this.iSponsors.getItemCount() > 0;
            }
        });
        this.iSponsors.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                boolean changed = false;
                for (int i = 0; i < EventFilterBox.this.iSponsors.getItemCount(); ++i) {
                    FilterBox.Chip chip = new FilterBox.Chip("sponsor", EventFilterBox.this.iSponsors.getValue(i)).withTranslatedCommand(MESSAGES.tagSponsor());
                    if (EventFilterBox.this.iSponsors.isItemSelected(i)) {
                        if (EventFilterBox.this.hasChip(chip)) continue;
                        EventFilterBox.this.addChip(chip, false);
                        changed = true;
                        continue;
                    }
                    if (!EventFilterBox.this.hasChip(chip)) continue;
                    EventFilterBox.this.removeChip(chip, false);
                    changed = true;
                }
                if (changed) {
                    EventFilterBox.this.fireValueChangeEvent();
                }
            }
        });
        FilterBox.StaticSimpleFilter mode = new FilterBox.StaticSimpleFilter("mode", MESSAGES.tagEventMode(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                if ("all".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventModeAbbv()[0];
                } else if ("my".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventModeAbbv()[1];
                } else if ("approved".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventModeAbbv()[2];
                } else if ("unapproved".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventModeAbbv()[3];
                } else if ("awaiting".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventModeAbbv()[4];
                } else if ("conflicting".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventModeAbbv()[5];
                } else if ("my awaiting".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventModeAbbv()[6];
                } else if ("cancelled".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventModeAbbv()[7];
                } else if ("expiring".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventModeAbbv()[8];
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        };
        mode.setMultipleSelection(false);
        this.addFilter(mode);
        this.addFilter(new FilterBox.StaticSimpleFilter("role", MESSAGES.tagEventRole(), new String[0]){

            @Override
            public void getPopupWidget(FilterBox box, AsyncCallback<Widget> callback) {
                callback.onSuccess(null);
            }

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                if ("all".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventRole()[0];
                } else if ("student".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventRole()[1];
                } else if ("instructor".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventRole()[2];
                } else if ("coordinator".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventRole()[3];
                } else if ("contact".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.eventRole()[4];
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        this.iServices = new ListBox();
        this.iServices.setMultipleSelect(false);
        this.iServices.setWidth("100%");
        this.addFilter(new FilterBox.CustomFilter("service", MESSAGES.tagService(), new Widget[]{this.iServices}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    for (int i = 0; i < EventFilterBox.this.iServices.getItemCount(); ++i) {
                        FilterBox.Chip chip = new FilterBox.Chip("service", EventFilterBox.this.iServices.getValue(i)).withTranslatedCommand(MESSAGES.tagService());
                        String name = EventFilterBox.this.iServices.getItemText(i);
                        if (EventFilterBox.this.iServices.getValue(i).toLowerCase().startsWith(text.toLowerCase())) {
                            suggestions.add(new FilterBox.Suggestion(name, chip));
                            continue;
                        }
                        if (text.length() <= 2 || !name.toLowerCase().contains(" " + text.toLowerCase())) continue;
                        suggestions.add(new FilterBox.Suggestion(name, chip));
                    }
                    callback.onSuccess(suggestions);
                }
            }

            @Override
            public boolean isVisible() {
                return EventFilterBox.this.iServices.getItemCount() > 0;
            }
        });
        this.iServices.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                boolean changed = false;
                for (int i = 1; i < EventFilterBox.this.iServices.getItemCount(); ++i) {
                    FilterBox.Chip chip = new FilterBox.Chip("service", EventFilterBox.this.iServices.getValue(i)).withTranslatedCommand(MESSAGES.tagService());
                    if (EventFilterBox.this.iServices.isItemSelected(i)) {
                        if (EventFilterBox.this.hasChip(chip)) continue;
                        EventFilterBox.this.addChip(chip, false);
                        changed = true;
                        continue;
                    }
                    if (!EventFilterBox.this.hasChip(chip)) continue;
                    EventFilterBox.this.removeChip(chip, false);
                    changed = true;
                }
                if (changed) {
                    EventFilterBox.this.fireValueChangeEvent();
                }
            }
        });
        Label reqLab = new Label(MESSAGES.propRequestedBy());
        this.iRequested = new AriaSuggestBox(new RequestedByOracle());
        this.iRequested.setStyleName("unitime-TextArea");
        this.iRequested.setWidth("200px");
        final CheckBox conflicts = new CheckBox(MESSAGES.checkDisplayConflicts());
        conflicts.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        final CheckBox sessions = new CheckBox(MESSAGES.checkSpanMultipleSessions());
        sessions.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        this.iOther = new FilterBox.CustomFilter("other", MESSAGES.tagOther(), new Widget[]{reqLab, this.iRequested, conflicts, sessions}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    if ("conflicts".startsWith(text.toLowerCase()) || MESSAGES.checkDisplayConflicts().toLowerCase().startsWith(text.toLowerCase())) {
                        suggestions.add(new FilterBox.Suggestion(MESSAGES.checkDisplayConflicts(), new FilterBox.Chip("flag", "Conflicts").withTranslatedCommand(MESSAGES.tagEventFlag()).withTranslatedValue(MESSAGES.attrFlagShowConflicts())));
                    }
                    if ("sessinons".startsWith(text.toLowerCase()) || MESSAGES.checkSpanMultipleSessions().toLowerCase().startsWith(text.toLowerCase())) {
                        suggestions.add(new FilterBox.Suggestion(MESSAGES.checkSpanMultipleSessions(), new FilterBox.Chip("flag", "All Sessions").withTranslatedCommand(MESSAGES.tagEventFlag()).withTranslatedValue(MESSAGES.attrFlagAllSessions())));
                    }
                    callback.onSuccess(suggestions);
                }
            }
        };
        this.addFilter(this.iOther);
        this.addFilter(new FilterBox.StaticSimpleFilter("requested", MESSAGES.tagRequested(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("flag", MESSAGES.tagEventFlag(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                if ("conflicts".equalsIgnoreCase(text)) {
                    translatedValue = MESSAGES.attrFlagShowConflicts();
                } else if ("all sessions".equalsIgnoreCase(text)) {
                    translatedValue = MESSAGES.attrFlagAllSessions();
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        this.iRequested.getValueBox().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EventFilterBox.this.requestedChanged(true);
            }
        });
        this.iRequested.getValueBox().addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        EventFilterBox.this.requestedChanged(false);
                    }
                });
            }
        });
        this.iRequested.getValueBox().addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            EventFilterBox.this.requestedChanged(false);
                        }
                    });
                }
            }
        });
        this.iRequested.getValueBox().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                EventFilterBox.this.requestedChanged(true);
            }
        });
        this.iRequested.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                EventFilterBox.this.requestedChanged(true);
            }
        });
        conflicts.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                FilterBox.Chip chip = new FilterBox.Chip("flag", "Conflicts").withTranslatedCommand(MESSAGES.tagEventFlag()).withTranslatedValue(MESSAGES.attrFlagShowConflicts());
                if (((Boolean)event.getValue()).booleanValue()) {
                    if (!EventFilterBox.this.hasChip(chip)) {
                        EventFilterBox.this.addChip(chip, true);
                    }
                } else if (EventFilterBox.this.hasChip(chip)) {
                    EventFilterBox.this.removeChip(chip, true);
                }
            }
        });
        conflicts.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                event.getNativeEvent().stopPropagation();
                event.getNativeEvent().preventDefault();
            }
        });
        sessions.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                FilterBox.Chip chip = new FilterBox.Chip("flag", "All Sessions").withTranslatedCommand(MESSAGES.tagEventFlag()).withTranslatedValue(MESSAGES.attrFlagAllSessions());
                if (((Boolean)event.getValue()).booleanValue()) {
                    if (!EventFilterBox.this.hasChip(chip)) {
                        EventFilterBox.this.addChip(chip, true);
                    }
                } else if (EventFilterBox.this.hasChip(chip)) {
                    EventFilterBox.this.removeChip(chip, true);
                }
            }
        });
        sessions.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                event.getNativeEvent().stopPropagation();
                event.getNativeEvent().preventDefault();
            }
        });
        AbsolutePanel m = new AbsolutePanel();
        m.setStyleName("unitime-DateSelector");
        final SingleDateSelector.SingleMonth m1 = new SingleDateSelector.SingleMonth(MESSAGES.tagDateFrom());
        m1.setAllowDeselect(true);
        m.add((Widget)m1);
        final SingleDateSelector.SingleMonth m2 = new SingleDateSelector.SingleMonth(MESSAGES.tagDateTo());
        m2.setAllowDeselect(true);
        m.add((Widget)m2);
        this.addFilter(new FilterBox.CustomFilter("date", MESSAGES.tagDate(), new Widget[]{m}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                Date date2;
                ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                FilterBox.Chip chFrom = null;
                FilterBox.Chip chTo = null;
                for (FilterBox.Chip c : chips) {
                    if (c.getCommand().equals("from")) {
                        chFrom = c;
                    }
                    if (!c.getCommand().equals("to")) continue;
                    chTo = c;
                }
                try {
                    date2 = DateTimeFormat.getFormat((String)"MM/dd").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateFrom()).withTranslatedValue(sLocalDateFormat.format(date2)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateTo()).withTranslatedValue(sLocalDateFormat.format(date2)), chTo));
                }
                catch (Exception date2) {
                    // empty catch block
                }
                try {
                    date2 = DateTimeFormat.getFormat((String)"dd.MM").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateFrom()).withTranslatedValue(sLocalDateFormat.format(date2)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateTo()).withTranslatedValue(sLocalDateFormat.format(date2)), chTo));
                }
                catch (Exception date3) {
                    // empty catch block
                }
                try {
                    date2 = DateTimeFormat.getFormat((String)"MM/dd/yy").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateFrom()).withTranslatedValue(sLocalDateFormat.format(date2)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateTo()).withTranslatedValue(sLocalDateFormat.format(date2)), chTo));
                }
                catch (Exception date4) {
                    // empty catch block
                }
                try {
                    date2 = DateTimeFormat.getFormat((String)"dd.MM.yy").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateFrom()).withTranslatedValue(sLocalDateFormat.format(date2)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateTo()).withTranslatedValue(sLocalDateFormat.format(date2)), chTo));
                }
                catch (Exception date5) {
                    // empty catch block
                }
                try {
                    date2 = DateTimeFormat.getFormat((String)"MMM dd").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateFrom()).withTranslatedValue(sLocalDateFormat.format(date2)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateTo()).withTranslatedValue(sLocalDateFormat.format(date2)), chTo));
                }
                catch (Exception date6) {
                    // empty catch block
                }
                try {
                    date2 = DateTimeFormat.getFormat((String)"MMM dd yy").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateFrom()).withTranslatedValue(sLocalDateFormat.format(date2)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date2)).withTranslatedCommand(MESSAGES.tagDateTo()).withTranslatedValue(sLocalDateFormat.format(date2)), chTo));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                callback.onSuccess(suggestions);
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("from", MESSAGES.tagDateFrom(), new String[0]){

            @Override
            public void validate(String value, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                try {
                    translatedValue = sLocalDateFormat.format(sDateFormat.parse(value));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), value).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("to", MESSAGES.tagDateTo(), new String[0]){

            @Override
            public void validate(String value, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                try {
                    translatedValue = sLocalDateFormat.format(sDateFormat.parse(value));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), value).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        session.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            @Override
            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                if (event.isChanged() && event.getNewAcademicSessionId() != null) {
                    RPC.execute(new EventInterface.RequestSessionDetails(event.getNewAcademicSessionId()), new AsyncCallback<GwtRpcResponseList<EventInterface.SessionMonth>>(){

                        public void onFailure(Throwable caught) {
                        }

                        public void onSuccess(GwtRpcResponseList<EventInterface.SessionMonth> result) {
                            m1.setMonths(result);
                            m2.setMonths(result);
                        }
                    });
                }
            }
        });
        m1.addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                FilterBox.Chip ch = EventFilterBox.this.getChip("from");
                Date value = (Date)event.getValue();
                if (value == null) {
                    if (ch != null) {
                        EventFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    if (ch != null) {
                        if (ch.getValue().equals(sDateFormat.format(value))) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("from", sDateFormat.format(value)).withTranslatedCommand(MESSAGES.tagDateFrom()).withTranslatedValue(sLocalDateFormat.format(value)), true);
                }
            }
        });
        m2.addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                FilterBox.Chip ch = EventFilterBox.this.getChip("to");
                Date value = (Date)event.getValue();
                if (value == null) {
                    if (ch != null) {
                        EventFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    if (ch != null) {
                        if (ch.getValue().equals(sDateFormat.format(value))) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("to", sDateFormat.format(value)).withTranslatedCommand(MESSAGES.tagDateTo()).withTranslatedValue(sLocalDateFormat.format(value)), true);
                }
            }
        });
        ArrayList<FilterBox.Chip> days = new ArrayList<FilterBox.Chip>();
        days.add(new FilterBox.Chip("day", "Monday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[0]));
        days.add(new FilterBox.Chip("day", "Tuesday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[1]));
        days.add(new FilterBox.Chip("day", "Wednesday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[2]));
        days.add(new FilterBox.Chip("day", "Thursday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[3]));
        days.add(new FilterBox.Chip("day", "Friday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[4]));
        days.add(new FilterBox.Chip("day", "Saturday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[5]));
        days.add(new FilterBox.Chip("day", "Sunday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[6]));
        this.addFilter(new FilterBox.StaticSimpleFilter("day", MESSAGES.tagDayOfWeek(), days));
        final TimeSelector st = new TimeSelector(null);
        final TimeSelector et = new TimeSelector(st);
        st.setStyleName("unitime-TextArea");
        st.addStyleName("unitime-TimeSelector");
        et.setStyleName("unitime-TextArea");
        et.addStyleName("unitime-TimeSelector");
        this.addFilter(new FilterBox.CustomFilter("time", MESSAGES.tagTime(), new Widget[]{new Label(MESSAGES.propAfter()), st, new Label(" " + MESSAGES.propBefore()), et}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                FilterBox.Chip chStart = null;
                FilterBox.Chip chStop = null;
                for (FilterBox.Chip c : chips) {
                    if (c.getCommand().equals("after")) {
                        chStart = c;
                    }
                    if (!c.getCommand().equals("before")) continue;
                    chStop = c;
                }
                Integer start = TimeSelector.TimeUtils.parseTime(CONSTANTS, text, null);
                Integer stop = TimeSelector.TimeUtils.parseTime(CONSTANTS, text, chStart == null ? null : TimeSelector.TimeUtils.parseMilitary(chStart.getValue()));
                if (chStart == null) {
                    if (start != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 3)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 3)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 6)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 6)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 9)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 9)), chStart));
                    }
                    if (stop != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 3)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 3)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 6)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 6)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 9)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 9)), chStop));
                    }
                } else {
                    if (stop != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 3)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 3)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 6)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 6)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 9)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 9)), chStop));
                    }
                    if (start != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 3)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 3)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 6)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 6)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 9)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 9)), chStart));
                    }
                }
                callback.onSuccess(suggestions);
            }
        });
        st.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                FilterBox.Chip ch = EventFilterBox.this.getChip("after");
                Integer start = (Integer)event.getValue();
                if (start == null) {
                    if (ch != null) {
                        EventFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    if (ch != null) {
                        if (ch.getCommand().equals(TimeSelector.TimeUtils.slot2military(start))) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start)), true);
                }
                FilterBox.Chip ch2 = EventFilterBox.this.getChip("before");
                Integer stop = et.getValue();
                if (stop == null) {
                    if (ch2 != null) {
                        EventFilterBox.this.removeChip(ch2, true);
                    }
                } else {
                    if (ch2 != null) {
                        if (ch2.getCommand().equals(TimeSelector.TimeUtils.slot2military(stop))) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch2, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop)), true);
                }
            }
        });
        et.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                FilterBox.Chip ch = EventFilterBox.this.getChip("before");
                Integer stop = (Integer)event.getValue();
                if (stop == null) {
                    if (ch != null) {
                        EventFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    if (ch != null) {
                        if (ch.getCommand().equals(TimeSelector.TimeUtils.slot2military(stop))) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop)), true);
                }
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("after", MESSAGES.tagTimeAfter(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                Integer slot = TimeSelector.TimeUtils.parseTime2(CONSTANTS, text, null);
                if (slot != null) {
                    translatedValue = TimeSelector.TimeUtils.slot2time(slot);
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("before", MESSAGES.tagTimeBefore(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                Integer slot = TimeSelector.TimeUtils.parseTime2(CONSTANTS, text, null);
                if (slot != null) {
                    translatedValue = TimeSelector.TimeUtils.slot2time(slot);
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        this.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                EventFilterBox.this.iLastRequested = EventFilterBox.this.getChip("requested");
                if (!EventFilterBox.this.isFilterPopupShowing()) {
                    FilterBox.Chip chFrom;
                    String value;
                    int i;
                    conflicts.setValue(Boolean.valueOf(EventFilterBox.this.hasChip(new FilterBox.Chip("flag", "Conflicts"))));
                    sessions.setValue(Boolean.valueOf(EventFilterBox.this.hasChip(new FilterBox.Chip("flag", "All Sessions"))));
                    FilterBox.Chip req = EventFilterBox.this.getChip("requested");
                    if (req == null) {
                        EventFilterBox.this.iRequested.setText("");
                    } else {
                        EventFilterBox.this.iRequested.setText(req.getValue());
                    }
                    for (i = 0; i < EventFilterBox.this.iSponsors.getItemCount(); ++i) {
                        value = EventFilterBox.this.iSponsors.getValue(i);
                        EventFilterBox.this.iSponsors.setItemSelected(i, EventFilterBox.this.hasChip(new FilterBox.Chip("sponsor", value)));
                    }
                    for (i = 1; i < EventFilterBox.this.iServices.getItemCount(); ++i) {
                        value = EventFilterBox.this.iServices.getValue(i);
                        if (!EventFilterBox.this.hasChip(new FilterBox.Chip("service", value))) continue;
                        EventFilterBox.this.iServices.setSelectedIndex(i);
                        break;
                    }
                    if ((chFrom = EventFilterBox.this.getChip("from")) != null) {
                        m1.setDate(sDateFormat.parse(chFrom.getValue()));
                    } else {
                        m1.clearSelection();
                    }
                    FilterBox.Chip chTo = EventFilterBox.this.getChip("to");
                    if (chTo != null) {
                        m2.setDate(sDateFormat.parse(chTo.getValue()));
                    } else {
                        m2.clearSelection();
                    }
                    FilterBox.Chip chStart = EventFilterBox.this.getChip("after");
                    if (chStart != null) {
                        st.setValue(TimeSelector.TimeUtils.parseMilitary(chStart.getValue()));
                    } else {
                        st.setValue(null);
                    }
                    FilterBox.Chip chStop = EventFilterBox.this.getChip("before");
                    if (chStop != null) {
                        et.setValue(TimeSelector.TimeUtils.parseMilitary(chStop.getValue()));
                    } else {
                        et.setValue(null);
                    }
                }
                if (EventFilterBox.this.getAcademicSessionId() != null) {
                    EventFilterBox.this.init(false, EventFilterBox.this.getAcademicSessionId(), new Command(){

                        public void execute() {
                            if (EventFilterBox.this.isFilterPopupShowing()) {
                                EventFilterBox.this.showFilterPopup();
                            }
                        }
                    });
                }
                EventFilterBox.this.setAriaLabel(ARIA.eventFilter(EventFilterBox.this.toAriaString()));
            }
        });
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                EventFilterBox.this.setAriaLabel(ARIA.eventFilter(EventFilterBox.this.toAriaString()));
            }
        });
    }

    @Override
    public void setValue(String value, boolean fireEvents) {
        ((FilterBox)this.iFilter.getWidget()).setValue(value, fireEvents);
    }

    public void setOtherVisible(boolean visible) {
        this.iOther.setVisible(visible);
    }

    @Override
    protected boolean populateFilter(FilterBox.Filter filter, List<EventInterface.FilterRpcResponse.Entity> entities) {
        if ("sponsor".equals(filter.getCommand())) {
            this.iSponsors.clear();
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    this.iSponsors.addItem(entity.getName() + (String)(entity.getCount() <= 0 ? "" : " (" + entity.getCount() + ")"), entity.getAbbreviation());
                }
            }
            for (int i = 0; i < this.iSponsors.getItemCount(); ++i) {
                String value = this.iSponsors.getValue(i);
                this.iSponsors.setItemSelected(i, this.hasChip(new FilterBox.Chip("sponsor", value)));
            }
            return true;
        }
        if ("service".equals(filter.getCommand())) {
            this.iServices.clear();
            if (entities != null) {
                this.iServices.addItem(MESSAGES.itemSelect(), "");
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    this.iServices.addItem(entity.getName() + (String)(entity.getCount() <= 0 ? "" : " (" + entity.getCount() + ")"), entity.getAbbreviation());
                }
            }
            for (int i = 1; i < this.iServices.getItemCount(); ++i) {
                String value = this.iServices.getValue(i);
                if (!this.hasChip(new FilterBox.Chip("service", value))) continue;
                this.iServices.setSelectedIndex(i);
                break;
            }
            return true;
        }
        return super.populateFilter(filter, entities);
    }

    private void requestedChanged(boolean fireChange) {
        FilterBox.Chip oldChip = this.getChip("requested");
        if (this.iRequested.getText().isEmpty()) {
            if (oldChip != null) {
                this.removeChip(oldChip, fireChange);
            }
        } else {
            FilterBox.Chip newChip = new FilterBox.Chip("requested", this.iRequested.getText()).withTranslatedCommand(MESSAGES.tagRequested());
            if (oldChip != null) {
                if (newChip.equals(oldChip)) {
                    if (fireChange && !newChip.equals(this.iLastRequested)) {
                        this.fireValueChangeEvent();
                    }
                    return;
                }
                this.removeChip(oldChip, false);
            }
            this.addChip(newChip, fireChange);
        }
    }

    @Override
    public EventInterface.EventFilterRpcRequest createRpcRequest() {
        return new EventInterface.EventFilterRpcRequest();
    }

    public class RequestedByOracle
    extends SuggestOracle {
        public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
            if (!request.getQuery().isEmpty()) {
                ((FilterBox)EventFilterBox.this.iFilter.getWidget()).getSuggestionsProvider().getSuggestions(((FilterBox)EventFilterBox.this.iFilter.getWidget()).getChips(null), request.getQuery(), new AsyncCallback<Collection<FilterBox.Suggestion>>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Collection<FilterBox.Suggestion> result) {
                        if (result == null) {
                            return;
                        }
                        ArrayList<RequestedBySuggestion> suggestions = new ArrayList<RequestedBySuggestion>();
                        for (FilterBox.Suggestion suggestion : result) {
                            if (suggestion.getChipToAdd() == null || !"requested".equals(suggestion.getChipToAdd().getCommand())) continue;
                            suggestions.add(new RequestedBySuggestion(suggestion));
                        }
                        callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
                    }
                });
            }
        }
    }

    public class RequestedBySuggestion
    implements SuggestOracle.Suggestion {
        private FilterBox.Suggestion iSuggestion;

        RequestedBySuggestion(FilterBox.Suggestion suggestion) {
            this.iSuggestion = suggestion;
        }

        public String getDisplayString() {
            return this.iSuggestion.getChipToAdd().getLabel();
        }

        public String getReplacementString() {
            return this.iSuggestion.getChipToAdd().getLabel();
        }
    }
}

