/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ClassListForm;
import org.unitime.timetable.form.ClassListFormInterface;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.WebClassListTableBuilder;
import org.unitime.timetable.webutil.csv.CsvClassListTableBuilder;
import org.unitime.timetable.webutil.pdf.PdfClassListTableBuilder;

@Action(value="classSearch", results={@Result(name={"showClassSearch"}, type="tiles", location="classSearch.tiles")})
@TilesDefinition(name="classSearch.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Classes"), @TilesPutAttribute(name="body", value="/user/classSearch.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="assignment")})
public class ClassSearchAction
extends UniTimeAction<ClassListForm> {
    private static final long serialVersionUID = -4834379802757297961L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String doit;
    private String[] subjectAreaIds;
    private String courseNbr;
    private String loadFilter;
    private boolean showTable = false;

    public String getDoit() {
        return this.doit;
    }

    public void setDoit(String doit) {
        this.doit = doit;
    }

    public String[] getSubjectAreaIds() {
        return this.subjectAreaIds;
    }

    public void setSubjectAreaIds(String[] subjectAreaIds) {
        this.subjectAreaIds = subjectAreaIds;
    }

    public String getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        this.courseNbr = courseNbr;
    }

    public String getLoadFilter() {
        return this.loadFilter;
    }

    public void setLoadFilter(String loadFilter) {
        this.loadFilter = loadFilter;
    }

    public boolean isShowTable() {
        return this.showTable;
    }

    public void setShowTable(boolean showTable) {
        this.showTable = showTable;
    }

    public String execute() throws Exception {
        if (ApplicationProperty.LegacyClasses.isFalse()) {
            Object url = "classSearch";
            boolean first = true;
            Enumeration e = this.getRequest().getParameterNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                url = (String)url + (first ? "?" : "&") + param + "=" + URLEncoder.encode(this.getRequest().getParameter(param), "utf-8");
                first = false;
            }
            this.response.sendRedirect((String)url);
            return null;
        }
        if (this.form == null) {
            this.form = new ClassListForm();
        }
        if (this.getSubjectAreaIds() != null) {
            ((ClassListForm)this.form).setSubjectAreaIds(this.getSubjectAreaIds());
        }
        if (this.getCourseNbr() != null) {
            ((ClassListForm)this.form).setCourseNbr(this.getCourseNbr());
        }
        LookupTables.setupItypes(this.request, true);
        if (MSG.actionSearchClasses().equals(this.doit) || "Search".equals(this.doit)) {
            return this.searchClasses();
        }
        if (MSG.actionExportPdf().equals(this.doit)) {
            return this.exportPdf();
        }
        if (MSG.actionExportCsv().equals(this.doit)) {
            return this.exportCsv();
        }
        BackTracker.markForBack(this.request, null, null, false, true);
        this.sessionContext.checkPermission(Right.Classes);
        Object sas = this.sessionContext.getAttribute(SessionAttribute.ClassesSubjectAreas);
        Object cn = this.sessionContext.getAttribute(SessionAttribute.ClassesCourseNumber);
        String subjectAreaIds = "";
        String courseNbr = "";
        if ((sas == null || sas.toString().trim().isEmpty()) && (cn == null || cn.toString().trim().isEmpty())) {
            sas = this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
            cn = this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
        }
        this.request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME, Department.findAllExternal(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        ClassSearchAction.setupGeneralFormFilters(this.sessionContext, (ClassListFormInterface)((Object)this.form));
        ClassSearchAction.setupClassListSpecificFormFilters(this.sessionContext, (ClassListForm)this.form);
        if (!this.sessionContext.hasPermission(Right.Examinations)) {
            ((ClassListForm)this.form).setExams(null);
        }
        ((ClassListForm)this.form).setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
        if (sas == null && ((ClassListForm)this.form).getSubjectAreas().size() == 1) {
            sas = ((ClassListForm)this.form).getSubjectAreas().iterator().next().getUniqueId().toString();
        }
        if (Constants.ALL_OPTION_VALUE.equals(sas)) {
            sas = null;
        }
        if (sas != null && sas.toString().trim().length() > 0) {
            subjectAreaIds = sas.toString();
            try {
                if (cn != null && cn.toString().trim().length() > 0) {
                    courseNbr = cn.toString();
                }
                Debug.debug("Subject Areas: " + subjectAreaIds);
                Debug.debug("Course Number: " + courseNbr);
                ((ClassListForm)this.form).setSubjectAreaIds(subjectAreaIds.split(","));
                ((ClassListForm)this.form).setCourseNbr(courseNbr);
                Integer maxSubjectsToSearch = ApplicationProperty.MaxSubjectsToSearchAutomatically.intValue();
                if (maxSubjectsToSearch != null && maxSubjectsToSearch >= 0 && ((ClassListForm)this.form).getSubjectAreaIds().length > maxSubjectsToSearch) {
                    this.setShowTable(false);
                    return "showClassSearch";
                }
                StringBuffer ids = new StringBuffer();
                StringBuffer names = new StringBuffer();
                StringBuffer subjIds = new StringBuffer();
                ((ClassListForm)this.form).validate(this);
                if (this.hasFieldErrors()) {
                    this.setShowTable(false);
                    return "showClassSearch";
                }
                ((ClassListForm)this.form).setClasses(ClassSearchAction.getClasses((ClassListFormInterface)((Object)this.form), WebSolver.getClassAssignmentProxy(this.request.getSession())));
                Collection<Class_> classes = ((ClassListForm)this.form).getClasses();
                if (classes.isEmpty()) {
                    this.addFieldError("searchResult", MSG.errorNoRecords());
                    this.setShowTable(false);
                    return "showClassSearch";
                }
                for (int i = 0; i < ((ClassListForm)this.form).getSubjectAreaIds().length; ++i) {
                    if (i > 0) {
                        names.append(",");
                        subjIds.append(",");
                    }
                    ids.append("&subjectAreaIds=" + ((ClassListForm)this.form).getSubjectAreaIds()[i]);
                    subjIds.append(((ClassListForm)this.form).getSubjectAreaIds()[i]);
                    names.append(((SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(((ClassListForm)this.form).getSubjectAreaIds()[i]))).getSubjectAreaAbbreviation());
                }
                BackTracker.markForBack(this.request, "classSearch.action?doit=Search&loadFilter=1&" + String.valueOf(ids) + "&courseNbr=" + URLEncoder.encode(((ClassListForm)this.form).getCourseNbr(), "utf-8"), MSG.backClasses(String.valueOf(names) + (String)(((ClassListForm)this.form).getCourseNbr() == null || ((ClassListForm)this.form).getCourseNbr().length() == 0 ? "" : " " + ((ClassListForm)this.form).getCourseNbr())), true, true);
                this.setShowTable(true);
                return "showClassSearch";
            }
            catch (NumberFormatException nfe) {
                Debug.error("Subject Area Ids session attribute is corrupted. Resetting ... ");
                this.sessionContext.removeAttribute(SessionAttribute.ClassesSubjectAreas);
                this.sessionContext.removeAttribute(SessionAttribute.ClassesCourseNumber);
            }
        }
        this.setShowTable(false);
        return "showClassSearch";
    }

    public String searchClasses() throws Exception {
        return this.performAction("searchClasses");
    }

    public String exportPdf() throws Exception {
        return this.performAction("exportPdf");
    }

    public String exportCsv() throws Exception {
        return this.performAction("exportCsv");
    }

    public String performAction(String action) throws Exception {
        this.sessionContext.checkPermission(Right.Classes);
        this.request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME, Department.findAllExternal(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        if ("1".equals(this.getLoadFilter())) {
            ClassSearchAction.setupGeneralFormFilters(this.sessionContext, (ClassListFormInterface)((Object)this.form));
            ClassSearchAction.setupClassListSpecificFormFilters(this.sessionContext, (ClassListForm)this.form);
        } else {
            this.sessionContext.getUser().setProperty("ClassList.divSec", ((ClassListForm)this.form).getDivSec() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.demand", ((ClassListForm)this.form).getDemand() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.demandIsVisible", ((ClassListForm)this.form).getDemandIsVisible() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.limit", ((ClassListForm)this.form).getLimit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.snapshotLimit", ((ClassListForm)this.form).getSnapshotLimit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.roomLimit", ((ClassListForm)this.form).getRoomLimit() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.manager", ((ClassListForm)this.form).getManager() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.datePattern", ((ClassListForm)this.form).getDatePattern() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.timePattern", ((ClassListForm)this.form).getTimePattern() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.instructor", ((ClassListForm)this.form).getInstructor() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.instructorAssignment", ((ClassListForm)this.form).getInstructorAssignment() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.lms", ((ClassListForm)this.form).getLms() == null ? null : (((ClassListForm)this.form).getLms() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("ClassList.preferences", ((ClassListForm)this.form).getPreferences() != false ? "1" : "0");
            if (((ClassListForm)this.form).getTimetable() != null) {
                this.sessionContext.getUser().setProperty("ClassList.timetable", ((ClassListForm)this.form).getTimetable() != false ? "1" : "0");
            }
            this.sessionContext.getUser().setProperty("ClassList.schedulePrintNote", ((ClassListForm)this.form).getSchedulePrintNote() != false ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.note", ((ClassListForm)this.form).getNote() != false ? "1" : "0");
            if (((ClassListForm)this.form).getExams() != null) {
                this.sessionContext.getUser().setProperty("ClassList.exams", ((ClassListForm)this.form).getExams() != false ? "1" : "0");
            }
            this.sessionContext.getUser().setProperty("ClassList.fundingDepartment", ((ClassListForm)this.form).getFundingDepartment() == null ? "0" : (((ClassListForm)this.form).getFundingDepartment() != false ? "1" : "0"));
            this.sessionContext.getUser().setProperty("ClassList.sortBy", ((ClassListForm)this.form).getSortBy());
            this.sessionContext.getUser().setProperty("ClassList.filterAssignedRoom", ((ClassListForm)this.form).getFilterAssignedRoom());
            this.sessionContext.getUser().setProperty("ClassList.filterInstructor", ((ClassListForm)this.form).getFilterInstructor());
            this.sessionContext.getUser().setProperty("ClassList.filterManager", ((ClassListForm)this.form).getFilterManager());
            this.sessionContext.getUser().setProperty("ClassList.filterIType", ((ClassListForm)this.form).getFilterIType());
            this.sessionContext.getUser().setProperty("ClassList.filterDayCode", String.valueOf(((ClassListForm)this.form).getFilterDayCode()));
            this.sessionContext.getUser().setProperty("ClassList.filterStartSlot", String.valueOf(((ClassListForm)this.form).getFilterStartSlot()));
            this.sessionContext.getUser().setProperty("ClassList.filterLength", String.valueOf(((ClassListForm)this.form).getFilterLength()));
            this.sessionContext.getUser().setProperty("ClassList.sortByKeepSubparts", ((ClassListForm)this.form).getSortByKeepSubparts() ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.showCrossListedClasses", ((ClassListForm)this.form).getShowCrossListedClasses() ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.filterNeedInstructor", ((ClassListForm)this.form).getFilterNeedInstructor() ? "1" : "0");
            this.sessionContext.getUser().setProperty("ClassList.includeCancelledClasses", ((ClassListForm)this.form).getIncludeCancelledClasses() ? "1" : "0");
        }
        if (!this.sessionContext.hasPermission(Right.Examinations)) {
            ((ClassListForm)this.form).setExams(null);
        }
        if (!ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
            ((ClassListForm)this.form).setFundingDepartment(false);
        }
        ((ClassListForm)this.form).setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
        ((ClassListForm)this.form).validate(this);
        if (this.hasFieldErrors()) {
            this.setShowTable(false);
            return "showClassSearch";
        }
        ((ClassListForm)this.form).setClasses(ClassSearchAction.getClasses((ClassListFormInterface)((Object)this.form), WebSolver.getClassAssignmentProxy(this.request.getSession())));
        Collection<Class_> classes = ((ClassListForm)this.form).getClasses();
        if (classes.isEmpty()) {
            this.addFieldError("searchResult", MSG.errorNoRecords());
            this.setShowTable(false);
            return "showClassSearch";
        }
        StringBuffer ids = new StringBuffer();
        StringBuffer names = new StringBuffer();
        StringBuffer subjIds = new StringBuffer();
        for (int i = 0; i < ((ClassListForm)this.form).getSubjectAreaIds().length; ++i) {
            if (i > 0) {
                names.append(",");
                subjIds.append(",");
            }
            ids.append("&subjectAreaIds=" + ((ClassListForm)this.form).getSubjectAreaIds()[i]);
            subjIds.append(((ClassListForm)this.form).getSubjectAreaIds()[i]);
            names.append(((SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(((ClassListForm)this.form).getSubjectAreaIds()[i]))).getSubjectAreaAbbreviation());
        }
        this.sessionContext.setAttribute(SessionAttribute.ClassesSubjectAreas, (Object)subjIds);
        this.sessionContext.setAttribute(SessionAttribute.ClassesCourseNumber, (Object)((ClassListForm)this.form).getCourseNbr());
        if ("exportPdf".equals(action)) {
            OutputStream out = ExportUtils.getPdfOutputStream(this.response, "classes");
            new PdfClassListTableBuilder().pdfTableForClasses(out, WebSolver.getClassAssignmentProxy(this.request.getSession()), WebSolver.getExamSolver(this.request.getSession()), (ClassListForm)this.form, this.sessionContext);
            out.flush();
            out.close();
            return null;
        }
        if ("exportCsv".equals(action)) {
            PrintWriter out = ExportUtils.getCsvWriter(this.response, "classes");
            new CsvClassListTableBuilder().csvTableForClasses(out, WebSolver.getClassAssignmentProxy(this.request.getSession()), WebSolver.getExamSolver(this.request.getSession()), (ClassListForm)this.form, this.sessionContext);
            out.flush();
            out.close();
            return null;
        }
        BackTracker.markForBack(this.request, "classSearch.action?doit=Search&loadFilter=1" + String.valueOf(ids) + "&courseNbr=" + URLEncoder.encode(((ClassListForm)this.form).getCourseNbr(), "utf-8"), MSG.backClasses(String.valueOf(names) + (String)(((ClassListForm)this.form).getCourseNbr() == null || ((ClassListForm)this.form).getCourseNbr().length() == 0 ? "" : " " + ((ClassListForm)this.form).getCourseNbr())), true, true);
        this.setShowTable(true);
        return "showClassSearch";
    }

    public static void setupGeneralFormFilters(SessionContext sessionContext, ClassListFormInterface form) {
        form.setSortBy(sessionContext.getUser().getProperty("ClassList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)));
        form.setFilterAssignedRoom(sessionContext.getUser().getProperty("ClassList.filterAssignedRoom", ""));
        form.setFilterManager(sessionContext.getUser().getProperty("ClassList.filterManager", ""));
        form.setFilterIType(sessionContext.getUser().getProperty("ClassList.filterIType", ""));
        form.setFilterDayCode(Integer.parseInt(sessionContext.getUser().getProperty("ClassList.filterDayCode", "-1")));
        form.setFilterStartSlot(Integer.parseInt(sessionContext.getUser().getProperty("ClassList.filterStartSlot", "-1")));
        form.setFilterLength(Integer.parseInt(sessionContext.getUser().getProperty("ClassList.filterLength", "-1")));
        form.setSortByKeepSubparts("1".equals(sessionContext.getUser().getProperty("ClassList.sortByKeepSubparts", "1")));
        form.setShowCrossListedClasses("1".equals(sessionContext.getUser().getProperty("ClassList.showCrossListedClasses", "0")));
    }

    public static void setupClassListSpecificFormFilters(SessionContext sessionContext, ClassListForm form) {
        form.setDivSec("1".equals(sessionContext.getUser().getProperty("ClassList.divSec", "0")));
        form.setLimit("1".equals(sessionContext.getUser().getProperty("ClassList.limit", "1")));
        form.setSnapshotLimit("1".equals(sessionContext.getUser().getProperty("ClassList.snapshotLimit", "1")));
        form.setRoomLimit("1".equals(sessionContext.getUser().getProperty("ClassList.roomLimit", "1")));
        form.setManager("1".equals(sessionContext.getUser().getProperty("ClassList.manager", "1")));
        form.setDatePattern("1".equals(sessionContext.getUser().getProperty("ClassList.datePattern", "1")));
        form.setTimePattern("1".equals(sessionContext.getUser().getProperty("ClassList.timePattern", "1")));
        form.setInstructor("1".equals(sessionContext.getUser().getProperty("ClassList.instructor", "1")));
        form.setInstructorAssignment("1".equals(sessionContext.getUser().getProperty("ClassList.instructorAssignment", "1")));
        if (LearningManagementSystemInfo.isLmsInfoDefinedForSession(sessionContext.getUser().getCurrentAcademicSessionId())) {
            form.setLms("1".equals(sessionContext.getUser().getProperty("ClassList.lms", "1")));
        } else {
            form.setLms(null);
        }
        form.setPreferences("1".equals(sessionContext.getUser().getProperty("ClassList.preferences", "1")));
        form.setTimetable("1".equals(sessionContext.getUser().getProperty("ClassList.timetable", "1")));
        form.setFilterInstructor(sessionContext.getUser().getProperty("ClassList.filterInstructor", ""));
        form.setSchedulePrintNote("1".equals(sessionContext.getUser().getProperty("ClassList.schedulePrintNote", "1")));
        form.setNote("1".equals(sessionContext.getUser().getProperty("ClassList.note", "0")));
        form.setExams("1".equals(sessionContext.getUser().getProperty("ClassList.exams", "0")));
        if (StudentClassEnrollment.sessionHasEnrollments(sessionContext.getUser().getCurrentAcademicSessionId())) {
            form.setDemandIsVisible(true);
            form.setDemand("1".equals(sessionContext.getUser().getProperty("ClassList.demand", "1")));
        } else {
            form.setDemandIsVisible(false);
            form.setDemand(false);
        }
        form.setFilterNeedInstructor("1".equals(sessionContext.getUser().getProperty("ClassList.filterNeedInstructor", "0")));
        form.setIncludeCancelledClasses("1".equals(sessionContext.getUser().getProperty("ClassList.includeCancelledClasses", "1")));
        form.setFundingDepartment("1".equals(sessionContext.getUser().getProperty("ClassList.fundingDepartment", "0")));
    }

    public static Set getClasses(ClassListFormInterface form, ClassAssignmentProxy classAssignmentProxy) {
        Session hibSession = InstructionalOfferingDAO.getInstance().getSession();
        HashSet<Long> filterManagers = new HashSet<Long>();
        if (form.getFilterManager() != null) {
            for (String filterManager : form.getFilterManagers()) {
                if (filterManager.isEmpty() || "-1".equals(filterManager)) {
                    filterManagers.clear();
                    break;
                }
                filterManagers.add(Long.valueOf(filterManager));
            }
        }
        boolean fetchStructure = true;
        boolean fetchCredits = false;
        boolean fetchInstructors = false;
        boolean fetchPreferences = false;
        boolean fetchAssignments = false;
        String[] subjectIds = form.getSubjectAreaIds();
        if (subjectIds != null && subjectIds.length > 0) {
            boolean doFilterAssignedTime;
            StringBuffer query = new StringBuffer();
            query.append("select c, co from Class_ as c ");
            if (fetchStructure) {
                query.append("left join fetch c.childClasses as cc ");
                query.append("left join fetch c.schedulingSubpart as ss ");
                query.append("left join fetch ss.childSubparts as css ");
                query.append("left join fetch ss.instrOfferingConfig as ioc ");
                query.append("left join fetch ioc.instructionalOffering as io ");
                query.append("left join fetch io.courseOfferings as cox ");
            }
            if (fetchCredits) {
                query.append("left join fetch ss.creditConfigs as ssc ");
            }
            if (fetchPreferences || fetchInstructors) {
                query.append("left join fetch c.classInstructors as ci ");
                query.append("left join fetch ci.instructor as di ");
            }
            if (fetchAssignments) {
                query.append("left join fetch c.assignments as ca ");
                query.append("left join fetch ca.rooms as car ");
            }
            if (fetchPreferences) {
                query.append("left join fetch c.preferences as cp ");
                query.append("left join fetch ss.preferences as ssp ");
                query.append("left join fetch di.preferences as dip ");
            }
            query.append("inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co ");
            query.append(" where co.subjectArea.uniqueId in ( ");
            boolean first = true;
            for (int i = 0; i < subjectIds.length; ++i) {
                if (!first) {
                    query.append(", ");
                } else {
                    first = false;
                }
                query.append(subjectIds[i]);
            }
            query.append(") ");
            String courseNbr = form.getCourseNbr();
            if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && courseNbr != null && courseNbr.length() > 2) {
                if (courseNbr.indexOf(42) >= 0) {
                    query.append(" and (co.courseNbr like :courseNbr or lower(co.title) like lower(:courseNbr))");
                } else {
                    query.append(" and (co.courseNbr = :courseNbr or lower(co.title) like ('%' || lower(:courseNbr) || '%'))");
                }
            } else if (form.getCourseNbr() != null && form.getCourseNbr().length() > 0) {
                if (courseNbr.indexOf(42) >= 0) {
                    query.append(" and co.courseNbr like :courseNbr ");
                } else {
                    query.append(" and co.courseNbr = :courseNbr ");
                }
            }
            boolean hasDeptIds = false;
            if (!filterManagers.isEmpty()) {
                if (filterManagers.contains(-2L) && filterManagers.size() == 1) {
                    query.append(" and c.managingDept = co.subjectArea.department");
                } else if (filterManagers.contains(-2L)) {
                    query.append(" and (c.managingDept = co.subjectArea.department or c.managingDept.uniqueId in :deptIds)");
                    hasDeptIds = true;
                } else {
                    query.append(" and c.managingDept.uniqueId in :deptIds");
                    hasDeptIds = true;
                }
            }
            if (!form.getShowCrossListedClasses()) {
                query.append(" and co.isControl = true ");
            }
            if (!form.getIncludeCancelledClasses() || form.getFilterNeedInstructor()) {
                query.append(" and c.cancelled = false");
            }
            if (form.getFilterNeedInstructor()) {
                query.append(" and (select sum(tr.teachingRequest.nbrInstructors) from TeachingClassRequest tr where tr.assignInstructor = true and  tr.teachingClass = c) > 0");
            }
            Query q = hibSession.createQuery(query.toString(), Object[].class);
            q.setFetchSize(1000);
            if (courseNbr != null && courseNbr.length() > 0) {
                if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
                    courseNbr = courseNbr.toUpperCase();
                }
                q.setParameter("courseNbr", (Object)courseNbr.replace('*', '%'));
            }
            if (hasDeptIds) {
                q.setParameterList("deptIds", filterManagers);
            }
            q.setCacheable(true);
            TreeSet<Object[]> ts = new TreeSet<Object[]>(new ClassCourseComparator(form.getSortBy(), classAssignmentProxy, form.getSortByKeepSubparts()));
            long sTime = new Date().getTime();
            boolean doFilterInstructor = form.getFilterInstructor() != null && form.getFilterInstructor().length() > 0;
            String filterInstructor = doFilterInstructor ? form.getFilterInstructor().toUpperCase() : null;
            boolean doFilterAssignedRoom = form.getFilterAssignedRoom() != null && form.getFilterAssignedRoom().length() > 0;
            String filterAssignedRoom = doFilterAssignedRoom ? form.getFilterAssignedRoom().toUpperCase() : null;
            boolean doFilterIType = form.getFilterIType() != null && form.getFilterIType().length() > 0;
            Integer filterIType = doFilterIType ? Integer.valueOf(form.getFilterIType()) : null;
            boolean bl = doFilterAssignedTime = form.getFilterDayCode() >= 0 && form.getFilterStartSlot() >= 0 && form.getFilterLength() >= 0 || form.getFilterDayCode() > 0 && form.getFilterStartSlot() < 0 && form.getFilterLength() <= 0;
            TimeLocation filterAssignedTime = doFilterAssignedTime ? new TimeLocation(form.getFilterDayCode() == 0 ? 255 : form.getFilterDayCode(), form.getFilterStartSlot() < 0 ? 0 : form.getFilterStartSlot(), form.getFilterStartSlot() < 0 ? 288 : Math.max(5, Constants.SLOT_LENGTH_MIN + form.getFilterLength() - 1) / Constants.SLOT_LENGTH_MIN, 0, 0.0, null, null, null, 0) : null;
            Debug.debug(" --- Filter classes ---");
            for (Object[] o : q.list()) {
                Placement p;
                Class_ c = (Class_)o[0];
                if (doFilterInstructor) {
                    boolean filterLine = true;
                    for (ClassInstructor ci : c.getClassInstructors()) {
                        StringTokenizer stk = new StringTokenizer(filterInstructor, " ,");
                        boolean containsInstructor = true;
                        while (stk.hasMoreTokens()) {
                            String token = stk.nextToken();
                            boolean containsToken = false;
                            if (ci.getInstructor().getFirstName() != null && ci.getInstructor().getFirstName().toUpperCase().indexOf(token) >= 0) {
                                containsToken = true;
                            }
                            if (!containsToken && ci.getInstructor().getMiddleName() != null && ci.getInstructor().getMiddleName().toUpperCase().indexOf(token) >= 0) {
                                containsToken = true;
                            }
                            if (!containsToken && ci.getInstructor().getLastName() != null && ci.getInstructor().getLastName().toUpperCase().indexOf(token) >= 0) {
                                containsToken = true;
                            }
                            if (containsToken) continue;
                            containsInstructor = false;
                            break;
                        }
                        if (!containsInstructor) continue;
                        filterLine = false;
                        break;
                    }
                    if (filterLine) continue;
                }
                if (doFilterIType) {
                    boolean match = false;
                    for (ItypeDesc itype = c.getSchedulingSubpart().getItype(); !match && itype != null; itype = itype.getParent()) {
                        match = itype.getItype().equals(filterIType);
                    }
                    if (!match) continue;
                }
                if (doFilterAssignedTime) {
                    try {
                        boolean overlap;
                        TimeLocation t;
                        ClassAssignmentProxy.AssignmentInfo a = classAssignmentProxy.getAssignment(c);
                        if (a == null || (p = a.getPlacement()) == null || (t = p.getTimeLocation()) == null) continue;
                        boolean bl2 = overlap = t.shareDays(filterAssignedTime) && t.shareHours(filterAssignedTime);
                        if (!overlap) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (doFilterAssignedRoom) {
                    try {
                        ClassAssignmentProxy.AssignmentInfo a = classAssignmentProxy.getAssignment(c);
                        if (a == null || (p = a.getPlacement()) == null || p.getNrRooms() <= 0) continue;
                        boolean filterLine = true;
                        if (p.isMultiRoom()) {
                            for (RoomLocation r : p.getRoomLocations()) {
                                if (r.getName().toUpperCase().indexOf(filterAssignedRoom) < 0) continue;
                                filterLine = false;
                                break;
                            }
                        } else if (p.getRoomLocation().getName().toUpperCase().indexOf(filterAssignedRoom) >= 0) {
                            filterLine = false;
                        }
                        if (filterLine) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                }
                ts.add(o);
            }
            long eTime = new Date().getTime();
            Debug.debug("fetch time = " + (eTime - sTime));
            Debug.debug("rows = " + ts.size());
            return ts;
        }
        return new TreeSet();
    }

    public List<IdValue> getManagers() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        ret.add(new IdValue(-2L, MSG.dropDeptDepartment()));
        for (Department d : (TreeSet)this.request.getAttribute(Department.EXTERNAL_DEPT_ATTR_NAME)) {
            ret.add(new IdValue(d.getUniqueId(), d.getManagingDeptLabel()));
        }
        return ret;
    }

    public int getFilterManagerSize() {
        int size = 1 + ((TreeSet)this.request.getAttribute(Department.EXTERNAL_DEPT_ATTR_NAME)).size();
        return Math.min(size, 3);
    }

    public String printTable() throws Exception {
        new WebClassListTableBuilder().htmlTableForClasses(this.sessionContext, this.getClassAssignmentService().getAssignment(), this.getExaminationSolverService().getSolver(), (ClassListForm)this.form, this.getPageContext().getOut(), this.request.getParameter("backType"), this.request.getParameter("backId"));
        return "";
    }
}

