/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.neighbourhoods;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.heuristics.NeighbourSelectionWithSuggestions;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class Suggestion
extends NeighbourSelectionWithSuggestions {
    private boolean iAllowUnassignments = false;

    public Suggestion(DataProperties properties) throws Exception {
        super(properties);
        this.iAllowUnassignments = properties.getPropertyBoolean("Suggestion.AllowUnassignments", this.iAllowUnassignments);
    }

    @Override
    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        Collection<Lecture> unassigned = solution.getModel().unassignedVariables(solution.getAssignment());
        if (!unassigned.isEmpty()) {
            int depth;
            Lecture lecture = ToolBox.random(unassigned);
            Neighbour<Lecture, Placement> neigbour = this.selectNeighbourWithSuggestions(solution, lecture, depth = Math.max(2, ToolBox.random(this.iSuggestionDepth)));
            if (neigbour != null) {
                return new SuggestionNeighbour(neigbour);
            }
            Placement placement = ToolBox.random(lecture.values(solution.getAssignment()));
            if (placement != null) {
                Set<Object> conflicts = new HashSet();
                if (this.iStat != null) {
                    for (Map.Entry<Constraint<Lecture, Placement>, Set<Placement>> entry : solution.getModel().conflictConstraints(solution.getAssignment(), placement).entrySet()) {
                        this.iStat.constraintAfterAssigned(solution.getAssignment(), solution.getIteration(), entry.getKey(), placement, entry.getValue());
                        conflicts.addAll((Collection<Object>)entry.getValue());
                    }
                } else {
                    conflicts = solution.getModel().conflictValues(solution.getAssignment(), placement);
                }
                if (!conflicts.contains(placement) && (this.iAllowUnassignments || conflicts.size() <= 1)) {
                    return new SimpleNeighbour<Lecture, Object>(lecture, placement, conflicts);
                }
            }
        }
        return null;
    }

    static class SuggestionNeighbour
    implements Neighbour<Lecture, Placement> {
        Neighbour<Lecture, Placement> iNeigbour;

        SuggestionNeighbour(Neighbour<Lecture, Placement> neigbour) {
            this.iNeigbour = neigbour;
        }

        @Override
        public void assign(Assignment<Lecture, Placement> assignment, long iteration) {
            this.iNeigbour.assign(assignment, iteration);
        }

        @Override
        public double value(Assignment<Lecture, Placement> assignment) {
            return -1.0;
        }

        @Override
        public Map<Lecture, Placement> assignments() {
            return this.iNeigbour.assignments();
        }
    }
}

