/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.ToolBox;

public class NeighbourSelectionWithSuggestions
extends StandardNeighbourSelection<Lecture, Placement> {
    private double iSuggestionProbability = 0.1;
    private double iSuggestionProbabilityAllAssigned = 0.5;
    protected int iSuggestionTimeout = 500;
    protected int iSuggestionDepth = 4;

    public NeighbourSelectionWithSuggestions(DataProperties properties) throws Exception {
        super(properties);
        this.iSuggestionProbability = properties.getPropertyDouble("Neighbour.SuggestionProbability", this.iSuggestionProbability);
        this.iSuggestionProbabilityAllAssigned = properties.getPropertyDouble("Neighbour.SuggestionProbabilityAllAssigned", this.iSuggestionProbabilityAllAssigned);
        this.iSuggestionTimeout = properties.getPropertyInt("Neighbour.SuggestionTimeout", this.iSuggestionTimeout);
        this.iSuggestionDepth = properties.getPropertyInt("Neighbour.SuggestionDepth", this.iSuggestionDepth);
    }

    public NeighbourSelectionWithSuggestions(Solver<Lecture, Placement> solver) throws Exception {
        this(solver.getProperties());
        this.init(solver);
    }

    @Override
    public void init(Solver<Lecture, Placement> solver) {
        super.init(solver);
    }

    @Override
    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        Neighbour<Lecture, Placement> neighbour = null;
        if (solution.getModel().unassignedVariables(solution.getAssignment()).isEmpty()) {
            for (int d = this.iSuggestionDepth; d > 1; --d) {
                if (!(ToolBox.random() < Math.pow(this.iSuggestionProbabilityAllAssigned, d - 1))) continue;
                neighbour = this.selectNeighbourWithSuggestions(solution, this.selectVariable(solution), d);
                break;
            }
        } else {
            for (int d = this.iSuggestionDepth; d > 1; --d) {
                if (!(ToolBox.random() < Math.pow(this.iSuggestionProbability, d - 1))) continue;
                neighbour = this.selectNeighbourWithSuggestions(solution, this.selectVariable(solution), d);
                break;
            }
        }
        return neighbour != null ? neighbour : super.selectNeighbour(solution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Neighbour<Lecture, Placement> selectNeighbourWithSuggestions(Solution<Lecture, Placement> solution, Lecture lecture, int depth) {
        if (lecture == null) {
            return null;
        }
        NeighbourSelectionWithSuggestionsContext context = new NeighbourSelectionWithSuggestionsContext(solution);
        Lock lock = solution.getLock().writeLock();
        lock.lock();
        try {
            ArrayList<Lecture> initialLectures = new ArrayList<Lecture>(1);
            initialLectures.add(lecture);
            this.backtrack(context, initialLectures, new HashMap<Lecture, Placement>(), new HashMap<Lecture, Placement>(), depth);
        }
        finally {
            lock.unlock();
        }
        return context.getSuggestionNeighbour();
    }

    private boolean containsCommited(NeighbourSelectionWithSuggestionsContext context, Collection<Placement> values) {
        if (context.getModel().hasConstantVariables()) {
            for (Placement placement : values) {
                Lecture lecture = (Lecture)placement.variable();
                if (!lecture.isCommitted()) continue;
                return true;
            }
        }
        return false;
    }

    private void backtrack(NeighbourSelectionWithSuggestionsContext context, List<Lecture> initialLectures, Map<Lecture, Placement> resolvedLectures, HashMap<Lecture, Placement> conflictsToResolve, int depth) {
        int nrUnassigned = conflictsToResolve.size();
        if ((initialLectures == null || initialLectures.isEmpty()) && nrUnassigned == 0) {
            context.setSuggestionNeighbourIfImproving(resolvedLectures);
            return;
        }
        if (depth <= 0 || context.checkTimeoutReached()) {
            return;
        }
        Assignment<Lecture, Placement> assignment = context.getAssignment();
        block0: for (Lecture lecture : initialLectures != null && !initialLectures.isEmpty() ? initialLectures : new ArrayList<Lecture>(conflictsToResolve.keySet())) {
            if (context.isTimeoutReached()) break;
            if (resolvedLectures.containsKey(lecture)) continue;
            List<Placement> placements = lecture.values(assignment);
            int rnd = ToolBox.random(placements.size());
            block1: for (int idx = 0; idx < placements.size(); ++idx) {
                Set<Placement> conflicts;
                Placement placement = placements.get((idx + rnd) % placements.size());
                if (context.isTimeoutReached()) continue block0;
                Placement cur = assignment.getValue(lecture);
                if (placement.equals(cur) || placement.isHard(assignment) || nrUnassigned + (conflicts = context.getModel().conflictValues(assignment, placement)).size() > depth || conflicts.contains(placement) || this.containsCommited(context, conflicts)) continue;
                for (Placement c : conflicts) {
                    if (!resolvedLectures.containsKey(c.variable())) continue;
                    continue block1;
                }
                for (Placement c : conflicts) {
                    assignment.unassign(0L, (Lecture)c.variable());
                }
                assignment.assign(0L, placement);
                for (Placement c : conflicts) {
                    conflictsToResolve.put((Lecture)c.variable(), c);
                }
                Placement resolvedConf = conflictsToResolve.remove(lecture);
                resolvedLectures.put(lecture, placement);
                this.backtrack(context, null, resolvedLectures, conflictsToResolve, depth - 1);
                resolvedLectures.remove(lecture);
                if (cur == null) {
                    assignment.unassign(0L, lecture);
                } else {
                    assignment.assign(0L, cur);
                }
                for (Placement p : conflicts) {
                    assignment.assign(0L, p);
                    conflictsToResolve.remove(p.variable());
                }
                if (resolvedConf == null) continue;
                conflictsToResolve.put(lecture, resolvedConf);
            }
        }
    }

    public class NeighbourSelectionWithSuggestionsContext {
        private Solution<Lecture, Placement> iSolution = null;
        private SuggestionNeighbour iSuggestionNeighbour = null;
        private double iValue = 0.0;
        private int iNrAssigned = 0;
        private boolean iTimeoutReached = false;
        private long iStartTime;

        public NeighbourSelectionWithSuggestionsContext(Solution<Lecture, Placement> solution) {
            this.iSolution = solution;
            this.iSuggestionNeighbour = null;
            this.iValue = solution.getModel().getTotalValue(solution.getAssignment());
            this.iNrAssigned = solution.getAssignment().nrAssignedVariables();
            this.iTimeoutReached = false;
            this.iStartTime = JProf.currentTimeMillis();
        }

        public SuggestionNeighbour getSuggestionNeighbour() {
            return this.iSuggestionNeighbour;
        }

        public boolean setSuggestionNeighbourIfImproving(Map<Lecture, Placement> assignment) {
            if (this.getAssignment().nrAssignedVariables() > this.getNrAssigned() || this.getAssignment().nrAssignedVariables() == this.getNrAssigned() && this.getValue() > this.getModel().getTotalValue(this.getAssignment())) {
                double value = this.getModel().getTotalValue(this.getAssignment());
                if (this.getSuggestionNeighbour() == null || this.getSuggestionNeighbour().value(this.getAssignment()) >= value) {
                    this.iSuggestionNeighbour = new SuggestionNeighbour(assignment, value);
                    return true;
                }
            }
            return false;
        }

        public Solution<Lecture, Placement> getSolution() {
            return this.iSolution;
        }

        public Assignment<Lecture, Placement> getAssignment() {
            return this.getSolution().getAssignment();
        }

        public TimetableModel getModel() {
            return (TimetableModel)this.getSolution().getModel();
        }

        public int getNrAssigned() {
            return this.iNrAssigned;
        }

        public double getValue() {
            return this.iValue;
        }

        public boolean isTimeoutReached() {
            return this.iTimeoutReached;
        }

        public boolean checkTimeoutReached() {
            if (this.iTimeoutReached) {
                return true;
            }
            if (NeighbourSelectionWithSuggestions.this.iSuggestionTimeout > 0 && JProf.currentTimeMillis() - this.iStartTime > (long)NeighbourSelectionWithSuggestions.this.iSuggestionTimeout) {
                this.iTimeoutReached = true;
            }
            return this.iTimeoutReached;
        }

        public void setTimeoutReached(boolean timeoutReached) {
            this.iTimeoutReached = timeoutReached;
        }
    }

    public class SuggestionNeighbour
    implements Neighbour<Lecture, Placement> {
        private double iValue = 0.0;
        private List<Placement> iDifferentAssignments = null;

        public SuggestionNeighbour(Map<Lecture, Placement> resolvedLectures, double value) {
            this.iValue = value;
            this.iDifferentAssignments = new ArrayList<Placement>(resolvedLectures.values());
        }

        @Override
        public double value(Assignment<Lecture, Placement> assignment) {
            return this.iValue;
        }

        @Override
        public void assign(Assignment<Lecture, Placement> assignment, long iteration) {
            for (Placement p : this.iDifferentAssignments) {
                assignment.unassign(iteration, (Lecture)p.variable());
            }
            for (Placement p : this.iDifferentAssignments) {
                assignment.assign(iteration, p);
            }
        }

        public int compareTo(Solution<Lecture, Placement> solution) {
            return Double.compare(this.iValue, solution.getModel().getTotalValue(solution.getAssignment()));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Suggestion{value=" + this.iValue + ": ");
            Iterator<Placement> e = this.iDifferentAssignments.iterator();
            while (e.hasNext()) {
                Placement p = e.next();
                sb.append("\n    " + ((Lecture)p.variable()).getName() + " " + p.getName() + (e.hasNext() ? "," : ""));
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public Map<Lecture, Placement> assignments() {
            HashMap<Lecture, Placement> ret = new HashMap<Lecture, Placement>();
            for (Placement p : this.iDifferentAssignments) {
                ret.put((Lecture)p.variable(), p);
            }
            return ret;
        }
    }
}

