/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.Set;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.DataProperties;

public class DiscouragedRoomConstraint
extends RoomConstraint
implements WeakeningConstraint<Lecture, Placement> {
    private int iUnassignmentsToWeaken = 1000;

    public DiscouragedRoomConstraint(DataProperties config, Long id, String name, Long buildingId, int capacity, RoomSharingModel roomSharingModel, Double x, Double y, boolean ignoreTooFar, boolean constraint) {
        super(id, name, buildingId, capacity, roomSharingModel, x, y, ignoreTooFar, constraint);
        this.iUnassignmentsToWeaken = config.getPropertyInt("DiscouragedRoom.Unassignments2Weaken", this.iUnassignmentsToWeaken);
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        if (!this.getConstraint() || !value.hasRoomLocation(this.getResourceId())) {
            return;
        }
        super.computeConflicts(assignment, value, conflicts);
        if (((DiscouragedRoomConstraintContext)this.getContext((Assignment)assignment)).isOverLimit(assignment, value)) {
            conflicts.add(value);
        }
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement value) {
        if (!this.getConstraint() || !value.hasRoomLocation(this.getResourceId())) {
            return false;
        }
        return ((DiscouragedRoomConstraintContext)this.getContext((Assignment)assignment)).isOverLimit(assignment, value) || super.inConflict(assignment, value);
    }

    @Override
    public String getName() {
        return "discouraged " + super.getName();
    }

    @Override
    public String toString() {
        return "Discouraged " + super.toString();
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment) {
        ((DiscouragedRoomConstraintContext)this.getContext((Assignment)assignment)).weaken();
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
        ((DiscouragedRoomConstraintContext)this.getContext((Assignment)assignment)).weaken(assignment, value);
    }

    @Override
    public RoomConstraint.RoomConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new DiscouragedRoomConstraintContext(assignment);
    }

    @Override
    public void unassigned(Assignment<Lecture, Placement> assignment, long iteration, Placement placement) {
        super.unassigned(assignment, iteration, placement);
        if (!placement.hasRoomLocation(this.getResourceId())) {
            ((DiscouragedRoomConstraintContext)this.getContext((Assignment)assignment)).weaken();
        }
    }

    public class DiscouragedRoomConstraintContext
    extends RoomConstraint.RoomConstraintContext {
        int iUsage;
        int iLimit;
        private long iUnassignment;

        public DiscouragedRoomConstraintContext(Assignment<Lecture, Placement> assignment) {
            super(assignment);
            this.iUsage = 0;
            this.iLimit = 0;
            this.iUnassignment = 0L;
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            super.assigned(assignment, placement);
            if (placement.hasRoomLocation(DiscouragedRoomConstraint.this.getResourceId()) && !((Lecture)placement.variable()).isCommitted()) {
                ++this.iUsage;
            }
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            super.unassigned(assignment, placement);
            if (placement.hasRoomLocation(DiscouragedRoomConstraint.this.getResourceId()) && !((Lecture)placement.variable()).isCommitted()) {
                --this.iUsage;
            }
        }

        public int getLimit() {
            return this.iLimit;
        }

        public int getUsage() {
            return this.iUsage;
        }

        public boolean isOverLimit(Assignment<Lecture, Placement> assignment, Placement value) {
            if (DiscouragedRoomConstraint.this.iUnassignmentsToWeaken == 0) {
                return false;
            }
            if (!value.hasRoomLocation(DiscouragedRoomConstraint.this.getResourceId())) {
                return false;
            }
            Lecture lecture = (Lecture)value.variable();
            if (lecture.roomLocations().size() == lecture.getNrRooms()) {
                return false;
            }
            if (lecture.isCommitted()) {
                return false;
            }
            Placement current = assignment.getValue(lecture);
            if (current != null && current.hasRoomLocation(DiscouragedRoomConstraint.this.getResourceId())) {
                return false;
            }
            return this.iUsage + 1 > this.iLimit;
        }

        public void weaken() {
            if (DiscouragedRoomConstraint.this.iUnassignmentsToWeaken == 0) {
                return;
            }
            ++this.iUnassignment;
            if (this.iUnassignment % (long)DiscouragedRoomConstraint.this.iUnassignmentsToWeaken == 0L) {
                ++this.iLimit;
            }
        }

        public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
            while (this.isOverLimit(assignment, value)) {
                ++this.iLimit;
            }
        }
    }
}

