/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ClassAssignmentsReportForm;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseSubjectArea;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.pdf.PdfClassListTableBuilder;

public class PdfClassAssignmentReportListTableBuilder
extends PdfClassListTableBuilder {
    protected Color sDisableColor = Color.BLACK;

    @Override
    protected String additionalNote() {
        return " " + MSG.classAssignmentsAdditionalNote();
    }

    @Override
    protected PdfPCell pdfBuildDatePatternCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        ClassAssignmentProxy.AssignmentInfo a = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        DatePattern dp = a != null ? a.getDatePattern() : prefGroup.effectiveDatePattern();
        PdfPCell cell = this.createCell();
        if (dp != null) {
            Color color = isEditable ? this.sEnableColor : this.sDisableColor;
            this.addText(cell, dp.getName(), false, false, 1, color, true);
        }
        return cell;
    }

    /*
     * WARNING - void declaration
     */
    public void pdfTableForClasses(OutputStream out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, ClassAssignmentsReportForm form, SessionContext context) throws Exception {
        void var9_13;
        this.setVisibleColumns(form);
        Collection<Class_> classes = form.getClasses();
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                if (classAssignment instanceof CachedClassAssignmentProxy) {
                    ((CachedClassAssignmentProxy)classAssignment).setCache(classes);
                }
                for (Object[] objectArray : classes) {
                    Class_ clazz = (Class_)objectArray[0];
                    if (classAssignment.getAssignment(clazz) == null) continue;
                    hasTimetable = true;
                    break;
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        this.setUserSettings(context.getUser());
        if (examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowExam(true);
            this.setShowExamTimetable(true);
            this.setShowExamName(false);
        }
        this.setShowInstructor(true);
        if (this.sessionHasEnrollments(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowDemand(true);
        }
        float[] widths = this.getWidths();
        float totalWidth = 0.0f;
        boolean bl = false;
        while (var9_13 < widths.length) {
            totalWidth += widths[var9_13];
            ++var9_13;
        }
        this.iDocument = new Document(new Rectangle(60.0f + totalWidth, 60.0f + 1.3f * totalWidth), 30.0f, 30.0f, 30.0f, 30.0f);
        this.iWriter = PdfEventHandler.initFooter(this.iDocument, out);
        this.iDocument.open();
        boolean bl2 = false;
        Iterator<Class_> it = classes.iterator();
        BaseSubjectArea subjectArea = null;
        String prevLabel = null;
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            Class_ c = (Class_)o[0];
            CourseOffering co = (CourseOffering)o[1];
            if (subjectArea == null || !subjectArea.getUniqueId().equals(co.getSubjectArea().getUniqueId())) {
                if (this.iPdfTable != null) {
                    this.iDocument.add((Element)this.iPdfTable);
                    this.iDocument.newPage();
                }
                this.iPdfTable = new PdfPTable(this.getWidths());
                this.iPdfTable.setWidthPercentage(100.0f);
                this.iPdfTable.getDefaultCell().setPadding(3.0f);
                this.iPdfTable.getDefaultCell().setBorderWidth(0.0f);
                this.iPdfTable.setSplitRows(false);
                subjectArea = co.getSubjectArea();
                boolean bl3 = false;
                this.iDocument.add((Element)new Paragraph(this.labelForTable((SubjectArea)subjectArea), PdfFont.getBigFont(true)));
                this.iDocument.add((Element)new Paragraph(" "));
                this.pdfBuildTableHeader(context.getUser().getCurrentAcademicSessionId());
            }
            this.pdfBuildClassRow(classAssignment, examAssignment, (bl3 += 1) ? 1 : 0, co, c, "", context, prevLabel);
            prevLabel = c.getClassLabel(co);
        }
        if (this.iPdfTable != null) {
            this.iDocument.add((Element)this.iPdfTable);
        }
        this.iDocument.close();
    }

    @Override
    protected PdfPCell pdfBuildInstructor(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ aClass;
        Color color = isEditable ? this.sEnableColor : this.sDisableColor;
        PdfPCell cell = this.createCell();
        if (prefGroup instanceof Class_ && (aClass = (Class_)prefGroup).isDisplayInstructor().booleanValue()) {
            InstructorComparator ic = new InstructorComparator();
            if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
                ic.setNameFormat(this.getInstructorNameFormat());
            }
            TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(ic);
            sortedInstructors.addAll(aClass.getClassInstructors());
            for (ClassInstructor ci : sortedInstructors) {
                String label = ci.getInstructor().getName(this.getInstructorNameFormat());
                this.addText(cell, label, false, false, 0, color, true);
            }
        }
        return cell;
    }
}

