/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.servlet.ServletRequest;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.RequiredTimeTableModel;

public class RequiredTimeTable {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static GwtMessages MSG = Localization.create(GwtMessages.class);
    private RequiredTimeTableModel iModel = null;
    private String iName = "rtt";

    public static String getTimeGridSize(UserContext user) {
        return UserProperty.GridSize.get(user);
    }

    public static boolean getTimeGridVertical(UserContext user) {
        return CommonValues.VerticalGrid.eq(UserProperty.GridOrientation.get(user));
    }

    public static boolean getTimeGridAsText(UserContext user) {
        return CommonValues.TextGrid.eq(UserProperty.GridOrientation.get(user));
    }

    public RequiredTimeTable(RequiredTimeTableModel model) {
        this.iModel = model;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String print(boolean timeVertical) throws IOException {
        return this.print(true, timeVertical);
    }

    public String exactTime(boolean editable) {
        StringBuffer sb = new StringBuffer();
        int days = 0;
        int startSlot = -1;
        int hour = -1;
        int min = -1;
        int morn = -1;
        try {
            days = this.getModel().getExactDays();
            startSlot = this.getModel().getExactStartSlot();
            int startMin = startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            if (startMin >= 0) {
                min = startMin % 60;
                int startHour = startMin / 60;
                morn = startHour < 12 ? 1 : 0;
                hour = startHour % 12;
                if (hour == 0) {
                    hour = 12;
                }
            }
        }
        catch (NumberFormatException startMin) {
            // empty catch block
        }
        Integer firstDayOfWeek = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
        if (editable) {
            int i;
            for (i = 0; i < Constants.DAY_CODES.length; ++i) {
                int j = firstDayOfWeek == null ? i : (i + firstDayOfWeek) % 7;
                sb.append("<input type='checkbox' name='" + this.iName + "_d" + j + "' " + ((days & Constants.DAY_CODES[j]) != 0 ? "checked" : "") + " />" + CONSTANTS.days()[j] + "&nbsp;&nbsp;\n");
            }
            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n");
            sb.append("<select name='" + this.iName + "_hour' >\n");
            sb.append("<option value=''></option>\n");
            for (i = 1; i <= 12; ++i) {
                sb.append("<option value='" + i + "' " + (i == hour ? "selected" : "") + ">" + i + "</option>\n");
            }
            sb.append("</select> : <select name='" + this.iName + "_min' >\n");
            sb.append("<option value=''></option>\n");
            for (i = 0; i < 60; i += 5) {
                sb.append("<option value='" + i + "' " + (i == min ? "selected" : "") + ">" + (i < 10 ? "0" : "") + i + "</option>\n");
            }
            sb.append("</select> <select name='" + this.iName + "_morn' >\n");
            sb.append("<option value=''></option>\n");
            sb.append("<option value='1' " + (morn == 1 ? "selected" : "") + ">" + CONSTANTS.timeAm() + "</option>\n");
            sb.append("<option value='0' " + (morn == 0 ? "selected" : "") + ">" + CONSTANTS.timePm() + "</option>\n");
            sb.append("</select>");
        } else {
            int i;
            int nrDays = 0;
            for (i = 0; i < Constants.DAY_CODES.length; ++i) {
                if ((days & Constants.DAY_CODES[i]) == 0) continue;
                ++nrDays;
            }
            for (i = 0; i < Constants.DAY_CODES.length; ++i) {
                int j;
                int n = j = firstDayOfWeek == null ? i : (i + firstDayOfWeek) % 7;
                if ((days & Constants.DAY_CODES[j]) == 0) continue;
                sb.append(nrDays == 1 ? CONSTANTS.days()[j] : CONSTANTS.shortDays()[j]);
            }
            sb.append(" " + Constants.slot2str(startSlot));
        }
        return sb.toString();
    }

    public String print(boolean editable, boolean timeVertical) {
        return this.print(editable, timeVertical, true, false);
    }

    public String getDays() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.getModel().getNrDays(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'" + this.getModel().getDayHeader(i) + "'");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getStartTimes() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.getModel().getNrTimes(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'" + this.getModel().getStartTime(i) + "'");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getEndTimes() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.getModel().getNrTimes(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'" + this.getModel().getEndTime(i) + "'");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getPreferences() {
        StringBuffer sb = new StringBuffer("[");
        for (int d = 0; d < this.getModel().getNrDays(); ++d) {
            if (d > 0) {
                sb.append(",");
            }
            sb.append("[");
            for (int t = 0; t < this.getModel().getNrTimes(); ++t) {
                if (t > 0) {
                    sb.append(",");
                }
                sb.append("'" + this.getModel().getPreference(d, t) + "'");
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getTexts() {
        StringBuffer sb = new StringBuffer("[");
        for (int d = 0; d < this.getModel().getNrDays(); ++d) {
            if (d > 0) {
                sb.append(",");
            }
            sb.append("[");
            for (int t = 0; t < this.getModel().getNrTimes(); ++t) {
                if (t > 0) {
                    sb.append(",");
                }
                sb.append("'" + this.getModel().getFieldText(d, t) + "'");
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getBorders() {
        StringBuffer sb = new StringBuffer("[");
        for (int d = 0; d < this.getModel().getNrDays(); ++d) {
            if (d > 0) {
                sb.append(",");
            }
            sb.append("[");
            for (int t = 0; t < this.getModel().getNrTimes(); ++t) {
                Color borderColor;
                if (t > 0) {
                    sb.append(",");
                }
                if ((borderColor = this.getModel().getBorder(d, t)) == null) {
                    sb.append("null");
                    continue;
                }
                sb.append("'rgb(" + borderColor.getRed() + "," + borderColor.getGreen() + "," + borderColor.getBlue() + ") 2px solid'");
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getEditables(boolean editable) {
        StringBuffer sb = new StringBuffer("[");
        for (int d = 0; d < this.getModel().getNrDays(); ++d) {
            if (d > 0) {
                sb.append(",");
            }
            sb.append("[");
            for (int t = 0; t < this.getModel().getNrTimes(); ++t) {
                if (t > 0) {
                    sb.append(",");
                }
                sb.append(editable && this.getModel().isEditable(d, t) ? "true" : "false");
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getPreferenceNames() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.getModel().getPreferenceNames().length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'" + this.getModel().getPreferenceNames()[i] + "'");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getPreferenceColors() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.getModel().getPreferenceNames().length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Color color = this.getModel().getPreferenceColor(this.getModel().getPreferenceNames()[i]);
            sb.append("'rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")'");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getPreferenceTexts() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.getModel().getPreferenceNames().length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'" + this.getModel().getPreferenceText(this.getModel().getPreferenceNames()[i]).replaceAll("'", "&#39;") + "'");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getPreferenceEnables() {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.getModel().getPreferenceNames().length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getModel().isPreferenceEnabled(this.getModel().getPreferenceNames()[i]) ? "true" : "false");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getSelections() {
        if (this.getModel().getNrSelections() == 0) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < this.getModel().getNrSelections(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("[");
            int[] limits = this.getModel().getSelectionLimits(i);
            sb.append("'" + this.getModel().getSelectionName(i) + "',[");
            sb.append(limits[0] + "," + limits[1] + "," + limits[2] + "," + limits[3]);
            sb.append("]]");
        }
        sb.append("]");
        return sb.toString();
    }

    public String print(boolean editable, boolean timeVertical, boolean showLegend, boolean showTexts) {
        return this.print(editable, timeVertical, showLegend, showTexts, null);
    }

    public String print(boolean editable, boolean timeVertical, boolean showLegend, boolean showTexts, String name) {
        if (this.getModel().isExactTime()) {
            return this.exactTime(editable);
        }
        return "<script language=\"javascript\">\ndocument.write(tpGenerate(\n\t'" + this.iName + "',\n\t" + (timeVertical ? "false" : "true") + ",\n\t" + (String)(name == null ? (this.getModel().getName() == null ? "null" : "'" + this.getModel().getName() + "'") : "'" + name + "'") + ",\n\t" + this.getModel().getNrTimes() + ",\n\t" + this.getModel().getNrDays() + ",\n\t" + this.getDays() + ",\n\t" + this.getStartTimes() + ",\n\t" + this.getEndTimes() + ",\n\t" + (showTexts ? this.getTexts() : "null") + ",\n\t" + this.getPreferences() + ",\n\t" + this.getBorders() + ",\n\t" + this.getEditables(editable) + ",\n\t" + this.getPreferenceNames() + ",\n\t" + this.getPreferenceColors() + ",\n\t" + this.getPreferenceTexts() + ",\n\t" + this.getPreferenceEnables() + ",\n\t" + this.getSelections() + ",\n\t" + this.getModel().getDefaultSelection() + ",\n\t'" + this.getModel().getDefaultPreference() + "',\n\t" + (String)(this.getModel().getPreferenceCheck() == null ? "null" : "\"" + this.getModel().getPreferenceCheck() + "\"") + ", \n\t" + showLegend + ", \n\t{'from':'" + MSG.propFrom() + "', 'to':'" + MSG.propTo() + "'}));\n</script>";
    }

    public void update(ServletRequest request) {
        if (this.getModel().isExactTime()) {
            int dayCode = 0;
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                if (request.getParameter(this.iName + "_d" + i) == null) continue;
                dayCode += Constants.DAY_CODES[i];
            }
            int startSlot = -1;
            try {
                if (request.getParameter(this.iName + "_hour") != null) {
                    int hour = Integer.parseInt(request.getParameter(this.iName + "_hour"));
                    if (hour == 12) {
                        hour = 0;
                    }
                    int min = Integer.parseInt(request.getParameter(this.iName + "_min"));
                    boolean morn = Integer.parseInt(request.getParameter(this.iName + "_morn")) == 1;
                    int startTime = (hour + (morn ? 0 : 12)) % 24 * 60 + min;
                    startSlot = (startTime - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                }
            }
            catch (Exception hour) {
                // empty catch block
            }
            this.getModel().setExactDays(dayCode);
            this.getModel().setExactStartSlot(startSlot);
            return;
        }
        for (int d = 0; d < this.getModel().getNrDays(); ++d) {
            for (int t = 0; t < this.getModel().getNrTimes(); ++t) {
                String prefStr = request.getParameter(this.iName + "_req_" + d + "_" + t);
                this.iModel.setPreference(d, t, prefStr == null ? this.getModel().getDefaultPreference() : prefStr);
            }
        }
    }

    public RequiredTimeTableModel getModel() {
        return this.iModel;
    }

    private void putPixel(WritableRaster raster, int x, int y, Color color) {
        raster.setPixel(x, y, new int[]{color.getRed(), color.getGreen(), color.getBlue()});
    }

    private void drawHline(WritableRaster raster, int x, int y, int width, Color color) {
        for (int i = 0; i < width; ++i) {
            this.putPixel(raster, x + i, y, color);
        }
    }

    private void drawVline(WritableRaster raster, int x, int y, int width, Color color) {
        for (int i = 0; i < width; ++i) {
            this.putPixel(raster, x, y + i, color);
        }
    }

    private void fillRect(WritableRaster raster, int x, int y, int width, int height, Color color) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                this.putPixel(raster, x + i, y + j, color);
            }
        }
    }

    public BufferedImage createBufferedImage(boolean timeVertical) {
        return this.createBufferedImage(timeVertical, false);
    }

    public BufferedImage createBufferedImage(boolean timeVertical, boolean highlight) {
        int cellsDown;
        int cellsAcross;
        if (this.getModel().isExactTime()) {
            return null;
        }
        int[] limit = this.getModel().getSelectionLimits(this.getModel().getDefaultSelection());
        int minTime = limit[0];
        int maxTime = limit[1];
        int minDay = limit[2];
        int maxDay = limit[3];
        int timeStep = limit.length >= 5 ? limit[4] : 1;
        int lineWidth = 1;
        int cellWidth = 5;
        int cellX = 0;
        int cellY = 0;
        int dx = 0;
        int dy = 0;
        if (highlight) {
            dx = 3;
            dy = 3;
        }
        if (timeVertical) {
            cellsAcross = maxDay >= minDay ? maxDay - minDay + 1 : maxDay - minDay + 8;
            cellsDown = 1 + (maxTime - minTime) / timeStep;
        } else {
            cellsAcross = 1 + (maxTime - minTime) / timeStep;
            cellsDown = maxDay >= minDay ? maxDay - minDay + 1 : maxDay - minDay + 8;
        }
        BufferedImage image = new BufferedImage((cellsAcross * cellWidth + cellsAcross + 1) * lineWidth + 2 * dx, cellsDown * cellWidth + ((cellsDown + 1) * lineWidth + 2 * dy), 1);
        WritableRaster raster = image.getRaster();
        int width = image.getWidth() - 3 * dx;
        int height = image.getHeight() - 3 * dy;
        if (highlight) {
            int j;
            int i;
            Color color = Color.yellow;
            for (i = 0; i < image.getWidth(); ++i) {
                for (j = 0; j < dx; ++j) {
                    this.putPixel(raster, i, j, color);
                    this.putPixel(raster, i, raster.getHeight() - 1 - j, color);
                }
            }
            for (i = 0; i < image.getHeight(); ++i) {
                for (j = 0; j < dx; ++j) {
                    this.putPixel(raster, j, i, color);
                    this.putPixel(raster, raster.getWidth() - 1 - j, i, color);
                }
            }
        }
        for (int cellY2 = 0; cellY2 < cellsDown + 1; ++cellY2) {
            this.drawHline(raster, dx, dy + cellY2 * (cellWidth + lineWidth), width, Color.darkGray);
            for (int cellX2 = 0; cellX2 < cellsAcross + 1; ++cellX2) {
                this.drawVline(raster, dx + cellX2 * (cellWidth + lineWidth), dy, height, Color.darkGray);
            }
        }
        int day = minDay;
        int idx = 0;
        while (true) {
            if (timeVertical) {
                cellX = idx;
            } else {
                cellY = idx;
            }
            for (int time = minTime; time <= maxTime; time += timeStep) {
                if (timeVertical) {
                    cellY = (time - minTime) / timeStep;
                } else {
                    cellX = (time - minTime) / timeStep;
                }
                String pref = this.iModel.getPreference(day, time);
                if (pref == null) {
                    pref = PreferenceLevel.sNeutral;
                }
                Color color = this.iModel.getPreferenceColor(pref);
                Color borderColor = this.iModel.getBorder(day, time);
                if (borderColor != null) {
                    this.fillRect(raster, dx + cellX * (cellWidth + lineWidth), dy + cellY * (cellWidth + lineWidth), cellWidth + 2, cellWidth + 2, borderColor);
                    this.fillRect(raster, dx + cellX * (cellWidth + lineWidth) + 2, dy + cellY * (cellWidth + lineWidth) + 2, cellWidth - 2, cellWidth - 2, color);
                    continue;
                }
                this.fillRect(raster, dx + cellX * (cellWidth + lineWidth) + 1, dy + cellY * (cellWidth + lineWidth) + 1, cellWidth, cellWidth, color);
            }
            if (day == maxDay) break;
            day = minDay <= maxDay ? ++day : (1 + day) % 7;
            ++idx;
        }
        return image;
    }
}

