/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ExamPdfReportForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.reports.exam.InstructorExamReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.reports.exam.StudentExamReport;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.queue.QueueItem;

public class PdfExamReportQueueItem
extends QueueItem {
    private static final long serialVersionUID = 1L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    public static String TYPE = "PDF Exam Report";
    private ExamPdfReportForm iForm;
    private String iUrl = null;
    private transient ExamSolverProxy iExamSolver;
    private String iName = null;
    private double iProgress = 0.0;
    private boolean iSubjectIndependent = false;

    public PdfExamReportQueueItem(Session session, UserContext owner, ExamPdfReportForm form, HttpServletRequest request, ExamSolverProxy examSolver) {
        super(session, owner);
        int i;
        this.iForm = form;
        this.iUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        this.iExamSolver = examSolver;
        this.iName = ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getLabel() + " ";
        for (i = 0; i < this.iForm.getReports().length; ++i) {
            if (i > 0) {
                this.iName = this.iName + ", ";
            }
            this.iName = this.iName + this.iForm.getReportName(this.iForm.getReports()[i]);
        }
        if (!this.iForm.getAll()) {
            this.iName = this.iName + " (";
            for (i = 0; i < this.iForm.getSubjects().length; ++i) {
                SubjectArea subject = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(this.iForm.getSubjects()[i]));
                if (i > 0) {
                    this.iName = this.iName + ", ";
                }
                this.iName = this.iName + subject.getSubjectAreaAbbreviation();
            }
            this.iName = this.iName + ")";
        }
        this.iSubjectIndependent = owner == null || owner.getCurrentAuthority() == null ? false : owner.getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        this.iForm.setSubjectAreas(SubjectArea.getUserSubjectAreas(owner, false));
    }

    @Override
    public void execute() {
        org.hibernate.Session hibSession = ExamDAO.getInstance().getSession();
        this.createReports(hibSession);
        if (hibSession.isOpen()) {
            hibSession.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createReports(org.hibernate.Session hibSession) {
        try {
            this.iProgress = 0.0;
            this.setStatus(MSG.statusLoadingExams());
            TreeSet<ExamAssignmentInfo> exams = null;
            if (this.iExamSolver != null && this.iExamSolver.getExamTypeId().equals(this.iForm.getExamType()) && ApplicationProperty.ExaminationPdfReportsCanUseSolution.isTrue()) {
                exams = new TreeSet<ExamAssignmentInfo>(this.iExamSolver.getAssignedExams());
                if (this.iForm.getIgnoreEmptyExams()) {
                    Iterator<ExamAssignmentInfo> i = exams.iterator();
                    while (i.hasNext()) {
                        if (!i.next().getStudentIds().isEmpty()) continue;
                        i.remove();
                    }
                }
                if (ApplicationProperty.ExaminationPdfReportsPreloadCrosslistedExams.isTrue()) {
                    Set<Long> studentsOfCourse;
                    Hashtable<Object, Object> course2students;
                    Long courseId;
                    Long studentId;
                    Long ownerId;
                    this.setStatus("  " + MSG.statusFetchingExams());
                    hibSession.createQuery("select o from Exam x inner join x.owners o where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId", ExamOwner.class).setParameter("sessionId", (Object)this.iExamSolver.getSessionId()).setParameter("examTypeId", (Object)this.iExamSolver.getExamTypeId()).setCacheable(true).list();
                    this.setStatus("  " + MSG.statusFetchingRelatedClasses());
                    hibSession.createQuery("select c from Class_ c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:classType and c.uniqueId=o.ownerId", Class_.class).setParameter("sessionId", (Object)this.iExamSolver.getSessionId()).setParameter("examTypeId", (Object)this.iExamSolver.getExamTypeId()).setParameter("classType", (Object)3).setCacheable(true).list();
                    this.setStatus("  " + MSG.statusFetchingRelatedConfigs());
                    hibSession.createQuery("select c from InstrOfferingConfig c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:configType and c.uniqueId=o.ownerId", InstrOfferingConfig.class).setParameter("sessionId", (Object)this.iExamSolver.getSessionId()).setParameter("examTypeId", (Object)this.iExamSolver.getExamTypeId()).setParameter("configType", (Object)2).setCacheable(true).list();
                    this.setStatus("  " + MSG.statusFetchingRelatedCourses());
                    hibSession.createQuery("select c from CourseOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:courseType and c.uniqueId=o.ownerId", CourseOffering.class).setParameter("sessionId", (Object)this.iExamSolver.getSessionId()).setParameter("examTypeId", (Object)this.iExamSolver.getExamTypeId()).setParameter("courseType", (Object)1).setCacheable(true).list();
                    this.setStatus("  " + MSG.statusFetchingRelatedOfferings());
                    hibSession.createQuery("select c from InstructionalOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:offeringType and c.uniqueId=o.ownerId", InstructionalOffering.class).setParameter("sessionId", (Object)this.iExamSolver.getSessionId()).setParameter("examTypeId", (Object)this.iExamSolver.getExamTypeId()).setParameter("offeringType", (Object)0).setCacheable(true).list();
                    Hashtable<Long, Hashtable<Long, Set<Long>>> owner2course2students = new Hashtable<Long, Hashtable<Long, Set<Long>>>();
                    this.setStatus("  " + MSG.statusLoadingStudentsFromClasses());
                    for (Object[] o : hibSession.createQuery("select o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=3 and o.ownerId=c.uniqueId", Object[].class).setParameter("sessionId", (Object)this.iExamSolver.getSessionId()).setParameter("examTypeId", (Object)this.iExamSolver.getExamTypeId()).setCacheable(true).list()) {
                        ownerId = (Long)o[0];
                        studentId = (Long)o[1];
                        courseId = (Long)o[2];
                        course2students = (Hashtable<Long, HashSet<Long>>)owner2course2students.get(ownerId);
                        if (course2students == null) {
                            course2students = new Hashtable<Long, HashSet<Long>>();
                            owner2course2students.put(ownerId, course2students);
                        }
                        if ((studentsOfCourse = (HashSet<Long>)course2students.get(courseId)) == null) {
                            studentsOfCourse = new HashSet<Long>();
                            course2students.put(courseId, studentsOfCourse);
                        }
                        studentsOfCourse.add(studentId);
                    }
                    this.setStatus("  " + MSG.statusLoadingStudentsFromConfigs());
                    for (Object[] o : hibSession.createQuery("select o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c inner join c.schedulingSubpart.instrOfferingConfig ioc where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=2 and o.ownerId=ioc.uniqueId", Object[].class).setParameter("sessionId", (Object)this.iExamSolver.getSessionId()).setParameter("examTypeId", (Object)this.iExamSolver.getExamTypeId()).setCacheable(true).list()) {
                        ownerId = (Long)o[0];
                        studentId = (Long)o[1];
                        courseId = (Long)o[2];
                        course2students = (Hashtable<Long, HashSet<Long>>)owner2course2students.get(ownerId);
                        if (course2students == null) {
                            course2students = new Hashtable<Long, HashSet<Long>>();
                            owner2course2students.put(ownerId, course2students);
                        }
                        if ((studentsOfCourse = (Set)course2students.get(courseId)) == null) {
                            studentsOfCourse = new HashSet();
                            course2students.put(courseId, studentsOfCourse);
                        }
                        studentsOfCourse.add(studentId);
                    }
                    this.setStatus("  " + MSG.statusLoadingStudentsFromCourses());
                    for (Object[] o : hibSession.createQuery("select o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering co where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=1 and o.ownerId=co.uniqueId", Object[].class).setParameter("sessionId", (Object)this.iExamSolver.getSessionId()).setParameter("examTypeId", (Object)this.iExamSolver.getExamTypeId()).setCacheable(true).list()) {
                        ownerId = (Long)o[0];
                        studentId = (Long)o[1];
                        courseId = (Long)o[2];
                        course2students = (Hashtable<Long, HashSet<Long>>)owner2course2students.get(ownerId);
                        if (course2students == null) {
                            course2students = new Hashtable<Long, HashSet<Long>>();
                            owner2course2students.put(ownerId, course2students);
                        }
                        if ((studentsOfCourse = (Set)course2students.get(courseId)) == null) {
                            studentsOfCourse = new HashSet();
                            course2students.put(courseId, studentsOfCourse);
                        }
                        studentsOfCourse.add(studentId);
                    }
                    this.setStatus("  " + MSG.statusLoadingStudentsFromOfferings());
                    for (Object[] o : hibSession.createQuery("select o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering.instructionalOffering io where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=0 and o.ownerId=io.uniqueId", Object[].class).setParameter("sessionId", (Object)this.iExamSolver.getSessionId()).setParameter("examTypeId", (Object)this.iExamSolver.getExamTypeId()).setCacheable(true).list()) {
                        ownerId = (Long)o[0];
                        studentId = (Long)o[1];
                        courseId = (Long)o[2];
                        course2students = owner2course2students.get(ownerId);
                        if (course2students == null) {
                            course2students = new Hashtable();
                            owner2course2students.put(ownerId, course2students);
                        }
                        if ((studentsOfCourse = (Set)course2students.get(courseId)) == null) {
                            studentsOfCourse = new HashSet();
                            course2students.put(courseId, studentsOfCourse);
                        }
                        studentsOfCourse.add(studentId);
                    }
                    for (ExamAssignmentInfo exam : exams) {
                        exam.createSectionsIncludeCrosslistedDummies(owner2course2students);
                    }
                }
            } else {
                exams = PdfLegacyExamReport.loadExams(this.getSessionId(), this.iForm.getExamType(), true, this.iForm.getIgnoreEmptyExams(), true);
            }
            this.iProgress = 0.1;
            Hashtable<CallSite, File> output = new Hashtable<CallSite, File>();
            Hashtable<SubjectArea, Hashtable<CallSite, File>> outputPerSubject = new Hashtable<SubjectArea, Hashtable<CallSite, File>>();
            Hashtable<ExamInfo.ExamInstructorInfo, File> ireports = null;
            Hashtable<Student, File> sreports = null;
            Session session = this.getSession();
            for (int i = 0; i < this.iForm.getReports().length; ++i) {
                this.iProgress = 0.1 + 0.8 / (double)this.iForm.getReports().length * (double)i;
                ExamPdfReportForm.RegisteredReport regReport = ExamPdfReportForm.RegisteredReport.valueOf(this.iForm.getReports()[i]);
                this.setStatus(MSG.statusGeneratingReport(this.iForm.getReportName(regReport)));
                Class<? extends PdfLegacyExamReport> reportClass = regReport.getImplementation();
                Object reportName = null;
                for (Map.Entry<String, Class> entry : PdfLegacyExamReport.sRegisteredReports.entrySet()) {
                    if (!entry.getValue().equals(reportClass)) continue;
                    reportName = entry.getKey();
                }
                if (reportName == null) {
                    reportName = "r" + (i + 1);
                }
                String string = session.getAcademicTerm() + session.getAcademicYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + "_" + (String)reportName;
                if (this.iForm.getAll()) {
                    File file = ApplicationProperties.getTempFile(string, PdfLegacyExamReport.getExtension(this.iForm.getReportMode()).substring(1));
                    this.log("&nbsp;&nbsp;" + MSG.statusWritingReport("<a href='temp/" + file.getName() + "'>" + (String)reportName + PdfLegacyExamReport.getExtension(this.iForm.getReportMode()) + "</a>") + (String)(this.iSubjectIndependent ? " " + MSG.hintNbrExams(exams.size()) : ""));
                    PdfLegacyExamReport report = reportClass.getConstructor(Integer.TYPE, File.class, Session.class, ExamType.class, Collection.class, Collection.class).newInstance(this.iForm.getReportMode().ordinal(), file, SessionDAO.getInstance().get(session.getUniqueId()), ExamTypeDAO.getInstance().get(this.iForm.getExamType()), this.iSubjectIndependent ? null : this.iForm.getSubjectAreas(), exams);
                    report.setDirect(this.iForm.getDirect());
                    report.setM2d(this.iForm.getM2d());
                    report.setBtb(this.iForm.getBtb());
                    report.setDispRooms(this.iForm.getDispRooms());
                    report.setNoRoom(this.iForm.getNoRoom());
                    report.setTotals(this.iForm.getTotals());
                    report.setLimit(this.iForm.getLimit() == null || this.iForm.getLimit().length() == 0 ? -1 : Integer.parseInt(this.iForm.getLimit()));
                    report.setRoomCode(this.iForm.getRoomCodes());
                    report.setDispLimits(this.iForm.getDispLimit());
                    report.setSince(this.iForm.getSince() == null || this.iForm.getSince().length() == 0 ? null : Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT).parse(this.iForm.getSince()));
                    report.setItype(this.iForm.getItype());
                    report.setClassSchedule(this.iForm.getClassSchedule());
                    report.setDispNote(this.iForm.getDispNote());
                    report.setCompact(this.iForm.getCompact());
                    report.setUseRoomDisplayNames(this.iForm.getRoomDispNames());
                    report.printReport();
                    report.close();
                    output.put((CallSite)((Object)((String)reportName + PdfLegacyExamReport.getExtension(this.iForm.getReportMode()))), file);
                    if (report instanceof InstructorExamReport && this.iForm.getEmailInstructors()) {
                        ireports = ((InstructorExamReport)report).printInstructorReports(string, new FileGenerator(string));
                        continue;
                    }
                    if (!(report instanceof StudentExamReport) || !this.iForm.getEmailStudents()) continue;
                    sreports = ((StudentExamReport)report).printStudentReports(string, new FileGenerator(string));
                    continue;
                }
                for (int j = 0; j < this.iForm.getSubjects().length; ++j) {
                    SubjectArea subject = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(this.iForm.getSubjects()[j]));
                    File file = ApplicationProperties.getTempFile(string + "_" + subject.getSubjectAreaAbbreviation(), PdfLegacyExamReport.getExtension(this.iForm.getReportMode()).substring(1));
                    int n = 0;
                    for (ExamAssignmentInfo exam : exams) {
                        if (!exam.isOfSubjectArea(subject)) continue;
                        ++n;
                    }
                    this.log("&nbsp;&nbsp;" + MSG.statusWritingReport("<a href='temp/" + file.getName() + "'>" + subject.getSubjectAreaAbbreviation() + "_" + (String)reportName + PdfLegacyExamReport.getExtension(this.iForm.getReportMode()) + "</a>") + " " + MSG.hintNbrExams(n));
                    ArrayList<SubjectArea> subjects = new ArrayList<SubjectArea>();
                    subjects.add(subject);
                    PdfLegacyExamReport report = reportClass.getConstructor(Integer.TYPE, File.class, Session.class, ExamType.class, Collection.class, Collection.class).newInstance(this.iForm.getReportMode().ordinal(), file, SessionDAO.getInstance().get(session.getUniqueId()), ExamTypeDAO.getInstance().get(this.iForm.getExamType()), subjects, exams);
                    report.setDirect(this.iForm.getDirect());
                    report.setM2d(this.iForm.getM2d());
                    report.setBtb(this.iForm.getBtb());
                    report.setDispRooms(this.iForm.getDispRooms());
                    report.setNoRoom(this.iForm.getNoRoom());
                    report.setTotals(this.iForm.getTotals());
                    report.setLimit(this.iForm.getLimit() == null || this.iForm.getLimit().length() == 0 ? -1 : Integer.parseInt(this.iForm.getLimit()));
                    report.setRoomCode(this.iForm.getRoomCodes());
                    report.setDispLimits(this.iForm.getDispLimit());
                    report.setItype(this.iForm.getItype());
                    report.setClassSchedule(this.iForm.getClassSchedule());
                    report.setDispNote(this.iForm.getDispNote());
                    report.setCompact(this.iForm.getCompact());
                    report.setUseRoomDisplayNames(this.iForm.getRoomDispNames());
                    report.printReport();
                    report.close();
                    output.put((CallSite)((Object)(subject.getSubjectAreaAbbreviation() + "_" + (String)reportName + PdfLegacyExamReport.getExtension(this.iForm.getReportMode()))), file);
                    Hashtable<CallSite, File> files = (Hashtable<CallSite, File>)outputPerSubject.get(subject);
                    if (files == null) {
                        files = new Hashtable<CallSite, File>();
                        outputPerSubject.put(subject, files);
                    }
                    files.put((CallSite)((Object)(subject.getSubjectAreaAbbreviation() + "_" + (String)reportName + PdfLegacyExamReport.getExtension(this.iForm.getReportMode()))), file);
                    if (report instanceof InstructorExamReport && this.iForm.getEmailInstructors()) {
                        ireports = ((InstructorExamReport)report).printInstructorReports(string, new FileGenerator(string));
                        continue;
                    }
                    if (!(report instanceof StudentExamReport) || !this.iForm.getEmailStudents()) continue;
                    sreports = ((StudentExamReport)report).printStudentReports(string, new FileGenerator(string));
                }
            }
            this.iProgress = 0.9;
            byte[] buffer = new byte[32768];
            int len = 0;
            if (output.isEmpty()) {
                this.log("<font color='orange'>" + MSG.warnNoReportGenerated() + "</font>");
            } else if (this.iForm.getEmail()) {
                Email mail;
                this.setStatus(MSG.statusSendingEmails());
                if (this.iForm.getEmailDeputies()) {
                    Hashtable files2send = new Hashtable();
                    for (Map.Entry entry : outputPerSubject.entrySet()) {
                        if (((SubjectArea)entry.getKey()).getDepartment().getTimetableManagers().isEmpty()) {
                            this.log("<font color='orange'>&nbsp;&nbsp;" + MSG.warnNoManagerForSubject(((SubjectArea)entry.getKey()).getSubjectAreaAbbreviation(), ((SubjectArea)entry.getKey()).getDepartment().getLabel()) + "</font>");
                        }
                        for (TimetableManager g : ((SubjectArea)entry.getKey()).getDepartment().getTimetableManagers()) {
                            void var16_53;
                            boolean receiveEmail = false;
                            for (ManagerRole mr : g.getManagerRoles()) {
                                if (!Boolean.TRUE.equals(mr.isReceiveEmails()) || mr.getRole().hasRight(Right.DepartmentIndependent) || !mr.getRole().hasRight(Right.ExaminationPdfReports)) continue;
                                receiveEmail = true;
                            }
                            if (!receiveEmail) continue;
                            if (g.getEmailAddress() == null || g.getEmailAddress().length() == 0) {
                                this.log("<font color='orange'>&nbsp;&nbsp;" + MSG.warnManagerHasNoEmail(g.getName()) + "</font>");
                                continue;
                            }
                            Hashtable hashtable = (Hashtable)files2send.get(g);
                            if (hashtable == null) {
                                Hashtable hashtable2 = new Hashtable();
                                files2send.put(g, hashtable2);
                            }
                            var16_53.putAll((Map)entry.getValue());
                        }
                    }
                    if (files2send.isEmpty()) {
                        this.log("<font color='red'>" + MSG.warnNothingToSend() + "</font>");
                    } else {
                        Set managers = files2send.keySet();
                        while (!managers.isEmpty()) {
                            TimetableManager timetableManager = (TimetableManager)managers.iterator().next();
                            Hashtable files = (Hashtable)files2send.get(timetableManager);
                            managers.remove(timetableManager);
                            this.log(MSG.infoSendingEmail(timetableManager.getName(), timetableManager.getEmailAddress()));
                            try {
                                Object s;
                                mail = Email.createEmail();
                                mail.setSubject(this.iForm.getSubject() == null ? MSG.emailSubjectExaminationReport() : this.iForm.getSubject());
                                mail.setText((String)(this.iForm.getMessage() == null ? "" : this.iForm.getMessage() + "\r\n\r\n") + MSG.emailForUpToDateReportVisit(this.iUrl) + "\r\n\r\n" + MSG.emailFooter(Constants.getVersion()));
                                mail.addRecipient(timetableManager.getEmailAddress(), timetableManager.getName());
                                Iterator i = managers.iterator();
                                while (i.hasNext()) {
                                    TimetableManager timetableManager2 = (TimetableManager)i.next();
                                    if (!files.equals(files2send.get(timetableManager2))) continue;
                                    this.log("&nbsp;&nbsp;" + MSG.infoIncluding(timetableManager2.getName(), timetableManager2.getEmailAddress()));
                                    mail.addRecipient(timetableManager2.getEmailAddress(), timetableManager2.getName());
                                    i.remove();
                                }
                                if (this.iForm.getAddress() != null) {
                                    s = new StringTokenizer(this.iForm.getAddress(), ";,\n\r ");
                                    while (((StringTokenizer)s).hasMoreTokens()) {
                                        mail.addRecipient(((StringTokenizer)s).nextToken(), null);
                                    }
                                }
                                if (this.iForm.getCc() != null) {
                                    s = new StringTokenizer(this.iForm.getCc(), ";,\n\r ");
                                    while (((StringTokenizer)s).hasMoreTokens()) {
                                        mail.addRecipientCC(((StringTokenizer)s).nextToken(), null);
                                    }
                                }
                                if (this.iForm.getBcc() != null) {
                                    s = new StringTokenizer(this.iForm.getBcc(), ";,\n\r ");
                                    while (((StringTokenizer)s).hasMoreTokens()) {
                                        mail.addRecipientBCC(((StringTokenizer)s).nextToken(), null);
                                    }
                                }
                                for (Map.Entry entry : files.entrySet()) {
                                    mail.addAttachment((File)entry.getValue(), session.getAcademicTerm() + session.getAcademicYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + "_" + (String)entry.getKey());
                                    this.log("&nbsp;&nbsp;" + MSG.infoAttaching("<a href='temp/" + ((File)entry.getValue()).getName() + "'>" + (String)entry.getKey() + "</a>"));
                                }
                                mail.send();
                                this.log(MSG.infoEmailSent());
                            }
                            catch (Exception e) {
                                this.log("<font color='red'>" + MSG.errorUnableToSendEmail(e.getMessage()) + "</font>");
                                this.setError(e);
                            }
                        }
                    }
                } else {
                    try {
                        Object s;
                        Email mail2 = Email.createEmail();
                        mail2.setSubject(this.iForm.getSubject() == null ? MSG.emailSubjectExaminationReport() : this.iForm.getSubject());
                        mail2.setText((String)(this.iForm.getMessage() == null ? "" : this.iForm.getMessage() + "\r\n\r\n") + MSG.emailForUpToDateReportVisit(this.iUrl) + "\r\n\r\n" + MSG.emailFooter(Constants.getVersion()));
                        if (this.iForm.getAddress() != null) {
                            s = new StringTokenizer(this.iForm.getAddress(), ";,\n\r ");
                            while (((StringTokenizer)s).hasMoreTokens()) {
                                mail2.addRecipient(((StringTokenizer)s).nextToken(), null);
                            }
                        }
                        if (this.iForm.getCc() != null) {
                            s = new StringTokenizer(this.iForm.getCc(), ";,\n\r ");
                            while (((StringTokenizer)s).hasMoreTokens()) {
                                mail2.addRecipientCC(((StringTokenizer)s).nextToken(), null);
                            }
                        }
                        if (this.iForm.getBcc() != null) {
                            s = new StringTokenizer(this.iForm.getBcc(), ";,\n\r ");
                            while (((StringTokenizer)s).hasMoreTokens()) {
                                mail2.addRecipientBCC(((StringTokenizer)s).nextToken(), null);
                            }
                        }
                        for (Map.Entry entry : output.entrySet()) {
                            mail2.addAttachment((File)entry.getValue(), session.getAcademicTerm() + session.getAcademicYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + "_" + (String)entry.getKey());
                        }
                        mail2.send();
                        this.log(MSG.infoEmailSent());
                    }
                    catch (Exception e) {
                        this.log("<font color='red'>" + MSG.errorUnableToSendEmail(e.getMessage()) + "</font>");
                        this.setError(e);
                    }
                }
                if (this.iForm.getEmailInstructors() && ireports != null && !ireports.isEmpty()) {
                    this.setStatus(MSG.statusEmailingInstructors());
                    for (ExamInfo.ExamInstructorInfo instructor : new TreeSet(ireports.keySet())) {
                        File file = (File)ireports.get(instructor);
                        String email = instructor.getInstructor().getEmail();
                        if (email == null || email.length() == 0) {
                            this.log("&nbsp;&nbsp;<font color='orange'>" + MSG.errorUnableToSentInstructorNoEmail("<a href='temp/" + file.getName() + "'>" + instructor.getName() + "</a>") + "</font>");
                            continue;
                        }
                        try {
                            StringTokenizer s;
                            mail = Email.createEmail();
                            mail.setSubject(this.iForm.getSubject() == null ? MSG.emailSubjectExaminationReport() : this.iForm.getSubject());
                            mail.setText((String)(this.iForm.getMessage() == null ? "" : this.iForm.getMessage() + "\r\n\r\n") + MSG.emailForUpToDateReportVisit(this.iUrl) + "\r\n\r\n" + MSG.emailFooter(Constants.getVersion()));
                            mail.addRecipient(email, null);
                            if (this.iForm.getCc() != null) {
                                s = new StringTokenizer(this.iForm.getCc(), ";,\n\r ");
                                while (s.hasMoreTokens()) {
                                    mail.addRecipientCC(s.nextToken(), null);
                                }
                            }
                            if (this.iForm.getBcc() != null) {
                                s = new StringTokenizer(this.iForm.getBcc(), ";,\n\r ");
                                while (s.hasMoreTokens()) {
                                    mail.addRecipientBCC(s.nextToken(), null);
                                }
                            }
                            mail.addAttachment(file, session.getAcademicTerm() + session.getAcademicYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + PdfLegacyExamReport.getExtension(this.iForm.getReportMode()));
                            mail.send();
                            this.log("&nbsp;&nbsp;" + MSG.infoEmailSentTo("<a href='temp/" + file.getName() + "'>" + instructor.getName() + "</a>"));
                        }
                        catch (Exception e) {
                            this.log("&nbsp;&nbsp;<font color='orange'>" + MSG.errorUnableToSendEmailTo("<a href='temp/" + file.getName() + "'>" + instructor.getName() + "</a>", e.getMessage()) + "</font>");
                            this.setError(e);
                        }
                    }
                    this.log(MSG.infoEmailsSent());
                }
                if (this.iForm.getEmailStudents() && sreports != null && !sreports.isEmpty()) {
                    this.setStatus(MSG.statusEmailingStudents());
                    for (Student student : new TreeSet(sreports.keySet())) {
                        File file = (File)sreports.get(student);
                        String email = student.getEmail();
                        if (email == null || email.length() == 0) {
                            this.log("&nbsp;&nbsp;<font color='orange'>" + MSG.errorUnableToSentStudentNoEmail("<a href='temp/" + file.getName() + "'>" + student.getName(DepartmentalInstructor.sNameFormatLastFist) + "</a>") + "</font>");
                            continue;
                        }
                        try {
                            StringTokenizer s;
                            mail = Email.createEmail();
                            mail.setSubject(this.iForm.getSubject() == null ? MSG.emailSubjectExaminationReport() : this.iForm.getSubject());
                            mail.setText((String)(this.iForm.getMessage() == null ? "" : this.iForm.getMessage() + "\r\n\r\n") + MSG.emailForUpToDateReportVisit(this.iUrl) + "\r\n\r\n" + MSG.emailFooter(Constants.getVersion()));
                            mail.addRecipient(email, null);
                            if (this.iForm.getCc() != null) {
                                s = new StringTokenizer(this.iForm.getCc(), ";,\n\r ");
                                while (s.hasMoreTokens()) {
                                    mail.addRecipientCC(s.nextToken(), null);
                                }
                            }
                            if (this.iForm.getBcc() != null) {
                                s = new StringTokenizer(this.iForm.getBcc(), ";,\n\r ");
                                while (s.hasMoreTokens()) {
                                    mail.addRecipientBCC(s.nextToken(), null);
                                }
                            }
                            mail.addAttachment(file, session.getAcademicTerm() + session.getAcademicYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + PdfLegacyExamReport.getExtension(this.iForm.getReportMode()));
                            mail.send();
                            this.log("&nbsp;&nbsp;" + MSG.infoEmailSentTo("<a href='temp/" + file.getName() + "'>" + student.getName(DepartmentalInstructor.sNameFormatLastFist) + "</a>"));
                        }
                        catch (Exception e) {
                            this.log("&nbsp;&nbsp;<font color='orange'>" + MSG.errorUnableToSendEmailTo("<a href='temp/" + file.getName() + "'>" + student.getName(DepartmentalInstructor.sNameFormatLastFist) + "</a>", e.getMessage()) + "</font>");
                            this.setError(e);
                        }
                    }
                    this.log(MSG.infoEmailsSent());
                }
            }
            if (output.isEmpty()) {
                throw new Exception(MSG.errorNoReportGenerated());
            }
            if (output.size() == 1) {
                this.setOutput((File)output.elements().nextElement());
            } else {
                FileInputStream fis = null;
                ZipOutputStream zip = null;
                try {
                    File file = ApplicationProperties.getTempFile(session.getAcademicTerm() + session.getAcademicYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference(), "zip");
                    this.log(MSG.statusWritingReport("<a href='temp/" + file.getName() + "'>" + session.getAcademicTerm() + session.getAcademicYear() + ((ExamType)ExamTypeDAO.getInstance().get(this.iForm.getExamType())).getReference() + ".zip</a>"));
                    zip = new ZipOutputStream(new FileOutputStream(file));
                    for (Map.Entry entry : output.entrySet()) {
                        zip.putNextEntry(new ZipEntry((String)entry.getKey()));
                        fis = new FileInputStream((File)entry.getValue());
                        while ((len = fis.read(buffer)) > 0) {
                            zip.write(buffer, 0, len);
                        }
                        fis.close();
                        fis = null;
                        zip.closeEntry();
                    }
                    zip.flush();
                    zip.close();
                    this.setOutput(file);
                }
                catch (IOException iOException) {
                    if (fis != null) {
                        fis.close();
                    }
                    if (zip != null) {
                        zip.close();
                    }
                    this.setError(iOException);
                }
            }
            this.iProgress = 1.0;
            this.setStatus(MSG.statusAllDone());
        }
        catch (Exception e) {
            this.fatal(MSG.errorTaskFailed(), e);
        }
    }

    @Override
    public String name() {
        return this.iName;
    }

    @Override
    public double progress() {
        return this.iProgress;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public static class FileGenerator
    implements InstructorExamReport.FileGenerator {
        String iName;

        public FileGenerator(String name) {
            this.iName = name;
        }

        @Override
        public File generate(String prefix, String ext) {
            return ApplicationProperties.getTempFile(this.iName + "_" + prefix, ext);
        }
    }
}

