/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BasePreference;
import org.unitime.timetable.model.base.BaseRoomPref;
import org.unitime.timetable.model.base.BaseTimePattern;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.test.MakeAssignmentsForClassEvents;
import org.unitime.timetable.util.Constants;

public class MasarykDefaultPreferences {
    protected static Log sLog = LogFactory.getLog(MasarykDefaultPreferences.class);

    private static String ident(CourseOffering co, Class_ c, org.hibernate.Session hibSession) {
        if (co.getExternalUniqueId() == null) {
            return null;
        }
        Object ext = co.getExternalUniqueId();
        if (c.getClassSuffix() != null && !c.getClassSuffix().isEmpty()) {
            ext = (String)ext + "/" + c.getClassSuffix();
        } else if (c.getExternalUniqueId() != null && !c.getExternalUniqueId().isEmpty() && c.getExternalUniqueId().indexOf(47) >= 0) {
            ext = (String)ext + c.getExternalUniqueId().substring(c.getExternalUniqueId().indexOf(47));
        }
        return ext;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            org.hibernate.Session hibSession = new _RootDAO().getSession();
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "FF"), ApplicationProperties.getProperty("year", "2011"), ApplicationProperties.getProperty("term", "Jaro"));
            boolean incremental = "true".equalsIgnoreCase(ApplicationProperties.getProperty("incremental", "false"));
            boolean addMeetWith = "true".equalsIgnoreCase(ApplicationProperties.getProperty("meetwith", "false"));
            boolean useScheduleNote = "true".equalsIgnoreCase(ApplicationProperties.getProperty("note", "true"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + String.valueOf(session)));
            }
            Session previous = Session.getSessionUsingInitiativeYearTerm(session.getAcademicInitiative(), String.valueOf(Integer.parseInt(session.getAcademicYear()) - 1), session.getAcademicTerm());
            Hashtable<Object, Float> oldRatios = new Hashtable<Object, Float>();
            if (previous != null) {
                for (SubjectArea sa : previous.getSubjectAreas()) {
                    for (CourseOffering co : sa.getCourseOfferings()) {
                        for (InstrOfferingConfig cfg : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                            for (SchedulingSubpart schedulingSubpart : cfg.getSchedulingSubparts()) {
                                for (Class_ c : schedulingSubpart.getClasses()) {
                                    Object id;
                                    Float ratio;
                                    if (c.getRoomRatio() == null || c.getRoomRatio().floatValue() <= 0.0f || c.getRoomRatio().floatValue() >= 1.0f || (ratio = (Float)oldRatios.get(id = MasarykDefaultPreferences.ident(co, c, hibSession))) != null && !(ratio.floatValue() > c.getRoomRatio().floatValue())) continue;
                                    oldRatios.put(id, c.getRoomRatio());
                                    sLog.info((Object)((String)id + " <- " + c.getRoomRatio()));
                                }
                            }
                        }
                    }
                }
            }
            MakeAssignmentsForClassEvents makePattern = new MakeAssignmentsForClassEvents(session, hibSession);
            RoomGroup poc = null;
            RoomGroup mult = null;
            RoomGroup bez = null;
            for (RoomGroup rg : RoomGroup.getAllGlobalRoomGroups(session)) {
                if (rg.getAbbv().equals("PO\u010c")) {
                    poc = rg;
                    continue;
                }
                if (rg.getAbbv().equals("MULT")) {
                    mult = rg;
                    continue;
                }
                if (!rg.getAbbv().equals("B\u011a\u017d")) continue;
                bez = rg;
            }
            if (!incremental) {
                hibSession.createMutationQuery("delete DistributionPref where owner in (from Department d where d.session.uniqueId = :sessionId)").setParameter("sessionId", (Object)session.getUniqueId()).executeUpdate();
                hibSession.createMutationQuery("delete DistributionPref where owner in (from Session s where s.uniqueId = :sessionId)").setParameter("sessionId", (Object)session.getUniqueId()).executeUpdate();
            }
            Hashtable<CallSite, HashSet<Class_>> meetWith = new Hashtable<CallSite, HashSet<Class_>>();
            DistributionType sameDaysType = (DistributionType)hibSession.createQuery("select d from DistributionType d where d.reference = :type", DistributionType.class).setParameter("type", (Object)"SAME_DAYS").uniqueResult();
            TimePattern tp2h = (TimePattern)hibSession.createQuery("select p from TimePattern as p where p.session.uniqueId=:sessionId and p.name=:name", TimePattern.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("name", (Object)"2h").uniqueResult();
            for (SchedulingSubpart ss : hibSession.createQuery("select distinct s from SchedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.department.session.uniqueId = :sessionId", SchedulingSubpart.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                Object t;
                boolean hasPreferences = false;
                if (!ss.getPreferences().isEmpty()) {
                    hasPreferences = true;
                }
                for (Class_ c : ss.getClasses()) {
                    if (c.effectiveDatePattern().getName().startsWith("import") || c.getNbrRooms() == 0) {
                        hasPreferences = false;
                        break;
                    }
                    if (c.getPreferences().size() > c.getPreferences(TimePref.class).size()) {
                        hasPreferences = true;
                        continue;
                    }
                    Iterator<TimePref> i = c.getPreferences(TimePref.class).iterator();
                    while (!hasPreferences && i.hasNext()) {
                        t = i.next();
                        TimePatternModel m = ((TimePref)t).getTimePatternModel();
                        if (m.isExactTime() || m.isDefault()) continue;
                        hasPreferences = true;
                    }
                }
                if (hasPreferences && incremental) continue;
                sLog.info((Object)("Setting " + ss.getSchedulingSubpartLabel() + " ..."));
                if (ss.getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
                    ss.getInstrOfferingConfig().setUnlimitedEnrollment(false);
                    ss.getInstrOfferingConfig().setLimit(0);
                    hibSession.merge((Object)ss);
                }
                if (ss.getChildSubparts().isEmpty() && ss.getParentSubpart() != null) {
                    boolean sameDay = false;
                    boolean hasConstraint = false;
                    boolean friday = false;
                    t = ss.getClasses().iterator();
                    while (t.hasNext()) {
                        int dayCode = 0;
                        for (Class_ c = t.next(); c != null; c = c.getParentClass()) {
                            for (DistributionObject distributionObject : c.getDistributionObjects()) {
                                if (!distributionObject.getDistributionPref().getDistributionType().equals(sameDaysType)) continue;
                                hasConstraint = true;
                            }
                            Assignment a = c.getCommittedAssignment();
                            if (a == null) continue;
                            if ((dayCode & a.getDays()) != 0) {
                                sameDay = true;
                            }
                            dayCode |= a.getDays().intValue();
                        }
                        friday = (dayCode & Constants.DAY_CODES[4]) != 0;
                    }
                    if (!(hasConstraint || friday || sameDay)) {
                        DistributionPref dp = new DistributionPref();
                        dp.setDistributionType(sameDaysType);
                        dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(sameDay ? PreferenceLevel.sStronglyDiscouraged : PreferenceLevel.sProhibited));
                        dp.setDistributionObjects(new HashSet<DistributionObject>());
                        dp.setStructure(DistributionPref.Structure.AllClasses);
                        dp.setOwner(ss.getManagingDept());
                        int index = 1;
                        for (SchedulingSubpart x = ss; x != null; x = x.getParentSubpart()) {
                            DistributionObject o = new DistributionObject();
                            o.setDistributionPref(dp);
                            o.setPrefGroup(x);
                            o.setSequenceNumber(index++);
                            dp.getDistributionObjects().add(o);
                        }
                        hibSession.persist((Object)dp);
                    }
                }
                for (Class_ c : ss.getClasses()) {
                    Meeting m = c.getEvent().getMeetings().iterator().next();
                    int minPerMeeting = 5 + 5 * (m.getStopPeriod() - m.getStartPeriod());
                    if ((minPerMeeting + 5) % 50 == 0) {
                        minPerMeeting += 5;
                    }
                    if ((minPerMeeting - 5) % 50 == 0) {
                        minPerMeeting -= 5;
                    }
                    if (ss.getMinutesPerWk() == minPerMeeting) continue;
                    System.out.println(c.getClassLabel(hibSession) + " has " + ss.getMinutesPerWk() + " minutes per meeting (should have " + minPerMeeting + ").");
                    if (c.getSectionNumber() != 1) continue;
                    ss.setMinutesPerWk(minPerMeeting);
                    hibSession.merge((Object)ss);
                }
                for (Class_ c : ss.getClasses()) {
                    Object tp;
                    TimePatternModel m;
                    Assignment a = c.getCommittedAssignment();
                    if (a == null) continue;
                    if (c.effectiveDatePattern().getName().startsWith("import")) {
                        c.setDatePattern(makePattern.getDatePattern(c.getEvent()));
                    }
                    for (Location location : a.getRooms()) {
                        if (!(location instanceof Room)) continue;
                        String code = location.getUniqueId() + ":" + a.getDatePattern().getUniqueId() + ":" + a.getTimePattern().getUniqueId() + ":" + a.getDays() + ":" + a.getStartSlot();
                        HashSet<Class_> classes = (HashSet<Class_>)meetWith.get(code);
                        if (classes == null) {
                            classes = new HashSet<Class_>();
                            meetWith.put((CallSite)((Object)code), classes);
                        }
                        classes.add(c);
                    }
                    c.setRoomRatio(Float.valueOf(1.0f));
                    c.getPreferences().clear();
                    BaseTimePattern pattern = null;
                    block18: for (TimePattern p : TimePattern.findApplicable(session.getUniqueId(), false, false, false, (int)c.getSchedulingSubpart().getMinutesPerWk(), c.effectiveDatePattern(), c.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel(), null)) {
                        for (TimePatternDays timePatternDays : p.getDays()) {
                            if (!a.getDays().equals(timePatternDays.getDayCode())) continue;
                            for (TimePatternTime t2 : p.getTimes()) {
                                if (!t2.getStartSlot().equals(a.getStartSlot())) continue;
                                pattern = p;
                                break block18;
                            }
                        }
                    }
                    boolean extConv = false;
                    if (pattern == null) {
                        pattern = TimePattern.findExactTime(session.getUniqueId());
                        m = ((TimePattern)pattern).getTimePatternModel();
                        m.setExactDays(a.getDays());
                        m.setExactStartSlot(a.getStartSlot());
                        tp = new TimePref();
                        ((BasePreference)tp).setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                        ((TimePref)tp).setTimePatternModel(m);
                        ((BasePreference)tp).setOwner(c);
                        c.getPreferences().add((Preference)tp);
                    } else {
                        if (pattern.getName().equals("2h ext")) {
                            pattern = tp2h;
                            extConv = true;
                        }
                        m = ((TimePattern)pattern).getTimePatternModel();
                        for (int d = 0; d < m.getNrDays(); ++d) {
                            void var25_56;
                            boolean bl = false;
                            while (var25_56 < m.getNrTimes()) {
                                if (a.getTimeLocation().getStartSlot() == m.getStartSlot((int)var25_56) && a.getTimeLocation().getDayCode() == m.getDayCode(d)) {
                                    int tt;
                                    for (tt = Math.max(0, (int)(var25_56 - true)); tt < Math.min(m.getNrTimes(), (int)(var25_56 + 2)); ++tt) {
                                        for (int dd = 0; dd < m.getNrDays(); ++dd) {
                                            m.setPreference(dd, tt, PreferenceLevel.sPreferred);
                                        }
                                    }
                                    m.setPreference(d, (int)var25_56, PreferenceLevel.sStronglyPreferred);
                                    if (d == m.getNrDays() - 1) {
                                        for (int dd = 0; dd < m.getNrDays() - 1; ++dd) {
                                            for (int tt2 = 0; tt2 < m.getNrTimes(); ++tt2) {
                                                m.setPreference(dd, tt2, PreferenceLevel.sProhibited);
                                            }
                                        }
                                    } else {
                                        for (tt = 0; tt < m.getNrTimes(); ++tt) {
                                            m.setPreference(m.getNrDays() - 1, tt, PreferenceLevel.sProhibited);
                                        }
                                    }
                                } else if (extConv && var25_56 > 0 && a.getTimeLocation().getDayCode() == m.getDayCode(d) && a.getTimeLocation().getStartSlot() > m.getStartSlot((int)(var25_56 - true)) && a.getTimeLocation().getStartSlot() < m.getStartSlot((int)var25_56)) {
                                    for (int dd = 0; dd < m.getNrDays(); ++dd) {
                                        m.setPreference(dd, (int)(var25_56 - true), PreferenceLevel.sPreferred);
                                        m.setPreference(dd, (int)var25_56, PreferenceLevel.sPreferred);
                                    }
                                    m.setPreference(d, (int)(var25_56 - true), PreferenceLevel.sStronglyPreferred);
                                    m.setPreference(d, (int)var25_56, PreferenceLevel.sStronglyPreferred);
                                }
                                ++var25_56;
                            }
                        }
                        tp = new TimePref();
                        ((BasePreference)tp).setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                        ((TimePref)tp).setTimePatternModel(m);
                        ((BasePreference)tp).setOwner(c);
                        c.getPreferences().add((Preference)tp);
                    }
                    boolean rgPref = true;
                    for (Location location : a.getRooms()) {
                        Object rp;
                        if (location instanceof NonUniversityLocation) {
                            rp = new RoomPref();
                            ((BasePreference)rp).setOwner(c);
                            ((BasePreference)rp).setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                            ((BaseRoomPref)rp).setRoom(location);
                            c.getPreferences().add((Preference)rp);
                            rgPref = false;
                        } else {
                            rp = new RoomPref();
                            ((BasePreference)rp).setOwner(c);
                            if (location.getRoomGroups().isEmpty()) {
                                ((BasePreference)rp).setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                                rgPref = false;
                            } else if (location.getCapacity() == 0) {
                                ((BasePreference)rp).setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                            } else {
                                ((BasePreference)rp).setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sPreferred));
                            }
                            ((BaseRoomPref)rp).setRoom(location);
                            c.getPreferences().add((Preference)rp);
                            BuildingPref bp = new BuildingPref();
                            bp.setOwner(c);
                            bp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                            bp.setBuilding(((Room)location).getBuilding());
                            c.getPreferences().add(bp);
                            Float lastLikeRoomRatio = null;
                            String id = MasarykDefaultPreferences.ident(ss.getControllingCourseOffering(), c, hibSession);
                            if (id != null) {
                                lastLikeRoomRatio = (Float)oldRatios.get(id);
                            }
                            if (lastLikeRoomRatio != null) {
                                sLog.info((Object)(id + " had room ration " + lastLikeRoomRatio + " last year."));
                            }
                            if (location.getCapacity() > 0 && location.getCapacity() < c.getClassLimit()) {
                                c.setRoomRatio(Float.valueOf((float)Math.floor(100 * location.getCapacity() / c.getClassLimit()) / 100.0f));
                                if (lastLikeRoomRatio != null && lastLikeRoomRatio.floatValue() < c.getRoomRatio().floatValue()) {
                                    sLog.info((Object)("Setting room ratio for " + c.getClassLabel(hibSession) + " <- " + lastLikeRoomRatio + " (was " + c.getRoomRatio() + ")"));
                                    c.setRoomRatio(lastLikeRoomRatio);
                                }
                            } else if (location.getCapacity() == 0) {
                                c.setRoomRatio(Float.valueOf(0.0f));
                            } else if (lastLikeRoomRatio != null) {
                                sLog.info((Object)("Setting room ratio for " + c.getClassLabel(hibSession) + " <- " + lastLikeRoomRatio));
                                c.setRoomRatio(lastLikeRoomRatio);
                            }
                        }
                        if (useScheduleNote || !rgPref) continue;
                        for (RoomGroup rg : location.getRoomGroups()) {
                            RoomGroupPref gp2;
                            RoomGroupPref gp;
                            if (rg.isGlobal().booleanValue() && rg.getAbbv().equals("MULT")) {
                                gp = new RoomGroupPref();
                                gp.setOwner(c);
                                gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                                gp.setRoomGroup(rg);
                                c.getPreferences().add(gp);
                                gp2 = new RoomGroupPref();
                                gp2.setOwner(c);
                                gp2.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sPreferred));
                                gp2.setRoomGroup(poc);
                                c.getPreferences().add(gp2);
                                continue;
                            }
                            if (rg.isGlobal().booleanValue() && rg.getAbbv().equals("PO\u010c")) {
                                gp = new RoomGroupPref();
                                gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                                gp.setOwner(c);
                                gp.setRoomGroup(rg);
                                c.getPreferences().add(gp);
                                continue;
                            }
                            if (!rg.isGlobal().booleanValue() || !rg.getAbbv().equals("B\u011a\u017d")) continue;
                            gp = new RoomGroupPref();
                            gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                            gp.setOwner(c);
                            gp.setRoomGroup(rg);
                            c.getPreferences().add(gp);
                            gp2 = new RoomGroupPref();
                            gp2.setOwner(c);
                            gp2.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
                            gp2.setRoomGroup(poc);
                            c.getPreferences().add(gp2);
                        }
                    }
                    if (useScheduleNote && rgPref) {
                        RoomGroupPref gp;
                        if ("MM".equals(c.getSchedulePrintNote())) {
                            gp = new RoomGroupPref();
                            gp.setOwner(c);
                            gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                            gp.setRoomGroup(mult);
                            c.getPreferences().add(gp);
                            RoomGroupPref roomGroupPref = new RoomGroupPref();
                            roomGroupPref.setOwner(c);
                            roomGroupPref.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sPreferred));
                            roomGroupPref.setRoomGroup(poc);
                            c.getPreferences().add(roomGroupPref);
                            RoomGroupPref gp3 = new RoomGroupPref();
                            gp3.setOwner(c);
                            gp3.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sDiscouraged));
                            gp3.setRoomGroup(bez);
                            c.getPreferences().add(gp3);
                        } else if ("PC".equals(c.getSchedulePrintNote())) {
                            gp = new RoomGroupPref();
                            gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                            gp.setOwner(c);
                            gp.setRoomGroup(poc);
                            c.getPreferences().add(gp);
                        } else {
                            gp = new RoomGroupPref();
                            gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                            gp.setOwner(c);
                            gp.setRoomGroup(bez);
                            c.getPreferences().add(gp);
                            RoomGroupPref roomGroupPref = new RoomGroupPref();
                            roomGroupPref.setOwner(c);
                            roomGroupPref.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
                            roomGroupPref.setRoomGroup(poc);
                            c.getPreferences().add(roomGroupPref);
                        }
                    }
                    c.setNbrRooms(Math.max(1, a.getRooms().size()));
                    hibSession.merge((Object)c);
                }
                hibSession.flush();
            }
            hibSession.flush();
            if (addMeetWith) {
                DistributionType distributionType = (DistributionType)hibSession.createQuery("select d from DistributionType d where d.reference = :type", DistributionType.class).setParameter("type", (Object)"MEET_WITH").uniqueResult();
                for (Set classes : meetWith.values()) {
                    if (classes.size() <= 1) continue;
                    sLog.info((Object)("Adding meet with between: " + String.valueOf(classes)));
                    DistributionPref dp = new DistributionPref();
                    dp.setDistributionType(distributionType);
                    dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                    dp.setDistributionObjects(new HashSet<DistributionObject>());
                    dp.setStructure(DistributionPref.Structure.AllClasses);
                    int index = 1;
                    int total = 0;
                    for (Class_ c : classes) {
                        if (index == 1) {
                            dp.setOwner(c.getManagingDept());
                        }
                        DistributionObject o = new DistributionObject();
                        o.setDistributionPref(dp);
                        o.setPrefGroup(c);
                        o.setSequenceNumber(index++);
                        dp.getDistributionObjects().add(o);
                        total += c.getClassLimit();
                    }
                    for (Location l : ((Class_)classes.iterator().next()).getCommittedAssignment().getRooms()) {
                        if (l instanceof NonUniversityLocation || l.getCapacity() <= 0 || l.getCapacity() >= total) continue;
                        double roomRatio = Math.floor(100.0 * (double)l.getCapacity().intValue() / (double)total) / 100.0;
                        for (Class_ c : classes) {
                            double roomLimit = Math.floor(roomRatio * (double)c.getClassLimit());
                            c.setRoomRatio(Float.valueOf((float)Math.floor(100.0 * roomLimit / (double)c.getClassLimit()) / 100.0f));
                            hibSession.merge((Object)c);
                        }
                    }
                    hibSession.persist((Object)dp);
                }
                hibSession.flush();
            }
            sLog.info((Object)"All done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

