/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.studentsct;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.ProblemLoader;
import org.cpsolver.ifs.util.ProblemSaver;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.StudentSectioningXMLLoader;
import org.cpsolver.studentsct.StudentSectioningXMLSaver;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.expectations.NeverOverExpected;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumOverride;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.cpsolver.studentsct.reservation.UniversalOverride;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.client.sectioning.SectioningReports;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.GroupOverrideReservation;
import org.unitime.timetable.model.LearningCommunityReservation;
import org.unitime.timetable.model.SectioningSolutionLog;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.dao.LearningCommunityReservationDAO;
import org.unitime.timetable.model.dao.SectioningSolutionLogDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.model.dao.StudentGroupReservationDAO;
import org.unitime.timetable.model.dao.StudentSchedulingRuleDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.StudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XClassEnrollment;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XCredit;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRule;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRules;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.model.XTime;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.server.sectioning.SectioningReportTypesBackend;
import org.unitime.timetable.solver.AbstractSolver;
import org.unitime.timetable.solver.SolverDisposeListener;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.studentsct.InMemoryReport;
import org.unitime.timetable.solver.studentsct.StudentSectioningDatabaseLoader;
import org.unitime.timetable.solver.studentsct.StudentSectioningDatabaseSaver;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.MemoryCounter;

public class StudentSolver
extends AbstractSolver<Request, Enrollment, StudentSectioningModel>
implements StudentSolverProxy {
    private static StudentSectioningMessages SCT_MSG = Localization.create(StudentSectioningMessages.class);
    private transient Map<Long, XCourse> iCourseInfoCache = null;
    private transient Map<Long, XOffering> iOfferingCache = null;
    private transient Map<String, Set<Long>> iInstructedOfferingsCache = null;
    private transient Map<Long, Student> iStudentCache = null;
    private transient Map<String, Student> iStudentExtCache = null;
    private Map<String, Object> iOnlineProperties = new HashMap<String, Object>();
    private Map<String, InMemoryReport> iReports = new HashMap<String, InMemoryReport>();
    private AcademicSessionInfo iSession = null;
    private DistanceMetric iDistanceMetric = null;
    private XSchedulingRules iRules = null;

    public StudentSolver(DataProperties properties, SolverDisposeListener disposeListener) {
        super(properties, disposeListener);
    }

    @Override
    protected ProblemSaver<Request, Enrollment, StudentSectioningModel> getDatabaseSaver(Solver<Request, Enrollment> solver) {
        try {
            String saverClass = this.getProperties().getProperty("General.DatabaseSaver", StudentSectioningDatabaseSaver.class.getName());
            if (saverClass != null && !saverClass.isEmpty()) {
                return (ProblemSaver)Class.forName(saverClass).getConstructor(Solver.class).newInstance(solver);
            }
        }
        catch (Exception e) {
            this.iProgress.error("Failed to create a custom database saver: " + e.getMessage(), (Throwable)e);
        }
        return new StudentSectioningDatabaseSaver(solver);
    }

    @Override
    protected ProblemLoader<Request, Enrollment, StudentSectioningModel> getDatabaseLoader(StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
        try {
            String loaderClass = this.getProperties().getProperty("General.DatabaseLoader", StudentSectioningDatabaseLoader.class.getName());
            if (loaderClass != null && !loaderClass.isEmpty()) {
                try {
                    return (ProblemLoader)Class.forName(loaderClass).getConstructor(StudentSolver.class, StudentSectioningModel.class, Assignment.class).newInstance(this, model, assignment);
                }
                catch (NoSuchMethodException e) {
                    return (ProblemLoader)Class.forName(loaderClass).getConstructor(StudentSectioningModel.class, Assignment.class).newInstance(model, assignment);
                }
            }
        }
        catch (Exception e) {
            this.iProgress.error("Failed to create a custom database loader: " + e.getMessage(), (Throwable)e);
        }
        return new StudentSectioningDatabaseLoader(this, model, assignment);
    }

    @Override
    protected ProblemSaver<Request, Enrollment, StudentSectioningModel> getCustomValidator(Solver<Request, Enrollment> solver) {
        try {
            String validatorClass = this.getProperties().getProperty("General.CustomValidator", null);
            if (validatorClass != null && !validatorClass.isEmpty()) {
                return (ProblemSaver)Class.forName(validatorClass).getConstructor(Solver.class).newInstance(solver);
            }
        }
        catch (Exception e) {
            this.iProgress.error("Failed to create a custom validator: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean isCanValidate() {
        String validatorClass = this.getProperties().getProperty("General.CustomValidator", null);
        return validatorClass != null && !validatorClass.isEmpty();
    }

    @Override
    protected StudentSectioningModel createModel(DataProperties properties) {
        return new StudentSectioningModel(properties);
    }

    public void setInitalSolution(Model<Request, Enrollment> model) {
        this.setInitalSolution((Solution<Request, Enrollment>)new Solution(model, (Assignment)new DefaultSingleAssignment()));
    }

    @Override
    protected Document createCurrentSolutionBackup(boolean anonymize, boolean idconv) {
        this.getProperties().setProperty("Xml.SaveBest", "true");
        this.getProperties().setProperty("Xml.SaveInitial", "true");
        this.getProperties().setProperty("Xml.SaveCurrent", "true");
        if (anonymize) {
            this.getProperties().setProperty("Xml.ConvertIds", idconv ? "true" : "false");
            this.getProperties().setProperty("Xml.SaveOnlineSectioningInfo", "true");
            this.getProperties().setProperty("Xml.SaveStudentInfo", "false");
            this.getProperties().setProperty("Xml.ShowNames", "false");
        }
        Document document = new StudentSectioningXMLSaver((Solver)this).saveDocument();
        if (anonymize) {
            this.getProperties().setProperty("Xml.ConvertIds", "false");
            this.getProperties().setProperty("Xml.SaveOnlineSectioningInfo", "true");
            this.getProperties().setProperty("Xml.SaveStudentInfo", "true");
            this.getProperties().setProperty("Xml.ShowNames", "true");
        }
        this.saveReports(document);
        return document;
    }

    @Override
    protected void restureCurrentSolutionFromBackup(Document document) {
        this.getProperties().setProperty("Xml.LoadBest", "true");
        this.getProperties().setProperty("Xml.LoadInitial", "true");
        this.getProperties().setProperty("Xml.LoadCurrent", "true");
        new StudentSectioningXMLLoader((StudentSectioningModel)this.getModel(), this.currentSolution().getAssignment()).load(document);
        this.readReports(document);
    }

    private void clearCachedData() {
        this.clearCourseInfoTable();
        this.clearOfferingCache();
        this.clearInstructedOfferingsCache();
        this.clearStudentCache();
    }

    @Override
    protected void disposeNoInherit(boolean unregister) {
        super.disposeNoInherit(unregister);
        this.clearCachedData();
    }

    @Override
    protected void afterLoad() {
        super.afterLoad();
        this.clearCachedData();
    }

    public void setInitalSolution(Solution<Request, Enrollment> solution) {
        super.setInitalSolution(solution);
        this.clearCachedData();
    }

    @Override
    public Callback getReloadingDoneCallback() {
        return new ReloadingDoneCallback();
    }

    @Override
    public AcademicSessionInfo getAcademicSession() {
        if (this.iSession == null) {
            try (Session hibSession = SessionDAO.getInstance().createNewSession();){
                this.iSession = new AcademicSessionInfo((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(this.getSessionId(), hibSession));
                this.iSession.setSectioningEnabled(false);
                this.iRules = new XSchedulingRules(this.iSession, hibSession);
            }
            catch (Exception e) {
                this.iSession = new AcademicSessionInfo(this.getSessionId(), this.getConfig().getProperty("Data.Year"), this.getConfig().getProperty("Data.Term"), this.getConfig().getProperty("Data.Initiative"));
            }
        }
        return this.iSession;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        if (this.iDistanceMetric == null) {
            this.iDistanceMetric = ((StudentSectioningModel)this.getModel()).getDistanceMetric();
        }
        if (this.iDistanceMetric == null) {
            this.iDistanceMetric = new DistanceMetric(this.getProperties());
            TravelTime.populateTravelTimes(this.iDistanceMetric);
        }
        return this.iDistanceMetric;
    }

    @Override
    public DataProperties getConfig() {
        return this.getProperties();
    }

    private Map<Long, XCourse> getCourseInfoTable() {
        if (this.iCourseInfoCache == null) {
            this.iCourseInfoCache = new Hashtable<Long, XCourse>();
            for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
                if (offering.isDummy()) continue;
                for (Course course : offering.getCourses()) {
                    if (course == null) continue;
                    this.iCourseInfoCache.put(course.getId(), new XCourse(course));
                }
            }
        }
        return this.iCourseInfoCache;
    }

    private void clearCourseInfoTable() {
        this.iCourseInfoCache = null;
    }

    private Map<Long, XOffering> getOfferingCache() {
        if (this.iOfferingCache == null) {
            this.iOfferingCache = new Hashtable<Long, XOffering>();
            List links = ((StudentSectioningModel)this.getModel()).getLinkedSections();
            for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
                if (offering.isDummy()) continue;
                this.iOfferingCache.put(offering.getId(), new XOffering(offering, links));
            }
        }
        return this.iOfferingCache;
    }

    private void clearOfferingCache() {
        this.iOfferingCache = null;
    }

    private Map<String, Set<Long>> getInstructedOfferingsCache() {
        if (this.iInstructedOfferingsCache == null) {
            this.iInstructedOfferingsCache = new Hashtable<String, Set<Long>>();
            for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
                if (offering.isDummy()) continue;
                for (Config config : offering.getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            if (!section.hasInstructors()) continue;
                            for (Instructor instructor : section.getInstructors()) {
                                if (instructor.getExternalId() == null) continue;
                                Set<Long> offerings = this.iInstructedOfferingsCache.get(instructor.getExternalId());
                                if (offerings == null) {
                                    offerings = new HashSet<Long>();
                                    this.iInstructedOfferingsCache.put(instructor.getExternalId(), offerings);
                                }
                                offerings.add(offering.getId());
                            }
                        }
                    }
                }
            }
            for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
                if (student.isDummy() || student.getExternalId() == null) continue;
                block6: for (Unavailability unavailability : student.getUnavailabilities()) {
                    for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
                        if (offering.isDummy()) continue;
                        for (Config config : offering.getConfigs()) {
                            for (Subpart subpart : config.getSubparts()) {
                                for (Section section : subpart.getSections()) {
                                    if (section.getId() != unavailability.getId()) continue;
                                    Set<Long> offerings = this.iInstructedOfferingsCache.get(student.getExternalId());
                                    if (offerings == null) {
                                        offerings = new HashSet<Long>();
                                        this.iInstructedOfferingsCache.put(student.getExternalId(), offerings);
                                    }
                                    offerings.add(offering.getId());
                                    continue block6;
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.iInstructedOfferingsCache;
    }

    private void clearInstructedOfferingsCache() {
        this.iInstructedOfferingsCache = null;
    }

    private Map<Long, Student> getStudentCache() {
        if (this.iStudentCache == null) {
            this.iStudentCache = new Hashtable<Long, Student>();
            for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
                if (student.isDummy()) continue;
                this.iStudentCache.put(student.getId(), student);
            }
        }
        return this.iStudentCache;
    }

    private void clearStudentCache() {
        this.iStudentCache = null;
        this.iStudentExtCache = null;
    }

    private Map<String, Student> getStudentExtCache() {
        if (this.iStudentExtCache == null) {
            this.iStudentExtCache = new HashMap<String, Student>();
            for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
                if (student.isDummy() || student.getExternalId() == null || student.getExternalId().isEmpty()) continue;
                this.iStudentExtCache.put(student.getExternalId(), student);
            }
        }
        return this.iStudentExtCache;
    }

    public Collection<XCourseId> findCourses(String query, Integer limit, CourseMatcher matcher) {
        return this.findCourses(query, limit, matcher, null);
    }

    public Collection<XCourseId> findCourses(String query, Integer limit, CourseMatcher matcher, Comparator<XCourseId> cmp) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XCourseId> ret = new ArrayList<XCourseId>(limit == null || limit < 0 ? 100 : limit);
        String queryInLowerCase = query.toLowerCase();
        for (XCourse c : this.getCourseInfoTable().values()) {
            if (c.matchCourseName(queryInLowerCase) && (matcher == null || matcher.match(c))) {
                ret.add(c);
            }
            if (limit == null || limit <= 0 || ret.size() < limit) continue;
            return ret;
        }
        if (queryInLowerCase.length() > 2) {
            for (XCourse c : this.getCourseInfoTable().values()) {
                if (c.matchTitle(queryInLowerCase) && (matcher == null || matcher.match(c))) {
                    ret.add(c);
                }
                if (limit == null || limit <= 0 || ret.size() < limit) continue;
                return ret;
            }
        }
        if (cmp != null) {
            Collections.sort(ret, cmp);
        }
        return ret;
    }

    public Collection<XCourseId> findCourses(CourseMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XCourseId> ret = new ArrayList<XCourseId>();
        for (XCourse c : this.getCourseInfoTable().values()) {
            if (matcher != null && !matcher.match(c)) continue;
            ret.add(c);
        }
        return ret;
    }

    public Collection<XStudentId> findStudents(StudentMatcher matcher) {
        if (matcher != null) {
            matcher.setServer(this);
        }
        ArrayList<XStudentId> ret = new ArrayList<XStudentId>();
        for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
            if (student.isDummy()) continue;
            XStudentId s = new XStudentId(student);
            if (student.isDummy() || matcher != null && !matcher.match(s)) continue;
            ret.add(s);
        }
        return ret;
    }

    @Override
    public XCourse getCourse(Long courseId) {
        return this.getCourseInfoTable().get(courseId);
    }

    @Override
    public XCourse getCourse(String courseName) {
        for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
            if (offering.isDummy()) continue;
            for (Course course : offering.getCourses()) {
                if (!course.getName().equalsIgnoreCase(courseName)) continue;
                return this.getCourse(course.getId());
            }
        }
        return null;
    }

    @Override
    public XStudent getStudent(Long studentId) {
        Student student = this.getStudentCache().get(studentId);
        return student == null ? null : new XStudent(student, (Assignment<Request, Enrollment>)this.currentSolution().getAssignment());
    }

    @Override
    public XOffering getOffering(Long offeringId) {
        return this.getOfferingCache().get(offeringId);
    }

    @Override
    public <X extends OnlineSectioningAction> X createAction(Class<X> clazz) {
        try {
            return (X)((OnlineSectioningAction)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (InstantiationException e) {
            throw new SectioningException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SectioningException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new SectioningException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new SectioningException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new SectioningException(e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public <E> E execute(OnlineSectioningAction<E> action, OnlineSectioningLog.Entity user) throws SectioningException {
        long c0 = OnlineSectioningHelper.getCpuTime();
        OnlineSectioningHelper h = new OnlineSectioningHelper(user);
        try {
            h.addMessageHandler(new OnlineSectioningHelper.DefaultMessageLogger(LogFactory.getLog((String)(action.getClass().getName() + "." + action.name() + "[" + this.getAcademicSession().toCompactString() + "]"))));
            h.addAction(action, this.getAcademicSession());
            E ret = action.execute(this, h);
            if (h.getAction() != null && !h.getAction().hasResult()) {
                if (ret == null) {
                    h.getAction().setResult(OnlineSectioningLog.Action.ResultType.NULL);
                } else if (ret instanceof Boolean) {
                    h.getAction().setResult((Boolean)ret != false ? OnlineSectioningLog.Action.ResultType.TRUE : OnlineSectioningLog.Action.ResultType.FALSE);
                } else {
                    h.getAction().setResult(OnlineSectioningLog.Action.ResultType.SUCCESS);
                }
            }
            E e = ret;
            return e;
        }
        catch (Exception e) {
            if (e instanceof SectioningException) {
                if (e.getCause() == null) {
                    this.sLog.info((Object)("Execution failed: " + e.getMessage()));
                    h.info("Execution failed: " + e.getMessage());
                } else {
                    this.sLog.warn((Object)("Execution failed: " + e.getMessage()), (Throwable)e);
                    h.warn("Execution failed: " + e.getMessage(), e.getCause());
                }
            } else {
                this.sLog.error((Object)("Execution failed: " + e.getMessage()), (Throwable)e);
                h.error("Execution failed: " + e.getMessage(), e);
            }
            if (h.getAction() != null) {
                h.getAction().setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
                if (e.getCause() != null && e instanceof SectioningException) {
                    h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getCause().getClass().getName() + ": " + e.getCause().getMessage()));
                } else {
                    h.getAction().addMessage(OnlineSectioningLog.Message.newBuilder().setLevel(OnlineSectioningLog.Message.Level.FATAL).setText(e.getMessage() == null ? "null" : e.getMessage()));
                }
            }
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(SCT_MSG.exceptionUnknown(e.getMessage()), e);
        }
        finally {
            if (h.getAction() != null) {
                h.getAction().setEndTime(System.currentTimeMillis()).setCpuTime(OnlineSectioningHelper.getCpuTime() - c0);
            }
            this.sLog.debug((Object)("Executed: " + String.valueOf(h.getLog()) + " (" + h.getLog().toByteArray().length + " bytes)"));
        }
    }

    @Override
    public <E> void execute(OnlineSectioningAction<E> action, OnlineSectioningLog.Entity user, OnlineSectioningServer.ServerCallback<E> callback) throws SectioningException {
        try {
            callback.onSuccess(this.execute(action, user));
        }
        catch (Throwable t) {
            callback.onFailure(t);
        }
    }

    @Override
    public void clearAll() {
    }

    @Override
    public void clearAllStudents() {
    }

    @Override
    public OnlineSectioningServer.Lock readLock() {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock writeLock() {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockAll() {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockStudent(Long studentId, Collection<Long> offeringIds, String actionName) {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockOffering(Long offeringId, Collection<Long> studentIds, String actionName) {
        return new NoLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockRequest(CourseRequestInterface request, String actionName) {
        return new NoLock();
    }

    @Override
    public boolean isOfferingLocked(Long offeringId) {
        return false;
    }

    @Override
    public void lockOffering(Long offeringId) {
    }

    @Override
    public void unlockOffering(Long offeringId) {
    }

    @Override
    public Collection<Long> getLockedOfferings() {
        return null;
    }

    @Override
    public void releaseAllOfferingLocks() {
    }

    @Override
    public void persistExpectedSpaces(Long offeringId) {
    }

    @Override
    public List<Long> getOfferingsToPersistExpectedSpaces(long minimalAge) {
        return null;
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean needPersistExpectedSpaces(Long offeringId) {
        return false;
    }

    @Override
    public void reload() {
    }

    @Override
    public Collection<XCourseRequest> getRequests(Long offeringId) {
        ArrayList<XCourseRequest> ret = new ArrayList<XCourseRequest>();
        HashSet<Long> reqIds = new HashSet<Long>();
        for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
            if (offering.getId() != offeringId.longValue()) continue;
            for (Course course : offering.getCourses()) {
                for (CourseRequest req : course.getRequests()) {
                    if (req.getStudent().isDummy() || !reqIds.add(req.getId())) continue;
                    ret.add(new XCourseRequest(req, (Enrollment)this.currentSolution().getAssignment().getValue((Variable)req)));
                }
            }
        }
        return ret;
    }

    @Override
    public XEnrollments getEnrollments(Long offeringId) {
        return new XEnrollments(offeringId, this.getRequests(offeringId));
    }

    @Override
    public XExpectations getExpectations(Long offeringId) {
        for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
            if (offering.getId() != offeringId.longValue()) continue;
            return new XExpectations(offering);
        }
        return null;
    }

    @Override
    public void update(XExpectations expectations) {
    }

    @Override
    public void remove(XStudent student) {
    }

    @Override
    public void update(XStudent student, boolean updateRequests) {
    }

    @Override
    public void remove(XOffering offering) {
    }

    @Override
    public void update(XOffering offering) {
    }

    @Override
    public XCourseRequest assign(XCourseRequest request, XEnrollment enrollment) {
        return request;
    }

    @Override
    public XCourseRequest waitlist(XCourseRequest request, boolean waitlist) {
        return request;
    }

    @Override
    public boolean checkDeadline(Long courseId, XTime sectionTime, OnlineSectioningServer.Deadline type) {
        return true;
    }

    @Override
    public String getCourseDetails(Long courseId, CourseDetailsProvider provider) {
        XCourse course = this.getCourse(courseId);
        return course == null ? null : course.getDetails(this.getAcademicSession(), provider);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public long getMemUsage() {
        return new MemoryCounter().estimate(this);
    }

    @Override
    public <E> E getProperty(String name, E defaultValue) {
        Object ret = this.iOnlineProperties.get(name);
        return (E)(ret == null ? defaultValue : ret);
    }

    @Override
    public <E> void setProperty(String name, E value) {
        if (value == null) {
            this.iOnlineProperties.remove(name);
        } else {
            this.iOnlineProperties.put(name, value);
        }
    }

    @Override
    public CSVFile getReport(DataProperties parameters) {
        try {
            String reference;
            String name = parameters.getProperty("report", null);
            if (name == null) {
                reference = parameters.getProperty("name");
                if (reference == null) {
                    return null;
                }
                if (this.iReports.containsKey(reference)) {
                    return this.iReports.get(reference);
                }
                name = SectioningReportTypesBackend.ReportType.valueOf(reference).getImplementation();
            }
            if (name == null || name.isEmpty()) {
                return null;
            }
            if (StudentSolver.class.getName().equals(name)) {
                reference = parameters.getProperty("reference");
                return reference == null ? null : (CSVFile)this.iReports.get(reference);
            }
            Class<?> clazz = Class.forName(name);
            StudentSectioningReport report = (StudentSectioningReport)clazz.getConstructor(StudentSectioningModel.class).newInstance(this.currentSolution().getModel());
            return report.create(this.currentSolution().getAssignment(), parameters);
        }
        catch (SectioningException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public OverExpectedCriterion getOverExpectedCriterion() {
        return new NeverOverExpected(this.getConfig());
    }

    @Override
    public SolverParameterGroup.SolverType getType() {
        return SolverParameterGroup.SolverType.STUDENT;
    }

    @Override
    public XCourseId getCourse(Long courseId, String courseName) {
        if (courseId != null) {
            return this.getCourse(courseId);
        }
        if (courseName != null) {
            return this.getCourse(courseName);
        }
        return null;
    }

    @Override
    public Collection<Long> getInstructedOfferings(String instructorExternalId) {
        return this.getInstructedOfferingsCache().get(instructorExternalId);
    }

    @Override
    public Set<Long> getRequestedCourseIds(Long studentId) {
        for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
            if (student.isDummy() || student.getId() != studentId.longValue()) continue;
            HashSet<Long> courseIds = new HashSet<Long>();
            for (Request request : student.getRequests()) {
                if (!(request instanceof CourseRequest)) continue;
                for (Course course : ((CourseRequest)request).getCourses()) {
                    courseIds.add(course.getId());
                }
            }
            return courseIds;
        }
        return null;
    }

    @Override
    public boolean isRunning() {
        if (super.isRunning()) {
            return true;
        }
        return this.iWorking && this.iWorkThread != null && this.iWorkThread instanceof AbstractSolver.InterruptibleThread && this.iWorkThread.isAlive() && !this.iWorkThread.isInterrupted();
    }

    @Override
    public void stopSolver() {
        if (super.isRunning()) {
            super.stopSolver();
        }
        if (this.iWorking && this.iWorkThread != null && this.iWorkThread instanceof AbstractSolver.InterruptibleThread && this.iWorkThread.isAlive() && !this.iWorkThread.isInterrupted()) {
            try {
                this.iWorkThread.interrupt();
                this.iWorkThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<SectioningReports.ReportTypeInterface> getReportTypes() {
        ArrayList<SectioningReports.ReportTypeInterface> ret = new ArrayList<SectioningReports.ReportTypeInterface>();
        for (InMemoryReport report : new TreeSet<InMemoryReport>(this.iReports.values())) {
            ret.add(new SectioningReports.ReportTypeInterface(report.getReference(), report.getName(), StudentSolver.class.getName(), false, "reference", report.getReference()));
        }
        return ret;
    }

    public void setReport(InMemoryReport report) {
        this.iReports.put(report.getReference(), report);
    }

    public InMemoryReport getReport(String reference) {
        return this.iReports.get(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] backupXml() {
        Lock lock = this.currentSolution().getLock().readLock();
        lock.lock();
        try {
            ByteArrayOutputStream ret = new ByteArrayOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream(ret);
            Document document = this.createCurrentSolutionBackup(false, false);
            this.saveProperties(document);
            new XMLWriter((OutputStream)gz, OutputFormat.createCompactFormat()).write(document);
            gz.flush();
            gz.close();
            byte[] byArray = ret.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            this.sLog.error((Object)e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean restoreXml(byte[] data) {
        StudentSectioningModel model = null;
        try {
            if (this.isRunning()) {
                this.stopSolver();
            }
            this.disposeNoInherit(false);
            model = this.createModel(this.getProperties());
            Progress.getInstance((Object)model).addProgressListener((ProgressListener)new ProgressWriter(System.out));
            this.setInitalSolution((Model<Request, Enrollment>)model);
            this.initSolver();
            Document document = new SAXReader().read((InputStream)new GZIPInputStream(new ByteArrayInputStream(data)));
            this.restureCurrentSolutionFromBackup(document);
            if (this.isPublished()) {
                Progress.getInstance((Object)model).setStatus(SCT_MSG.statusPublished());
                model.clearBest();
            } else {
                Progress.getInstance((Object)model).setStatus(MSG.statusReady());
            }
            this.clearCachedData();
            return true;
        }
        catch (Exception e) {
            this.sLog.error((Object)e.getMessage(), (Throwable)e);
            if (model != null) {
                Progress.removeInstance((Object)model);
            }
            return false;
        }
    }

    @Override
    public boolean isPublished() {
        return this.getProperties().getProperty("StudentSct.Published") != null;
    }

    @Override
    public Map<String, String> currentSolutionInfo() {
        String published = this.getProperties().getProperty("StudentSct.Published");
        if (published != null) {
            Map info = this.currentSolution().getModel().getExtendedInfo(this.currentSolution().getAssignment());
            info.put(" " + SCT_MSG.infoPublished(), Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP).format(new Date(Long.valueOf(published))));
            return info;
        }
        return super.currentSolutionInfo();
    }

    @Override
    public boolean canPassivate() {
        return super.canPassivate() && !this.isPublished();
    }

    @Override
    public boolean restore(File folder, String puid, boolean removeFiles) {
        if (super.restore(folder, puid, removeFiles)) {
            if (this.isPublished()) {
                Progress.getInstance((Object)this.currentSolution().getModel()).setStatus(SCT_MSG.statusPublished());
            }
            return true;
        }
        return false;
    }

    protected Gson getGson() {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        builder.setPrettyPrinting();
        return builder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finishBeforeSave() {
        if (this.getProperties().getPropertyBoolean("General.Validate", false) && this.isCanValidate()) {
            ProblemSaver<Request, Enrollment, StudentSectioningModel> saver = this.getCustomValidator((Solver<Request, Enrollment>)this);
            Lock lock = this.currentSolution().getLock().readLock();
            saver.setTerminationCondition((TerminationCondition)new TerminationCondition<Request, Enrollment>(){

                public boolean canContinue(Solution<Request, Enrollment> currentSolution) {
                    return !StudentSolver.this.isStop();
                }
            });
            lock.lock();
            try {
                saver.save();
            }
            catch (Exception e) {
                this.sLog.error((Object)("Failed to validate the problem: " + e.getMessage()), (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        if (this.getProperties().getPropertyBoolean("General.Publish", false)) {
            SolverPredefinedSetting config;
            byte[] data = this.backupXml();
            SectioningSolutionLog log = new SectioningSolutionLog();
            log.setData(data);
            log.setInfo(this.getGson().toJson(this.currentSolutionInfo()));
            log.setTimeStamp(new Date());
            log.setSession((org.unitime.timetable.model.Session)SessionDAO.getInstance().get(this.getSessionId()));
            String mgrId = this.getProperties().getProperty("General.OwnerPuid");
            log.setOwner(TimetableManager.findByExternalId(mgrId));
            Long configId = this.getProperties().getPropertyLong("General.SettingsId", null);
            if (configId != null && (config = (SolverPredefinedSetting)SolverPredefinedSettingDAO.getInstance().get(configId)) != null) {
                log.setConfig(config.getDescription());
            }
            SectioningSolutionLogDAO.getInstance().getSession().persist((Object)log);
            SectioningSolutionLogDAO.getInstance().getSession().flush();
            Long publishId = log.getUniqueId();
            if (SolverServerImplementation.getInstance() != null) {
                SolverServerImplementation.getInstance().unloadSolver(this.getType(), "PUBLISHED_" + this.getSessionId());
                DataProperties config2 = new DataProperties(this.getProperties().toMap());
                config2.setProperty("StudentSct.Published", String.valueOf(new Date().getTime()));
                config2.setProperty("StudentSct.PublishId", publishId.toString());
                config2.setProperty("General.OwnerPuid", "PUBLISHED_" + config2.getProperty("General.SessionId"));
                StudentSolverProxy solver = SolverServerImplementation.getInstance().getStudentSolverContainer().createSolver("PUBLISHED_" + config2.getProperty("General.SessionId"), config2);
                if (!solver.restoreXml(data)) {
                    solver.dispose();
                }
            }
        }
    }

    protected void saveReports(Document document) {
        Element reports = document.getRootElement().addElement("reports");
        for (InMemoryReport r : this.iReports.values()) {
            try {
                StringWriter sw = new StringWriter();
                r.save(sw);
                reports.addElement("report").addAttribute("reference", r.getReference()).addAttribute("name", r.getName()).add((CDATA)new DOMCDATA(sw.toString()));
            }
            catch (Exception exception) {}
        }
    }

    protected void readReports(Document document) {
        this.iReports.clear();
        Element reports = document.getRootElement().element("reports");
        if (reports != null) {
            Iterator i = reports.elementIterator("report");
            while (i.hasNext()) {
                Element e = (Element)i.next();
                InMemoryReport r = new InMemoryReport(e.attributeValue("reference"), e.attributeValue("name"));
                try {
                    r.load(new StringReader(e.getText()));
                    this.iReports.put(r.getReference(), r);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock lock = this.currentSolution().getLock().writeLock();
        lock.lock();
        try {
            for (Request request : this.currentSolution().getModel().variables()) {
                if (request instanceof CourseRequest && ((CourseRequest)request).isFixed()) continue;
                this.currentSolution().getAssignment().unassign(0L, (Variable)request);
            }
            this.currentSolution().clearBest();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public OnlineSectioningServer.CourseDeadlines getCourseDeadlines(Long courseId) {
        return new OnlineSectioningServer.CourseDeadlines(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public boolean checkDeadline(XTime sectionTime, OnlineSectioningServer.Deadline type) {
                return true;
            }
        };
    }

    public static ReservationInterface convert(Reservation reservation, StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
        StudentGroupReservation sgr;
        ReservationInterface.IdName g;
        ReservationInterface r = null;
        Course co = null;
        for (Course c : reservation.getOffering().getCourses()) {
            if (co != null && !reservation.getOffering().getName().equals(c.getName())) continue;
            co = c;
        }
        if (reservation instanceof org.cpsolver.studentsct.reservation.LearningCommunityReservation) {
            LearningCommunityReservation lcr = (LearningCommunityReservation)LearningCommunityReservationDAO.getInstance().get(reservation.getId());
            if (lcr != null) {
                r = new ReservationInterface.LCReservation();
                g = new ReservationInterface.IdName();
                g.setAbbv(lcr.getGroup().getGroupAbbreviation());
                g.setName(lcr.getGroup().getGroupName());
                g.setLimit(lcr.getGroup().getStudents().size());
                ((ReservationInterface.LCReservation)r).setGroup(g);
                co = ((org.cpsolver.studentsct.reservation.LearningCommunityReservation)reservation).getCourse();
                ReservationInterface.Course course = new ReservationInterface.Course();
                course.setId(co.getId());
                course.setAbbv(co.getName());
                course.setControl(reservation.getOffering().getName().equals(co.getName()));
                course.setLimit(co.getLimit() < 0 ? null : Integer.valueOf(co.getLimit()));
                ((ReservationInterface.LCReservation)r).setCourse(course);
            }
        } else if (reservation instanceof GroupReservation && (sgr = (StudentGroupReservation)StudentGroupReservationDAO.getInstance().get(reservation.getId())) != null) {
            r = new ReservationInterface.GroupReservation();
            g = new ReservationInterface.IdName();
            g.setAbbv(sgr.getGroup().getGroupAbbreviation());
            g.setName(sgr.getGroup().getGroupName());
            g.setLimit(sgr.getGroup().getStudents().size());
            ((ReservationInterface.GroupReservation)r).setGroup(g);
            r.setOverride(sgr instanceof GroupOverrideReservation);
        }
        if (r == null) {
            if (reservation instanceof CourseReservation) {
                co = ((CourseReservation)reservation).getCourse();
                ReservationInterface.Course course = new ReservationInterface.Course();
                course.setId(co.getId());
                course.setAbbv(co.getName());
                course.setControl(reservation.getOffering().getName().equals(co.getName()));
                course.setLimit(co.getLimit() < 0 ? null : Integer.valueOf(co.getLimit()));
                r = new ReservationInterface.CourseReservation();
                r.setOverride(reservation.mustBeUsed() || reservation.canAssignOverLimit() || reservation.isAllowDisabled());
                ((ReservationInterface.CourseReservation)r).setCourse(course);
                r.setProjection(co.getProjected());
                r.setEnrollment(((Course.CourseContext)co.getContext(assignment)).getEnrollments().size());
            } else if (reservation instanceof CurriculumReservation) {
                CurriculumReservation cr = (CurriculumReservation)reservation;
                r = new ReservationInterface.CurriculumReservation();
                r.setOverride(reservation.mustBeUsed() || reservation.canAssignOverLimit() || reservation.isAllowDisabled());
                ReservationInterface.Areas curriculum = new ReservationInterface.Areas();
                long areaId = 0L;
                for (String area : cr.getAcademicAreas()) {
                    ReservationInterface.IdName aa = new ReservationInterface.IdName();
                    aa.setId(areaId++);
                    aa.setAbbv(area);
                    aa.setName(area);
                    curriculum.getAreas().add(aa);
                }
                long clasfId = 0L;
                for (Object classification : cr.getClassifications()) {
                    ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                    clasf.setId(clasfId++);
                    clasf.setAbbv((String)classification);
                    clasf.setName((String)classification);
                    curriculum.getClassifications().add(clasf);
                }
                long majorId = 0L;
                long concId = 0L;
                for (String major : cr.getMajors()) {
                    ReservationInterface.IdName mj = new ReservationInterface.IdName();
                    mj.setId(majorId);
                    mj.setAbbv(major);
                    mj.setName(major);
                    curriculum.getMajors().add(mj);
                    if (cr.getConcentrations(major) != null) {
                        for (String conc : cr.getConcentrations(major)) {
                            ReservationInterface.IdName cc = new ReservationInterface.IdName();
                            cc.setId(concId++);
                            cc.setAbbv(conc);
                            cc.setParentId(majorId);
                            cc.setName(conc);
                            curriculum.getConcentrations().add(cc);
                        }
                    }
                    ++majorId;
                }
                for (String minor : cr.getMinors()) {
                    ReservationInterface.IdName mn = new ReservationInterface.IdName();
                    mn.setAbbv(minor);
                    mn.setName(minor);
                    curriculum.getMinors().add(mn);
                }
                if (curriculum.getAreas().size() > 1) {
                    Collections.sort(curriculum.getAreas(), new Comparator<ReservationInterface.IdName>(){

                        @Override
                        public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                            int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = s1.getName().compareTo(s2.getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return s1.getId().compareTo(s2.getId());
                        }
                    });
                }
                Collections.sort(curriculum.getMajors(), new Comparator<ReservationInterface.IdName>(){

                    @Override
                    public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                        int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = s1.getName().compareTo(s2.getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getId().compareTo(s2.getId());
                    }
                });
                Collections.sort(curriculum.getClassifications(), new Comparator<ReservationInterface.IdName>(){

                    @Override
                    public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                        int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = s1.getName().compareTo(s2.getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getId().compareTo(s2.getId());
                    }
                });
                Collections.sort(curriculum.getMinors(), new Comparator<ReservationInterface.IdName>(){

                    @Override
                    public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                        int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = s1.getName().compareTo(s2.getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getId().compareTo(s2.getId());
                    }
                });
                Collections.sort(curriculum.getConcentrations(), new Comparator<ReservationInterface.IdName>(){

                    @Override
                    public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                        int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = s1.getName().compareTo(s2.getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getId().compareTo(s2.getId());
                    }
                });
                ((ReservationInterface.CurriculumReservation)r).setCurriculum(curriculum);
            } else if (reservation instanceof IndividualReservation) {
                r = new ReservationInterface.IndividualReservation();
                r.setOverride(reservation instanceof ReservationOverride || !reservation.mustBeUsed());
                if (reservation instanceof ReservationOverride) {
                    r = new ReservationInterface.OverrideReservation(reservation.canAssignOverLimit() && reservation.isAllowOverlap() && reservation.canBreakLinkedSections() ? ReservationInterface.OverrideType.AllowOverLimitTimeConflictLink : (reservation.canAssignOverLimit() && reservation.canBreakLinkedSections() ? ReservationInterface.OverrideType.AllowOverLimitLink : (reservation.isAllowOverlap() && reservation.canBreakLinkedSections() ? ReservationInterface.OverrideType.AllowTimeConflictLink : (reservation.canAssignOverLimit() && reservation.isAllowOverlap() ? ReservationInterface.OverrideType.AllowOverLimitTimeConflict : (reservation.canAssignOverLimit() ? ReservationInterface.OverrideType.AllowOverLimit : (reservation.isAllowOverlap() ? ReservationInterface.OverrideType.AllowTimeConflict : (reservation.canBreakLinkedSections() ? ReservationInterface.OverrideType.CoReqOverride : ReservationInterface.OverrideType.Other)))))));
                } else {
                    r.setOverride(!reservation.mustBeUsed() || !reservation.canAssignOverLimit() || !reservation.isAllowDisabled());
                }
                for (Student student : model.getStudents()) {
                    if (!((IndividualReservation)reservation).getStudentIds().contains(student.getId())) continue;
                    ReservationInterface.IdName s = new ReservationInterface.IdName();
                    s.setId(student.getId());
                    s.setAbbv(student.getExternalId());
                    s.setName(student.getName());
                    ((ReservationInterface.IndividualReservation)r).getStudents().add(s);
                }
                Collections.sort(((ReservationInterface.IndividualReservation)r).getStudents(), new Comparator<ReservationInterface.IdName>(){

                    @Override
                    public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                        int cmp = s1.getName().compareTo(s2.getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getAbbv().compareTo(s2.getAbbv());
                    }
                });
            } else if (reservation instanceof UniversalOverride) {
                r = new ReservationInterface.UniversalReservation();
                ((ReservationInterface.UniversalReservation)r).setFilter(((UniversalOverride)reservation).getFilter());
            } else {
                return null;
            }
        }
        r.setEnrollment(((Reservation.ReservationContext)reservation.getContext(assignment)).getEnrollments().size());
        ReservationInterface.Offering offering = new ReservationInterface.Offering();
        offering.setAbbv(co.getName());
        offering.setId(reservation.getOffering().getId());
        offering.setOffered(true);
        r.setOffering(offering);
        for (Course cx : reservation.getOffering().getCourses()) {
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(cx.getId());
            course.setAbbv(cx.getName());
            course.setControl(reservation.getOffering().getName().equals(cx.getName()));
            course.setLimit(cx.getLimit() < 0 ? null : Integer.valueOf(cx.getLimit()));
            offering.getCourses().add(course);
        }
        for (Config ioc : reservation.getOffering().getConfigs()) {
            if (reservation.getConfigs().contains(ioc)) {
                boolean hasSection = false;
                for (Subpart subpart : ioc.getSubparts()) {
                    Set sections = reservation.getSections(subpart);
                    if (sections == null) continue;
                    for (Section c : sections) {
                        ReservationInterface.Clazz clazz = new ReservationInterface.Clazz();
                        clazz.setId(c.getId());
                        clazz.setAbbv(c.getName(c.getId()));
                        clazz.setName(subpart.getName() + " " + c.getName(c.getId()));
                        clazz.setLimit(c.getLimit() < 0 ? null : Integer.valueOf(c.getLimit()));
                        r.getClasses().add(clazz);
                        hasSection = true;
                    }
                }
                if (hasSection) continue;
                ReservationInterface.Config config = new ReservationInterface.Config();
                config.setId(ioc.getId());
                config.setName(ioc.getName());
                config.setAbbv(ioc.getName());
                config.setLimit(ioc.getLimit() < 0 ? null : Integer.valueOf(ioc.getLimit()));
                r.getConfigs().add(config);
                continue;
            }
            for (Subpart subpart : ioc.getSubparts()) {
                Set sections = reservation.getSections(subpart);
                if (sections == null) continue;
                for (Section c : sections) {
                    ReservationInterface.Clazz clazz = new ReservationInterface.Clazz();
                    clazz.setId(c.getId());
                    clazz.setAbbv(c.getName(c.getId()));
                    clazz.setName(subpart.getName() + " " + c.getName(c.getId()));
                    clazz.setLimit(c.getLimit() < 0 ? null : Integer.valueOf(c.getLimit()));
                    r.getClasses().add(clazz);
                }
            }
        }
        r.setExpired(reservation.isExpired());
        r.setLimit(reservation.getReservationLimit() < 0.0 ? null : Integer.valueOf((int)Math.round(reservation.getReservationLimit())));
        r.setInclusive(reservation.areRestrictionsInclusive());
        r.setId(reservation.getId());
        r.setAllowOverlaps(reservation.isAllowOverlap());
        r.setMustBeUsed(reservation.mustBeUsed());
        r.setAlwaysExpired(reservation instanceof ReservationOverride || reservation instanceof CurriculumOverride);
        r.setOverLimit(reservation.canAssignOverLimit());
        return r;
    }

    @Override
    public List<ReservationInterface> getReservations(Long offeringId) {
        Assignment assignment = this.currentSolution().getAssignment();
        for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
            if (!offeringId.equals(offering.getId())) continue;
            ArrayList<ReservationInterface> ret = new ArrayList<ReservationInterface>();
            for (Reservation r : offering.getReservations()) {
                ReservationInterface res = StudentSolver.convert(r, (StudentSectioningModel)this.getModel(), (Assignment<Request, Enrollment>)assignment);
                if (res == null) continue;
                ret.add(res);
            }
            Collections.sort(ret);
            return ret;
        }
        return null;
    }

    @Override
    public void setSchedulingRules(XSchedulingRules rules) {
        this.iRules = rules;
    }

    @Override
    public XSchedulingRule getSchedulingRule(XStudent student, StudentSchedulingRule.Mode mode, boolean isAdvisor, boolean isAdmin) {
        if (this.iRules != null) {
            return this.iRules.getRule(student, mode, this, isAdvisor, isAdmin);
        }
        StudentSchedulingRule rule = StudentSchedulingRule.getRule(new StatusPageSuggestionsAction.StudentMatcher(student, this.getAcademicSession().getDefaultSectioningStatus(), this, false), this.getAcademicSession(), isAdvisor, isAdmin, mode, StudentSchedulingRuleDAO.getInstance().getSession());
        return rule == null ? null : new XSchedulingRule(rule);
    }

    @Override
    public XSchedulingRule getSchedulingRule(Long studentId, StudentSchedulingRule.Mode mode, boolean isAdvisor, boolean isAdmin) {
        XStudent student = this.getStudent(studentId);
        if (student == null) {
            return null;
        }
        return this.getSchedulingRule(student, mode, isAdvisor, isAdmin);
    }

    @Override
    public Collection<XClassEnrollment> getStudentSchedule(String studentExternalId) {
        XStudent student = this.getStudentForExternalId(studentExternalId);
        if (student == null) {
            return null;
        }
        ArrayList<XClassEnrollment> ret = new ArrayList<XClassEnrollment>();
        for (XRequest request : student.getRequests()) {
            XCourseRequest cr;
            XEnrollment e;
            if (!(request instanceof XCourseRequest) || (e = (cr = (XCourseRequest)request).getEnrollment()) == null) continue;
            XOffering offering = this.getOffering(e.getOfferingId());
            XEnrollments enrl = this.getEnrollments(e.getOfferingId());
            for (XSection section : offering.getSections(e)) {
                XClassEnrollment ce = new XClassEnrollment(e, section);
                if (section.getParentId() != null) {
                    ce.setParentSectionName(offering.getSection(section.getParentId()).getName(e.getCourseId()));
                }
                if (enrl != null) {
                    ce.setEnrollment(enrl.countEnrollmentsForSection(section.getSectionId()));
                }
                XSubpart subpart = offering.getSubpart(section.getSubpartId());
                ce.setCredit(subpart.getCredit(e.getCourseId()));
                Float creditOverride = section.getCreditOverride(e.getCourseId());
                if (creditOverride != null) {
                    ce.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                }
                ret.add(ce);
            }
        }
        return ret;
    }

    @Override
    public XStudent getStudentForExternalId(String externalUniqueId) {
        if (externalUniqueId == null || externalUniqueId.isEmpty()) {
            return null;
        }
        Student student = this.getStudentExtCache().get(externalUniqueId);
        return student == null ? null : new XStudent(student, (Assignment<Request, Enrollment>)this.currentSolution().getAssignment());
    }

    @Override
    public DistanceMetric getUnavailabilityDistanceMetric() {
        if (((StudentSectioningModel)this.getModel()).getStudentQuality() != null) {
            return ((StudentSectioningModel)this.getModel()).getStudentQuality().getStudentQualityContext().getUnavailabilityDistanceMetric();
        }
        return this.getDistanceMetric();
    }

    @Override
    public float[] getCredits(String studentExternalId) {
        Student student = this.getStudentExtCache().get(studentExternalId);
        if (student == null) {
            return null;
        }
        ArrayList<Float> mins = new ArrayList<Float>();
        ArrayList<Float> maxs = new ArrayList<Float>();
        int nrCourses = 0;
        float tMin = 0.0f;
        float tMax = 0.0f;
        float tEnrl = 0.0f;
        for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest cr = (CourseRequest)request;
            Enrollment e = (Enrollment)this.currentSolution().getAssignment().getValue((Variable)cr);
            if (e != null) {
                tEnrl += e.getCredit();
            }
            Float min = null;
            Float max = null;
            for (Course course : cr.getCourses()) {
                if (course.getCredit() == null) continue;
                XCredit xc = new XCredit(course.getCredit());
                if (min == null || min.floatValue() > xc.getMinCredit().floatValue()) {
                    min = xc.getMinCredit();
                }
                if (max != null && !(max.floatValue() < xc.getMaxCredit().floatValue())) continue;
                max = xc.getMaxCredit();
            }
            if (cr.isAlternative()) {
                if (min == null) continue;
                mins.add(min);
                maxs.add(max);
                continue;
            }
            if (min == null) continue;
            if (cr.isWaitlist()) {
                tMin += min.floatValue();
                tMax += max.floatValue();
                continue;
            }
            mins.add(min);
            maxs.add(max);
            ++nrCourses;
        }
        Collections.sort(mins);
        Collections.sort(maxs);
        for (int i = 0; i < nrCourses; ++i) {
            tMin += ((Float)mins.get(i)).floatValue();
            tMax += ((Float)maxs.get(maxs.size() - i - 1)).floatValue();
        }
        return new float[]{tMin, tMax, tEnrl};
    }

    public List<GetAssignment.CourseSection> getUnavailabilities(Long studentId) {
        Student student = this.getStudentCache().get(studentId);
        if (student == null) {
            return null;
        }
        ArrayList<GetAssignment.CourseSection> sections = new ArrayList<GetAssignment.CourseSection>();
        XCourseId courseId = null;
        for (Unavailability unavailability : student.getUnavailabilities()) {
            if (unavailability.getSection().getSubpart() == null || unavailability.getCourseId() == null) continue;
            if (courseId == null || !courseId.getCourseId().equals(unavailability.getCourseId())) {
                courseId = null;
                for (Course course : unavailability.getSection().getSubpart().getConfig().getOffering().getCourses()) {
                    if (!unavailability.getCourseId().equals(course.getId())) continue;
                    courseId = new XCourseId(course);
                    break;
                }
                if (courseId == null) {
                    Course course = (Course)unavailability.getSection().getSubpart().getConfig().getOffering().getCourses().get(0);
                    courseId = new XCourseId(course);
                }
            }
            sections.add(new GetAssignment.CourseSection(courseId, new XSection(unavailability.getSection()), unavailability.isAllowOverlap(), unavailability.isTeachingAssignment()));
        }
        return sections;
    }

    public List<GetAssignment.CourseSection> fillUnavailabilitiesIn(ClassAssignmentInterface ret, Long studentId) {
        Student student = this.getStudentCache().get(studentId);
        if (student == null) {
            return null;
        }
        ArrayList<GetAssignment.CourseSection> sections = new ArrayList<GetAssignment.CourseSection>();
        XCourseId courseId = null;
        String courseNote = null;
        ClassAssignmentInterface.CourseAssignment ca = null;
        for (Unavailability unavailability : student.getUnavailabilities()) {
            if (unavailability.getSection().getSubpart() == null || unavailability.getCourseId() == null) continue;
            if (courseId == null || !courseId.getCourseId().equals(unavailability.getCourseId())) {
                ca = new ClassAssignmentInterface.CourseAssignment();
                ca.setCanWaitList(false);
                ca.setAssigned(true);
                ca.setCourseId(unavailability.getCourseId());
                courseId = null;
                courseNote = null;
                for (Course course : unavailability.getSection().getSubpart().getConfig().getOffering().getCourses()) {
                    if (!unavailability.getCourseId().equals(course.getId())) continue;
                    courseId = new XCourseId(course);
                    courseNote = course.getNote();
                    break;
                }
                if (courseId == null) {
                    Course course = (Course)unavailability.getSection().getSubpart().getConfig().getOffering().getCourses().get(0);
                    courseId = new XCourseId(course);
                    courseNote = course.getNote();
                }
                ca.setSubject(courseId.getSubjectArea());
                ca.setCourseNbr(courseId.getCourseNumber());
                ca.setTitle(courseId.getTitle());
                ca.setTeachingAssignment(true);
                ca.setHasCrossList(unavailability.getSection().getSubpart().getConfig().getOffering().getCourses().size() > 0);
                ret.add(ca);
            }
            ClassAssignmentInterface.ClassAssignment a = ca.addClassAssignment();
            a.setAlternative(false);
            a.setClassId(unavailability.getSection().getId());
            a.setSubpart(unavailability.getSection().getSubpart().getName());
            a.setClassNumber(unavailability.getSection().getName());
            a.setSection(unavailability.getSection().getName(unavailability.getCourseId().longValue()));
            a.setExternalId(unavailability.getSection().getName(unavailability.getCourseId().longValue()));
            a.setCancelled(unavailability.getSection().isCancelled());
            a.setLimit(new int[]{0, unavailability.getSection().getLimit()});
            if (unavailability.getSection().getTime() != null) {
                for (DayCode d : DayCode.toDayCodes(unavailability.getSection().getTime().getDayCode())) {
                    a.addDay(d.getIndex());
                }
                a.setStart(unavailability.getSection().getTime().getStartSlot());
                a.setLength(unavailability.getSection().getTime().getLength());
                a.setBreakTime(unavailability.getSection().getTime().getBreakTime());
                a.setDatePattern(unavailability.getSection().getTime().getDatePatternName());
            }
            if (unavailability.getSection().getRooms() != null) {
                for (RoomLocation room : unavailability.getSection().getRooms()) {
                    a.addRoom(room.getId(), room.getName());
                }
            }
            for (Instructor instr : unavailability.getSection().getInstructors()) {
                a.addInstructor(instr.getName());
                a.addInstructoEmail(instr.getEmail() == null ? "" : instr.getEmail());
            }
            if (unavailability.getSection().getParent() != null) {
                a.setParentSection(unavailability.getSection().getParent().getName(unavailability.getCourseId().longValue()));
            }
            a.setSubpartId(unavailability.getSection().getSubpart().getId());
            a.setHasAlternatives(false);
            a.addNote(courseNote);
            a.addNote(unavailability.getSection().getNote());
            a.setCredit(unavailability.getSection().getSubpart().getCredit());
            a.setCreditRange(unavailability.getSection().getSubpart().getCreditValue(), unavailability.getSection().getSubpart().getCreditValue());
            a.setTeachingAssignment(true);
            a.setInstructing(unavailability.isTeachingAssignment());
            sections.add(new GetAssignment.CourseSection(courseId, new XSection(unavailability.getSection()), unavailability.isAllowOverlap(), unavailability.isTeachingAssignment()));
        }
        return sections;
    }

    public class ReloadingDoneCallback
    implements Callback {
        Map<Long, Map<Long, Enrollment>> iCurrentAssignmentTable = new Hashtable<Long, Map<Long, Enrollment>>();
        Map<Long, Map<Long, Enrollment>> iBestAssignmentTable = new Hashtable<Long, Map<Long, Enrollment>>();
        Map<Long, Map<Long, Enrollment>> iInitialAssignmentTable = new Hashtable<Long, Map<Long, Enrollment>>();
        String iSolutionId = null;
        Progress iProgress = null;

        public ReloadingDoneCallback() {
            this.iSolutionId = StudentSolver.this.getProperties().getProperty("General.SolutionId");
            for (Request request : StudentSolver.this.currentSolution().getModel().variables()) {
                Map<Long, Enrollment> assignments;
                Enrollment enrollment = (Enrollment)StudentSolver.this.currentSolution().getAssignment().getValue((Variable)request);
                if (enrollment != null) {
                    assignments = this.iCurrentAssignmentTable.get(request.getStudent().getId());
                    if (assignments == null) {
                        assignments = new Hashtable<Long, Enrollment>();
                        this.iCurrentAssignmentTable.put(request.getStudent().getId(), assignments);
                    }
                    assignments.put(request.getId(), enrollment);
                }
                if (request.getBestAssignment() != null) {
                    assignments = this.iBestAssignmentTable.get(request.getStudent().getId());
                    if (assignments == null) {
                        assignments = new Hashtable<Long, Enrollment>();
                        this.iBestAssignmentTable.put(request.getStudent().getId(), assignments);
                    }
                    assignments.put(request.getId(), (Enrollment)request.getBestAssignment());
                }
                if (request.getInitialAssignment() == null) continue;
                assignments = this.iInitialAssignmentTable.get(request.getStudent().getId());
                if (assignments == null) {
                    assignments = new Hashtable<Long, Enrollment>();
                    this.iInitialAssignmentTable.put(request.getStudent().getId(), assignments);
                }
                assignments.put(request.getId(), (Enrollment)request.getInitialAssignment());
            }
        }

        private Enrollment getEnrollment(Request request, Enrollment enrollment) {
            if (request instanceof FreeTimeRequest) {
                return ((FreeTimeRequest)request).createEnrollment();
            }
            CourseRequest cr = (CourseRequest)request;
            HashSet<Section> sections = new HashSet<Section>();
            for (Section s : enrollment.getSections()) {
                Section section = cr.getSection(s.getId());
                if (section == null) {
                    this.iProgress.warn("Section " + s.getName() + " is not available for " + cr.getName());
                    return null;
                }
                sections.add(section);
            }
            return cr.createEnrollment(StudentSolver.this.currentSolution().getAssignment(), sections);
        }

        private void assign(Enrollment enrollment, boolean warn) {
            if (!enrollment.getStudent().isAvailable(enrollment)) {
                if (warn) {
                    this.iProgress.warn("There is a problem assigning " + enrollment.getName() + " to " + enrollment.getStudent().getName() + " (" + enrollment.getStudent().getExternalId() + "): Student not available.");
                } else {
                    this.iProgress.info("There is a problem assigning " + enrollment.getName() + " to " + enrollment.getStudent().getName() + " (" + enrollment.getStudent().getExternalId() + "): Student not available.");
                }
                return;
            }
            Map conflictConstraints = StudentSolver.this.currentSolution().getModel().conflictConstraints(StudentSolver.this.currentSolution().getAssignment(), (Value)enrollment);
            if (conflictConstraints.isEmpty()) {
                StudentSolver.this.currentSolution().getAssignment().assign(0L, (Value)enrollment);
            } else {
                if (warn) {
                    this.iProgress.warn("There is a problem assigning " + enrollment.getName() + " to " + enrollment.getStudent().getName() + " (" + enrollment.getStudent().getExternalId() + ")");
                } else {
                    this.iProgress.info("There is a problem assigning " + enrollment.getName() + " to " + enrollment.getStudent().getName() + " (" + enrollment.getStudent().getExternalId() + ")");
                }
                for (Constraint c : conflictConstraints.keySet()) {
                    Set vals = (Set)conflictConstraints.get(c);
                    for (Enrollment enrl : vals) {
                        this.iProgress.info("    conflicts with " + enrl.getName() + (String)(enrl.getRequest().getStudent().getId() != enrollment.getStudent().getId() ? " of a different student (" + enrl.getRequest().getStudent().getExternalId() + ")" : "") + " due to " + c.getClass().getSimpleName());
                    }
                }
            }
        }

        private void unassignAll() {
            for (Request request : StudentSolver.this.currentSolution().getModel().variables()) {
                StudentSolver.this.currentSolution().getAssignment().unassign(0L, (Variable)request);
            }
        }

        public void execute() {
            Enrollment enrollment;
            Request request;
            Map r;
            this.iProgress = Progress.getInstance((Object)StudentSolver.this.currentSolution().getModel());
            Hashtable<Long, Hashtable<Long, Request>> requests = new Hashtable<Long, Hashtable<Long, Request>>();
            for (Request request2 : StudentSolver.this.currentSolution().getModel().variables()) {
                r = (Hashtable<Long, Request>)requests.get(request2.getStudent().getId());
                if (r == null) {
                    r = new Hashtable<Long, Request>();
                    requests.put(request2.getStudent().getId(), (Hashtable<Long, Request>)r);
                }
                r.put(request2.getId(), request2);
            }
            if (!this.iBestAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating best assignment ...", (long)this.iBestAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iBestAssignmentTable.entrySet()) {
                    r = (Map)requests.get(entry.getKey());
                    this.iProgress.incProgress();
                    if (r == null) continue;
                    for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                        request = (Request)r.get(e2.getKey());
                        if (request == null || (enrollment = this.getEnrollment(request, (Enrollment)e2.getValue())) == null) continue;
                        this.assign(enrollment, false);
                    }
                }
                StudentSolver.this.currentSolution().saveBest();
            }
            if (!this.iInitialAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating initial assignment ...", (long)this.iInitialAssignmentTable.size());
                for (Map.Entry entry : this.iInitialAssignmentTable.entrySet()) {
                    r = (Map)requests.get(entry.getKey());
                    this.iProgress.incProgress();
                    if (r == null) continue;
                    for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                        request = (Request)r.get(e2.getKey());
                        if (request == null || (enrollment = this.getEnrollment(request, (Enrollment)e2.getValue())) == null) continue;
                        request.setInitialAssignment((Value)enrollment);
                    }
                }
            }
            if (!this.iCurrentAssignmentTable.isEmpty()) {
                this.iProgress.setPhase("Creating current assignment ...", (long)this.iCurrentAssignmentTable.size());
                this.unassignAll();
                for (Map.Entry entry : this.iCurrentAssignmentTable.entrySet()) {
                    r = (Map)requests.get(entry.getKey());
                    this.iProgress.incProgress();
                    if (r == null) continue;
                    for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                        request = (Request)r.get(e2.getKey());
                        if (request == null || (enrollment = this.getEnrollment(request, (Enrollment)e2.getValue())) == null) continue;
                        this.assign(enrollment, true);
                    }
                }
            }
            this.iCurrentAssignmentTable.clear();
            this.iBestAssignmentTable.clear();
            this.iInitialAssignmentTable.clear();
            this.iProgress = null;
            if (this.iSolutionId != null) {
                StudentSolver.this.getProperties().setProperty("General.SolutionId", this.iSolutionId);
            }
            StudentSolver.this.iLoadedDate = new Date();
            StudentSolver.this.iWorking = false;
            StudentSolver.this.afterLoad();
            Progress.getInstance((Object)StudentSolver.this.currentSolution().getModel()).setStatus("Awaiting commands ...");
        }
    }

    public static class NoLock
    implements OnlineSectioningServer.Lock {
        @Override
        public void release() {
        }
    }
}

