/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.DeptBalancingReport;
import org.unitime.timetable.solver.ui.DiscouragedInstructorBtbReport;
import org.unitime.timetable.solver.ui.JenrlInfo;
import org.unitime.timetable.solver.ui.PerturbationReport;
import org.unitime.timetable.solver.ui.RoomReport;
import org.unitime.timetable.solver.ui.SameSubpartBalancingReport;
import org.unitime.timetable.solver.ui.StudentConflictsReport;
import org.unitime.timetable.solver.ui.ViolatedDistrPreferencesReport;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

@GwtRpcImplements(value=CourseTimetablingSolverInterface.SolverReportsRequest.class)
public class SolverReportsBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.SolverReportsRequest, CourseTimetablingSolverInterface.SolverReportsResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Formats.Format<Number> sDoubleFormat = Formats.getNumberFormat("0.00");
    protected static DecimalFormat sDF = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public CourseTimetablingSolverInterface.SolverReportsResponse execute(CourseTimetablingSolverInterface.SolverReportsRequest request, SessionContext context) {
        PerturbationReport perturbationReport;
        SameSubpartBalancingReport sameSubpartBalancingReport;
        DeptBalancingReport deptBalancingReport;
        StudentConflictsReport studentConflictsReport;
        DiscouragedInstructorBtbReport discouragedInstructorBtbReportReport;
        ViolatedDistrPreferencesReport violatedDistrPreferencesReport;
        DatePattern dp;
        context.checkPermission(Right.SolutionReports);
        SolverProxy solver = this.courseTimetablingSolverService.getSolver();
        if (solver == null) {
            throw new GwtRpcException(MESSAGES.warnSolverNotLoaded());
        }
        Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        BitSet sessionDays = session.getDefaultDatePattern().getPatternBitSet();
        int startDayDayOfWeek = Constants.getDayOfWeek(session.getDefaultDatePattern().getStartDate());
        Float nrWeeks = null;
        if (ApplicationProperty.TimetableGridUtilizationSkipHolidays.isFalse() && (dp = session.getDefaultDatePatternNotNull()) != null) {
            nrWeeks = Float.valueOf(dp.getEffectiveNumberOfWeeks());
        }
        CourseTimetablingSolverInterface.SolverReportsResponse response = new CourseTimetablingSolverInterface.SolverReportsResponse();
        for (RoomType type : RoomType.findAll()) {
            TableInterface.TableHeaderIterface[] roomReport = solver.getRoomReport(sessionDays, startDayDayOfWeek, type.getUniqueId(), nrWeeks);
            if (roomReport == null || roomReport.getGroups().isEmpty()) continue;
            response.addTable(SolverReportsBackend.getRoomReportTable((RoomReport)roomReport, type));
        }
        RoomReport roomReport = solver.getRoomReport(sessionDays, startDayDayOfWeek, null, nrWeeks);
        if (roomReport != null && !roomReport.getGroups().isEmpty()) {
            response.addTable(SolverReportsBackend.getRoomReportTable(roomReport, null));
        }
        if (response.hasTables()) {
            for (int i = 0; i < response.getTables().size() - 1; ++i) {
                for (TableInterface.TableHeaderIterface h : response.getTables().get(i).getHeader()) {
                    h.setDescription(null);
                }
            }
        }
        if ((violatedDistrPreferencesReport = solver.getViolatedDistrPreferencesReport()) != null && !violatedDistrPreferencesReport.getGroups().isEmpty()) {
            response.addTable(SolverReportsBackend.getViolatedDistrPreferencesReportTable(violatedDistrPreferencesReport));
        }
        if ((discouragedInstructorBtbReportReport = solver.getDiscouragedInstructorBtbReport()) != null && !discouragedInstructorBtbReportReport.getGroups().isEmpty()) {
            response.addTable(SolverReportsBackend.getDiscouragedInstructorBtbReportReportTable(discouragedInstructorBtbReportReport));
        }
        if ((studentConflictsReport = solver.getStudentConflictsReport()) != null && !studentConflictsReport.getGroups().isEmpty()) {
            response.addTable(SolverReportsBackend.getStudentConflictsReportTable(studentConflictsReport));
        }
        if ((deptBalancingReport = solver.getDeptBalancingReport()) != null && !deptBalancingReport.getGroups().isEmpty()) {
            response.addTable(SolverReportsBackend.getDeptBalancingReportTable(deptBalancingReport));
        }
        if ((sameSubpartBalancingReport = solver.getSameSubpartBalancingReport()) != null && !sameSubpartBalancingReport.getGroups().isEmpty()) {
            response.addTable(SolverReportsBackend.getSameSubpartBalancingReportTable(sameSubpartBalancingReport));
        }
        if ((perturbationReport = solver.getPerturbationReport()) != null && !perturbationReport.getGroups().isEmpty()) {
            response.addTable(SolverReportsBackend.getPerturbationReportTable(perturbationReport));
        }
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(true)) {
            response.addPreference(new RoomInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2bgColor(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), false));
        }
        return response;
    }

    public static TableInterface getRoomReportTable(RoomReport report, RoomType type) {
        TableInterface table = new TableInterface("report-rooms" + (String)(type == null ? "" : "-" + type.getReference().toLowerCase()), type == null ? MESSAGES.reportRoomAllocationNonUnivLocs() : MESSAGES.reportRoomAllocation(type.getLabel()));
        table.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colRoomReportGroup()).setDescription(MESSAGES.reportRoomAlocDescGroup()), new TableInterface.TableHeaderIterface(MESSAGES.colRoomReportActualSizes()).setDescription(MESSAGES.reportRoomAlocDescSize()), new TableInterface.TableHeaderIterface(MESSAGES.colRoomReportNbrRooms()).setDescription(MESSAGES.reportRoomAlocDescNbrRooms()), new TableInterface.TableHeaderIterface(MESSAGES.colRoomReportClassUse()).setDescription(MESSAGES.reportRoomAlocDescClassUse()), new TableInterface.TableHeaderIterface(MESSAGES.colRoomReportClassShould()).setDescription(MESSAGES.reportRoomAlocDescClassShould()), new TableInterface.TableHeaderIterface(MESSAGES.colRoomReportClassMust()).setDescription(MESSAGES.reportRoomAlocDescClassMust()), new TableInterface.TableHeaderIterface(MESSAGES.colRoomReportHourUse()).setDescription(MESSAGES.reportRoomAlocDescHourUse()), new TableInterface.TableHeaderIterface(MESSAGES.colRoomReportHourShould()).setDescription(MESSAGES.reportRoomAlocDescHourShould()), new TableInterface.TableHeaderIterface(MESSAGES.colRoomReportHourMust()).setDescription(MESSAGES.reportRoomAlocDescHourMust()));
        int nrLines = 0;
        try {
            int nrAllRooms = 0;
            int nrAllLectureUse = 0;
            int nrAllLectureShouldUse = 0;
            double allSlotsUse = 0.0;
            double allSlotsShouldUse = 0.0;
            TreeSet groups = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    RoomReport.RoomAllocationGroup g1 = (RoomReport.RoomAllocationGroup)o1;
                    RoomReport.RoomAllocationGroup g2 = (RoomReport.RoomAllocationGroup)o2;
                    return -Double.compare(g1.getMinRoomSize(), g2.getMinRoomSize());
                }
            });
            groups.addAll(report.getGroups());
            for (RoomReport.RoomAllocationGroup g : groups) {
                if (g.getNrRooms() == 0) continue;
                double factor = (double)Constants.SLOT_LENGTH_MIN / 60.0;
                ++nrLines;
                table.addRow(new TableInterface.TableRowInterface(new TableInterface.TableCellInterface<Integer>(g.getMinRoomSize(), MESSAGES.reportRoomRange(String.valueOf(g.getMinRoomSize()), g.getMaxRoomSize() == Integer.MAX_VALUE ? "\u221e" : String.valueOf(g.getMaxRoomSize()))), new TableInterface.TableCellInterface<Integer>(g.getActualMinRoomSize(), MESSAGES.reportRoomRange(String.valueOf(g.getActualMinRoomSize()), String.valueOf(g.getActualMaxRoomSize()))), new TableInterface.TableCellInterface<Integer>(g.getNrRooms(), g.getNrRooms() + " (" + g.getNrRoomsThisSizeOrBigger() + ")"), new TableInterface.TableCellInterface<Integer>(g.getLecturesUse(), g.getLecturesUse() + " (" + (nrAllLectureUse += g.getLecturesUse()) + ")"), new TableInterface.TableCellInterface<Integer>(g.getLecturesShouldUse(), g.getLecturesShouldUse() + " (" + (nrAllLectureShouldUse += g.getLecturesShouldUse()) + ")"), new TableInterface.TableCellInterface<Integer>(g.getLecturesMustUse(), g.getLecturesMustUse() + " (" + g.getLecturesMustUseThisSizeOrBigger() + ")"), new TableInterface.TableCellInterface<Double>(factor * g.getSlotsUse() / (double)g.getNrRooms(), sDoubleFormat.format(factor * g.getSlotsUse() / (double)g.getNrRooms()) + " (" + sDoubleFormat.format(factor * (allSlotsUse += g.getSlotsUse()) / (double)(nrAllRooms += g.getNrRooms())) + ")"), new TableInterface.TableCellInterface<Double>(factor * g.getSlotsShouldUse() / (double)g.getNrRooms(), sDoubleFormat.format(factor * g.getSlotsShouldUse() / (double)g.getNrRooms()) + " (" + sDoubleFormat.format(factor * (allSlotsShouldUse += g.getSlotsShouldUse()) / (double)nrAllRooms) + ")"), new TableInterface.TableCellInterface<Double>(factor * g.getSlotsMustUse() / (double)g.getNrRooms(), sDoubleFormat.format(factor * g.getSlotsMustUse() / (double)g.getNrRooms()) + " (" + sDoubleFormat.format(factor * g.getSlotsMustUseThisSizeOrBigger() / (double)g.getNrRoomsThisSizeOrBigger()) + ")")));
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.setErrorMessage(MESSAGES.failedToComputeReport(e.getMessage()));
        }
        if (nrLines == 0 && !table.hasErrorMessage()) {
            return null;
        }
        Collections.sort(table.getRows(), new Comparator<TableInterface.TableRowInterface>(){

            @Override
            public int compare(TableInterface.TableRowInterface r1, TableInterface.TableRowInterface r2) {
                return r1.compareTo(r2, 0, false);
            }
        });
        return table;
    }

    public static TableInterface getDeptBalancingReportTable(DeptBalancingReport deptBalancingReport) {
        TableInterface table = new TableInterface("dept-balancing", MESSAGES.reportDepartmentalBalancing());
        TableInterface.TableHeaderIterface[] header = new TableInterface.TableHeaderIterface[2 + deptBalancingReport.getSlotsPerDayNoEvening() / 6];
        header[0] = new TableInterface.TableHeaderIterface(MESSAGES.colDepartment());
        header[1] = new TableInterface.TableHeaderIterface(MESSAGES.colPenalty());
        for (int i = 0; i < deptBalancingReport.getSlotsPerDayNoEvening() / 6; ++i) {
            header[2 + i] = new TableInterface.TableHeaderIterface(Constants.slot2str(deptBalancingReport.getFirstDaySlot() + i * 6)).setAlignment(TableInterface.Alignment.CENTER);
        }
        table.setHeader(header);
        try {
            for (DeptBalancingReport.DeptBalancingGroup g : deptBalancingReport.getGroups()) {
                TableInterface.TableCellInterface[] line = new TableInterface.TableCellInterface[2 + deptBalancingReport.getSlotsPerDayNoEvening() / 6];
                line[0] = new TableInterface.TableCellInterface<String>(g.getDepartmentName());
                int penalty = 0;
                for (int i = 0; i < deptBalancingReport.getSlotsPerDayNoEvening() / 6; ++i) {
                    int limit;
                    int slot = deptBalancingReport.getFirstDaySlot() + i * 6;
                    int usage = g.getUsage(slot);
                    if (usage > (limit = g.getLimit(slot))) {
                        penalty += g.getExcess(slot);
                    }
                    Vector classes = new Vector(g.getClasses(slot));
                    Collections.sort(classes);
                    TableInterface.TableCellMultiLine cell = new TableInterface.TableCellMultiLine();
                    int u = 0;
                    boolean over = false;
                    Enumeration e = classes.elements();
                    while (e.hasMoreElements()) {
                        ClassAssignmentDetails ca = (ClassAssignmentDetails)e.nextElement();
                        TableInterface.TableCellClickableClassName x = new TableInterface.TableCellClickableClassName(ca.getClazz().getClassId(), ca.getClazz().getName());
                        int nrMeetings = 0;
                        for (int j = deptBalancingReport.getFirstWorkDay(); j <= deptBalancingReport.getLastWorkDay(); ++j) {
                            if ((Constants.DAY_CODES[j % 7] & ca.getTime().getDays()) == 0) continue;
                            ++nrMeetings;
                        }
                        if ((u += nrMeetings) > limit && !over) {
                            over = true;
                            if (cell.last() != null) {
                                cell.last().setUnderlined(true);
                            }
                        }
                        x.setColor(PreferenceLevel.prolog2color(ca.getClazz().getPref()));
                        cell.add(x);
                    }
                    TableInterface.TableCellInterface<String> h = new TableInterface.TableCellInterface<String>((String)(limit == 0 ? "" : usage + " / " + limit));
                    if (usage > limit) {
                        h.setColor("red");
                    }
                    cell.getChunks().add(0, h);
                    line[i + 2] = cell;
                }
                line[1] = new TableInterface.TableCellInterface<Integer>(penalty);
                if (penalty > 0) {
                    line[1].setColor("red");
                }
                table.addRow(new TableInterface.TableRowInterface(line));
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.setErrorMessage(MESSAGES.failedToComputeReport(e.getMessage()));
        }
        Collections.sort(table.getRows(), new Comparator<TableInterface.TableRowInterface>(){

            @Override
            public int compare(TableInterface.TableRowInterface r1, TableInterface.TableRowInterface r2) {
                return r1.compareTo(r2, 0, true);
            }
        });
        table.setShowPrefLegend(true);
        return table;
    }

    public static TableInterface getViolatedDistrPreferencesReportTable(ViolatedDistrPreferencesReport report) {
        TableInterface table = new TableInterface("dist-pref", MESSAGES.reportViolatedDistributionPreferences());
        table.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colDistrubutionType()), new TableInterface.TableHeaderIterface(MESSAGES.colPreference()), new TableInterface.TableHeaderIterface(MESSAGES.colViolations()).setAlignment(TableInterface.Alignment.RIGHT), new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()));
        try {
            for (ViolatedDistrPreferencesReport.ViolatedDistrPreference g : report.getGroups()) {
                TableInterface.TableCellMultiLine classes = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine dates = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine times = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine rooms = new TableInterface.TableCellMultiLine();
                Enumeration e = g.getClasses().elements();
                while (e.hasMoreElements()) {
                    ClassAssignmentDetails ca = (ClassAssignmentDetails)e.nextElement();
                    ClassAssignmentDetails.TimeInfo time = ca.getTime();
                    TableInterface.TableCellRooms room = new TableInterface.TableCellRooms();
                    if (ca.getRoom() != null) {
                        for (int j = 0; j < ca.getRoom().length; ++j) {
                            room.add(ca.getRoom()[j].getName(), ca.getRoom()[j].getColor(), ca.getRoom()[j].getId(), PreferenceLevel.int2string(ca.getRoom()[j].getPref()));
                        }
                    }
                    classes.add(new TableInterface.TableCellClickableClassName(ca.getClazz().getClassId(), ca.getClazz().getName()).setColor(PreferenceLevel.prolog2color(ca.getClazz().getPref())));
                    dates.add(new TableInterface.TableCellInterface<String>(time.getDatePatternName()).setColor(PreferenceLevel.int2color(time.getDatePatternPreference())));
                    times.add(new TableInterface.TableCellTime(time.getDaysName() + " " + time.getStartTime() + " - " + time.getEndTime()).setId(ca.getClazz().getClassId() + "," + time.getDays() + "," + time.getStartSlot()).setColor(PreferenceLevel.int2color(time.getPref())));
                    rooms.add(room);
                }
                table.addRow(new TableInterface.TableRowInterface(new TableInterface.TableCellInterface<String>(g.getName()), new TableInterface.TableCellInterface<String>(PreferenceLevel.getPreferenceLevel(PreferenceLevel.int2prolog(g.getPreference())).getPrefName()).setColor(PreferenceLevel.int2color(g.getPreference())), new TableInterface.TableCellInterface<Integer>(g.getNrViolations()), classes, dates, times, rooms));
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.setErrorMessage(MESSAGES.failedToComputeReport(e.getMessage()));
        }
        Collections.sort(table.getRows(), new Comparator<TableInterface.TableRowInterface>(){

            @Override
            public int compare(TableInterface.TableRowInterface r1, TableInterface.TableRowInterface r2) {
                return r1.compareTo(r2, 0, true);
            }
        });
        table.setShowPrefLegend(true);
        return table;
    }

    public static TableInterface getDiscouragedInstructorBtbReportReportTable(DiscouragedInstructorBtbReport report) {
        TableInterface table = new TableInterface("instructor-btb", MESSAGES.reportInstructorBackToBackPreferences());
        table.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colInstructor()), new TableInterface.TableHeaderIterface(MESSAGES.colPreference()), new TableInterface.TableHeaderIterface(MESSAGES.colDistance()), new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()));
        try {
            for (DiscouragedInstructorBtbReport.DiscouragedBtb g : report.getGroups()) {
                TableInterface.TableCellMultiLine classes = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine dates = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine times = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine rooms = new TableInterface.TableCellMultiLine();
                classes.add(new TableInterface.TableCellClickableClassName(g.getFirst().getClazz().getClassId(), g.getFirst().getClazz().getName()).setColor(PreferenceLevel.prolog2color(g.getFirst().getClazz().getPref())));
                dates.add(new TableInterface.TableCellInterface<String>(g.getFirst().getTime().getDatePatternName()).setColor(PreferenceLevel.int2color(g.getFirst().getTime().getDatePatternPreference())));
                times.add(new TableInterface.TableCellTime(g.getFirst().getTime().getDaysName() + " " + g.getFirst().getTime().getStartTime() + " - " + g.getFirst().getTime().getEndTime()).setId(g.getFirst().getClazz().getClassId() + "," + g.getFirst().getTime().getDays() + "," + g.getFirst().getTime().getStartSlot()).setColor(PreferenceLevel.int2color(g.getFirst().getTime().getPref())));
                TableInterface.TableCellRooms froom = new TableInterface.TableCellRooms();
                if (g.getFirst().getRoom() != null) {
                    for (int j = 0; j < g.getFirst().getRoom().length; ++j) {
                        froom.add(g.getFirst().getRoom()[j].getName(), g.getFirst().getRoom()[j].getColor(), g.getFirst().getRoom()[j].getId(), PreferenceLevel.int2string(g.getFirst().getRoom()[j].getPref()));
                    }
                }
                rooms.add(froom);
                classes.add(new TableInterface.TableCellClickableClassName(g.getSecond().getClazz().getClassId(), g.getSecond().getClazz().getName()).setColor(PreferenceLevel.prolog2color(g.getSecond().getClazz().getPref())));
                dates.add(new TableInterface.TableCellInterface<String>(g.getSecond().getTime().getDatePatternName()).setColor(PreferenceLevel.int2color(g.getSecond().getTime().getDatePatternPreference())));
                times.add(new TableInterface.TableCellTime(g.getSecond().getTime().getDaysName() + " " + g.getSecond().getTime().getStartTime() + " - " + g.getSecond().getTime().getEndTime()).setId(g.getSecond().getClazz().getClassId() + "," + g.getSecond().getTime().getDays() + "," + g.getSecond().getTime().getStartSlot()).setColor(PreferenceLevel.int2color(g.getSecond().getTime().getPref())));
                TableInterface.TableCellRooms sroom = new TableInterface.TableCellRooms();
                if (g.getSecond().getRoom() != null) {
                    for (int j = 0; j < g.getSecond().getRoom().length; ++j) {
                        sroom.add(g.getSecond().getRoom()[j].getName(), g.getSecond().getRoom()[j].getColor(), g.getSecond().getRoom()[j].getId(), PreferenceLevel.int2string(g.getSecond().getRoom()[j].getPref()));
                    }
                }
                rooms.add(sroom);
                table.addRow(new TableInterface.TableRowInterface(new TableInterface.TableCellInterface<String>(g.getInstructorName()), new TableInterface.TableCellInterface<String>(PreferenceLevel.getPreferenceLevel(g.getPreference()).getPrefName()).setColor(PreferenceLevel.prolog2color(g.getPreference())), new TableInterface.TableCellInterface<Double>(g.getDistance(), g.getDistance() == 0.0 ? MESSAGES.notApplicable() : (g.getDistance() < 0.0 ? MESSAGES.breakTime(sDF.format(-g.getDistance())) : MESSAGES.roomDistance(sDoubleFormat.format(g.getDistance())))), classes, dates, times, rooms));
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.setErrorMessage(MESSAGES.failedToComputeReport(e.getMessage()));
        }
        Collections.sort(table.getRows(), new Comparator<TableInterface.TableRowInterface>(){

            @Override
            public int compare(TableInterface.TableRowInterface r1, TableInterface.TableRowInterface r2) {
                return r1.compareTo(r2, 0, true);
            }
        });
        table.setShowPrefLegend(true);
        return table;
    }

    public static TableInterface getStudentConflictsReportTable(StudentConflictsReport report) {
        boolean hasHard = false;
        boolean hasDistance = false;
        boolean hasFixed = false;
        boolean hasCommitted = false;
        boolean hasImportant = false;
        boolean hasInstructor = false;
        boolean hasWorkday = false;
        for (JenrlInfo g : report.getGroups()) {
            if (g.isHard()) {
                hasHard = true;
            }
            if (g.isDistance()) {
                hasDistance = true;
            }
            if (g.isFixed()) {
                hasFixed = true;
            }
            if (g.isCommited()) {
                hasCommitted = true;
            }
            if (g.isImportant()) {
                hasImportant = true;
            }
            if (g.isInstructor()) {
                hasInstructor = true;
            }
            if (!g.isWorkDay()) continue;
            hasWorkday = true;
        }
        TableInterface table = new TableInterface("student-conf", MESSAGES.reportStudentConflicts());
        table.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colNrConflicts()), new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colStudentConflictHard()).setVisible(hasHard), new TableInterface.TableHeaderIterface(MESSAGES.colStudentConflictDistance()).setVisible(hasDistance), new TableInterface.TableHeaderIterface(MESSAGES.colStudentConflictFixed()).setVisible(hasFixed), new TableInterface.TableHeaderIterface(MESSAGES.colStudentConflictCommitted()).setVisible(hasCommitted), new TableInterface.TableHeaderIterface(MESSAGES.colStudentConflictImportant()).setVisible(hasImportant), new TableInterface.TableHeaderIterface(MESSAGES.colStudentConflictInstructor()).setVisible(hasInstructor), new TableInterface.TableHeaderIterface(MESSAGES.colStudentConflictWorkday()).setVisible(hasWorkday), new TableInterface.TableHeaderIterface(MESSAGES.colCurriculum()));
        try {
            int[] total = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
            for (JenrlInfo g : report.getGroups()) {
                if (Math.round(g.getJenrl()) <= 0L) continue;
                TableInterface.TableCellMultiLine classes = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine dates = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine times = new TableInterface.TableCellMultiLine();
                TableInterface.TableCellMultiLine rooms = new TableInterface.TableCellMultiLine();
                classes.add(new TableInterface.TableCellClickableClassName(g.getFirst().getClazz().getClassId(), g.getFirst().getClazz().getName()).setColor(PreferenceLevel.prolog2color(g.getFirst().getClazz().getPref())));
                dates.add(new TableInterface.TableCellInterface<String>(g.getFirst().getTime().getDatePatternName()).setColor(PreferenceLevel.int2color(g.getFirst().getTime().getDatePatternPreference())));
                times.add(new TableInterface.TableCellTime(g.getFirst().getTime().getDaysName() + " " + g.getFirst().getTime().getStartTime() + " - " + g.getFirst().getTime().getEndTime()).setId(g.getFirst().getClazz().getClassId() + "," + g.getFirst().getTime().getDays() + "," + g.getFirst().getTime().getStartSlot()).setColor(PreferenceLevel.int2color(g.getFirst().getTime().getPref())));
                TableInterface.TableCellRooms froom = new TableInterface.TableCellRooms();
                if (g.getFirst().getRoom() != null) {
                    for (int j = 0; j < g.getFirst().getRoom().length; ++j) {
                        froom.add(g.getFirst().getRoom()[j].getName(), g.getFirst().getRoom()[j].getColor(), g.getFirst().getRoom()[j].getId(), PreferenceLevel.int2string(g.getFirst().getRoom()[j].getPref()));
                    }
                }
                rooms.add(froom);
                classes.add(new TableInterface.TableCellClickableClassName(g.getSecond().getClazz().getClassId(), g.getSecond().getClazz().getName()).setColor(PreferenceLevel.prolog2color(g.getSecond().getClazz().getPref())));
                dates.add(new TableInterface.TableCellInterface<String>(g.getSecond().getTime().getDatePatternName()).setColor(PreferenceLevel.int2color(g.getSecond().getTime().getDatePatternPreference())));
                times.add(new TableInterface.TableCellTime(g.getSecond().getTime().getDaysName() + " " + g.getSecond().getTime().getStartTime() + " - " + g.getSecond().getTime().getEndTime()).setId(g.getSecond().getClazz().getClassId() + "," + g.getSecond().getTime().getDays() + "," + g.getSecond().getTime().getStartSlot()).setColor(PreferenceLevel.int2color(g.getSecond().getTime().getPref())));
                TableInterface.TableCellRooms sroom = new TableInterface.TableCellRooms();
                if (g.getSecond().getRoom() != null) {
                    for (int j = 0; j < g.getSecond().getRoom().length; ++j) {
                        sroom.add(g.getSecond().getRoom()[j].getName(), g.getSecond().getRoom()[j].getColor(), g.getSecond().getRoom()[j].getId(), PreferenceLevel.int2string(g.getSecond().getRoom()[j].getPref()));
                    }
                }
                rooms.add(sroom);
                table.addRow(new TableInterface.TableRowInterface(new TableInterface.TableCellInterface<Long>(Math.round(g.getJenrl())), classes, dates, times, rooms, new TableInterface.TableCellBoolean(g.isHard()).setFormattedValue(g.isHard() ? MESSAGES.exportTrue() : MESSAGES.exportFalse()), new TableInterface.TableCellInterface<Object>((g.isDistance() ? Double.valueOf(g.getDistance()) : null)).setFormattedValue(g.isDistance() ? MESSAGES.reportDistanceInMeter((int)Math.round(g.getDistance())) : ""), new TableInterface.TableCellBoolean(g.isFixed()).setFormattedValue(g.isFixed() ? MESSAGES.exportTrue() : MESSAGES.exportFalse()), new TableInterface.TableCellBoolean(g.isCommited()).setFormattedValue(g.isCommited() ? MESSAGES.exportTrue() : MESSAGES.exportFalse()), new TableInterface.TableCellBoolean(g.isImportant()).setFormattedValue(g.isImportant() ? MESSAGES.exportTrue() : MESSAGES.exportFalse()), new TableInterface.TableCellBoolean(g.isInstructor()).setFormattedValue(g.isInstructor() ? MESSAGES.exportTrue() : MESSAGES.exportFalse()), new TableInterface.TableCellBoolean(g.isWorkDay()).setFormattedValue(g.isWorkDay() ? MESSAGES.exportTrue() : MESSAGES.exportFalse()), new TableInterface.TableCellText(g.getCurriculumText())));
                total[0] = (int)((long)total[0] + Math.round(g.getJenrl()));
                if (g.isHard()) {
                    total[1] = (int)((long)total[1] + Math.round(g.getJenrl()));
                }
                if (g.isDistance()) {
                    total[2] = (int)((long)total[2] + Math.round(g.getJenrl()));
                }
                if (g.isFixed()) {
                    total[3] = (int)((long)total[3] + Math.round(g.getJenrl()));
                }
                if (g.isCommited()) {
                    total[4] = (int)((long)total[4] + Math.round(g.getJenrl()));
                }
                if (g.isImportant()) {
                    total[5] = (int)((long)total[5] + Math.round(g.getJenrl()));
                }
                if (g.isInstructor()) {
                    total[6] = total[6] + (g.isInstructor() ? 1 : 0);
                }
                if (!g.isWorkDay()) continue;
                total[7] = (int)((long)total[7] + Math.round(g.getJenrl()));
            }
            table.addRow(new TableInterface.TableRowInterface(new TableInterface.TableCellInterface<Long>(Long.valueOf(total[0])), new TableInterface.TableCellText(MESSAGES.reportTotal()).setStyleName("italic"), new TableInterface.TableCellText(""), new TableInterface.TableCellText(""), new TableInterface.TableCellText(""), new TableInterface.TableCellBoolean(null).setFormattedValue(String.valueOf(total[1])), new TableInterface.TableCellInterface<Integer>(1000 * total[2]).setFormattedValue(String.valueOf(total[2])), new TableInterface.TableCellBoolean(null).setFormattedValue(String.valueOf(total[3])), new TableInterface.TableCellBoolean(null).setFormattedValue(String.valueOf(total[4])), new TableInterface.TableCellBoolean(null).setFormattedValue(String.valueOf(total[5])), new TableInterface.TableCellBoolean(null).setFormattedValue(String.valueOf(total[6])), new TableInterface.TableCellBoolean(null).setFormattedValue(String.valueOf(total[7])), new TableInterface.TableCellText("")));
        }
        catch (Exception e) {
            Debug.error(e);
            table.setErrorMessage(MESSAGES.failedToComputeReport(e.getMessage()));
        }
        Collections.sort(table.getRows(), new Comparator<TableInterface.TableRowInterface>(){

            @Override
            public int compare(TableInterface.TableRowInterface r1, TableInterface.TableRowInterface r2) {
                return r1.compareTo(r2, 0, false);
            }
        });
        table.setShowPrefLegend(true);
        return table;
    }

    public static TableInterface getSameSubpartBalancingReportTable(SameSubpartBalancingReport report) {
        TableInterface table = new TableInterface("section-balanc", MESSAGES.reportSectionBalancing());
        TableInterface.TableHeaderIterface[] header = new TableInterface.TableHeaderIterface[2 + report.getSlotsPerDayNoEvening() / 6];
        header[0] = new TableInterface.TableHeaderIterface(MESSAGES.colDepartment());
        header[1] = new TableInterface.TableHeaderIterface(MESSAGES.colPenalty());
        for (int i = 0; i < report.getSlotsPerDayNoEvening() / 6; ++i) {
            header[2 + i] = new TableInterface.TableHeaderIterface(Constants.slot2str(report.getFirstDaySlot() + i * 6)).setAlignment(TableInterface.Alignment.CENTER);
        }
        table.setHeader(header);
        try {
            for (SameSubpartBalancingReport.SameSubpartBalancingGroup g : report.getGroups()) {
                TableInterface.TableCellInterface[] line = new TableInterface.TableCellInterface[2 + report.getSlotsPerDayNoEvening() / 6];
                line[0] = new TableInterface.TableCellInterface<String>(g.getName());
                int penalty = 0;
                for (int i = 0; i < report.getSlotsPerDayNoEvening() / 6; ++i) {
                    int limit;
                    int slot = report.getFirstDaySlot() + i * 6;
                    int usage = g.getUsage(slot);
                    if (usage > (limit = g.getLimit(slot))) {
                        penalty += g.getExcess(slot);
                    }
                    Vector classes = new Vector(g.getClasses(slot));
                    Collections.sort(classes);
                    TableInterface.TableCellMultiLine cell = new TableInterface.TableCellMultiLine();
                    int u = 0;
                    boolean over = false;
                    Enumeration e = classes.elements();
                    while (e.hasMoreElements()) {
                        ClassAssignmentDetails ca = (ClassAssignmentDetails)e.nextElement();
                        TableInterface.TableCellClickableClassName x = new TableInterface.TableCellClickableClassName(ca.getClazz().getClassId(), ca.getClazz().getName());
                        int nrMeetings = 0;
                        for (int j = report.getFirstWorkDay(); j <= report.getLastWorkDay(); ++j) {
                            if ((Constants.DAY_CODES[j % 7] & ca.getTime().getDays()) == 0) continue;
                            ++nrMeetings;
                        }
                        if ((u += nrMeetings) > limit && !over) {
                            over = true;
                            if (cell.last() != null) {
                                cell.last().setUnderlined(true);
                            }
                        }
                        x.setColor(PreferenceLevel.prolog2color(ca.getClazz().getPref()));
                        cell.add(x);
                    }
                    TableInterface.TableCellInterface<String> h = new TableInterface.TableCellInterface<String>((String)(limit == 0 ? "" : usage + " / " + limit));
                    if (usage > limit) {
                        h.setColor("red");
                    }
                    cell.getChunks().add(0, h);
                    line[i + 2] = cell;
                }
                line[1] = new TableInterface.TableCellInterface<Integer>(penalty);
                if (penalty > 0) {
                    line[1].setColor("red");
                }
                table.addRow(new TableInterface.TableRowInterface(line));
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.setErrorMessage(MESSAGES.failedToComputeReport(e.getMessage()));
        }
        Collections.sort(table.getRows(), new Comparator<TableInterface.TableRowInterface>(){

            @Override
            public int compare(TableInterface.TableRowInterface r1, TableInterface.TableRowInterface r2) {
                return r1.compareTo(r2, 0, true);
            }
        });
        table.setShowPrefLegend(true);
        return table;
    }

    public static TableInterface.TableCellInterface dispNumber(int value) {
        return new TableInterface.TableCellInterface<Integer>(value, (String)(value == 0 ? "" : (value <= 0 ? String.valueOf(value) : "+" + String.valueOf(value)))).setColor(value < 0 ? "green" : (value > 0 ? "red" : null));
    }

    public static TableInterface.TableCellInterface dispNumber(double value) {
        return new TableInterface.TableCellInterface<Double>(value, (String)((double)Math.round(1000.0 * value) == 0.0 ? "" : (value >= 5.0E-4 ? "+" : "") + sDF.format(value))).setColor(value < 0.0 ? "green" : (value > 0.0 ? "red" : null));
    }

    public static TableInterface getPerturbationReportTable(PerturbationReport report) {
        TableInterface table = new TableInterface("perturbations", MESSAGES.reportPerturbations());
        table.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colClass()).setDescription(MESSAGES.reportPertClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()).setDescription(MESSAGES.reportPertDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()).setDescription(MESSAGES.reportPertTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()).setDescription(MESSAGES.reportPertRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colShortDist()).setDescription(MESSAGES.reportPertDistance()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationStudents()).setDescription(MESSAGES.reportPertStudents()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationStudentsTime()).setDescription(MESSAGES.reportPertStudentsTime()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationStudentsRoom()).setDescription(MESSAGES.reportPertStudentsRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationStudentsBuilding()).setDescription(MESSAGES.reportPertStudentsBuilding()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationInstructor()).setDescription(MESSAGES.reportPertInstructor()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationInstructorTime()).setDescription(MESSAGES.reportPertInstructorTime()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationInstructorRoom()).setDescription(MESSAGES.reportPertInstructorRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationInstructorBuilding()).setDescription(MESSAGES.reportPertInstructorBuilding()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationRoom()).setDescription(MESSAGES.reportPertRoomChange()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationBuilding()).setDescription(MESSAGES.reportPertBuildingChange()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationTime()).setDescription(MESSAGES.reportPertTimeChange()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationDay()).setDescription(MESSAGES.reportPertDayChange()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationHour()).setDescription(MESSAGES.reportPertHourChange()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationTooFarStudent()).setDescription(MESSAGES.reportPertTooFarStudents()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationTooFarInstructor()).setDescription(MESSAGES.reportPertTooFarInstructor()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationDeltaStudentConflicts()).setDescription(MESSAGES.reportPertDeltaStudentConf()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationNewStudentConflicts()).setDescription(MESSAGES.reportPertNewStudentConf()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationDeltaTimePref()).setDescription(MESSAGES.reportPertDeltaTimePref()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationDeltaRoomPref()).setDescription(MESSAGES.reportPertDeltaRoomPref()), new TableInterface.TableHeaderIterface(MESSAGES.colPerturbationDeltaInstructorBTB()).setDescription(MESSAGES.reportPertDeltaInstructorBTBPref()));
        try {
            for (PerturbationReport.PerturbationGroup g : report.getGroups()) {
                int j;
                ClassAssignmentDetails ca = g.getClazz();
                ClassAssignmentDetails.ClassInfo clazz = ca.getClazz();
                ClassAssignmentDetails.TimeInfo timeBefore = ca.getTime();
                ClassAssignmentDetails.TimeInfo timeAfter = ca.getAssignedTime();
                TableInterface.TableCellChange date = new TableInterface.TableCellChange(timeBefore == null ? null : new TableInterface.TableCellInterface<String>(timeBefore.getDatePatternName()).setColor(PreferenceLevel.int2color(timeBefore.getDatePatternPreference())), timeAfter == null ? null : new TableInterface.TableCellInterface<String>(timeAfter.getDatePatternName()).setColor(PreferenceLevel.int2color(timeAfter.getDatePatternPreference())));
                TableInterface.TableCellChange time = new TableInterface.TableCellChange(timeBefore == null ? null : new TableInterface.TableCellTime(timeBefore.getDaysName() + " " + timeBefore.getStartTime() + " - " + timeBefore.getEndTime()).setId(clazz.getClassId() + "," + timeBefore.getDays() + "," + timeBefore.getStartSlot()).setColor(PreferenceLevel.int2color(timeBefore.getPref())), timeAfter == null ? null : new TableInterface.TableCellTime(timeAfter.getDaysName() + " " + timeAfter.getStartTime() + " - " + timeAfter.getEndTime()).setId(clazz.getClassId() + "," + timeAfter.getDays() + "," + timeAfter.getStartSlot()).setColor(PreferenceLevel.int2color(timeAfter.getPref())));
                ClassAssignmentDetails.RoomInfo[] roomBefore = ca.getRoom();
                ClassAssignmentDetails.RoomInfo[] roomAfter = ca.getAssignedRoom();
                TableInterface.TableCellChange room = new TableInterface.TableCellChange();
                if (roomBefore != null) {
                    TableInterface.TableCellRooms beforeRooms = new TableInterface.TableCellRooms();
                    for (j = 0; j < roomBefore.length; ++j) {
                        beforeRooms.add(roomBefore[j].getName(), roomBefore[j].getColor(), roomBefore[j].getId(), PreferenceLevel.int2string(roomBefore[j].getPref()));
                    }
                    room.setFirst(beforeRooms);
                }
                if (roomAfter != null) {
                    TableInterface.TableCellRooms afterRooms = new TableInterface.TableCellRooms();
                    for (j = 0; j < roomAfter.length; ++j) {
                        afterRooms.add(roomAfter[j].getName(), roomAfter[j].getColor(), roomAfter[j].getId(), PreferenceLevel.int2string(roomAfter[j].getPref()));
                    }
                    room.setSecond(afterRooms);
                    if (roomAfter.length == 0 && roomBefore == null) {
                        room.setFirst(new TableInterface.TableCellRooms());
                    }
                }
                table.addRow(new TableInterface.TableRowInterface(g.getClazz().getClazz().getClassId(), "gwt.jsp?page=suggestions&menu=hide&id=" + clazz.getClassId(), MESSAGES.dialogSuggestions(), new TableInterface.TableCellClickableClassName(clazz.getClassId(), clazz.getName()).setColor(PreferenceLevel.prolog2color(clazz.getPref())), date, time, room, new TableInterface.TableCellInterface<Double>(g.distance).setFormattedValue(Math.round(g.distance) > 0L ? MESSAGES.reportDistanceInMeter((int)Math.round(g.distance)) : ""), SolverReportsBackend.dispNumber(g.affectedStudents), SolverReportsBackend.dispNumber(g.affectedStudentsByTime), SolverReportsBackend.dispNumber(g.affectedStudentsByRoom), SolverReportsBackend.dispNumber(g.affectedStudentsByBldg), SolverReportsBackend.dispNumber(g.affectedInstructors), SolverReportsBackend.dispNumber(g.affectedInstructorsByTime), SolverReportsBackend.dispNumber(g.affectedInstructorsByRoom), SolverReportsBackend.dispNumber(g.affectedInstructorsByBldg), SolverReportsBackend.dispNumber(g.differentRoom), SolverReportsBackend.dispNumber(g.differentBuilding), SolverReportsBackend.dispNumber(g.differentTime), SolverReportsBackend.dispNumber(g.differentDay), SolverReportsBackend.dispNumber(g.differentHour), SolverReportsBackend.dispNumber(g.tooFarForStudents), SolverReportsBackend.dispNumber(g.tooFarForInstructors), SolverReportsBackend.dispNumber(g.deltaStudentConflicts), SolverReportsBackend.dispNumber(g.newStudentConflicts), SolverReportsBackend.dispNumber(Math.round(g.deltaTimePreferences)), SolverReportsBackend.dispNumber(g.deltaRoomPreferences), SolverReportsBackend.dispNumber(g.deltaInstructorDistancePreferences)));
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.setErrorMessage(MESSAGES.failedToComputeReport(e.getMessage()));
        }
        Collections.sort(table.getRows(), new Comparator<TableInterface.TableRowInterface>(){

            @Override
            public int compare(TableInterface.TableRowInterface r1, TableInterface.TableRowInterface r2) {
                return r1.compareTo(r2, 0, true);
            }
        });
        return table;
    }
}

