/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.dao.StudentSchedulingRuleDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

@Service(value="gwtAdminTable[type=studentSchedulingRules]")
public class StudentSchedulingRules
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageStudentSchedulingRule(), MESSAGES.pageStudentSchedulingRules());
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingRules')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        ArrayList<SimpleEditInterface.ListItem> modes = new ArrayList<SimpleEditInterface.ListItem>();
        modes.add(new SimpleEditInterface.ListItem("false", MESSAGES.ruleConjunctive()));
        modes.add(new SimpleEditInterface.ListItem("true", MESSAGES.ruleDisjunctive()));
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldRuleName(), SimpleEditInterface.FieldType.text, 200, 255, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldStudentFilter(), SimpleEditInterface.FieldType.text, 500, 2048, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldCourseTypeRegExp(), SimpleEditInterface.FieldType.text, 300, 2048, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldCourseNameRegExp(), SimpleEditInterface.FieldType.text, 300, 2048, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldInstructionalMethodRegExp(), SimpleEditInterface.FieldType.text, 300, 2048, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldRuleMode(), SimpleEditInterface.FieldType.list, 40, modes, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldInitiative(), SimpleEditInterface.FieldType.text, 100, 1024, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldTerm(), SimpleEditInterface.FieldType.text, 100, 1024, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldFirstYear(), SimpleEditInterface.FieldType.number, 50, 4, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldLastYear(), SimpleEditInterface.FieldType.number, 50, 4, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldAppliesToFilter(), SimpleEditInterface.FieldType.toggle, 40, SimpleEditInterface.Flag.DEFAULT_CHECKED), new SimpleEditInterface.Field(MESSAGES.fieldAppliesToOnline(), SimpleEditInterface.FieldType.toggle, 40, SimpleEditInterface.Flag.DEFAULT_CHECKED), new SimpleEditInterface.Field(MESSAGES.fieldAppliesToBatch(), SimpleEditInterface.FieldType.toggle, 40, SimpleEditInterface.Flag.DEFAULT_CHECKED), new SimpleEditInterface.Field(MESSAGES.fieldAdvisorOverride(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]), new SimpleEditInterface.Field(MESSAGES.fieldAdminOverride(), SimpleEditInterface.FieldType.toggle, 40, new SimpleEditInterface.Flag[0]));
        data.setSaveOrder(false);
        data.setCanMoveUpAndDown(true);
        data.setAllowSort(false);
        DecimalFormat df = new DecimalFormat("0000");
        for (StudentSchedulingRule rule : StudentSchedulingRuleDAO.getInstance().getSession().createQuery("from StudentSchedulingRule order by ord", StudentSchedulingRule.class).list()) {
            SimpleEditInterface.Record r = data.addRecord(rule.getUniqueId());
            r.setField(0, rule.getRuleName());
            r.setField(1, rule.getStudentFilter());
            r.setField(2, rule.getCourseType());
            r.setField(3, rule.getCourseName());
            r.setField(4, rule.getInstructonalMethod());
            r.setField(5, rule.isDisjunctive() != false ? "true" : "false");
            r.setField(6, rule.getFilterInitiative());
            r.setField(7, rule.getFilterTerm());
            r.setField(8, rule.getFirstYear() == null ? "" : df.format(rule.getFirstYear()));
            r.setField(9, rule.getLastYear() == null ? "" : df.format(rule.getLastYear()));
            r.setField(10, rule.isAppliesToFilter() != false ? "true" : "false");
            r.setField(11, rule.isAppliesToOnline() != false ? "true" : "false");
            r.setField(12, rule.isAppliesToBatch() != false ? "true" : "false");
            r.setField(13, rule.isAdvisorOverride() != false ? "true" : "false");
            r.setField(14, rule.isAdminOverride() != false ? "true" : "false");
        }
        data.setEditable(context.hasPermission(Right.StudentSchedulingRuleEdit));
        return data;
    }

    protected int nextOrd(Set<Integer> ords) {
        for (int i = 0; i < ords.size() + 1; ++i) {
            if (ords.contains(i)) continue;
            ords.add(i);
            return i;
        }
        return ords.size();
    }

    protected int nextOrd() {
        List rules = StudentSchedulingRuleDAO.getInstance().findAll();
        int idx = 0;
        block0: while (true) {
            for (StudentSchedulingRule t : rules) {
                if (idx != t.getOrd()) continue;
                ++idx;
                continue block0;
            }
            break;
        }
        return idx;
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingRuleEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        HashSet<Integer> ords = new HashSet<Integer>();
        for (SimpleEditInterface.Record r : data.getRecords()) {
            if (r.isEmpty(data)) continue;
            r.setOrder(this.nextOrd(ords));
        }
        for (StudentSchedulingRule rule : StudentSchedulingRuleDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(rule.getUniqueId());
            if (r == null) {
                this.delete(rule, context, hibSession);
                continue;
            }
            this.update(rule, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession, false);
        }
        this.notifyOnlineServers(context, hibSession);
    }

    protected void notifyOnlineServers(SessionContext context, Session hibSession) {
        for (String sessionId : ((SolverServerService)SpringApplicationContextHolder.getBean("solverServerService")).getOnlineStudentSchedulingContainer().getSolvers()) {
            StudentSectioningQueue.sessionSchedulingRulesChanged(hibSession, context.getUser(), Long.valueOf(sessionId));
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingRuleEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.save(record, context, hibSession, true);
    }

    protected void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession, boolean notify) {
        StudentSchedulingRule rule = new StudentSchedulingRule();
        if (record.getOrder() == null) {
            record.setOrder(this.nextOrd());
        }
        rule.setRuleName(record.getField(0));
        rule.setStudentFilter(record.getField(1));
        rule.setCourseType(record.getField(2));
        rule.setCourseName(record.getField(3));
        rule.setInstructonalMethod(record.getField(4));
        rule.setDisjunctive("true".equalsIgnoreCase(record.getField(5)));
        rule.setFilterInitiative(record.getField(6));
        rule.setFilterTerm(record.getField(7));
        rule.setFirstYear(record.getField(8) == null || record.getField(8).isEmpty() ? null : Integer.valueOf(record.getField(8)));
        rule.setLastYear(record.getField(9) == null || record.getField(9).isEmpty() ? null : Integer.valueOf(record.getField(9)));
        rule.setAppliesToFilter(record.getField(10) == null || "true".equalsIgnoreCase(record.getField(10)));
        rule.setAppliesToOnline(record.getField(11) == null || "true".equalsIgnoreCase(record.getField(11)));
        rule.setAppliesToBatch(record.getField(12) == null || "true".equalsIgnoreCase(record.getField(12)));
        rule.setAdvisorOverride("true".equalsIgnoreCase(record.getField(13)));
        rule.setAdminOverride("true".equalsIgnoreCase(record.getField(14)));
        rule.setOrd(record.getOrder());
        hibSession.persist((Object)rule);
        record.setUniqueId(rule.getUniqueId());
        ChangeLog.addChange(hibSession, context, rule, rule.getRuleName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
        if (notify) {
            this.notifyOnlineServers(context, hibSession);
        }
    }

    protected void update(StudentSchedulingRule rule, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (rule == null) {
            return;
        }
        if (ToolBox.equals((Object)rule.getRuleName(), (Object)record.getField(0)) && ToolBox.equals((Object)rule.getStudentFilter(), (Object)record.getField(1)) && ToolBox.equals((Object)rule.getCourseType(), (Object)record.getField(2)) && ToolBox.equals((Object)rule.getCourseName(), (Object)record.getField(3)) && ToolBox.equals((Object)rule.getInstructonalMethod(), (Object)record.getField(4)) && ToolBox.equals((Object)rule.isDisjunctive(), (Object)"true".equalsIgnoreCase(record.getField(5))) && ToolBox.equals((Object)rule.getFilterInitiative(), (Object)record.getField(6)) && ToolBox.equals((Object)rule.getFilterTerm(), (Object)record.getField(7)) && ToolBox.equals((Object)rule.getFirstYear(), record.getField(8) == null || record.getField(8).isEmpty() ? null : Integer.valueOf(record.getField(8))) && ToolBox.equals((Object)rule.getLastYear(), record.getField(9) == null || record.getField(9).isEmpty() ? null : Integer.valueOf(record.getField(9))) && ToolBox.equals((Object)rule.isAppliesToFilter(), (Object)(record.getField(10) == null || "true".equalsIgnoreCase(record.getField(10)) ? 1 : 0)) && ToolBox.equals((Object)rule.isAppliesToOnline(), (Object)(record.getField(11) == null || "true".equalsIgnoreCase(record.getField(11)) ? 1 : 0)) && ToolBox.equals((Object)rule.isAppliesToBatch(), (Object)(record.getField(12) == null || "true".equalsIgnoreCase(record.getField(12)) ? 1 : 0)) && ToolBox.equals((Object)rule.isAdvisorOverride(), (Object)"true".equalsIgnoreCase(record.getField(13))) && ToolBox.equals((Object)rule.isAdminOverride(), (Object)"true".equalsIgnoreCase(record.getField(14))) && (record.getOrder() == null || ToolBox.equals((Object)rule.getOrd(), (Object)record.getOrder()))) {
            return;
        }
        rule.setRuleName(record.getField(0));
        rule.setStudentFilter(record.getField(1));
        rule.setCourseType(record.getField(2));
        rule.setCourseName(record.getField(3));
        rule.setInstructonalMethod(record.getField(4));
        rule.setDisjunctive("true".equalsIgnoreCase(record.getField(5)));
        rule.setFilterInitiative(record.getField(6));
        rule.setFilterTerm(record.getField(7));
        rule.setFirstYear(record.getField(8) == null || record.getField(8).isEmpty() ? null : Integer.valueOf(record.getField(8)));
        rule.setLastYear(record.getField(9) == null || record.getField(9).isEmpty() ? null : Integer.valueOf(record.getField(9)));
        rule.setAppliesToFilter(record.getField(10) == null || "true".equalsIgnoreCase(record.getField(10)));
        rule.setAppliesToOnline(record.getField(11) == null || "true".equalsIgnoreCase(record.getField(11)));
        rule.setAppliesToBatch(record.getField(12) == null || "true".equalsIgnoreCase(record.getField(12)));
        rule.setAdvisorOverride("true".equalsIgnoreCase(record.getField(13)));
        rule.setAdminOverride("true".equalsIgnoreCase(record.getField(14)));
        if (record.getOrder() != null) {
            rule.setOrd(record.getOrder());
        }
        hibSession.merge((Object)rule);
        ChangeLog.addChange(hibSession, context, rule, rule.getRuleName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingRuleEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((StudentSchedulingRule)StudentSchedulingRuleDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
        this.notifyOnlineServers(context, hibSession);
    }

    protected void delete(StudentSchedulingRule rule, SessionContext context, Session hibSession) {
        if (rule == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, rule, rule.getRuleName(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)rule);
    }

    @Override
    @PreAuthorize(value="checkPermission('StudentSchedulingRuleEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((StudentSchedulingRule)StudentSchedulingRuleDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
        this.notifyOnlineServers(context, hibSession);
    }
}

