/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

public class ScheduleByPeriodReport
extends PdfLegacyExamReport {
    protected static Log sLog = LogFactory.getLog(ScheduleByPeriodReport.class);

    public ScheduleByPeriodReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, MSG.legacyReportScheduleByPeriod(), session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        TreeSet sections;
        sLog.debug((Object)MSG.statusSortingSections());
        Hashtable<String, TreeSet> subject2courseSections = new Hashtable<String, TreeSet>();
        for (ExamInfo examInfo : this.getExams()) {
            for (ExamInfo.ExamSectionInfo section : examInfo.getSectionsIncludeCrosslistedDummies()) {
                if (!this.hasSubjectArea(section)) continue;
                sections = (TreeSet)subject2courseSections.get(section.getSubject());
                if (sections == null) {
                    sections = new TreeSet();
                    subject2courseSections.put(section.getSubject(), sections);
                }
                sections.add(section);
            }
        }
        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrDateAndTime(), 30), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnId() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 10), this.rpad(MSG.lrMeetingTimes(), 35), this.lpad(MSG.lrEnrl(), 5), this.iDispRooms ? this.rpad(MSG.lrRoom(), 11) : NULL, this.iDispRooms ? this.lpad(MSG.lrCap(), 5) : NULL, this.iDispRooms ? this.lpad(MSG.lrExCap(), 6) : NULL), new AbstractReport.Line(this.lpad("", '-', 30), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 10), this.lpad("", '-', 35), this.lpad("", '-', 5), this.iDispRooms ? this.lpad("", '-', 11) : NULL, this.iDispRooms ? this.lpad("", '-', 5) : NULL, this.iDispRooms ? this.lpad("", '-', 6) : NULL));
        sLog.debug((Object)MSG.statusPrintingReport());
        this.printHeader();
        Iterator<ExamPeriod> p = ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType()).iterator();
        while (p.hasNext()) {
            ExamPeriod examPeriod = p.next();
            this.iPeriodPrinted = false;
            this.setPageName(this.formatPeriod(examPeriod));
            this.setCont(this.formatPeriod(examPeriod));
            for (String subject : new TreeSet(subject2courseSections.keySet())) {
                sections = (TreeSet)subject2courseSections.get(subject);
                this.iSubjectPrinted = false;
                for (ExamInfo.ExamSectionInfo section : sections) {
                    if (!examPeriod.equals(section.getExamAssignment().getPeriod())) continue;
                    if (!this.iDispRooms) {
                        this.println(this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : this.formatPeriod(examPeriod), 30), this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(section.getCourseNbr(), 8), this.iItype ? this.rpad(section.getItype(), 6) : NULL, this.formatSection10(section.getSection()), this.rpad(this.getMeetingTime(section), 35), this.lpad(String.valueOf(section.getNrStudents()), 5));
                        this.iSubjectPrinted = !this.iNewPage;
                        this.iPeriodPrinted = this.iSubjectPrinted;
                        continue;
                    }
                    if (section.getExamAssignment().getRooms() == null || section.getExamAssignment().getRooms().isEmpty()) {
                        this.println(this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : this.formatPeriod(examPeriod), 30), this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(section.getCourseNbr(), 8), this.iItype ? this.rpad(section.getItype(), 6) : NULL, this.formatSection10(section.getSection()), this.rpad(this.getMeetingTime(section), 35), this.lpad(String.valueOf(section.getNrStudents()), 5), new AbstractReport.Cell(this.iNoRoom).withColSpan(3));
                        this.iSubjectPrinted = !this.iNewPage;
                        this.iPeriodPrinted = this.iSubjectPrinted;
                        continue;
                    }
                    if (this.getLineNumber() + section.getExamAssignment().getRooms().size() > this.getNrLinesPerPage() && this.getNrLinesPerPage() > 0) {
                        this.newPage();
                    }
                    boolean firstRoom = true;
                    for (ExamRoomInfo room : section.getExamAssignment().getRooms()) {
                        this.println(this.rpad(!firstRoom || this.iPeriodPrinted && this.isSkipRepeating() ? "" : this.formatPeriod(examPeriod), 30), this.rpad(!firstRoom || this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(!firstRoom ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(!firstRoom ? "" : section.getItype(), 6) : NULL, this.formatSection10(!firstRoom ? "" : section.getSection()), !firstRoom ? this.rpad("", 35) : this.getMeetingTime(section), this.lpad(!firstRoom ? "" : String.valueOf(section.getNrStudents()), 5), this.formatRoom(room), this.lpad("" + room.getCapacity(), 5), this.lpad("" + room.getExamCapacity(), 6));
                        firstRoom = false;
                    }
                    this.iSubjectPrinted = !this.iNewPage;
                    this.iPeriodPrinted = this.iSubjectPrinted;
                }
            }
            this.setCont(null);
            if (!this.iPeriodPrinted || !p.hasNext()) continue;
            this.newPage();
        }
        if (this.iPeriodPrinted) {
            this.lastPage();
        }
    }
}

