/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.model.Student;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentNote;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseAdvisorCourseRequest;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.base.BaseStudentAreaClassificationMajor;
import org.unitime.timetable.model.base.BaseStudentAreaClassificationMinor;
import org.unitime.timetable.model.base.BaseStudentNote;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.status.FindStudentInfoAction;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.onlinesectioning.status.db.DbFindEnrollmentInfoAction;
import org.unitime.timetable.util.Formats;

public class DbFindStudentInfoAction
extends FindStudentInfoAction {
    private static final long serialVersionUID = 1L;

    public boolean isMyStudent(Student student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getUniqueId());
    }

    public boolean isCanSelect(Student student) {
        if (this.iIsAdmin) {
            return true;
        }
        return this.iIsAdvisor ? this.iCanEditOtherStudents || this.iCanEditMyStudents && this.isMyStudent(student) : this.iCanSelect;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public List<ClassAssignmentInterface.StudentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (this.iFilter == null) {
            return super.execute(server, helper);
        }
        HashMap<Long, ClassAssignmentInterface.StudentInfo> students = new HashMap<Long, ClassAssignmentInterface.StudentInfo>();
        int gEnrl = 0;
        int gWait = 0;
        int gRes = 0;
        int gUnasg = 0;
        int gNoSub = 0;
        int gSwap = 0;
        int gtEnrl = 0;
        int gtWait = 0;
        int gtRes = 0;
        int gtUnasg = 0;
        int gtNoSub = 0;
        int gtSwap = 0;
        int gConNeed = 0;
        int gtConNeed = 0;
        int gOvrNeed = 0;
        int gtOvrNeed = 0;
        int gDist = 0;
        int gtDist = 0;
        int gNrDC = 0;
        int gtNrDC = 0;
        int gShr = 0;
        int gtShr = 0;
        int gFre = 0;
        int gtFre = 0;
        int gPIM = 0;
        int gtPIM = 0;
        int gPSec = 0;
        int gtPSec = 0;
        HashSet<Long> unassigned = new HashSet<Long>();
        HashSet<Long> assignedRequests = new HashSet<Long>();
        AcademicSessionInfo session = server.getAcademicSession();
        StatusPageSuggestionsAction.CourseLookup lookup = new StatusPageSuggestionsAction.CourseLookup(session);
        DistanceMetric dm = server.getDistanceMetric();
        boolean useAdvisorWaitLists = server.getConfig().getPropertyBoolean("Load.UseAdvisorWaitLists", false);
        boolean useAdvisorNoSubs = server.getConfig().getPropertyBoolean("Load.UseAdvisorNoSubs", false);
        DbFindEnrollmentInfoAction.DbFindStudentInfoMatcher sm = new DbFindEnrollmentInfoAction.DbFindStudentInfoMatcher(session, this.iQuery, helper.getStudentNameFormat(), this.iMyStudents);
        sm.setServer(server);
        HashMap<CourseOffering, ArrayList<CourseRequest>> requests = new HashMap<CourseOffering, ArrayList<CourseRequest>>();
        block0: for (CourseRequest cr : SectioningStatusFilterAction.getCourseQuery(this.iFilter, server, helper).select("distinct cr").query(helper.getHibSession()).list()) {
            ArrayList<CourseRequest> list;
            if (!this.hasMatchingSubjectArea(cr.getCourseOffering().getSubjectAreaAbbv()) || !this.isCourseVisible(cr.getCourseOffering().getUniqueId()) || !this.query().match(new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, cr, this.isConsentToDoCourse(cr.getCourseOffering()), this.isMyStudent(cr.getCourseDemand().getStudent()), helper.getStudentNameFormat(), lookup))) continue;
            if (cr.getClassEnrollments().isEmpty()) {
                for (CourseRequest x : cr.getCourseDemand().getCourseRequests()) {
                    if (x.equals(cr) || x.getClassEnrollments().isEmpty()) continue;
                    continue block0;
                }
            }
            if ((list = (ArrayList<CourseRequest>)requests.get(cr.getCourseOffering())) == null) {
                list = new ArrayList<CourseRequest>();
                requests.put(cr.getCourseOffering(), list);
            }
            list.add(cr);
        }
        for (Object entry : requests.entrySet()) {
            CourseOffering course = (CourseOffering)entry.getKey();
            boolean isConsentToDoCourse = this.isConsentToDoCourse(course);
            for (CourseRequest request : (List)entry.getValue()) {
                DbFindEnrollmentInfoAction.DbCourseRequestMatcher crm;
                Iterator<StudentClassEnrollment> status;
                Student student = request.getCourseDemand().getStudent();
                ClassAssignmentInterface.StudentInfo s = (ClassAssignmentInterface.StudentInfo)students.get(student.getUniqueId());
                if (s == null) {
                    int i;
                    s = new ClassAssignmentInterface.StudentInfo();
                    students.put(student.getUniqueId(), s);
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    s.setStudent(st);
                    st.setId(student.getUniqueId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(student.getExternalUniqueId());
                    st.setCanShowExternalId(this.iCanShowExtIds);
                    status = student.getEffectiveStatus();
                    if (status == null || ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.waitlist)) {
                        st.setWaitListMode(OnlineSectioningInterface.WaitListMode.WaitList);
                    } else if (status != null && ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.nosubs)) {
                        st.setWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs);
                    } else {
                        st.setWaitListMode(OnlineSectioningInterface.WaitListMode.None);
                    }
                    st.setCanRegister(this.iCanRegister && (status == null || ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.regenabled) || this.iIsAdmin && ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.regadmin) || this.iIsAdvisor && ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.regadvisor)));
                    st.setCanUseAssistant(this.iCanUseAssistant && (status == null || ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.enabled) || this.iIsAdmin && ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.admin) || this.iIsAdvisor && ((StudentSectioningStatus)((Object)status)).hasOption(StudentSectioningStatus.Option.advisor)));
                    st.setCanSelect(this.isCanSelect(student));
                    st.setName(helper.getStudentNameFormat().format(student));
                    for (Comparable<StudentAreaClassificationMajor> acm : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
                        st.addArea(((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicArea().getAcademicAreaAbbreviation(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicArea().getTitle());
                        st.addClassification(((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicClassification().getCode(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicClassification().getName());
                        st.addMajor(((BaseStudentAreaClassificationMajor)((Object)acm)).getMajor().getCode(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getMajor().getName());
                        st.addConcentration(((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration().getCode(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration().getName());
                        st.addDegree(((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree().getReference(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree().getLabel());
                        st.addProgram(((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram().getReference(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram().getLabel());
                        st.addCampus(((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus().getReference(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus().getLabel());
                    }
                    st.setDefaultCampus(server.getAcademicSession().getCampus());
                    for (Comparable<StudentAreaClassificationMajor> acm : new TreeSet<StudentAreaClassificationMinor>(student.getAreaClasfMinors())) {
                        st.addMinor(((BaseStudentAreaClassificationMinor)((Object)acm)).getMinor().getCode(), ((BaseStudentAreaClassificationMinor)((Object)acm)).getMinor().getName());
                    }
                    for (StudentAccomodation acc : student.getAccomodations()) {
                        st.addAccommodation(acc.getAbbreviation(), acc.getName());
                    }
                    for (StudentGroup gr : student.getGroups()) {
                        if (gr.getType() == null) {
                            st.addGroup(gr.getGroupAbbreviation(), gr.getGroupName());
                            continue;
                        }
                        st.addGroup(gr.getType().getReference(), gr.getGroupAbbreviation(), gr.getGroupName());
                    }
                    for (Advisor a : student.getAdvisors()) {
                        if (a.getLastName() == null) continue;
                        st.addAdvisor(helper.getInstructorNameFormat().format(a));
                    }
                    int tEnrl = 0;
                    int tWait = 0;
                    int tRes = 0;
                    int tConNeed = 0;
                    int tReq = 0;
                    int tUnasg = 0;
                    int tOvrNeed = 0;
                    int ovrNeed = 0;
                    int tNoSub = 0;
                    int tSwap = 0;
                    float tCred = 0.0f;
                    int nrDisCnf = 0;
                    int maxDist = 0;
                    int share = 0;
                    int ftShare = 0;
                    ArrayList<Float> minsTot = new ArrayList<Float>();
                    ArrayList<Float> maxsTot = new ArrayList<Float>();
                    ArrayList<Float> mins = new ArrayList<Float>();
                    ArrayList<Float> maxs = new ArrayList<Float>();
                    int nrCoursesTot = 0;
                    int nrCourses = 0;
                    float studentMin = 0.0f;
                    float studentMax = 0.0f;
                    float studentMinTot = 0.0f;
                    float studentMaxTot = 0.0f;
                    Set<Long> advisorWaitListedCourseIds = student.getAdvisorWaitListedCourseIds(useAdvisorWaitLists, useAdvisorNoSubs);
                    for (CourseDemand demand : student.getCourseDemands()) {
                        InstructionalMethod im;
                        if (demand.getCourseRequests().isEmpty()) continue;
                        Float minTot = null;
                        Float maxTot = null;
                        Float min = null;
                        Float max = null;
                        for (Object r : demand.getCourseRequests()) {
                            CourseCreditUnitConfig c = ((BaseCourseRequest)r).getCourseOffering().getCredit();
                            if (c != null) {
                                if (minTot == null || minTot.floatValue() > c.getMinCredit()) {
                                    minTot = Float.valueOf(c.getMinCredit());
                                }
                                if (maxTot == null || maxTot.floatValue() < c.getMaxCredit()) {
                                    maxTot = Float.valueOf(c.getMaxCredit());
                                }
                            }
                            if (((CourseRequest)r).isRequestPending()) {
                                ++tOvrNeed;
                                ++gtOvrNeed;
                            }
                            if (!this.query().match(new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, (CourseRequest)r, this.isConsentToDoCourse(((BaseCourseRequest)r).getCourseOffering()), this.isMyStudent(student), helper.getStudentNameFormat(), lookup))) continue;
                            if (c != null) {
                                if (min == null || min.floatValue() > c.getMinCredit()) {
                                    min = Float.valueOf(c.getMinCredit());
                                }
                                if (max == null || max.floatValue() < c.getMaxCredit()) {
                                    max = Float.valueOf(c.getMaxCredit());
                                }
                            }
                            if (!((CourseRequest)r).isRequestPending()) continue;
                            ++ovrNeed;
                            ++gOvrNeed;
                        }
                        boolean isWaitList = false;
                        if (!demand.isAlternative().booleanValue()) {
                            if (demand.isWaitListOrNoSub(st.getWaitListMode())) {
                                isWaitList = true;
                            } else if (advisorWaitListedCourseIds != null && !advisorWaitListedCourseIds.isEmpty()) {
                                Object r;
                                r = demand.getCourseRequests().iterator();
                                while (r.hasNext()) {
                                    CourseRequest r2 = (CourseRequest)r.next();
                                    if (!advisorWaitListedCourseIds.contains(r2.getCourseOffering().getUniqueId())) continue;
                                    isWaitList = true;
                                    break;
                                }
                            }
                        }
                        if (isWaitList) {
                            if (minTot != null) {
                                studentMinTot += minTot.floatValue();
                                studentMaxTot += maxTot.floatValue();
                            }
                            if (min != null) {
                                studentMin += min.floatValue();
                                studentMax += max.floatValue();
                            }
                        } else {
                            if (minTot != null) {
                                minsTot.add(minTot);
                                maxsTot.add(maxTot);
                                if (!demand.isAlternative().booleanValue()) {
                                    ++nrCoursesTot;
                                }
                            }
                            if (min != null) {
                                mins.add(min);
                                maxs.add(max);
                                if (!demand.isAlternative().booleanValue()) {
                                    ++nrCourses;
                                }
                            }
                        }
                        if (!demand.isAlternative().booleanValue()) {
                            ++tReq;
                        }
                        List<StudentClassEnrollment> enrollment = null;
                        Object assigned = null;
                        for (Object r : demand.getCourseRequests()) {
                            enrollment = ((CourseRequest)r).getClassEnrollments();
                            if (enrollment.isEmpty()) continue;
                            assigned = r;
                            break;
                        }
                        if (enrollment.isEmpty()) {
                            Object r;
                            BaseCourseRequest first = null;
                            r = demand.getCourseRequests().iterator();
                            while (r.hasNext()) {
                                CourseRequest r3 = (CourseRequest)r.next();
                                if (first != null && r3.getOrder() >= first.getOrder()) continue;
                                first = r3;
                            }
                            DbFindEnrollmentInfoAction.DbCourseRequestMatcher crm2 = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, (CourseRequest)first, this.isConsentToDoCourse(first.getCourseOffering()), this.isMyStudent(student), helper.getStudentNameFormat(), lookup);
                            if (!crm2.canAssign()) continue;
                            ++tUnasg;
                            ++gtUnasg;
                            if (demand.effectiveWaitList()) {
                                ++tWait;
                                ++gtWait;
                            }
                            if (!demand.effectiveNoSub()) continue;
                            ++tNoSub;
                            ++gtNoSub;
                            continue;
                        }
                        ++tEnrl;
                        ++gtEnrl;
                        DbFindEnrollmentInfoAction.DbCourseRequestMatcher crm3 = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, (CourseRequest)assigned, this.isConsentToDoCourse(((BaseCourseRequest)assigned).getCourseOffering()), this.isMyStudent(student), helper.getStudentNameFormat(), lookup);
                        if (crm3.reservation() != null) {
                            ++tRes;
                            ++gtRes;
                        }
                        if (((BaseCourseRequest)assigned).getCourseOffering().getConsentType() != null && crm3.approval() == null) {
                            ++tConNeed;
                            ++gtConNeed;
                        }
                        if (crm3.request().getCourseDemand().effectiveWaitList() && !crm3.request().getCourseDemand().isEnrolledExceptForWaitListSwap()) {
                            ++tSwap;
                            ++gtSwap;
                        }
                        if (((BaseCourseRequest)assigned).getCourseOffering().getCredit() != null) {
                            StudentClassEnrollment e;
                            tCred += ((BaseCourseRequest)assigned).getCourseOffering().getCredit().getMinCredit();
                            Iterator<StudentClassEnrollment> iterator = enrollment.iterator();
                            if (iterator.hasNext() && (im = (e = iterator.next()).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod()) != null) {
                                s.addIMTotalCredit(im.getReference(), ((BaseCourseRequest)assigned).getCourseOffering().getCredit().getMinCredit());
                            }
                        } else {
                            for (StudentClassEnrollment e : enrollment) {
                                if (e.getClazz().getSchedulingSubpart().getCredit() == null) continue;
                                tCred += e.getClazz().getSchedulingSubpart().getCredit().getMinCredit();
                                im = e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
                                if (im == null) continue;
                                s.addIMTotalCredit(im.getReference(), e.getClazz().getSchedulingSubpart().getCredit().getMinCredit());
                            }
                        }
                        for (StudentClassEnrollment section : enrollment) {
                            int sh;
                            Assignment assignment = section.getClazz().getCommittedAssignment();
                            if (assignment == null) continue;
                            for (StudentClassEnrollment otherSection : student.getClassEnrollments()) {
                                Assignment otherAssignment;
                                if (section.equals(otherSection) || (otherAssignment = otherSection.getClazz().getCommittedAssignment()) == null) continue;
                                if (this.isDistanceConflict(student, assignment, otherAssignment, dm)) {
                                    ++nrDisCnf;
                                    ++gtNrDC;
                                    int d = this.getDistanceInMinutes(assignment, otherAssignment, dm);
                                    if (d > maxDist) {
                                        maxDist = d;
                                    }
                                    if (d > gtDist) {
                                        gtDist = d;
                                    }
                                }
                                if (!assignment.getTimeLocation().hasIntersection(otherAssignment.getTimeLocation()) || section.getClazz().isToIgnoreStudentConflictsWith(otherSection.getClazz()) || section.getClazz().getUniqueId() >= otherSection.getClazz().getUniqueId()) continue;
                                sh = assignment.getTimeLocation().nrSharedDays(otherAssignment.getTimeLocation()) * assignment.getTimeLocation().nrSharedHours(otherAssignment.getTimeLocation()) * Constants.SLOT_LENGTH_MIN;
                                share += sh;
                                gtShr += sh;
                            }
                            for (CourseDemand cd : student.getCourseDemands()) {
                                TimeLocation ft;
                                if (cd.getFreeTime() == null || !(ft = new TimeLocation(cd.getFreeTime().getDayCode().intValue(), cd.getFreeTime().getStartSlot().intValue(), cd.getFreeTime().getLength().intValue(), 0, 0.0, 0, null, null, session.getFreeTimePattern(), 0)).hasIntersection(assignment.getTimeLocation())) continue;
                                sh = assignment.getTimeLocation().nrSharedDays(ft) * assignment.getTimeLocation().nrSharedHours(ft) * Constants.SLOT_LENGTH_MIN;
                                ftShare += sh;
                                gtFre += sh;
                            }
                        }
                    }
                    Collections.sort(mins);
                    Collections.sort(maxs);
                    for (i = 0; i < nrCourses; ++i) {
                        studentMin += ((Float)mins.get(i)).floatValue();
                        studentMax += ((Float)maxs.get(maxs.size() - i - 1)).floatValue();
                    }
                    Collections.sort(minsTot);
                    Collections.sort(maxsTot);
                    for (i = 0; i < nrCoursesTot; ++i) {
                        studentMinTot += ((Float)minsTot.get(i)).floatValue();
                        studentMaxTot += ((Float)maxsTot.get(maxsTot.size() - i - 1)).floatValue();
                    }
                    if (student.isRequestPending()) {
                        if (nrCourses == nrCoursesTot) {
                            ++gOvrNeed;
                            ++ovrNeed;
                        }
                        ++gtOvrNeed;
                        ++tOvrNeed;
                    }
                    s.setRequestCredit(studentMin, studentMax);
                    s.setTotalRequestCredit(studentMinTot, studentMaxTot);
                    s.setTotalEnrollment(tEnrl);
                    s.setTotalReservation(tRes);
                    s.setTotalWaitlist(tWait);
                    s.setTotalNoSub(tNoSub);
                    s.setTotalSwap(tSwap);
                    s.setTotalUnassigned(tUnasg);
                    s.setTotalConsentNeeded(tConNeed);
                    s.setTotalOverrideNeeded(tOvrNeed);
                    s.setEnrollment(0);
                    s.setReservation(0);
                    s.setWaitlist(0);
                    s.setNoSub(0);
                    s.setSwap(0);
                    s.setUnassigned(0);
                    s.setConsentNeeded(0);
                    s.setOverrideNeeded(ovrNeed);
                    s.setRequested(tReq);
                    s.setStatus(student.getSectioningStatus() == null ? session.getDefaultSectioningStatus() : student.getSectioningStatus().getReference());
                    s.setEmailDate(student.getScheduleEmailedDate() == null ? null : student.getScheduleEmailedDate());
                    s.setCredit(Float.valueOf(0.0f));
                    s.setTotalCredit(Float.valueOf(tCred));
                    s.setNrDistanceConflicts(0);
                    s.setLongestDistanceMinutes(0);
                    s.setOverlappingMinutes(0);
                    s.setTotalNrDistanceConflicts(nrDisCnf);
                    s.setTotalLongestDistanceMinutes(maxDist);
                    s.setTotalOverlappingMinutes(share);
                    s.setFreeTimeOverlappingMins(0);
                    s.setTotalFreeTimeOverlappingMins(ftShare);
                    s.setPrefInstrMethConflict(0);
                    s.setTotalPrefInstrMethConflict(0);
                    s.setPrefSectionConflict(0);
                    s.setTotalPrefSectionConflict(0);
                    BaseStudentNote note = null;
                    for (StudentNote n : student.getNotes()) {
                        if (note != null && ((StudentNote)note).compareTo(n) >= 0) continue;
                        note = n;
                    }
                    if (note != null) {
                        s.setNote(note.getTextNote());
                    }
                    s.setMyStudent(this.isMyStudent(student));
                    s.setAdvisedInfo(DbFindStudentInfoAction.getAdvisedInfo(student, server, helper));
                    s.setPreference(DbFindStudentInfoAction.getStudentSchedulingPreference(student, server, helper));
                    s.setPin(student.getPin());
                    s.setPinReleased(student.getPinReleased());
                }
                if (!(crm = new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, request, isConsentToDoCourse, this.isMyStudent(student), helper.getStudentNameFormat(), lookup)).enrollment().isEmpty()) {
                    if (assignedRequests.add(crm.request().getCourseDemand().getUniqueId())) {
                        s.setEnrollment(s.getEnrollment() + 1);
                        ++gEnrl;
                        if (crm.reservation() != null) {
                            s.setReservation(s.getReservation() + 1);
                            ++gRes;
                        }
                        if (course.getConsentType() != null && crm.approval() == null) {
                            s.setConsentNeeded(s.getConsentNeeded() + 1);
                            ++gConNeed;
                        }
                        if (crm.request().getCourseDemand().effectiveWaitList() && !crm.request().getCourseDemand().isEnrolledExceptForWaitListSwap()) {
                            s.setSwap(s.getSwap() + 1);
                            ++gSwap;
                        }
                        for (StudentClassEnrollment e : crm.enrollment()) {
                            if (e.getTimestamp() == null) continue;
                            if (s.getEnrolledDate() == null) {
                                s.setEnrolledDate(e.getTimestamp());
                                continue;
                            }
                            if (!e.getTimestamp().after(s.getEnrolledDate())) continue;
                            s.setEnrolledDate(e.getTimestamp());
                        }
                        if (crm.approval() != null) {
                            for (StudentClassEnrollment e : crm.enrollment()) {
                                if (e.getApprovedDate() == null) continue;
                                if (s.getApprovedDate() == null) {
                                    s.setApprovedDate(e.getApprovedDate());
                                    continue;
                                }
                                if (!e.getApprovedDate().after(s.getApprovedDate())) continue;
                                s.setApprovedDate(e.getApprovedDate());
                            }
                        }
                        if (course.getCredit() != null) {
                            StudentClassEnrollment e;
                            InstructionalMethod im;
                            s.setCredit(Float.valueOf(s.getCredit().floatValue() + course.getCredit().getMinCredit()));
                            status = crm.enrollment().iterator();
                            if (status.hasNext() && (im = (e = status.next()).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod()) != null) {
                                s.addIMCredit(im.getReference(), course.getCredit().getMinCredit());
                            }
                        } else {
                            for (StudentClassEnrollment e : crm.enrollment()) {
                                if (e.getClazz().getSchedulingSubpart().getCredit() == null) continue;
                                s.setCredit(Float.valueOf(s.getCredit().floatValue() + e.getClazz().getSchedulingSubpart().getCredit().getMinCredit()));
                                InstructionalMethod im = e.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod();
                                if (im == null) continue;
                                s.addIMCredit(im.getReference(), e.getClazz().getSchedulingSubpart().getCredit().getMinCredit());
                            }
                        }
                        boolean hasIm = false;
                        boolean im = false;
                        HashSet<String> allSubpart = new HashSet<String>();
                        HashSet<String> selectedSubparts = new HashSet<String>();
                        for (StudentSectioningPref pref : request.getPreferences()) {
                            if (pref instanceof StudentInstrMthPref) {
                                StudentInstrMthPref imp = (StudentInstrMthPref)pref;
                                InstructionalMethod method = crm.enrollment().get(0).getClazz().getSchedulingSubpart().getInstrOfferingConfig().getEffectiveInstructionalMethod();
                                hasIm = true;
                                if (!im && method != null && method.equals(imp.getInstructionalMethod())) {
                                    im = true;
                                }
                            }
                            if (!(pref instanceof StudentClassPref)) continue;
                            StudentClassPref scp = (StudentClassPref)pref;
                            allSubpart.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                            for (StudentClassEnrollment section : crm.enrollment()) {
                                if (!scp.getClazz().equals(section.getClazz())) continue;
                                selectedSubparts.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                            }
                        }
                        if (hasIm) {
                            s.setTotalPrefInstrMethConflict(s.getTotalPrefInstrMethConflict() + 1);
                            ++gtPIM;
                            if (im) {
                                s.setPrefInstrMethConflict(s.getPrefInstrMethConflict() + 1);
                                ++gPIM;
                            }
                        }
                        if (!allSubpart.isEmpty()) {
                            s.setTotalPrefSectionConflict(s.getTotalPrefSectionConflict() + allSubpart.size());
                            gtPSec += allSubpart.size();
                            s.setPrefSectionConflict(s.getPrefSectionConflict() + selectedSubparts.size());
                            gPSec += selectedSubparts.size();
                        }
                    }
                    for (StudentClassEnrollment section : crm.enrollment()) {
                        int sh;
                        Assignment assignment = section.getClazz().getCommittedAssignment();
                        if (assignment == null) continue;
                        for (StudentClassEnrollment otherSection : student.getClassEnrollments()) {
                            Assignment otherAssignment;
                            if (section.equals(otherSection) || (otherAssignment = otherSection.getClazz().getCommittedAssignment()) == null) continue;
                            if (this.isDistanceConflict(student, assignment, otherAssignment, dm)) {
                                s.setNrDistanceConflicts(s.getNrDistanceConflicts() + 1);
                                ++gNrDC;
                                int d = this.getDistanceInMinutes(assignment, otherAssignment, dm);
                                if (d > s.getLongestDistanceMinutes()) {
                                    s.setLongestDistanceMinutes(d);
                                }
                                if (d > gDist) {
                                    gDist = d;
                                }
                            }
                            if (!assignment.getTimeLocation().hasIntersection(otherAssignment.getTimeLocation()) || section.getClazz().isToIgnoreStudentConflictsWith(otherSection.getClazz()) || section.getClazz().getUniqueId() >= otherSection.getClazz().getUniqueId() && this.query().match(new DbFindEnrollmentInfoAction.DbCourseRequestMatcher(session, otherSection.getCourseRequest(), this.isConsentToDoCourse(otherSection.getCourseOffering()), this.isMyStudent(student), helper.getStudentNameFormat(), lookup))) continue;
                            sh = assignment.getTimeLocation().nrSharedDays(otherAssignment.getTimeLocation()) * assignment.getTimeLocation().nrSharedHours(otherAssignment.getTimeLocation()) * Constants.SLOT_LENGTH_MIN;
                            s.setOverlappingMinutes(s.getOverlappingMinutes() + sh);
                            gShr += sh;
                        }
                        for (CourseDemand cd : student.getCourseDemands()) {
                            TimeLocation ft;
                            if (cd.getFreeTime() == null || !(ft = new TimeLocation(cd.getFreeTime().getDayCode().intValue(), cd.getFreeTime().getStartSlot().intValue(), cd.getFreeTime().getLength().intValue(), 0, 0.0, 0, null, null, session.getFreeTimePattern(), 0)).hasIntersection(assignment.getTimeLocation())) continue;
                            sh = assignment.getTimeLocation().nrSharedDays(ft) * assignment.getTimeLocation().nrSharedHours(ft) * Constants.SLOT_LENGTH_MIN;
                            s.setFreeTimeOverlappingMins(s.getFreeTimeOverlappingMins() + sh);
                            gFre += sh;
                        }
                    }
                } else if (unassigned.add(crm.request().getCourseDemand().getUniqueId())) {
                    if (crm.canAssign()) {
                        if (crm.request().getCourseDemand().effectiveWaitList()) {
                            s.setWaitlist(s.getWaitlist() + 1);
                            ++gWait;
                            if (s.getTopWaitingPriority() == null) {
                                s.setTopWaitingPriority(1 + crm.request().getCourseDemand().getPriority());
                            } else {
                                s.setTopWaitingPriority(Math.min(1 + crm.request().getCourseDemand().getPriority(), s.getTopWaitingPriority()));
                            }
                        }
                        if (crm.request().getCourseDemand().effectiveNoSub()) {
                            s.setNoSub(s.getNoSub() + 1);
                            ++gNoSub;
                        }
                        s.setUnassigned(s.getUnassigned() + 1);
                        ++gUnasg;
                    }
                    for (CourseRequest c : crm.request().getCourseDemand().getCourseRequests()) {
                        boolean reqIm = false;
                        HashSet<String> reqSubparts = new HashSet<String>();
                        for (StudentSectioningPref pref : c.getPreferences()) {
                            if (!pref.isRequired().booleanValue()) continue;
                            if (pref instanceof StudentInstrMthPref) {
                                reqIm = true;
                            }
                            if (!(pref instanceof StudentClassPref)) continue;
                            StudentClassPref scp = (StudentClassPref)pref;
                            reqSubparts.add(scp.getClazz().getSchedulingSubpart().getItypeDesc());
                        }
                        if (reqIm) {
                            s.setTotalPrefInstrMethConflict(s.getTotalPrefInstrMethConflict() + 1);
                            ++gtPIM;
                        }
                        if (reqSubparts.isEmpty()) continue;
                        s.setTotalPrefSectionConflict(s.getTotalPrefSectionConflict() + reqSubparts.size());
                        gtPSec += reqSubparts.size();
                    }
                }
                if (crm.request().getCourseDemand().getTimestamp() != null) {
                    if (s.getRequestedDate() == null) {
                        s.setRequestedDate(crm.request().getCourseDemand().getTimestamp());
                    } else if (crm.request().getCourseDemand().getTimestamp().after(s.getRequestedDate())) {
                        s.setRequestedDate(crm.request().getCourseDemand().getTimestamp());
                    }
                }
                if (crm.request().getCourseDemand().getWaitlistedTimeStamp() == null) continue;
                if (s.getWaitListedDate() == null) {
                    s.setWaitListedDate(crm.request().getCourseDemand().getWaitlistedTimeStamp());
                    continue;
                }
                if (!crm.request().getCourseDemand().getWaitlistedTimeStamp().after(s.getWaitListedDate())) continue;
                s.setWaitListedDate(crm.request().getCourseDemand().getWaitlistedTimeStamp());
            }
        }
        ArrayList<Object> ret = new ArrayList(students.values());
        if (this.iSubjectAreas == null && this.iCoursesIcoordinate == null) {
            for (Student student : SectioningStatusFilterAction.getQuery(this.iFilter, server, helper).select("distinct s").query(helper.getHibSession()).list()) {
                if (students.containsKey(student.getUniqueId()) || !sm.match(student)) continue;
                ClassAssignmentInterface.StudentInfo s = new ClassAssignmentInterface.StudentInfo();
                ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                s.setStudent(st);
                st.setId(student.getUniqueId());
                st.setSessionId(session.getUniqueId());
                st.setExternalId(student.getExternalUniqueId());
                st.setCanShowExternalId(this.iCanShowExtIds);
                StudentSectioningStatus status = student.getEffectiveStatus();
                if (status == null || status.hasOption(StudentSectioningStatus.Option.waitlist)) {
                    st.setWaitListMode(OnlineSectioningInterface.WaitListMode.WaitList);
                } else if (status != null && status.hasOption(StudentSectioningStatus.Option.nosubs)) {
                    st.setWaitListMode(OnlineSectioningInterface.WaitListMode.NoSubs);
                } else {
                    st.setWaitListMode(OnlineSectioningInterface.WaitListMode.None);
                }
                st.setCanRegister(this.iCanRegister && (status == null || status.hasOption(StudentSectioningStatus.Option.regenabled) || this.iIsAdmin && status.hasOption(StudentSectioningStatus.Option.regadmin) || this.iIsAdvisor && status.hasOption(StudentSectioningStatus.Option.regadvisor)));
                st.setCanUseAssistant(this.iCanUseAssistant && (status == null || status.hasOption(StudentSectioningStatus.Option.enabled) || this.iIsAdmin && status.hasOption(StudentSectioningStatus.Option.admin) || this.iIsAdvisor && status.hasOption(StudentSectioningStatus.Option.advisor)));
                st.setCanSelect(this.isCanSelect(student));
                st.setName(helper.getStudentNameFormat().format(student));
                for (Comparable<StudentAreaClassificationMajor> acm : new TreeSet<StudentAreaClassificationMajor>(student.getAreaClasfMajors())) {
                    st.addArea(((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicArea().getAcademicAreaAbbreviation(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicArea().getTitle());
                    st.addClassification(((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicClassification().getCode(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getAcademicClassification().getName());
                    st.addMajor(((BaseStudentAreaClassificationMajor)((Object)acm)).getMajor().getCode(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getMajor().getName());
                    st.addConcentration(((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration().getCode(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getConcentration().getName());
                    st.addDegree(((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree().getReference(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getDegree().getLabel());
                    st.addProgram(((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram().getReference(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getProgram().getLabel());
                    st.addCampus(((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus().getReference(), ((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus() == null ? null : ((BaseStudentAreaClassificationMajor)((Object)acm)).getCampus().getLabel());
                }
                st.setDefaultCampus(server.getAcademicSession().getCampus());
                for (Comparable<StudentAreaClassificationMajor> acm : new TreeSet<StudentAreaClassificationMinor>(student.getAreaClasfMinors())) {
                    st.addMinor(((BaseStudentAreaClassificationMinor)((Object)acm)).getMinor().getCode(), ((BaseStudentAreaClassificationMinor)((Object)acm)).getMinor().getName());
                }
                for (StudentAccomodation acc : student.getAccomodations()) {
                    st.addAccommodation(acc.getAbbreviation(), acc.getName());
                }
                for (StudentGroup gr : student.getGroups()) {
                    if (gr.getType() == null) {
                        st.addGroup(gr.getGroupAbbreviation(), gr.getGroupName());
                        continue;
                    }
                    st.addGroup(gr.getType().getReference(), gr.getGroupAbbreviation(), gr.getGroupName());
                }
                for (Advisor a : student.getAdvisors()) {
                    if (a.getLastName() == null) continue;
                    st.addAdvisor(helper.getInstructorNameFormat().format(a));
                }
                s.setStatus(student.getSectioningStatus() == null ? session.getDefaultSectioningStatus() : student.getSectioningStatus().getReference());
                s.setEmailDate(student.getScheduleEmailedDate() == null ? null : student.getScheduleEmailedDate());
                BaseStudentNote note = null;
                for (StudentNote n : student.getNotes()) {
                    if (note != null && ((StudentNote)note).compareTo(n) >= 0) continue;
                    note = n;
                }
                if (note != null) {
                    s.setNote(note.getTextNote());
                }
                s.setMyStudent(this.isMyStudent(student));
                s.setAdvisedInfo(DbFindStudentInfoAction.getAdvisedInfo(student, server, helper));
                s.setPreference(DbFindStudentInfoAction.getStudentSchedulingPreference(student, server, helper));
                s.setPin(student.getPin());
                s.setPinReleased(student.isPinReleased());
                ret.add(s);
            }
        }
        Collections.sort(ret, new Comparator<ClassAssignmentInterface.StudentInfo>(){

            @Override
            public int compare(ClassAssignmentInterface.StudentInfo s1, ClassAssignmentInterface.StudentInfo s2) {
                int cmp = s1.getStudent().getName().compareTo(s2.getStudent().getName());
                if (cmp != 0) {
                    return cmp;
                }
                return Long.valueOf(s1.getStudent().getId()).compareTo(s2.getStudent().getId());
            }
        });
        if (this.limit() != null && ret.size() >= this.limit()) {
            ArrayList<ClassAssignmentInterface.StudentInfo> r = new ArrayList<ClassAssignmentInterface.StudentInfo>(this.limit());
            for (ClassAssignmentInterface.StudentInfo i : ret) {
                r.add(i);
                if (r.size() != this.limit().intValue()) continue;
                break;
            }
            ret = r;
        }
        ClassAssignmentInterface.StudentInfo t = new ClassAssignmentInterface.StudentInfo();
        t.setEnrollment(gEnrl);
        t.setReservation(gRes);
        t.setWaitlist(gWait);
        t.setNoSub(gNoSub);
        t.setSwap(gSwap);
        t.setUnassigned(gUnasg);
        t.setTotalEnrollment(gtEnrl);
        t.setTotalReservation(gtRes);
        t.setTotalWaitlist(gtWait);
        t.setTotalNoSub(gtNoSub);
        t.setTotalSwap(gtSwap);
        t.setTotalUnassigned(gtUnasg);
        t.setConsentNeeded(gConNeed);
        t.setTotalConsentNeeded(gtConNeed);
        t.setOverrideNeeded(gOvrNeed);
        t.setTotalOverrideNeeded(gtOvrNeed);
        t.setNrDistanceConflicts(gNrDC);
        t.setTotalNrDistanceConflicts(gtNrDC);
        t.setLongestDistanceMinutes(gDist);
        t.setTotalLongestDistanceMinutes(gtDist);
        t.setOverlappingMinutes(gShr);
        t.setTotalOverlappingMinutes(gtShr);
        t.setFreeTimeOverlappingMins(gFre);
        t.setTotalFreeTimeOverlappingMins(gtFre);
        t.setPrefInstrMethConflict(gPIM);
        t.setTotalPrefInstrMethConflict(gtPIM);
        t.setPrefSectionConflict(gPSec);
        t.setTotalPrefSectionConflict(gtPSec);
        ret.add(t);
        return ret;
    }

    public int getDistanceInMinutes(Assignment as1, Assignment as2, DistanceMetric m) {
        Placement p1 = as1.getPlacement();
        Placement p2 = as2.getPlacement();
        if (p1.getNrRooms() == 0 || p2.getNrRooms() == 0) {
            return 0;
        }
        TimeLocation t1 = p1.getTimeLocation();
        TimeLocation t2 = p2.getTimeLocation();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return 0;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            int dist;
            if (a1 + t1.getLength() <= a2 && (dist = Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2)) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength())) {
                return dist;
            }
        } else if (a1 + t1.getLength() == a2) {
            return Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2);
        }
        return 0;
    }

    public boolean isDistanceConflict(Student student, Assignment as1, Assignment as2, DistanceMetric m) {
        Placement p1 = as1.getPlacement();
        Placement p2 = as2.getPlacement();
        if (p1.getNrRooms() == 0 || p2.getNrRooms() == 0) {
            return false;
        }
        TimeLocation t1 = p1.getTimeLocation();
        TimeLocation t2 = p2.getTimeLocation();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return false;
        }
        int a1 = t1.getStartSlot();
        int a2 = t2.getStartSlot();
        boolean sd = false;
        for (StudentAccomodation a : student.getAccomodations()) {
            if (!m.getShortDistanceAccommodationReference().equals(a.getAbbreviation())) continue;
            sd = true;
            break;
        }
        if (sd) {
            if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
                if (a1 + t1.getLength() <= a2) {
                    int dist = Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2);
                    return dist > Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
                }
            } else if (a1 + t1.getLength() == a2) {
                return Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2) > 0;
            }
        } else if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            if (a1 + t1.getLength() <= a2) {
                int dist = Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2);
                return dist > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (a2 - a1 - t1.getLength());
            }
        } else if (a1 + t1.getLength() == a2) {
            return Placement.getDistanceInMinutes((DistanceMetric)m, (Placement)p1, (Placement)p2) > t1.getBreakTime();
        }
        return false;
    }

    public boolean isConsentToDoCourse(CourseOffering course) {
        return this.iCoursesIcanApprove != null && course.getConsentType() != null && this.iCoursesIcanApprove.contains(course.getUniqueId());
    }

    public static String getStudentSchedulingPreference(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        String pref = null;
        if (student.getModalityPreference() != null && student.getModalityPreference() != Student.ModalityPreference.NO_PREFERENCE) {
            switch (student.getModalityPreference()) {
                case ONILNE_DISCOURAGED: {
                    pref = (String)(pref == null ? "" : pref + "\n") + MSG.itemSchedulingModalityPreferFaceToFace();
                    break;
                }
                case ONLINE_PREFERRED: {
                    pref = (String)(pref == null ? "" : pref + "\n") + MSG.itemSchedulingModalityPreferOnline();
                    break;
                }
                case ONLINE_REQUIRED: {
                    pref = (String)(pref == null ? "" : pref + "\n") + MSG.itemSchedulingModalityRequireOnline();
                }
            }
        }
        if (student.getBackToBackPreference() != null && student.getBackToBackPreference() != Student.BackToBackPreference.NO_PREFERENCE) {
            switch (student.getBackToBackPreference()) {
                case BTB_DISCOURAGED: {
                    pref = (String)(pref == null ? "" : pref + "\n") + MSG.itemSchedulingBackToBackDiscourage();
                    break;
                }
                case BTB_PREFERRED: {
                    pref = (String)(pref == null ? "" : pref + "\n") + MSG.itemSchedulingBackToBackPrefer();
                }
            }
        }
        if (student.getClassStartDate() != null || student.getClassEndDate() != null) {
            pref = student.getClassStartDate() == null ? (String)(pref == null ? "" : pref + "\n") + MSG.schedulingPrefClassesTo(Formats.getDateFormat(CONST.patternDateFormat()).format(student.getClassEndDate())) : (student.getClassEndDate() == null ? (String)(pref == null ? "" : pref + "\n") + MSG.schedulingPrefClassesFrom(Formats.getDateFormat(CONST.patternDateFormat()).format(student.getClassStartDate())) : (String)(pref == null ? "" : pref + "\n") + MSG.schedulingPrefClassesBetween(Formats.getDateFormat(CONST.patternDateFormat()).format(student.getClassStartDate()), Formats.getDateFormat(CONST.patternDateFormat()).format(student.getClassEndDate())));
        }
        return pref;
    }

    public static ClassAssignmentInterface.AdvisedInfoInterface getAdvisedInfo(Student student, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (student == null || student.getAdvisorCourseRequests() == null || student.getAdvisorCourseRequests().isEmpty()) {
            return null;
        }
        ArrayList<AdvisorCourseRequest> acrs = new ArrayList<AdvisorCourseRequest>(student.getAdvisorCourseRequests());
        Collections.sort(acrs);
        HashSet<Long> enrolledCourseIds = new HashSet<Long>();
        for (StudentClassEnrollment e : student.getClassEnrollments()) {
            enrolledCourseIds.add(e.getCourseOffering().getUniqueId());
        }
        ClassAssignmentInterface.AdvisedInfoInterface info = new ClassAssignmentInterface.AdvisedInfoInterface();
        BaseAdvisorCourseRequest last = null;
        CourseDemand.Critical advCritical = CourseDemand.Critical.fromText(ApplicationProperty.AdvisorCourseRequestsAllowCritical.valueOfSession(server.getAcademicSession().getUniqueId()));
        CourseOffering advFirstChoice = null;
        BaseCourseRequest firstChoice = null;
        CourseOffering firstEnrolled = null;
        boolean firstChoiceCritical = false;
        float minCred = 0.0f;
        float maxCred = 0.0f;
        float cm = 0.0f;
        float cx = 0.0f;
        int nrCourses = 0;
        int nrCriticalCourses = 0;
        int nrCoursesFound = 0;
        int nrCriticalCoursesFound = 0;
        int nrSubstMisMatch = 0;
        int nrCoursesAssigned = 0;
        int foundPrioMin = 0;
        int foundPrioMax = 0;
        int points = 0;
        int maxPoints = 0;
        int missingCrit = 0;
        int missingPrim = 0;
        int notAssignedCrit = 0;
        int notAssignedPrim = 0;
        for (AdvisorCourseRequest acr : acrs) {
            if (acr.getPriority() == -1) continue;
            if (last != null && last.getPriority() != acr.getPriority()) {
                minCred += cm;
                maxCred += cx;
                cm = 0.0f;
                cx = 0.0f;
                if (advFirstChoice != null) {
                    if (firstChoiceCritical && nrCoursesFound == 0) {
                        ++missingCrit;
                        ++missingPrim;
                        if (nrCourses > 1) {
                            info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourseWithAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourseWithAlts(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourseWithAlts(advFirstChoice.getCourseName())));
                        } else {
                            info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourse(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourse(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourse(advFirstChoice.getCourseName())));
                        }
                    } else if (!last.isSubstitute().booleanValue() && nrCoursesFound - nrSubstMisMatch == 0) {
                        ++missingPrim;
                        if (nrCourses > 1) {
                            info.addMessage(MSG.advMessageMissingCourseWithAlts(advFirstChoice.getCourseName()));
                        } else {
                            info.addMessage(MSG.advMessageMissingCourse(advFirstChoice.getCourseName()));
                        }
                    } else if (last.isSubstitute().booleanValue() && nrCoursesFound == 0) {
                        if (nrCourses > 1) {
                            info.addMessage(MSG.advMessageMissingSubstituteCourseWithAlts(advFirstChoice.getCourseName()));
                        } else {
                            info.addMessage(MSG.advMessageMissingSubstituteCourse(advFirstChoice.getCourseName()));
                        }
                    } else if (firstChoice == null && firstChoiceCritical) {
                        info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourseHasAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourseHasAlts(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourseHasAlts(advFirstChoice.getCourseName())));
                    } else if (firstChoice == null) {
                        info.addMessage(MSG.advMessageMissingCourseHasAlts(advFirstChoice.getCourseName()));
                    } else if (nrCoursesFound < nrCourses) {
                        info.addMessage(MSG.advMessageMissingAlternatives(advFirstChoice.getCourseName()));
                    }
                    if (nrCoursesFound > 0 && nrCoursesAssigned == 0 && !last.isSubstitute().booleanValue()) {
                        ++notAssignedPrim;
                        if (firstChoiceCritical) {
                            ++notAssignedCrit;
                            if (nrCourses > 1) {
                                info.addNotAssignedMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageNotEnrolledImportantCourseWithAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageNotEnrolledVitalCourseWithAlts(advFirstChoice.getCourseName()) : MSG.advMessageNotEnrolledCriticalCourseWithAlts(advFirstChoice.getCourseName())));
                            } else {
                                info.addNotAssignedMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageNotEnrolledImportantCourse(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageNotEnrolledVitalCourse(advFirstChoice.getCourseName()) : MSG.advMessageNotEnrolledCriticalCourse(advFirstChoice.getCourseName())));
                            }
                        } else if (nrCourses > 1) {
                            info.addNotAssignedMessage(MSG.advMessageNotEnrolledCourseWithAlts(advFirstChoice.getCourseName()));
                        } else {
                            info.addNotAssignedMessage(MSG.advMessageNotEnrolledCourse(advFirstChoice.getCourseName()));
                        }
                    } else if (last.isSubstitute().booleanValue() && nrCoursesAssigned > 0) {
                        --notAssignedPrim;
                        info.addNotAssignedMessage(MSG.advMessageHasEnrolledSubstituteCourse(firstEnrolled.getCourseName()));
                    }
                    maxPoints += 4 + (firstChoiceCritical ? 2 : 0);
                    if (firstChoice != null) {
                        points += 2;
                        if (firstChoiceCritical && firstChoice.getCourseDemand().isCriticalOrImportant()) {
                            points += 2;
                        }
                        if (firstChoice.getCourseDemand().isAlternative() == last.isSubstitute()) {
                            ++points;
                        }
                        if (firstChoice.getCourseDemand().getFirstChoiceCourseOffering().equals(advFirstChoice)) {
                            ++points;
                        }
                    }
                    maxPoints += 2;
                    if (nrCourses == nrCoursesFound) {
                        points += 2;
                    }
                    if (nrCourses > 1) {
                        ++maxPoints;
                    }
                    if (nrCourses > 1 && nrCoursesFound >= 1) {
                        ++points;
                    }
                    if (nrCourses > 0 && !last.isSubstitute().booleanValue()) {
                        maxPoints += 2;
                    }
                    if (nrCourses > 0 && nrCoursesFound >= 1 && !last.isSubstitute().booleanValue() && nrCoursesFound - nrSubstMisMatch > 0) {
                        points += 2;
                    }
                    if (nrCourses > 1) {
                        ++maxPoints;
                    }
                    if (nrCourses > 1 && nrCoursesFound > 1) {
                        ++points;
                    }
                    if (nrCourses > 2) {
                        ++maxPoints;
                    }
                    if (nrCourses > 2 && nrCoursesFound > 2) {
                        ++points;
                    }
                    if (nrCoursesFound > 1) {
                        ++maxPoints;
                    }
                    if (nrCoursesFound > 1 && foundPrioMin == foundPrioMax) {
                        ++points;
                    }
                    ++maxPoints;
                    if (nrSubstMisMatch == 0 && nrCoursesFound > 0) {
                        ++points;
                    }
                    if (nrCriticalCourses > 1) {
                        maxPoints += 3;
                    }
                    if (nrCriticalCourses > 1 && nrCriticalCoursesFound > 1) {
                        points += 3;
                    }
                }
                nrCourses = 0;
                nrCriticalCourses = 0;
                nrCoursesFound = 0;
                nrCriticalCoursesFound = 0;
                nrSubstMisMatch = 0;
                advFirstChoice = null;
                firstChoice = null;
                firstChoiceCritical = false;
                foundPrioMin = 0;
                foundPrioMax = 0;
                firstEnrolled = null;
                nrCoursesAssigned = 0;
            }
            if (!acr.isSubstitute().booleanValue()) {
                CourseCreditUnitConfig credit;
                CourseCreditUnitConfig courseCreditUnitConfig = credit = acr.getCourseOffering() == null ? null : acr.getCourseOffering().getCredit();
                if (credit != null) {
                    if (acr.getAlternative() == 0 || credit.getMinCredit() < cm) {
                        cm = credit.getMinCredit();
                    }
                    if (acr.getAlternative() == 0 || credit.getMaxCredit() > cx) {
                        cx = credit.getMaxCredit();
                    }
                } else if (acr.getAlternative() == 0) {
                    cm = acr.getCreditMin();
                    cx = acr.getCreditMax();
                }
            }
            if (acr.getCourseOffering() != null) {
                ++nrCourses;
                if (acr.isCriticalOrImportant() && !acr.isSubstitute().booleanValue()) {
                    ++nrCriticalCourses;
                }
                BaseCourseRequest request = null;
                block2: for (CourseDemand cd : student.getCourseDemands()) {
                    for (CourseRequest cr : cd.getCourseRequests()) {
                        if (!cr.getCourseOffering().equals(acr.getCourseOffering())) continue;
                        request = cr;
                        break block2;
                    }
                }
                if (advFirstChoice == null) {
                    advFirstChoice = acr.getCourseOffering();
                    firstChoiceCritical = acr.isCriticalOrImportant();
                    firstChoice = request;
                }
                if (enrolledCourseIds.contains(acr.getCourseOffering().getUniqueId())) {
                    ++nrCoursesAssigned;
                    if (firstEnrolled == null) {
                        firstEnrolled = acr.getCourseOffering();
                    }
                }
                if (request != null) {
                    if (++nrCoursesFound == 1) {
                        foundPrioMin = request.getCourseDemand().getPriority();
                        foundPrioMax = request.getCourseDemand().getPriority();
                    } else {
                        if (request.getCourseDemand().getPriority() < foundPrioMin) {
                            foundPrioMin = request.getCourseDemand().getPriority();
                        }
                        if (request.getCourseDemand().getPriority() > foundPrioMax) {
                            foundPrioMax = request.getCourseDemand().getPriority();
                        }
                    }
                    if (acr.isSubstitute() != request.getCourseDemand().isAlternative()) {
                        ++nrSubstMisMatch;
                    }
                    if (acr.isCriticalOrImportant() && request.getCourseDemand().isCriticalOrImportant() && !request.getCourseDemand().isAlternative().booleanValue()) {
                        ++nrCriticalCoursesFound;
                    }
                }
            }
            last = acr;
        }
        info.setMinCredit(Float.valueOf(minCred += cm));
        info.setMaxCredit(Float.valueOf(maxCred += cx));
        if (advFirstChoice != null) {
            if (firstChoiceCritical && nrCoursesFound == 0) {
                ++missingCrit;
                ++missingPrim;
                if (nrCourses > 1) {
                    info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourseWithAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourseWithAlts(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourseWithAlts(advFirstChoice.getCourseName())));
                } else {
                    info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourse(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourse(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourse(advFirstChoice.getCourseName())));
                }
            } else if (!last.isSubstitute().booleanValue() && nrCoursesFound - nrSubstMisMatch == 0) {
                ++missingPrim;
                if (nrCourses > 1) {
                    info.addMessage(MSG.advMessageMissingCourseWithAlts(advFirstChoice.getCourseName()));
                } else {
                    info.addMessage(MSG.advMessageMissingCourse(advFirstChoice.getCourseName()));
                }
            } else if (last.isSubstitute().booleanValue() && nrCoursesFound == 0) {
                if (nrCourses > 1) {
                    info.addMessage(MSG.advMessageMissingSubstituteCourseWithAlts(advFirstChoice.getCourseName()));
                } else {
                    info.addMessage(MSG.advMessageMissingSubstituteCourse(advFirstChoice.getCourseName()));
                }
            } else if (firstChoice == null && firstChoiceCritical) {
                info.addMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageMissingImportantCourseHasAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageMissingVitalCourseHasAlts(advFirstChoice.getCourseName()) : MSG.advMessageMissingCriticalCourseHasAlts(advFirstChoice.getCourseName())));
            } else if (firstChoice == null) {
                info.addMessage(MSG.advMessageMissingCourseHasAlts(advFirstChoice.getCourseName()));
            } else if (nrCoursesFound < nrCourses) {
                info.addMessage(MSG.advMessageMissingAlternatives(advFirstChoice.getCourseName()));
            }
            if (nrCoursesFound > 0 && nrCoursesAssigned == 0 && !last.isSubstitute().booleanValue()) {
                ++notAssignedPrim;
                if (firstChoiceCritical) {
                    ++notAssignedCrit;
                    if (nrCourses > 1) {
                        info.addNotAssignedMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageNotEnrolledImportantCourseWithAlts(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageNotEnrolledVitalCourseWithAlts(advFirstChoice.getCourseName()) : MSG.advMessageNotEnrolledCriticalCourseWithAlts(advFirstChoice.getCourseName())));
                    } else {
                        info.addNotAssignedMessage(advCritical == CourseDemand.Critical.IMPORTANT ? MSG.advMessageNotEnrolledImportantCourse(advFirstChoice.getCourseName()) : (advCritical == CourseDemand.Critical.VITAL ? MSG.advMessageNotEnrolledVitalCourse(advFirstChoice.getCourseName()) : MSG.advMessageNotEnrolledCriticalCourse(advFirstChoice.getCourseName())));
                    }
                } else if (nrCourses > 1) {
                    info.addNotAssignedMessage(MSG.advMessageNotEnrolledCourseWithAlts(advFirstChoice.getCourseName()));
                } else {
                    info.addNotAssignedMessage(MSG.advMessageNotEnrolledCourse(advFirstChoice.getCourseName()));
                }
            } else if (last.isSubstitute().booleanValue() && nrCoursesAssigned > 0) {
                --notAssignedPrim;
                info.addNotAssignedMessage(MSG.advMessageHasEnrolledSubstituteCourse(firstEnrolled.getCourseName()));
            }
            maxPoints += 4 + (firstChoiceCritical ? 2 : 0);
            if (firstChoice != null) {
                points += 2;
                if (firstChoiceCritical && firstChoice.getCourseDemand().isCriticalOrImportant()) {
                    points += 2;
                }
                if (firstChoice.getCourseDemand().isAlternative() == last.isSubstitute()) {
                    ++points;
                }
                if (firstChoice.getCourseDemand().getFirstChoiceCourseOffering().equals(advFirstChoice)) {
                    ++points;
                }
            }
            maxPoints += 2;
            if (nrCourses == nrCoursesFound) {
                points += 2;
            }
            if (nrCourses > 1) {
                ++maxPoints;
            }
            if (nrCourses > 1 && nrCoursesFound >= 1) {
                ++points;
            }
            if (nrCourses > 0 && !last.isSubstitute().booleanValue()) {
                maxPoints += 2;
            }
            if (nrCourses > 0 && nrCoursesFound >= 1 && !last.isSubstitute().booleanValue() && nrCoursesFound - nrSubstMisMatch > 0) {
                points += 2;
            }
            if (nrCourses > 1) {
                ++maxPoints;
            }
            if (nrCourses > 1 && nrCoursesFound > 1) {
                ++points;
            }
            if (nrCourses > 2) {
                ++maxPoints;
            }
            if (nrCourses > 2 && nrCoursesFound > 2) {
                ++points;
            }
            if (nrCoursesFound > 1) {
                ++maxPoints;
            }
            if (nrCoursesFound > 1 && foundPrioMin == foundPrioMax) {
                ++points;
            }
            ++maxPoints;
            if (nrSubstMisMatch == 0 && nrCoursesFound > 0) {
                ++points;
            }
            if (nrCriticalCourses > 1) {
                maxPoints += 3;
            }
            if (nrCriticalCourses > 1 && nrCriticalCoursesFound > 1) {
                points += 3;
            }
        }
        info.setPercentage(Float.valueOf((float)points / (float)maxPoints));
        info.setMissingCritical(missingCrit);
        info.setMissingPrimary(missingPrim);
        info.setNotAssignedCritical(notAssignedCrit);
        info.setNotAssignedPrimary(notAssignedPrim);
        info.setAdvisorCritical(advCritical.ordinal());
        return info;
    }
}

