/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.HardDistanceConflicts;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.online.MaxOverExpectedConstraint;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.expectations.MinimizeConflicts;
import org.cpsolver.studentsct.online.expectations.NeverOverExpected;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.cpsolver.studentsct.online.selection.BestPenaltyCriterion;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSuggestions;
import org.cpsolver.studentsct.online.selection.SuggestionsBranchAndBound;
import org.cpsolver.studentsct.reservation.IndividualRestriction;
import org.cpsolver.studentsct.reservation.Reservation;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.solver.SuggestionsFilter;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class ComputeSuggestionsAction
extends FindAssignmentAction {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private ClassAssignmentInterface.ClassAssignment iSelection;
    private double iValue = 0.0;
    private String iFilter = null;

    @Override
    public ComputeSuggestionsAction forRequest(CourseRequestInterface request) {
        super.forRequest(request);
        return this;
    }

    @Override
    public ComputeSuggestionsAction withAssignment(Collection<ClassAssignmentInterface.ClassAssignment> assignment) {
        super.withAssignment(assignment);
        return this;
    }

    public ComputeSuggestionsAction withSelection(ClassAssignmentInterface.ClassAssignment selectedAssignment) {
        this.iSelection = selectedAssignment;
        return this;
    }

    public ComputeSuggestionsAction withFilter(String filter) {
        this.iFilter = filter;
        return this;
    }

    public ClassAssignmentInterface.ClassAssignment getSelection() {
        return this.iSelection;
    }

    public String getFilter() {
        return this.iFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClassAssignmentInterface> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        String override;
        long t0 = System.currentTimeMillis();
        OverExpectedCriterion overExpected = server.getOverExpectedCriterion();
        if ((this.getRequest().areSpaceConflictsAllowed() || this.getRequest().areTimeConflictsAllowed() || this.getRequest().areLinkedConflictsAllowed()) && server.getConfig().getPropertyBoolean("OverExpected.MinimizeConflicts", false)) {
            overExpected = new MinimizeConflicts(server.getConfig(), overExpected);
        }
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), overExpected);
        model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
        AssignmentMap assignment = new AssignmentMap();
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        OnlineSectioningLog.Action.Builder action = helper.getAction();
        if (this.getRequest().getStudentId() != null) {
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getRequest().getStudentId()));
        }
        Student student = new Student(this.getRequest().getStudentId() == null ? -1L : this.getRequest().getStudentId());
        HashSet<FindAssignmentAction.IdPair> enrolled = null;
        ClassAssignmentInterface unavailabilities = null;
        List<GetAssignment.CourseSection> providedUnavailabilities = null;
        OnlineSectioningServer.Lock readLock = server.readLock();
        try {
            XStudent original;
            boolean checkDeadlines = server.getConfig().getPropertyBoolean("FindAssignment.CheckDeadlines", false) && !this.getRequest().areDeadlineConflictsAllowed();
            Integer currentDateIndex = null;
            if (server.getConfig().getPropertyBoolean("FindAssignment.AvoidPastSections", true)) {
                currentDateIndex = Days.daysBetween((ReadablePartial)new LocalDate((Object)server.getAcademicSession().getDatePatternFirstDate()), (ReadablePartial)new LocalDate()).getDays() + server.getConfig().getPropertyInt("FindAssignment.AvoidPastOffset", 0);
            }
            boolean onlineOnlyFilter = true;
            if (helper.hasAdminPermission() && server.getConfig().getPropertyBoolean("Load.OnlineOnlyAdminOverride", false)) {
                onlineOnlyFilter = false;
            } else if (helper.hasAvisorPermission() && server.getConfig().getPropertyBoolean("Load.OnlineOnlyAdvisorOverride", false)) {
                onlineOnlyFilter = false;
            }
            XStudent xStudent = original = this.getRequest().getStudentId() == null ? null : server.getStudent(this.getRequest().getStudentId());
            if (original != null) {
                unavailabilities = new ClassAssignmentInterface();
                providedUnavailabilities = GetAssignment.fillUnavailabilitiesIn(unavailabilities, original, server, helper, null);
                Collections.reverse(unavailabilities.getCourseAssignments());
                student.setExternalId(original.getExternalId());
                student.setName(original.getName());
                student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
                student.setAllowDisabled(original.isAllowDisabled());
                if (server instanceof StudentSolver) {
                    student.setMaxCredit(original.getMaxCredit());
                }
                student.setClassFirstDate(original.getClassStartDate());
                student.setClassLastDate(original.getClassEndDate());
                student.setBackToBackPreference(original.getBackToBackPreference());
                student.setModalityPreference(original.getModalityPreference());
                action.getStudentBuilder().setUniqueId(original.getStudentId()).setExternalId(original.getExternalId()).setName(original.getName());
                enrolled = new HashSet<FindAssignmentAction.IdPair>();
                for (XRequest xRequest : original.getRequests()) {
                    if (!(xRequest instanceof XCourseRequest) || ((XCourseRequest)xRequest).getEnrollment() == null) continue;
                    XEnrollment xEnrollment = ((XCourseRequest)xRequest).getEnrollment();
                    for (Long s : xEnrollment.getSectionIds()) {
                        enrolled.add(new FindAssignmentAction.IdPair(xEnrollment.getCourseId(), s));
                    }
                }
                OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                for (XRequest xRequest : original.getRequests()) {
                    if (!(xRequest instanceof XCourseRequest) || ((XCourseRequest)xRequest).getEnrollment() == null) continue;
                    XCourseRequest cr = (XCourseRequest)xRequest;
                    XOffering offering = server.getOffering(cr.getEnrollment().getOfferingId());
                    for (XSection section : offering.getSections(cr.getEnrollment())) {
                        enrollment.addSection(OnlineSectioningHelper.toProto(section, cr.getEnrollment()));
                    }
                }
                action.addEnrollment(enrollment);
            }
            HashMap<Long, Section> classTable = new HashMap<Long, Section>();
            HashSet<XDistribution> hashSet = new HashSet<XDistribution>();
            if (this.getAssignment() != null) {
                this.getRequest().moveActiveSubstitutionsUp();
            }
            for (CourseRequestInterface.Request c : this.getRequest().getCourses()) {
                ComputeSuggestionsAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, false, true, classTable, hashSet, this.getAssignment() != null, this.getAssignment() != null, checkDeadlines, currentDateIndex, onlineOnlyFilter, this.isCanRequirePreferences(), helper);
            }
            if (student.getRequests().isEmpty()) {
                throw new SectioningException(MSG.exceptionNoCourse());
            }
            for (CourseRequestInterface.Request c : this.getRequest().getAlternatives()) {
                ComputeSuggestionsAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, true, true, classTable, hashSet, this.getAssignment() != null, this.getAssignment() != null, checkDeadlines, currentDateIndex, onlineOnlyFilter, this.isCanRequirePreferences(), helper);
            }
            if (helper.isAlternativeCourseEnabled()) {
                for (Request r : student.getRequests()) {
                    XOffering x;
                    XCourse ci;
                    Object course;
                    Long altCourseId;
                    CourseRequest cr;
                    if (r.isAlternative() || !(r instanceof CourseRequest) || (cr = (CourseRequest)r).getCourses().size() != 1 || (altCourseId = (course = server.getCourse(((Course)cr.getCourses().get(0)).getId())) == null ? null : ((XCourse)course).getAlternativeCourseId()) == null) continue;
                    boolean hasCourse = false;
                    block10: for (Request x2 : student.getRequests()) {
                        if (!(x2 instanceof CourseRequest)) continue;
                        for (Course c : ((CourseRequest)x2).getCourses()) {
                            if (c.getId() != altCourseId.longValue()) continue;
                            hasCourse = true;
                            continue block10;
                        }
                    }
                    if (hasCourse || (ci = server.getCourse(altCourseId)) == null || (x = server.getOffering(ci.getOfferingId())) == null) continue;
                    cr.getCourses().add(ComputeSuggestionsAction.clone(x, server.getEnrollments(x.getOfferingId()), ci.getCourseId(), student.getId(), original, classTable, server, (StudentSectioningModel)model, this.getAssignment() != null, checkDeadlines, currentDateIndex, onlineOnlyFilter, helper));
                    hashSet.addAll(x.getDistributions());
                }
            }
            if (providedUnavailabilities != null) {
                for (GetAssignment.CourseSection cs : providedUnavailabilities) {
                    if (cs.getSection().isCancelled() || cs.getSection().getTime() == null) continue;
                    Unavailability ua = new Unavailability(student, new Section(cs.getSection().getSectionId().longValue(), cs.getSection().getLimit(), cs.getCourse().getCourseName() + " " + cs.getSection().getSubpartName() + " " + cs.getSection().getName(cs.getCourse().getCourseId()), null, cs.getSection().toPlacement(0), null, new Instructor[0]), cs.isAllowOverlap());
                    ua.setTeachingAssignment(cs.isTeachingAssignment());
                    ua.setCourseId(cs.getCourse().getCourseId());
                }
            }
            model.addStudent(student);
            model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
            for (XDistribution link : hashSet) {
                if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
                ArrayList<Section> sections = new ArrayList<Section>();
                for (Long sectionId : link.getSectionIds()) {
                    Section x = (Section)classTable.get(sectionId);
                    if (x == null) continue;
                    sections.add(x);
                }
                if (sections.size() < 2) continue;
                model.addLinkedSections(linkedClassesMustBeUsed, sections);
            }
        }
        finally {
            readLock.release();
        }
        long t1 = System.currentTimeMillis();
        Hashtable<CourseRequest, Iterator<OnlineSectioningLog.Time.Builder>> preferredSectionsForCourse = new Hashtable<CourseRequest, Iterator<OnlineSectioningLog.Time.Builder>>();
        Hashtable<CourseRequest, Set<Section>> requiredSectionsForCourse = new Hashtable<CourseRequest, Set<Section>>();
        HashSet<FreeTimeRequest> requiredFreeTimes = new HashSet<FreeTimeRequest>();
        ArrayList<ClassAssignmentInterface> arrayList = new ArrayList<ClassAssignmentInterface>();
        ClassAssignmentInterface classAssignmentInterface = new ClassAssignmentInterface();
        arrayList.add(classAssignmentInterface);
        OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
        requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
        for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
            if (a == null || !a.isAssigned()) continue;
            requested.addSection(OnlineSectioningHelper.toProto(a));
        }
        action.addEnrollment(requested);
        Request selectedRequest = null;
        Section selectedSection = null;
        double selectedPenalty = 0.0;
        Enrollment[] enrollmentArray = new Enrollment[student.getRequests().size()];
        int idx = 0;
        for (Request r : student.getRequests()) {
            OnlineSectioningLog.Request.Builder rq = OnlineSectioningHelper.toProto(r);
            if (r instanceof CourseRequest) {
                CourseRequest cr = (CourseRequest)r;
                if (this.getRequest().areTimeConflictsAllowed() || this.getRequest().areSpaceConflictsAllowed() || this.getRequest().areLinkedConflictsAllowed()) {
                    for (Course course : cr.getCourses()) {
                        Object res22;
                        XCourse xc = server.getCourse(course.getId());
                        boolean time = this.getRequest().areTimeConflictsAllowed() && xc.areTimeConflictOverridesAllowed();
                        boolean space = this.getRequest().areSpaceConflictsAllowed() && xc.areSpaceConflictOverridesAllowed();
                        boolean linked = this.getRequest().areLinkedConflictsAllowed() && xc.areLinkedConflictOverridesAllowed();
                        boolean hasNeverIncludedReservation = false;
                        if (!server.getConfig().getPropertyBoolean("Reservations.NeverIncludedAllowOverride", false)) {
                            for (Object res22 : course.getOffering().getReservations()) {
                                if (!res22.neverIncluded()) continue;
                                hasNeverIncludedReservation = true;
                            }
                        }
                        if (!hasNeverIncludedReservation && (time || space || linked)) {
                            OnlineReservation dummy = new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), -100, space, 1, true, true, time, true, true);
                            dummy.setBreakLinkedSections(linked);
                            res22 = course.getOffering().getConfigs().iterator();
                            while (res22.hasNext()) {
                                Config g = (Config)res22.next();
                                dummy.addConfig(g);
                                for (Subpart subpart : g.getSubparts()) {
                                    for (Section x : subpart.getSections()) {
                                        dummy.addSection(x, false);
                                    }
                                }
                            }
                        }
                        if (!time && !space && !linked || !server.getConfig().getPropertyBoolean("Restrictions.AllowOverride", false) || !course.getOffering().hasRestrictions()) continue;
                        IndividualRestriction restriction = new IndividualRestriction(-3L, course.getOffering(), new Long[]{student.getId()});
                        res22 = course.getOffering().getConfigs().iterator();
                        while (res22.hasNext()) {
                            Config c = (Config)res22.next();
                            restriction.addConfig(c);
                        }
                    }
                }
                if (!this.getSelection().isFreeTime() && cr.getCourse(this.getSelection().getCourseId().longValue()) != null) {
                    Section section;
                    selectedRequest = r;
                    if (this.getSelection().getClassId() != null && (section = cr.getSection(this.getSelection().getClassId().longValue())) != null) {
                        selectedSection = section;
                    }
                }
                Iterator<OnlineSectioningLog.Time.Builder> preferredSections = new HashSet();
                HashSet<Section> requiredSections = new HashSet<Section>();
                for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                    if (a == null || a.isFreeTime() || cr.getCourse(a.getCourseId().longValue()) == null || a.getClassId() == null) continue;
                    Section section = cr.getSection(a.getClassId().longValue());
                    boolean hasIndividualReservation = false;
                    if (section != null && section.getLimit() == 0) {
                        for (Reservation res : cr.getReservations(cr.getCourse(a.getCourseId().longValue()))) {
                            Set sect;
                            if (!res.canAssignOverLimit() || (sect = res.getSections(section.getSubpart())) != null && !sect.contains(section)) continue;
                            hasIndividualReservation = true;
                        }
                    }
                    if (section == null || section.getLimit() == 0 && !hasIndividualReservation) {
                        classAssignmentInterface.addMessage((a.isSaved() ? "Enrolled class " : (a.isPinned() ? "Required class " : "Previously selected class ")) + a.getSubject() + " " + a.getCourseNbr() + " " + a.getSubpart() + " " + a.getSection() + " is no longer available.");
                        if (this.getSelection().getCourseId() != null && cr.getCourse(this.getSelection().getCourseId().longValue()) != null) continue;
                    }
                    selectedPenalty += model.getOverExpected((Assignment)assignment, enrollmentArray, idx, section, (Request)cr);
                    if (a.isPinned() && !this.getSelection().equals(a)) {
                        requiredSections.add(section);
                    }
                    ((HashSet)((Object)preferredSections)).add((OnlineSectioningLog.Time.Builder)section);
                    rq.addSection(OnlineSectioningHelper.toProto((SctAssignment)section, cr.getCourse(a.getCourseId().longValue())).setPreference(this.getSelection().equals(a) ? OnlineSectioningLog.Section.Preference.SELECTED : (a.isPinned() ? OnlineSectioningLog.Section.Preference.REQUIRED : OnlineSectioningLog.Section.Preference.PREFERRED)));
                }
                preferredSectionsForCourse.put(cr, preferredSections);
                requiredSectionsForCourse.put(cr, requiredSections);
                if (!((HashSet)((Object)preferredSections)).isEmpty()) {
                    Section section = (Section)((HashSet)((Object)preferredSections)).iterator().next();
                    enrollmentArray[idx] = new Enrollment((Request)cr, 0, section.getSubpart().getConfig(), preferredSections, (Assignment)assignment);
                }
            } else {
                FreeTimeRequest ft = (FreeTimeRequest)r;
                if (this.getSelection().isFreeTime() && ft.getTime() != null && ft.getTime().getStartSlot() == this.getSelection().getStart() && ft.getTime().getLength() == this.getSelection().getLength() && ft.getTime().getDayCode() == DayCode.toInt(DayCode.toDayCodes(this.getSelection().getDays()))) {
                    selectedRequest = r;
                    for (OnlineSectioningLog.Time.Builder ftb : rq.getFreeTimeBuilderList()) {
                        ftb.setPreference(OnlineSectioningLog.Section.Preference.SELECTED);
                    }
                } else {
                    for (ClassAssignmentInterface.ClassAssignment a : this.getAssignment()) {
                        if (a == null || !a.isFreeTime() || !a.isPinned() || ft.getTime() == null || ft.getTime().getStartSlot() != a.getStart() || ft.getTime().getLength() != a.getLength() || ft.getTime().getDayCode() != DayCode.toInt(DayCode.toDayCodes(a.getDays()))) continue;
                        requiredFreeTimes.add(ft);
                        for (OnlineSectioningLog.Time.Builder ftb : rq.getFreeTimeBuilderList()) {
                            ftb.setPreference(OnlineSectioningLog.Section.Preference.REQUIRED);
                        }
                    }
                }
            }
            ++idx;
            action.addRequest(rq);
        }
        long t2 = System.currentTimeMillis();
        if (selectedRequest == null) {
            return new ArrayList<ClassAssignmentInterface>();
        }
        Object suggestionBaB = null;
        boolean avoidOverExpected = server.getAcademicSession().isSectioningEnabled();
        if (avoidOverExpected && helper.getUser() != null && helper.getUser().hasType() && helper.getUser().getType() != OnlineSectioningLog.Entity.EntityType.STUDENT) {
            avoidOverExpected = false;
        }
        if ((override = ApplicationProperty.OnlineSchedulingAllowOverExpected.value()) != null) {
            avoidOverExpected = "false".equalsIgnoreCase(override);
        }
        double maxOverExpected = -1.0;
        if (avoidOverExpected && !(model.getOverExpectedCriterion() instanceof NeverOverExpected)) {
            long x0 = System.currentTimeMillis();
            MultiCriteriaBranchAndBoundSelection selection = new MultiCriteriaBranchAndBoundSelection(model.getProperties());
            selection.setModel(model);
            selection.setPreferredSections(preferredSectionsForCourse);
            selection.setRequiredSections(requiredSectionsForCourse);
            selection.setRequiredFreeTimes(requiredFreeTimes);
            selection.setTimeout(100);
            BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, student, (MultiCriteriaBranchAndBoundSelection.SelectionCriterion)new BestPenaltyCriterion(student, model));
            long x1 = System.currentTimeMillis();
            if (neighbour != null) {
                maxOverExpected = 0.0;
                for (int i = 0; i < neighbour.getAssignment().length; ++i) {
                    Enrollment enrollment = neighbour.getAssignment()[i];
                    if (enrollment == null || enrollment.getAssignments() == null || !enrollment.isCourseRequest()) continue;
                    for (Section section : enrollment.getSections()) {
                        maxOverExpected += model.getOverExpected((Assignment)assignment, neighbour.getAssignment(), i, section, enrollment.getRequest());
                    }
                }
                if (maxOverExpected < selectedPenalty) {
                    maxOverExpected = selectedPenalty;
                }
                helper.debug("Maximum number of over-expected sections limited to " + maxOverExpected + " (computed in " + (x1 - x0) + " ms).");
            }
        }
        SuggestionsFilter filter = null;
        if (this.getFilter() != null && !this.getFilter().isEmpty()) {
            filter = new SuggestionsFilter(this.getFilter(), server.getAcademicSession().getDatePatternFirstDate());
        }
        if (maxOverExpected >= 0.0) {
            model.addGlobalConstraint((GlobalConstraint)new MaxOverExpectedConstraint(maxOverExpected));
        }
        suggestionBaB = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSuggestions(model.getProperties(), student, (Assignment)assignment, requiredSectionsForCourse, requiredFreeTimes, preferredSectionsForCourse, selectedRequest, selectedSection, (SuggestionsBranchAndBound.SuggestionFilter)filter, maxOverExpected, server.getConfig().getPropertyBoolean("StudentWeights.PriorityWeighting", true)) : new SuggestionsBranchAndBound(model.getProperties(), student, (Assignment)assignment, requiredSectionsForCourse, requiredFreeTimes, preferredSectionsForCourse, selectedRequest, selectedSection, (SuggestionsBranchAndBound.SuggestionFilter)filter, maxOverExpected);
        helper.debug("Using " + (server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? "multi-criteria " : "") + (server.getConfig().getPropertyBoolean("StudentWeights.PriorityWeighting", true) ? "priority" : "equal") + " weighting model with " + server.getConfig().getPropertyInt("Suggestions.Timeout", 5000) + " ms time limit" + (String)(maxOverExpected < 0.0 ? "" : ", maximal over-expected of " + maxOverExpected) + " and maximal depth of " + server.getConfig().getPropertyInt("Suggestions.MaxDepth", 4) + ".");
        TreeSet suggestions = suggestionBaB.computeSuggestions();
        this.iValue = suggestions.isEmpty() ? 0.0 : -((SuggestionsBranchAndBound.Suggestion)suggestions.first()).getValue();
        long t3 = System.currentTimeMillis();
        helper.debug("  -- suggestion B&B took " + suggestionBaB.getTime() + "ms" + (suggestionBaB.isTimeoutReached() ? ", timeout reached" : ""));
        for (SuggestionsBranchAndBound.Suggestion suggestion : suggestions) {
            ClassAssignmentInterface ca = this.convert(server, (Assignment<Request, Enrollment>)assignment, suggestion.getEnrollments(), requiredSectionsForCourse, requiredFreeTimes, true, model.getStudentQuality(), enrolled);
            if (unavailabilities != null) {
                for (ClassAssignmentInterface.CourseAssignment courseAssignment : unavailabilities.getCourseAssignments()) {
                    ca.getCourseAssignments().add(0, courseAssignment);
                }
            }
            arrayList.add(ca);
            OnlineSectioningLog.Enrollment.Builder solution = OnlineSectioningLog.Enrollment.newBuilder();
            solution.setType(OnlineSectioningLog.Enrollment.EnrollmentType.COMPUTED);
            solution.setValue(-suggestion.getValue());
            for (Enrollment e : suggestion.getEnrollments()) {
                if (e == null || e.getAssignments() == null) continue;
                for (SctAssignment section : e.getAssignments()) {
                    solution.addSection(OnlineSectioningHelper.toProto(section, e));
                }
            }
            action.addEnrollment(solution);
        }
        if (suggestions.isEmpty() && selectedRequest != null && selectedRequest instanceof CourseRequest) {
            Object ov;
            TreeSet<Enrollment> overlap = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                @Override
                public int compare(Enrollment o1, Enrollment o2) {
                    return o1.getRequest().compareTo(o2.getRequest());
                }
            });
            Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
            CourseRequest request = (CourseRequest)selectedRequest;
            Course course = (Course)request.getCourses().get(0);
            List list = request.getAvaiableEnrollmentsSkipSameTime((Assignment)assignment);
            TreeSet<Object> overlapMessages = new TreeSet<Object>();
            for (Enrollment enrl : list) {
                Object x;
                for (Request q : enrl.getStudent().getRequests()) {
                    if (q.equals((Object)request) || (x = (Enrollment)assignment.getValue((Variable)q)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                    for (SctAssignment a : x.getAssignments()) {
                        if (!a.isOverlapping(enrl.getAssignments()) && !HardDistanceConflicts.inConflict((StudentQuality)model.getStudentQuality(), (SctAssignment)a, (Enrollment)enrl)) continue;
                        overlap.add((Enrollment)x);
                        if (!(x.getRequest() instanceof CourseRequest)) continue;
                        CourseRequest cr = (CourseRequest)x.getRequest();
                        TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                        if (ss == null) {
                            ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator((Assignment)assignment));
                            overlapingSections.put(cr, ss);
                        }
                        ss.add((Section)a);
                    }
                }
                block37: for (Unavailability unavailability : student.getUnavailabilities()) {
                    x = enrl.getAssignments().iterator();
                    while (x.hasNext()) {
                        SctAssignment section = (SctAssignment)x.next();
                        if (!HardDistanceConflicts.inConflict((StudentQuality)model.getStudentQuality(), (Section)((Section)section), (Unavailability)unavailability)) continue;
                        overlapMessages.add(unavailability.getCourseName() + " " + unavailability.getSectionName());
                        continue block37;
                    }
                }
            }
            block39: for (Unavailability unavailability : student.getUnavailabilities()) {
                for (Config config : course.getOffering().getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            if (section.getLimit() <= 0 || !unavailability.isOverlapping((SctAssignment)section)) continue;
                            overlapMessages.add(unavailability.getCourseName() + " " + unavailability.getSectionName());
                            continue block39;
                        }
                    }
                }
            }
            for (Enrollment q : overlap) {
                ov = null;
                if (q.getRequest() instanceof FreeTimeRequest) {
                    ov = OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest());
                } else {
                    CourseRequest cr = (CourseRequest)q.getRequest();
                    Course o = q.getCourse();
                    ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                    if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                        for (Section s : (TreeSet)overlapingSections.get(cr)) {
                            ov = (String)ov + " " + s.getSubpart().getName();
                        }
                    }
                }
                overlapMessages.add(ov);
            }
            if (!overlapMessages.isEmpty()) {
                Object overlapMessage = null;
                Iterator i = overlapMessages.iterator();
                while (i.hasNext()) {
                    ov = (String)i.next();
                    if (overlapMessage == null) {
                        overlapMessage = ov;
                        continue;
                    }
                    if (i.hasNext()) {
                        overlapMessage = (String)overlapMessage + MSG.conflictWithMiddle((String)ov);
                        continue;
                    }
                    overlapMessage = (String)overlapMessage + MSG.conflictWithLast((String)ov);
                }
                classAssignmentInterface.addMessage(MSG.suggestionsNoChoicesCourseIsConflicting(MSG.course(course.getSubjectArea(), course.getCourseNumber()), (String)overlapMessage));
            } else if (course.getLimit() == 0) {
                classAssignmentInterface.addMessage(MSG.suggestionsNoChoicesCourseIsFull(MSG.course(course.getSubjectArea(), course.getCourseNumber())));
            } else if (SectioningRequest.hasInconsistentRequirements(request, course.getId())) {
                classAssignmentInterface.addMessage(MSG.suggestionsNoChoicesDueToStudentPrefs(MSG.course(course.getSubjectArea(), course.getCourseNumber())));
            }
            if (student.hasMaxCredit()) {
                float assignedCredit = 0.0f;
                for (Request q : student.getRequests()) {
                    Enrollment e;
                    if (q.equals((Object)request) || (e = (Enrollment)q.getAssignment((Assignment)assignment)) == null) continue;
                    assignedCredit += e.getCredit();
                }
                Float minCred = null;
                for (Course c : request.getCourses()) {
                    if (!c.hasCreditValue() || minCred != null && !(minCred.floatValue() > c.getCreditValue().floatValue())) continue;
                    minCred = c.getCreditValue();
                }
                if (minCred != null && assignedCredit + minCred.floatValue() > student.getMaxCredit()) {
                    classAssignmentInterface.addMessage(MSG.conflictOverMaxCredit(student.getMaxCredit()));
                }
            }
        }
        long t4 = System.currentTimeMillis();
        helper.debug("Sectioning took " + (t4 - t0) + "ms (model " + (t1 - t0) + "ms, solver init " + (t2 - t1) + "ms, sectioning " + (t3 - t2) + "ms, conversion " + (t4 - t3) + "ms)");
        return arrayList;
    }

    @Override
    public String name() {
        return "suggestions";
    }

    public double value() {
        return this.iValue;
    }
}

