/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetInfo;
import org.unitime.timetable.onlinesectioning.custom.AdvisorCourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentHoldsCheckProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentPinsProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.custom.purdue.XEInterface;
import org.unitime.timetable.onlinesectioning.model.XAdvisorRequest;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRule;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.util.Formats;

public class SimplifiedCourseRequestsValidationProvider
implements CourseRequestsValidationProvider,
StudentHoldsCheckProvider,
AdvisorCourseRequestsValidationProvider,
StudentPinsProvider {
    private static Log sLog = LogFactory.getLog(SimplifiedCourseRequestsValidationProvider.class);
    private static StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = Localization.create(StudentSectioningConstants.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public SimplifiedCourseRequestsValidationProvider() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        Context cx = new Context();
        cx.getParameters().add("readTimeout", this.getSpecialRegistrationApiReadTimeout());
        this.iClient.setContext(cx);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getSpecialRegistrationApiReadTimeout() {
        return ApplicationProperties.getProperty("purdue.specreg.readTimeout", "60000");
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiSiteCheckEligibility() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkEligibility", this.getSpecialRegistrationApiSite() + "/checkEligibility");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected SpecialRegistrationInterface.ApiMode getSpecialRegistrationApiMode() {
        return SpecialRegistrationInterface.ApiMode.valueOf(ApplicationProperties.getProperty("purdue.specreg.mode.validation", "PREREG"));
    }

    protected String getBannerSite() {
        return ApplicationProperties.getProperty("banner.xe.site");
    }

    protected String getBannerUser(boolean admin) {
        String user;
        if (admin && (user = ApplicationProperties.getProperty("banner.xe.admin.user")) != null) {
            return user;
        }
        return ApplicationProperties.getProperty("banner.xe.user");
    }

    protected String getBannerPassword(boolean admin) {
        String pwd;
        if (admin && (pwd = ApplicationProperties.getProperty("banner.xe.admin.password")) != null) {
            return pwd;
        }
        return ApplicationProperties.getProperty("banner.xe.password");
    }

    protected String getAdminParameter() {
        return ApplicationProperties.getProperty("banner.xe.adminParameter", "systemIn");
    }

    protected String getBannerErrors() {
        return ApplicationProperties.getProperty("banner.xe.prereg.errors", "(Holds prevent registration\\.|Student Status prevents registration\\.)");
    }

    protected boolean isValidationEnabled(org.unitime.timetable.model.Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status == null || status.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected boolean isValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getPresentStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected boolean isBannerAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.admin", "false"));
    }

    protected boolean isPreregAdmin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("banner.xe.prereg.admin", "false"));
    }

    protected boolean isUseXE() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specReg.XEeligibility", "false"));
    }

    protected boolean isCheckForPin() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specReg.checkForPin", "true"));
    }

    protected boolean isWaitListNoAlts() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.waitListNoAlts", "false"));
    }

    protected boolean isAdvisedNoAlts() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.advisedNoAlts", "true"));
    }

    protected String getBannerId(org.unitime.timetable.model.Student student) {
        Object id = student.getExternalUniqueId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected String getBannerId(XStudentId student) {
        Object id = student.getExternalId();
        while (((String)id).length() < 9) {
            id = "0" + (String)id;
        }
        return id;
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    public boolean isDisableRegistrationWhenNotEligible() {
        return "true".equals(ApplicationProperties.getProperty("purdue.specreg.disableRegistrationWhenNotEligible", "true"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, org.unitime.timetable.model.Student student) throws SectioningException {
        if (student == null || !check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
            return;
        }
        if (!this.isValidationEnabled(student)) {
            return;
        }
        if (this.isUseXE()) {
            ClientResource resource = null;
            try {
                XStudent xs;
                boolean admin;
                String pin = helper.getPin();
                if ((pin == null || pin.isEmpty()) && student.hasReleasedPin()) {
                    pin = student.getPin();
                }
                AcademicSessionInfo session = server.getAcademicSession();
                String term = this.getBannerTerm(session);
                boolean manager = helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER;
                boolean bl = admin = manager && this.isBannerAdmin();
                if (helper.isDebugEnabled()) {
                    helper.debug("Checking eligility for " + student.getName("last-first-middle") + " (term: " + term + ", id:" + this.getBannerId(student) + (String)(admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
                }
                resource = new ClientResource(this.getBannerSite());
                resource.setNext((Uniform)this.iClient);
                resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(manager), this.getBannerPassword(manager));
                Gson gson = this.getGson(helper);
                XEInterface.RegisterResponse original = null;
                resource.addQueryParameter("term", term);
                resource.addQueryParameter("bannerId", this.getBannerId(student));
                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                if (admin || this.isPreregAdmin()) {
                    String param = this.getAdminParameter();
                    resource.addQueryParameter(param, "SB");
                    helper.getAction().addOptionBuilder().setKey(param).setValue("SB");
                } else if (pin != null && !pin.isEmpty()) {
                    resource.addQueryParameter("altPin", pin);
                    helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
                }
                long t0 = System.currentTimeMillis();
                try {
                    resource.get(MediaType.APPLICATION_JSON);
                }
                catch (ResourceException exception) {
                    helper.getAction().setApiException(exception.getMessage());
                    try {
                        XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                        XEInterface.Error error = response.getError();
                        if (error != null && error.message != null) {
                            throw new SectioningException(error.message);
                        }
                        if (error != null && error.description != null) {
                            throw new SectioningException(error.description);
                        }
                        if (error == null || error.errorMessage == null) throw exception;
                        throw new SectioningException(error.errorMessage);
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Throwable t) {
                        throw exception;
                    }
                }
                finally {
                    helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                }
                List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)current));
                if (current != null && !current.isEmpty()) {
                    original = (XEInterface.RegisterResponse)current.get(0);
                }
                if (original != null && helper.isDebugEnabled()) {
                    helper.debug("Current registration: " + gson.toJson((Object)original));
                }
                if (original != null && original.maxHours != null) {
                    check.setMaxCredit(original.maxHours);
                }
                String bannerErrors = this.getBannerErrors();
                Object error = null;
                if (original != null && original.failureReasons != null) {
                    for (String m : original.failureReasons) {
                        if (bannerErrors != null && !m.matches(bannerErrors)) continue;
                        if (error == null) {
                            error = m;
                            continue;
                        }
                        error = (String)error + (((String)error).endsWith(".") ? " " : ", ") + m;
                    }
                }
                if (error != null) {
                    if (this.isDisableRegistrationWhenNotEligible()) {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, helper.isAdmin());
                    }
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck((String)error));
                }
                if (student.getUniqueId() == null || original == null || original.maxHours == null || !(original.maxHours.floatValue() > 0.0f) || original.maxHours == student.getMaxCredit()) return;
                org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getUniqueId(), helper.getHibSession());
                dbStudent.setMaxCredit(original.maxHours);
                helper.getHibSession().merge((Object)dbStudent);
                helper.getHibSession().flush();
                if (server instanceof DatabaseServer || (xs = server.getStudent(student.getUniqueId())) == null) return;
                xs.setMaxCredit(original.maxHours);
                server.update(xs, false);
                return;
            }
            catch (SectioningException e) {
                helper.info("Banner eligibility failed: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.warn("Banner eligibility failed: " + e.getMessage(), e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
        ClientResource resource = null;
        try {
            XStudent xs;
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException((String)(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + String.valueOf((Object)eligibility.status) + ")." : eligibility.message));
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems != null) {
                Object m = null;
                for (SpecialRegistrationInterface.EligibilityProblem p : ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems) {
                    if (m == null) {
                        m = p.message;
                        continue;
                    }
                    m = (String)m + "\n" + p.message;
                }
                if (m != null) {
                    if (this.isDisableRegistrationWhenNotEligible()) {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, helper.isAdmin());
                    }
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck((String)m));
                }
            }
            String pin = null;
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN != null && !((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN.isEmpty() && !"NA".equals(((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN)) {
                pin = ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN;
            }
            Float maxCredit = null;
            if (eligibility.maxCredit != null && eligibility.maxCredit.floatValue() > 0.0f) {
                maxCredit = eligibility.maxCredit;
                check.setMaxCredit(eligibility.maxCredit);
            }
            if ((maxCredit == null || maxCredit.equals(student.getMaxCredit())) && (pin == null || pin.equals(student.getPin()))) return;
            org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getUniqueId(), helper.getHibSession());
            if (maxCredit != null) {
                dbStudent.setMaxCredit(maxCredit);
            }
            if (pin != null) {
                dbStudent.setPin(pin);
            }
            helper.getHibSession().merge((Object)dbStudent);
            helper.getHibSession().flush();
            if (server instanceof DatabaseServer || (xs = server.getStudent(student.getUniqueId())) == null) return;
            if (maxCredit != null) {
                xs.setMaxCredit(maxCredit);
            }
            if (pin != null) {
                xs.setPin(pin);
            }
            server.update(xs, false);
            return;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected List<CourseRequestInterface.RequestedCourse> getOverCreditRequests(CourseRequestInterface request, float maxCredit) {
        ArrayList<CourseRequestInterface.RequestedCourse> ret = new ArrayList<CourseRequestInterface.RequestedCourse>();
        float primary = 0.0f;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).hasCredit() || !((primary += r.getRequestedCourse(0).getCreditMin().floatValue()) > maxCredit)) continue;
            ret.add(r.getRequestedCourse(0));
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() <= 1) continue;
            float credit = r.getRequestedCourse(0).hasCredit() ? r.getRequestedCourse(0).getCreditMin().floatValue() : 0.0f;
            for (int i = 1; i < r.getRequestedCourse().size(); ++i) {
                float alt;
                float f = alt = r.getRequestedCourse(i).hasCredit() ? r.getRequestedCourse(i).getCreditMin().floatValue() : 0.0f;
                if (!(primary - credit + alt > maxCredit)) continue;
                ret.add(r.getRequestedCourse(i));
            }
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ArrayList<Float> credits = new ArrayList<Float>();
        float total = 0.0f;
        CourseRequestInterface.RequestedCourse last = null;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            Float credit = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue()) || !(total + (credit = rc.getCreditMin()).floatValue() > maxCredit)) continue;
                ret.add(rc);
            }
            if (credit != null) {
                credits.add(credit);
                total += credit.floatValue();
            }
            last = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        Collections.sort(credits);
        float low = credits.isEmpty() ? 0.0f : ((Float)credits.get(0)).floatValue();
        CourseRequestInterface.RequestedCourse first = null;
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || !(total + rc.getCreditMin().floatValue() - low > maxCredit)) continue;
                ret.add(rc);
                break;
            }
            if (first != null) continue;
            first = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ret.add(first != null ? first : last);
        return ret;
    }

    @Override
    public void check(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        XSchedulingRule rule;
        Float maxCredit;
        String minCreditLimitFilter;
        int count;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            return;
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer ORD_UNITIME = 0;
        HashSet<Long> advisorCoursesNoAlt = new HashSet<Long>();
        if (original.hasAdvisorRequests() && this.isAdvisedNoAlts()) {
            for (XAdvisorRequest ar : original.getAdvisorRequests()) {
                count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != ar.getPriority()) continue;
                    ++count;
                }
                if (count != true || ar.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(ar.getCourseId().getCourseId());
            }
        } else if (original.hasAdvisorRequests() && this.isWaitListNoAlts()) {
            for (XAdvisorRequest ar : original.getAdvisorRequests()) {
                if (!ar.isWaitListOrNoSub() || ar.isSubstitute()) continue;
                count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != ar.getPriority() || x.isSubstitute()) continue;
                    ++count;
                }
                if (count != 1 || ar.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(ar.getCourseId().getCourseId());
            }
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            CourseRequestInterface.RequestedCourse rc;
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly() || advisorCoursesNoAlt.contains(rc.getCourseId())) continue;
            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), ORD_UNITIME);
        }
        for (int i = 0; i < request.getCourses().size(); ++i) {
            CourseRequestInterface.Request r;
            r = request.getCourse(i);
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).isFreeTime()) continue;
            boolean hasCourse = false;
            for (int j = i + 1; j < request.getCourses().size(); ++j) {
                CourseRequestInterface.Request q = request.getCourse(j);
                if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).isCourse()) continue;
                hasCourse = true;
                break;
            }
            if (!hasCourse) continue;
            Object free = "";
            for (CourseRequestInterface.FreeTime freeTime : r.getRequestedCourse(0).getFreeTime()) {
                if (!((String)free).isEmpty()) {
                    free = (String)free + ", ";
                }
                free = (String)free + freeTime.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
            }
            request.addConfirmationMessage(0L, CONSTANTS.freePrefix() + (String)free, "FREE-TIME", ApplicationProperties.getProperty("purdue.specreg.messages.freeTimeHighPriority", "High priority free time"), ORD_UNITIME);
        }
        String minCreditLimit = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float minCredit = 0.0f;
        block8: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                if (!requestedCourse.hasCredit()) continue;
                minCredit += requestedCourse.getCreditMin().floatValue();
                continue block8;
            }
        }
        if (!request.isEmpty()) {
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
        }
        if (minCreditLimit != null && minCredit > 0.0f && minCredit < Float.parseFloat(minCreditLimit) && (original.getMaxCredit() == null || original.getMaxCredit().floatValue() > Float.parseFloat(minCreditLimit)) && ((minCreditLimitFilter = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if ((maxCredit = original.getMaxCredit()) == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
        }
        Set<Long> advisorWaitListedCourseIds = original.getAdvisorWaitListedCourseIds(server);
        if (maxCredit.floatValue() < request.getCredit(advisorWaitListedCourseIds)) {
            for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                request.addConfirmationMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds)))), null, ORD_UNITIME);
            }
            request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(advisorWaitListedCourseIds)))));
            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
        }
        if ((rule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission())) != null) {
            for (XRequest r : original.getRequests()) {
                if (!(r instanceof XCourseRequest)) continue;
                XCourseRequest cr = (XCourseRequest)r;
                for (XCourseId course : cr.getCourseIds()) {
                    if (rule.matchesCourse(course, helper.getHibSession())) continue;
                    request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-RULE", ApplicationProperties.getProperty("purdue.specreg.messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", rule.getRuleName()).replace("{course}", course.getCourseName()), ORD_UNITIME);
                    CourseRequestInterface.RequestPriority rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                    if (rp == null) continue;
                    rp.getRequest().getRequestedCourse(rp.getChoice()).setInactive(true);
                }
            }
        } else {
            String string = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
            if (string != null && !string.isEmpty()) {
                Object rp;
                InstructionalMethod configIm;
                InstructionalOffering offering;
                XCourseRequest cr;
                String im;
                String cn;
                if (new Query(string).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                    cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    im = server.getConfig().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
                    for (XRequest r : original.getRequests()) {
                        if (!(r instanceof XCourseRequest)) continue;
                        cr = (XCourseRequest)r;
                        for (XCourseId course : cr.getCourseIds()) {
                            if (cn != null && !cn.isEmpty() && !course.getCourseName().matches(cn)) {
                                request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                CourseRequestInterface.RequestPriority rp2 = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                if (rp2 == null) continue;
                                rp2.getRequest().getRequestedCourse(rp2.getChoice()).setInactive(true);
                                continue;
                            }
                            if (im == null) continue;
                            boolean hasMatchingConfig = false;
                            offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId(), helper.getHibSession());
                            if (offering != null) {
                                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                            rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                            if (rp == null) continue;
                            ((CourseRequestInterface.RequestPriority)rp).getRequest().getRequestedCourse(((CourseRequestInterface.RequestPriority)rp).getChoice()).setInactive(true);
                        }
                    }
                } else if (server.getConfig().getPropertyBoolean("Load.OnlineOnlyExclusiveCourses", false)) {
                    cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    im = server.getConfig().getProperty("Load.ResidentialInstructionalModeRegExp");
                    for (XRequest r : original.getRequests()) {
                        if (!(r instanceof XCourseRequest)) continue;
                        cr = (XCourseRequest)r;
                        for (XCourseId course : cr.getCourseIds()) {
                            if (cn != null && !cn.isEmpty() && course.getCourseName().matches(cn)) {
                                request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                                CourseRequestInterface.RequestPriority rp3 = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                                if (rp3 == null) continue;
                                rp3.getRequest().getRequestedCourse(rp3.getChoice()).setInactive(true);
                                continue;
                            }
                            if (im == null) continue;
                            boolean hasMatchingConfig = false;
                            offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(course.getOfferingId(), helper.getHibSession());
                            if (offering != null) {
                                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                            rp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(course.getCourseId(), course.getCourseName()));
                            if (rp == null) continue;
                            ((CourseRequestInterface.RequestPriority)rp).getRequest().getRequestedCourse(((CourseRequestInterface.RequestPriority)rp).getChoice()).setInactive(true);
                        }
                    }
                }
            }
        }
        if (!(server instanceof DatabaseServer)) {
            HashMap<XSection, XCourseId> hashMap = new HashMap<XSection, XCourseId>();
            for (XRequest r : original.getRequests()) {
                if (r.isAlternative() || !(r instanceof XCourseRequest)) continue;
                XCourseRequest cr = (XCourseRequest)r;
                for (XCourseId course : cr.getCourseIds()) {
                    XOffering offering = server.getOffering(course.getOfferingId());
                    if (offering != null && offering.getConfigs().size() == 1) {
                        for (XSubpart subpart : offering.getConfigs().get(0).getSubparts()) {
                            if (subpart.getSections().size() != 1) continue;
                            XSection section = subpart.getSections().get(0);
                            for (XSection other : hashMap.keySet()) {
                                if (!section.isOverlapping(offering.getDistributions(), other)) continue;
                                request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course.getCourseName()).replace("{other}", ((XCourseId)hashMap.get(other)).getCourseName()), ORD_UNITIME);
                            }
                            if (cr.getCourseIds().size() != 1) continue;
                            hashMap.put(section, course);
                        }
                    }
                    if (!offering.hasInconsistentRequirements(original, cr, course, server.getAcademicSession())) continue;
                    request.addConfirmationMessage(course.getCourseId(), course.getCourseName(), "STUD_PREF", ApplicationProperties.getProperty("purdue.specreg.messages.inconsistentStudPref", "Not available due to preferences selected.").replace("{course}", course.getCourseName()), ORD_UNITIME);
                }
            }
        }
    }

    @Override
    public boolean updateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        return false;
    }

    @Override
    public boolean revalidateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> conf;
        void var22_65;
        String minCreditLimitFilter;
        void var27_93;
        boolean bl;
        boolean bl2;
        int count;
        XStudent original;
        XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
        if (original == null) {
            throw new PageAccessException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
        }
        if (!this.isValidationEnabled(server, helper, original)) {
            return;
        }
        Integer CONF_NONE = null;
        Integer CONF_UNITIME = 0;
        HashSet<Long> coursesWithNotAlt = new HashSet<Long>();
        for (XRequest xRequest : original.getRequests()) {
            XCourseRequest xCourseRequest;
            if (!(xRequest instanceof XCourseRequest) || (xCourseRequest = (XCourseRequest)xRequest).getCourseIds().size() != 1 || xCourseRequest.isAlternative()) continue;
            coursesWithNotAlt.add(xCourseRequest.getCourseIds().get(0).getCourseId());
        }
        HashSet<Long> advisorCoursesNoAlt = new HashSet<Long>();
        if (original.hasAdvisorRequests() && this.isAdvisedNoAlts()) {
            for (XAdvisorRequest xAdvisorRequest : original.getAdvisorRequests()) {
                count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != xAdvisorRequest.getPriority()) continue;
                    ++count;
                }
                if (count != true || xAdvisorRequest.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(xAdvisorRequest.getCourseId().getCourseId());
            }
        } else if (original.hasAdvisorRequests() && this.isWaitListNoAlts()) {
            for (XAdvisorRequest xAdvisorRequest : original.getAdvisorRequests()) {
                if (!xAdvisorRequest.isWaitListOrNoSub() || xAdvisorRequest.isSubstitute()) continue;
                count = 0;
                for (XAdvisorRequest x : original.getAdvisorRequests()) {
                    if (x.getPriority() != xAdvisorRequest.getPriority() || x.isSubstitute()) continue;
                    ++count;
                }
                if (count != 1 || xAdvisorRequest.getCourseId() == null) continue;
                advisorCoursesNoAlt.add(xAdvisorRequest.getCourseId().getCourseId());
            }
        }
        boolean bl3 = false;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            CourseRequestInterface.RequestedCourse rc;
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly() || advisorCoursesNoAlt.contains(rc.getCourseId())) continue;
            response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), !coursesWithNotAlt.contains(rc.getCourseId()) ? CONF_UNITIME : CONF_NONE);
            if (coursesWithNotAlt.contains(rc.getCourseId())) continue;
            bl2 = true;
        }
        boolean bl4 = false;
        boolean questionInconStuPref = false;
        if (!(server instanceof DatabaseServer)) {
            CourseRequest cr;
            OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
            model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
            boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
            AssignmentMap assignment = new AssignmentMap();
            Student student = new Student(request.getStudentId().longValue());
            student.setExternalId(original.getExternalId());
            student.setName(original.getName());
            student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
            student.setAllowDisabled(original.isAllowDisabled());
            student.setClassFirstDate(original.getClassStartDate());
            student.setClassLastDate(original.getClassEndDate());
            student.setBackToBackPreference(original.getBackToBackPreference());
            student.setModalityPreference(original.getModalityPreference());
            HashMap classTable = new HashMap();
            HashSet<XDistribution> distributions = new HashSet<XDistribution>();
            boolean hasAssignment = false;
            for (XRequest reqest : original.getRequests()) {
                if (!(reqest instanceof XCourseRequest) || ((XCourseRequest)reqest).getEnrollment() == null) continue;
                hasAssignment = true;
                break;
            }
            for (CourseRequestInterface.Request c : request.getCourses()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, false, false, classTable, distributions, hasAssignment, true, helper);
            }
            for (CourseRequestInterface.Request c : request.getAlternatives()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, true, false, classTable, distributions, hasAssignment, true, helper);
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkUnavailabilitiesFromOtherSessions", "false"))) {
                if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessions", false)) {
                    GetInfo.fillInUnavailabilitiesFromOtherSessions(student, server, helper);
                } else if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsUsingDatabase", false)) {
                    GetInfo.fillInUnavailabilitiesFromOtherSessionsUsingDatabase(student, server, helper);
                }
            }
            model.addStudent(student);
            model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
            for (XDistribution link : distributions) {
                if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
                ArrayList<Section> arrayList = new ArrayList<Section>();
                for (Long sectionId : link.getSectionIds()) {
                    Section x = (Section)classTable.get(sectionId);
                    if (x == null) continue;
                    arrayList.add(x);
                }
                if (arrayList.size() < 2) continue;
                model.addLinkedSections(linkedClassesMustBeUsed, arrayList);
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.dummyReservation", "false"))) {
                for (Request r : student.getRequests()) {
                    if (!(r instanceof CourseRequest)) continue;
                    CourseRequest courseRequest = (CourseRequest)r;
                    for (Object course : courseRequest.getCourses()) {
                        new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), 5000, true, 1, true, true, true, true, true);
                    }
                }
            }
            HashMap<Section, Course> singleSections = new HashMap<Section, Course>();
            for (Request request2 : student.getRequests()) {
                if (request2.isAlternative() || !(request2 instanceof CourseRequest)) continue;
                cr = (CourseRequest)request2;
                for (Course course : cr.getCourses()) {
                    if (course.getOffering().getConfigs().size() != 1) continue;
                    for (Subpart subpart : ((Config)course.getOffering().getConfigs().get(0)).getSubparts()) {
                        if (subpart.getSections().size() != 1) continue;
                        Section section = (Section)subpart.getSections().get(0);
                        for (Section other : singleSections.keySet()) {
                            if (!section.isOverlapping((SctAssignment)other)) continue;
                            boolean confirm = (original.getRequestForCourse(course.getId()) == null || original.getRequestForCourse(((Course)singleSections.get(other)).getId()) == null) && cr.getCourses().size() == 1;
                            response.addMessage(course.getId(), course.getName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course.getName()).replace("{other}", ((Course)singleSections.get(other)).getName()), confirm ? CONF_UNITIME : CONF_NONE);
                            if (!confirm) continue;
                            bl = true;
                        }
                        if (cr.getCourses().size() != 1) continue;
                        singleSections.put(section, course);
                    }
                }
            }
            for (Request request3 : student.getRequests()) {
                if (!(request3 instanceof CourseRequest)) continue;
                cr = (CourseRequest)request3;
                for (Course course : cr.getCourses()) {
                    if (!SectioningRequest.hasInconsistentRequirements(cr, course.getId())) continue;
                    boolean confirm = original.getRequestForCourse(course.getId()) == null;
                    response.addMessage(course.getId(), course.getName(), "STUD_PREF", ApplicationProperties.getProperty("purdue.specreg.messages.inconsistentStudPref", "Not available due to preferences selected.").replace("{course}", course.getName()), confirm ? CONF_UNITIME : CONF_NONE);
                    if (!confirm) continue;
                    questionInconStuPref = true;
                }
            }
        }
        boolean questionDropCritical = false;
        boolean dropImportant = false;
        boolean dropVital = false;
        boolean dropCritical = false;
        for (XRequest r : original.getRequests()) {
            XCourseRequest cr;
            if (!(r instanceof XCourseRequest) || !(cr = (XCourseRequest)r).isCritical() || cr.isAlternative() || cr.getCourseIds().isEmpty()) continue;
            boolean hasCourse = false;
            for (XCourseId xCourseId : cr.getCourseIds()) {
                if (request.getRequestPriority(new CourseRequestInterface.RequestedCourse(xCourseId.getCourseId(), xCourseId.getCourseName())) == null) continue;
                hasCourse = true;
                break;
            }
            if (hasCourse) continue;
            XCourseId course = cr.getCourseIds().get(0);
            if (cr.getCritical() == 2) {
                response.addMessage(course.getCourseId(), course.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseDropCrit", "Important course has been removed.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                dropImportant = true;
            } else if (cr.getCritical() == 3) {
                response.addMessage(course.getCourseId(), course.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseDropCrit", "Vital course has been removed.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                dropVital = true;
            } else {
                response.addMessage(course.getCourseId(), course.getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseDropCrit", "Critical course has been removed.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                dropCritical = true;
            }
            questionDropCritical = true;
        }
        boolean questionMissingAdvisorCritical = false;
        boolean missCritical = false;
        boolean missImportant = false;
        boolean missVital = false;
        CourseDemand.Critical advCritical = CourseDemand.Critical.fromText(ApplicationProperty.AdvisorCourseRequestsAllowCritical.valueOfSession(server.getAcademicSession().getUniqueId()));
        if (original.hasAdvisorRequests()) {
            for (XAdvisorRequest ar : original.getAdvisorRequests()) {
                CourseRequestInterface.RequestPriority arp;
                if (ar.getAlternative() != 0 || ar.isSubstitute() || !ar.isCritical() || !ar.hasCourseId() || (arp = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(ar.getCourseId().getCourseId(), ar.getCourseId().getCourseName()))) != null && !arp.isAlternative()) continue;
                boolean hasAlt = false;
                for (XAdvisorRequest xAdvisorRequest : original.getAdvisorRequests()) {
                    CourseRequestInterface.RequestPriority requestPriority;
                    if (xAdvisorRequest.getPriority() != ar.getPriority() || !xAdvisorRequest.hasCourseId() || xAdvisorRequest.isSubstitute() || !xAdvisorRequest.isCritical() || ar.getAlternative() == 0 || (requestPriority = request.getRequestPriority(new CourseRequestInterface.RequestedCourse(xAdvisorRequest.getCourseId().getCourseId(), xAdvisorRequest.getCourseId().getCourseName()))) == null || requestPriority.isAlternative()) continue;
                    hasAlt = true;
                    break;
                }
                if (hasAlt) continue;
                if (advCritical == CourseDemand.Critical.IMPORTANT || ar.getCritical() == 2) {
                    response.addMessage(ar.getCourseId().getCourseId(), ar.getCourseId().getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseMissingAdvisedCritical", "Missing important course that has been recommended by the advisor.").replace("{course}", ar.getCourseId().getCourseName()), CONF_UNITIME);
                    missImportant = true;
                } else if (advCritical == CourseDemand.Critical.VITAL || ar.getCritical() == 3) {
                    response.addMessage(ar.getCourseId().getCourseId(), ar.getCourseId().getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseMissingAdvisedCritical", "Missing vital course that has been recommended by the advisor.").replace("{course}", ar.getCourseId().getCourseName()), CONF_UNITIME);
                    missVital = true;
                } else {
                    response.addMessage(ar.getCourseId().getCourseId(), ar.getCourseId().getCourseName(), "DROP_CRIT", ApplicationProperties.getProperty("purdue.specreg.messages.courseMissingAdvisedCritical", "Missing critical course that has been recommended by the advisor.").replace("{course}", ar.getCourseId().getCourseName()), CONF_UNITIME);
                    missCritical = true;
                }
                questionMissingAdvisorCritical = true;
            }
        }
        boolean bl5 = false;
        XSchedulingRule rule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission());
        boolean onlineOnly = false;
        if (rule != null) {
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse requestedCourse : r.getRequestedCourse()) {
                    CourseOffering co;
                    if (requestedCourse.getCourseId() == null || (co = (CourseOffering)CourseOfferingDAO.getInstance().get(requestedCourse.getCourseId(), helper.getHibSession())) == null || rule.matchesCourse(co)) continue;
                    boolean confirm = original.getRequestForCourse(requestedCourse.getCourseId()) == null;
                    response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NOT-RULE", ApplicationProperties.getProperty("purdue.specreg.messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", rule.getRuleName()).replace("{course}", requestedCourse.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                    if (!confirm) continue;
                    boolean bl6 = true;
                }
            }
        } else {
            String filter = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
            if (filter != null && !filter.isEmpty()) {
                InstructionalMethod configIm;
                CourseOffering co;
                boolean hasMatchingConfig;
                boolean confirm;
                if (new Query(filter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                    onlineOnly = true;
                    String cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    String string = server.getConfig().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
                    for (CourseRequestInterface.Request r : request.getCourses()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            boolean bl7;
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && !course.getCourseName().matches(cn)) {
                                confirm = original.getRequestForCourse(course.getCourseId()) == null;
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                                if (!confirm) continue;
                                bl7 = true;
                                continue;
                            }
                            if (string == null) continue;
                            hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (string.isEmpty()) {
                                        if (config.getInstructionalMethod() != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            boolean confirm2 = original.getRequestForCourse(course.getCourseId()) == null;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), confirm2 ? CONF_UNITIME : CONF_NONE);
                            if (!confirm2) continue;
                            bl7 = true;
                        }
                    }
                    for (CourseRequestInterface.Request r : request.getAlternatives()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            boolean bl8;
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && !course.getCourseName().matches(cn)) {
                                confirm = original.getRequestForCourse(course.getCourseId()) == null;
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                                if (!confirm) continue;
                                bl8 = true;
                                continue;
                            }
                            if (string == null) continue;
                            hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (string.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            boolean confirm3 = original.getRequestForCourse(course.getCourseId()) == null;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), confirm3 ? CONF_UNITIME : CONF_NONE);
                            if (!confirm3) continue;
                            bl8 = true;
                        }
                    }
                } else if (server.getConfig().getPropertyBoolean("Load.OnlineOnlyExclusiveCourses", false)) {
                    String cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    String string = server.getConfig().getProperty("Load.ResidentialInstructionalModeRegExp");
                    for (CourseRequestInterface.Request r : request.getCourses()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            boolean bl9;
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && course.getCourseName().matches(cn)) {
                                confirm = original.getRequestForCourse(course.getCourseId()) == null;
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                                if (!confirm) continue;
                                bl9 = true;
                                continue;
                            }
                            if (string == null) continue;
                            hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (string.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            boolean confirm4 = original.getRequestForCourse(course.getCourseId()) == null;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), confirm4 ? CONF_UNITIME : CONF_NONE);
                            if (!confirm4) continue;
                            bl9 = true;
                        }
                    }
                    for (CourseRequestInterface.Request r : request.getAlternatives()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            boolean bl10;
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && course.getCourseName().matches(cn)) {
                                confirm = original.getRequestForCourse(course.getCourseId()) == null;
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), confirm ? CONF_UNITIME : CONF_NONE);
                                if (!confirm) continue;
                                bl10 = true;
                                continue;
                            }
                            if (string == null) continue;
                            hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (string.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(string)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            boolean confirm5 = original.getRequestForCourse(course.getCourseId()) == null;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), confirm5 ? CONF_UNITIME : CONF_NONE);
                            if (!confirm5) continue;
                            bl10 = true;
                        }
                    }
                }
            }
        }
        boolean questionFreeTime = false;
        for (int i = 0; i < request.getCourses().size(); ++i) {
            boolean bl11;
            CourseRequestInterface.Request request4 = request.getCourse(i);
            if (!request4.hasRequestedCourse() || !request4.getRequestedCourse(0).isFreeTime()) continue;
            boolean bl12 = false;
            for (int j = i + 1; j < request.getCourses().size(); ++j) {
                CourseRequestInterface.Request q = request.getCourse(j);
                if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).isCourse()) continue;
                bl11 = true;
            }
            Object free = "";
            boolean confirm = false;
            block39: for (CourseRequestInterface.FreeTime ft : request4.getRequestedCourse(0).getFreeTime()) {
                if (!((String)free).isEmpty()) {
                    free = (String)free + ", ";
                }
                free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                if (confirm) continue;
                XFreeTimeRequest ftr = original.getRequestForFreeTime(ft);
                if (ftr == null) {
                    confirm = true;
                    continue;
                }
                if (!bl11) continue;
                for (int j = i + 1; j < request.getCourses().size(); ++j) {
                    XCourseRequest cr;
                    CourseRequestInterface.Request q = request.getCourse(j);
                    if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).isCourse() || (cr = original.getRequestForCourse(q.getRequestedCourse(0).getCourseId())) != null && cr.getPriority() >= ftr.getPriority()) continue;
                    confirm = true;
                    continue block39;
                }
            }
            if (bl11) {
                response.addMessage(0L, CONSTANTS.freePrefix() + (String)free, "FREE-TIME", ApplicationProperties.getProperty("purdue.specreg.messages.freeTimeHighPriority", "High priority free time"), confirm ? CONF_UNITIME : CONF_NONE);
            }
            if (!confirm) continue;
            questionFreeTime = true;
        }
        String creditError = null;
        Float f = original.getMaxCredit();
        if (f == null) {
            Float f2 = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
        }
        Set<Long> set = original.getAdvisorWaitListedCourseIds(server);
        if (var27_93 != null && request.getCredit(set) > var27_93.floatValue()) {
            for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, var27_93.floatValue())) {
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format((Number)var27_93)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(set)))), CONF_NONE);
            }
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format((Number)var27_93)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(set)))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
            creditError = ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou may not be able to get a full schedule.").replace("{max}", sCreditFormat.format((Number)var27_93)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(set))));
        }
        String minCreditLimit = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float minCredit = 0.0f;
        block42: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                minCredit += rc.getCreditMin().floatValue();
                continue block42;
            }
        }
        if (creditError == null && minCreditLimit != null && minCredit < Float.parseFloat(minCreditLimit) && (var27_93 == null || var27_93.floatValue() > Float.parseFloat(minCreditLimit)) && ((minCreditLimitFilter = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
            creditError = ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit)));
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if (response.getConfirms().contains(CONF_UNITIME)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.unitimeProblemsFound", "The following issues have been detected:"), CONF_UNITIME, -1);
            response.addConfirmation("", CONF_UNITIME, 1);
        }
        int line = 2;
        if (creditError != null) {
            response.addConfirmation(creditError, CONF_UNITIME, line++);
        }
        if (bl2) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.noAlternatives", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no alternatives provided. You may not be able to get a full schedule because you did not provide an alternative course."), CONF_UNITIME, line++);
        }
        if (bl) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.timeConflicts", (line > 2 ? "\n" : "") + "Two or more single section courses are conflicting with each other. You will likely not be able to get the conflicting course, so please provide an alternative course if possible."), CONF_UNITIME, line++);
        }
        if (questionInconStuPref) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.inconsistentStudPref", (line > 2 ? "\n" : "") + "One or more courses are not available due to the selected preferences."), CONF_UNITIME, line++);
        }
        if (questionDropCritical) {
            if (dropVital && !dropCritical && !dropImportant) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (line > 2 ? "\n" : "") + "One or more vital courses have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (dropImportant && !dropVital && !dropCritical) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (line > 2 ? "\n" : "") + "One or more important courses have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (advCritical != CourseDemand.Critical.NORMAL) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (line > 2 ? "\n" : "") + "One or more critical courses have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.dropCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked as critical in your degree plan have been removed. This may prohibit progress towards degree. Please consult with your academic advisor."), CONF_UNITIME, line++);
            }
        }
        if (questionMissingAdvisorCritical) {
            if (advCritical == CourseDemand.Critical.IMPORTANT || missImportant && !missCritical && !missVital) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked by your advisor as important have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (advCritical == CourseDemand.Critical.VITAL || missVital && !missCritical && !missImportant) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked by your advisor as vital have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            } else if (advCritical == CourseDemand.Critical.CRITICAL) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked by your advisor as critical have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.missingAdvisedCritical", (line > 2 ? "\n" : "") + "One or more courses that are marked as critical in your degree plan and that have been listed by your advisor have not been requested. This may prohibit progress towards degree. Please see you advisor course requests and/or consult with your academic advisor."), CONF_UNITIME, line++);
            }
        }
        if (var22_65 != false) {
            if (rule != null) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.ruleNotMet", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no {rule} option at the moment. You may not be able to get a full schedule because becasue you are not allowed to take these courses.".replace("{rule}", rule.getRuleName())), CONF_UNITIME, line++);
            } else if (onlineOnly) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.onlineOnlyNotMet", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no online-only option at the moment. You may not be able to get a full schedule because becasue you are not allowed to take these courses."), CONF_UNITIME, line++);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.residentialNotMet", (line > 2 ? "\n" : "") + "One or more of the newly requested courses have no residential option at the moment. You may not be able to get a full schedule because becasue you are not allowed to take these courses."), CONF_UNITIME, line++);
            }
        }
        if (questionFreeTime) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.freeTimeRequested", (line > 2 ? "\n" : "") + "Free time requests will be considered as time blocks during the pre-registration process. When possible, classes should be avoided during free time. However, if a free time request is placed higher than a course, the course cannot be attended during free time and you may not receive a full schedule."), CONF_UNITIME, line++);
        }
        if (line > 2) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.confirmation", "\nDo you want to proceed?"), CONF_UNITIME, line++);
        }
        if ((conf = response.getConfirms()).contains(CONF_UNITIME)) {
            response.setConfirmation(CONF_UNITIME, ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeDialogName", "Warning Confirmations"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButton", "Accept & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButton", "Cancel Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButtonTitle", "Accept the above warning(s) and submit the Course Requests"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButtonTitle", "Go back to editing your Course Requests"));
        }
    }

    @Override
    public void submit(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
    }

    @Override
    public Collection<Long> updateStudents(OnlineSectioningServer server, OnlineSectioningHelper helper, List<org.unitime.timetable.model.Student> students) throws SectioningException {
        return null;
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getStudentHoldError(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) throws SectioningException {
        if (this.isUseXE()) {
            ClientResource resource = null;
            try {
                boolean admin;
                String pin = helper.getPin();
                if ((pin == null || pin.isEmpty()) && student instanceof XStudent && ((XStudent)student).hasReleasedPin()) {
                    pin = ((XStudent)student).getPin();
                }
                AcademicSessionInfo session = server.getAcademicSession();
                String term = this.getBannerTerm(session);
                boolean manager = helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER;
                boolean bl = admin = manager && this.isBannerAdmin();
                if (helper.isDebugEnabled()) {
                    helper.debug("Checking eligility for " + student.getName() + " (term: " + term + ", id:" + this.getBannerId(student) + (String)(admin ? ", admin" : (pin != null ? ", pin:" + pin : "")) + ")");
                }
                resource = new ClientResource(this.getBannerSite());
                resource.setNext((Uniform)this.iClient);
                resource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getBannerUser(manager), this.getBannerPassword(manager));
                Gson gson = this.getGson(helper);
                XEInterface.RegisterResponse original = null;
                resource.addQueryParameter("term", term);
                resource.addQueryParameter("bannerId", this.getBannerId(student));
                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                helper.getAction().addOptionBuilder().setKey("bannerId").setValue(this.getBannerId(student));
                if (admin || this.isPreregAdmin()) {
                    String param = this.getAdminParameter();
                    resource.addQueryParameter(param, "SB");
                    helper.getAction().addOptionBuilder().setKey(param).setValue("SB");
                } else if (pin != null && !pin.isEmpty()) {
                    resource.addQueryParameter("altPin", pin);
                    helper.getAction().addOptionBuilder().setKey("pin").setValue(pin);
                }
                long t0 = System.currentTimeMillis();
                try {
                    resource.get(MediaType.APPLICATION_JSON);
                }
                catch (ResourceException exception) {
                    helper.getAction().setApiException(exception.getMessage());
                    try {
                        XEInterface.ErrorResponse response = new GsonRepresentation<XEInterface.ErrorResponse>(resource.getResponseEntity(), XEInterface.ErrorResponse.class).getObject();
                        helper.getAction().addOptionBuilder().setKey("exception").setValue(gson.toJson((Object)response));
                        XEInterface.Error error = response.getError();
                        if (error != null && error.message != null) {
                            throw new SectioningException(error.message);
                        }
                        if (error != null && error.description != null) {
                            throw new SectioningException(error.description);
                        }
                        if (error != null && error.errorMessage != null) {
                            throw new SectioningException(error.errorMessage);
                        }
                        throw exception;
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Throwable t) {
                        throw exception;
                    }
                }
                finally {
                    if (!helper.getAction().hasApiGetTime()) {
                        helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                    }
                }
                List current = (List)new GsonRepresentation(resource.getResponseEntity(), XEInterface.RegisterResponse.TYPE_LIST).getObject();
                helper.getAction().addOptionBuilder().setKey("holds-response").setValue(gson.toJson((Object)current));
                if (current != null && !current.isEmpty()) {
                    original = (XEInterface.RegisterResponse)current.get(0);
                }
                if (original != null && helper.isDebugEnabled()) {
                    helper.debug("Current registration: " + gson.toJson((Object)original));
                }
                String bannerErrors = this.getBannerErrors();
                Object error = null;
                if (original != null && original.failureReasons != null) {
                    for (String m : original.failureReasons) {
                        if (bannerErrors != null && !m.matches(bannerErrors)) continue;
                        if (error == null) {
                            error = m;
                            continue;
                        }
                        error = error + (((String)error).endsWith(".") ? " " : ", ") + m;
                    }
                }
                Iterator<String> iterator = error;
                return iterator;
            }
            catch (SectioningException e) {
                helper.info("Banner eligibility failed: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.warn("Banner eligibility failed: " + e.getMessage(), e);
                throw new SectioningException(e.getMessage());
            }
            finally {
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
            }
        }
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            if (!helper.getAction().hasApiGetTime()) {
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("holds-response").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException((String)(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + String.valueOf((Object)eligibility.status) + ")." : eligibility.message));
            }
            if (this.isCheckForPin() && eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN != null && !((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN.isEmpty() && !"NA".equals(((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN)) {
                helper.getAction().addOptionBuilder().setKey("PIN").setValue(((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN);
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems != null) {
                Object m = null;
                for (SpecialRegistrationInterface.EligibilityProblem p : ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).eligibilityProblems) {
                    if (m == null) {
                        m = p.message;
                        continue;
                    }
                    m = (String)m + "\n" + p.message;
                }
                Iterator<SpecialRegistrationInterface.EligibilityProblem> iterator = m;
                return iterator;
            }
            String string = null;
            return string;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }

    protected boolean isAdvisorValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, String status) {
        if (status == null) {
            status = student.getStatus();
        } else if (status.isEmpty()) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getPresentStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.reqval) || dbStatus.hasOption(StudentSectioningStatus.Option.specreg);
    }

    @Override
    public void validateAdvisorRecommendations(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.AdvisingStudentDetails details, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> conf;
        String minCreditLimitFilter;
        boolean bl;
        XStudent original;
        XStudent xStudent = original = details.getStudentId() == null ? null : server.getStudent(details.getStudentId());
        if (original == null) {
            throw new PageAccessException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
        }
        if (!this.isAdvisorValidationEnabled(server, helper, original, details.getStatus() == null ? null : details.getStatus().getReference())) {
            return;
        }
        CourseRequestInterface request = details.getRequest();
        Integer CONF_UNITIME = 0;
        HashSet<Long> courseIds = new HashSet<Long>();
        for (CourseRequestInterface.Request request2 : request.getCourses()) {
            if (!request2.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : request2.getRequestedCourse()) {
                if (!rc.hasCourseId() || courseIds.add(rc.getCourseId())) continue;
                response.addError(rc.getCourseId(), rc.getCourseName(), "DUPL", ApplicationProperties.getProperty("purdue.specreg.messages.duplicateCourse", "Course {course} used multiple times.").replace("{course}", rc.getCourseName()));
                if (response.hasErrorMessage()) continue;
                response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.duplicateCourse", "Course {course} used multiple times.").replace("{course}", rc.getCourseName()));
            }
        }
        boolean questionNoAlt = false;
        if (!this.isAdvisedNoAlts()) {
            for (CourseRequestInterface.Request r : request.getCourses()) {
                CourseRequestInterface.RequestedCourse rc;
                if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (r.isWaitList() || r.isNoSub()) && this.isWaitListNoAlts() || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly()) continue;
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), CONF_UNITIME);
                questionNoAlt = true;
            }
        }
        boolean bl2 = false;
        boolean questionInconStuPref = false;
        if (!(server instanceof DatabaseServer)) {
            CourseRequest cr;
            OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
            model.setDayOfWeekOffset(server.getAcademicSession().getDayOfWeekOffset());
            boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
            AssignmentMap assignment = new AssignmentMap();
            Student student = new Student(request.getStudentId().longValue());
            student.setExternalId(original.getExternalId());
            student.setName(original.getName());
            student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
            student.setAllowDisabled(original.isAllowDisabled());
            student.setClassFirstDate(original.getClassStartDate());
            student.setClassLastDate(original.getClassEndDate());
            student.setBackToBackPreference(original.getBackToBackPreference());
            student.setModalityPreference(original.getModalityPreference());
            HashMap<Long, Section> classTable = new HashMap<Long, Section>();
            HashSet distributions = new HashSet();
            boolean hasAssignment = false;
            for (XRequest reqest : original.getRequests()) {
                if (!(reqest instanceof XCourseRequest) || ((XCourseRequest)reqest).getEnrollment() == null) continue;
                hasAssignment = true;
                break;
            }
            for (CourseRequestInterface.Request c : request.getCourses()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, false, false, classTable, distributions, hasAssignment, true, helper);
            }
            for (CourseRequestInterface.Request c : request.getAlternatives()) {
                FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, c, true, false, classTable, distributions, hasAssignment, true, helper);
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.checkUnavailabilitiesFromOtherSessions", "false"))) {
                if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessions", false)) {
                    GetInfo.fillInUnavailabilitiesFromOtherSessions(student, server, helper);
                } else if (server.getConfig().getPropertyBoolean("General.CheckUnavailabilitiesFromOtherSessionsUsingDatabase", false)) {
                    GetInfo.fillInUnavailabilitiesFromOtherSessionsUsingDatabase(student, server, helper);
                }
            }
            model.addStudent(student);
            model.setStudentQuality(new StudentQuality(server.getDistanceMetric(), model.getProperties()));
            Iterator<Serializable> iterator = distributions.iterator();
            while (iterator.hasNext()) {
                XDistribution link = (XDistribution)iterator.next();
                if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
                ArrayList<Section> sections = new ArrayList<Section>();
                for (Long sectionId : link.getSectionIds()) {
                    Section x = (Section)classTable.get(sectionId);
                    if (x == null) continue;
                    sections.add(x);
                }
                if (sections.size() < 2) continue;
                model.addLinkedSections(linkedClassesMustBeUsed, sections);
            }
            if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.dummyReservation", "false"))) {
                for (Request r : student.getRequests()) {
                    if (!(r instanceof CourseRequest)) continue;
                    CourseRequest cr2 = (CourseRequest)r;
                    for (Object course : cr2.getCourses()) {
                        new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), 5000, true, 1, true, true, true, true, true);
                    }
                }
            }
            HashMap<Section, Course> singleSections = new HashMap<Section, Course>();
            for (CourseRequestInterface.Request r : student.getRequests()) {
                if (r.isAlternative() || !(r instanceof CourseRequest)) continue;
                cr = (CourseRequest)r;
                for (Course course : cr.getCourses()) {
                    if (course.getOffering().getConfigs().size() != 1) continue;
                    for (Subpart subpart : ((Config)course.getOffering().getConfigs().get(0)).getSubparts()) {
                        if (subpart.getSections().size() != 1) continue;
                        Section section = (Section)subpart.getSections().get(0);
                        for (Section other : singleSections.keySet()) {
                            if (!section.isOverlapping((SctAssignment)other)) continue;
                            response.addMessage(course.getId(), course.getName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course.getName()).replace("{other}", ((Course)singleSections.get(other)).getName()), CONF_UNITIME);
                            bl = true;
                        }
                        if (cr.getCourses().size() != 1) continue;
                        singleSections.put(section, course);
                    }
                }
            }
            for (CourseRequestInterface.Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                cr = (CourseRequest)r;
                for (Course course : cr.getCourses()) {
                    if (!SectioningRequest.hasInconsistentRequirements(cr, course.getId())) continue;
                    response.addMessage(course.getId(), course.getName(), "STUD_PREF", ApplicationProperties.getProperty("purdue.specreg.messages.inconsistentStudPref", "Not available due to preferences selected.").replace("{course}", course.getName()), CONF_UNITIME);
                    questionInconStuPref = true;
                }
            }
        }
        boolean questionRestrictionsNotMet = false;
        XSchedulingRule rule = server.getSchedulingRule(original, StudentSchedulingRule.Mode.Online, helper.hasAvisorPermission(), helper.hasAdminPermission());
        boolean onlineOnly = false;
        if (rule != null) {
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                    CourseOffering co;
                    if (course.getCourseId() == null || (co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession())) == null || rule.matchesCourse(co)) continue;
                    response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RULE", ApplicationProperties.getProperty("purdue.specreg.messages.notMatchingRuleCourse", "No {rule} option.").replace("{rule}", rule.getRuleName()).replace("{course}", course.getCourseName()), CONF_UNITIME);
                    questionRestrictionsNotMet = true;
                }
            }
        } else {
            String filter = server.getConfig().getProperty("Load.OnlineOnlyStudentFilter", null);
            if (filter != null && !filter.isEmpty()) {
                InstructionalMethod configIm;
                CourseOffering co;
                String im;
                String cn;
                if (new Query(filter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                    onlineOnly = true;
                    cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    im = server.getConfig().getProperty("Load.OnlineOnlyInstructionalModeRegExp");
                    for (CourseRequestInterface.Request r : request.getCourses()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && !course.getCourseName().matches(cn)) {
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (im == null) continue;
                            boolean hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (config.getInstructionalMethod() != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                            questionRestrictionsNotMet = true;
                        }
                    }
                    for (CourseRequestInterface.Request r : request.getAlternatives()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && !course.getCourseName().matches(cn)) {
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (im == null) continue;
                            boolean hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-ONLINE", ApplicationProperties.getProperty("purdue.specreg.messages.onlineStudentReqResidentialCourse", "No online-only option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                            questionRestrictionsNotMet = true;
                        }
                    }
                } else if (server.getConfig().getPropertyBoolean("Load.OnlineOnlyExclusiveCourses", false)) {
                    cn = server.getConfig().getProperty("Load.OnlineOnlyCourseNameRegExp");
                    im = server.getConfig().getProperty("Load.ResidentialInstructionalModeRegExp");
                    for (CourseRequestInterface.Request r : request.getCourses()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && course.getCourseName().matches(cn)) {
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (im == null) continue;
                            boolean hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                            questionRestrictionsNotMet = true;
                        }
                    }
                    for (CourseRequestInterface.Request r : request.getAlternatives()) {
                        if (!r.hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse course : r.getRequestedCourse()) {
                            if (course.getCourseId() == null) continue;
                            if (cn != null && !cn.isEmpty() && course.getCourseName().matches(cn)) {
                                response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                                questionRestrictionsNotMet = true;
                                continue;
                            }
                            if (im == null) continue;
                            boolean hasMatchingConfig = false;
                            co = (CourseOffering)CourseOfferingDAO.getInstance().get(course.getCourseId(), helper.getHibSession());
                            if (co != null) {
                                for (InstrOfferingConfig config : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                                    configIm = config.getEffectiveInstructionalMethod();
                                    if (im.isEmpty()) {
                                        if (configIm != null && configIm.getReference() != null && !configIm.getReference().isEmpty()) continue;
                                        hasMatchingConfig = true;
                                        continue;
                                    }
                                    if (configIm == null || configIm.getReference() == null || !configIm.getReference().matches(im)) continue;
                                    hasMatchingConfig = true;
                                }
                            }
                            if (hasMatchingConfig) continue;
                            response.addMessage(course.getCourseId(), course.getCourseName(), "NOT-RESIDENTIAL", ApplicationProperties.getProperty("purdue.specreg.messages.residentialStudentReqOnlineCourse", "No residential option.").replace("{course}", course.getCourseName()), CONF_UNITIME);
                            questionRestrictionsNotMet = true;
                        }
                    }
                }
            }
        }
        boolean questionFreeTime = false;
        for (int i = 0; i < request.getCourses().size(); ++i) {
            CourseRequestInterface.Request r = request.getCourse(i);
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).isFreeTime()) continue;
            boolean hasCourse = false;
            for (int j = i + 1; j < request.getCourses().size(); ++j) {
                CourseRequestInterface.Request q = request.getCourse(j);
                if (!q.hasRequestedCourse() || !q.getRequestedCourse(0).hasCourseId()) continue;
                hasCourse = true;
            }
            Object free = "";
            for (CourseRequestInterface.FreeTime ft : r.getRequestedCourse(0).getFreeTime()) {
                if (!((String)free).isEmpty()) {
                    free = (String)free + ", ";
                }
                free = (String)free + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
            }
            if (hasCourse) {
                response.addMessage(0L, CONSTANTS.freePrefix() + (String)free, "FREE-TIME", ApplicationProperties.getProperty("purdue.specreg.messages.freeTimeHighPriority", "High priority free time"), CONF_UNITIME);
            }
            questionFreeTime = true;
        }
        String creditError = null;
        Float maxCredit = original.getMaxCredit();
        if (maxCredit == null) {
            maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
        }
        request.setWaitListMode(details.getWaitListMode());
        if (maxCredit != null && request.getCredit(null) > maxCredit.floatValue()) {
            for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                response.addMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null)))), CONF_UNITIME);
            }
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null)))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
            creditError = ApplicationProperties.getProperty("purdue.specreg.messages.acr.maxCreditError", "Maximum of {max} credit hours exceeded.\nThe student may not be able to get a full schedule.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit(null))));
        }
        String minCreditLimit = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float minCredit = 0.0f;
        block34: for (CourseRequestInterface.Request r : request.getCourses()) {
            if (r.hasAdvisorCredit()) {
                minCredit += r.getAdvisorCreditMin();
                continue;
            }
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                minCredit += rc.getCreditMin().floatValue();
                continue block34;
            }
        }
        if (creditError == null && minCreditLimit != null && minCredit < Float.parseFloat(minCreditLimit) && (maxCredit == null || maxCredit.floatValue() > Float.parseFloat(minCreditLimit)) && ((minCreditLimitFilter = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck.studentFilter")) == null || minCreditLimitFilter.isEmpty() || new Query(minCreditLimitFilter).match(new StatusPageSuggestionsAction.StudentMatcher(original, server.getAcademicSession().getDefaultSectioningStatus(), server, false)))) {
            creditError = ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit)));
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if (response.getConfirms().contains(CONF_UNITIME)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.unitimeProblemsFound", "The following issues have been detected:"), CONF_UNITIME, -1);
            response.addConfirmation("", CONF_UNITIME, 1);
        }
        int line = 2;
        if (creditError != null) {
            response.addConfirmation(creditError, CONF_UNITIME, line++);
        }
        if (questionNoAlt) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.noAlternatives", (line > 2 ? "\n" : "") + "One or more of the recommended courses have no alternatives provided. The student may not be able to get a full schedule."), CONF_UNITIME, line++);
        }
        if (bl) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.timeConflicts", (line > 2 ? "\n" : "") + "Two or more single section courses are conflicting with each other. The student will likely not be able to get the conflicting course, so please provide an alternative course if possible."), CONF_UNITIME, line++);
        }
        if (questionInconStuPref) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.inconsistentStudPref", (line > 2 ? "\n" : "") + "One or more courses are not available due to the selected preferences."), CONF_UNITIME, line++);
        }
        if (questionRestrictionsNotMet) {
            if (rule != null) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.ruleNotMet", (line > 2 ? "\n" : "") + "One or more of the recommended courses have no {rule} option at the moment. The student may not be able to get a full schedule.".replace("{rule}", rule.getRuleName())), CONF_UNITIME, 5);
            } else if (onlineOnly) {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.onlineOnlyNotMet", (line > 2 ? "\n" : "") + "One or more of the recommended courses have no online-only option at the moment. The student may not be able to get a full schedule."), CONF_UNITIME, 5);
            } else {
                response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.residentialNotMet", (line > 2 ? "\n" : "") + "One or more of the recommended courses have no residential option at the moment. The student may not be able to get a full schedule."), CONF_UNITIME, 5);
            }
        }
        if (questionFreeTime) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.acr.freeTimeRequested", (line > 2 ? "\n" : "") + "Free time requests will be considered as time blocks during the pre-registration process. When possible, classes should be avoided during free time. However, if a free time request is placed higher than a course, the course cannot be attended during free time and the student may not receive a full schedule."), CONF_UNITIME, 6);
        }
        if (line > 2) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.confirmation", "\nDo you want to proceed?"), CONF_UNITIME, 7);
        }
        if ((conf = response.getConfirms()).contains(CONF_UNITIME)) {
            response.setConfirmation(CONF_UNITIME, ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeDialogName", "Warning Confirmations"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeYesButton", "Accept & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeNoButton", "Cancel Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeYesButtonTitle", "Accept the above warning(s) and submit the Advisor Course Recommendations"), ApplicationProperties.getProperty("purdue.specreg.confirm.acr.unitimeNoButtonTitle", "Go back to editing your Advisor Course Recommendations"));
        }
    }

    @Override
    public String retriveStudentPin(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudentId student) throws SectioningException {
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server.getAcademicSession();
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentId", this.getBannerId(student));
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode().name());
            helper.getAction().addOptionBuilder().setKey("term").setValue(term);
            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            if (!helper.getAction().hasApiGetTime()) {
                helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
            }
            SpecialRegistrationInterface.CheckEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.CheckEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.CheckEligibilityResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
            }
            helper.getAction().addOptionBuilder().setKey("holds-response").setValue(gson.toJson((Object)eligibility));
            if (SpecialRegistrationInterface.ResponseStatus.success != eligibility.status) {
                throw new SectioningException((String)(eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + String.valueOf((Object)eligibility.status) + ")." : eligibility.message));
            }
            if (eligibility.data != null && ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN != null && !((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN.isEmpty() && !"NA".equals(((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN)) {
                String string = ((SpecialRegistrationInterface.SpecialRegistrationEligibility)eligibility.data).PIN;
                return string;
            }
            String string = null;
            return string;
        }
        catch (SectioningException e) {
            helper.getAction().setApiException(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new SectioningException(e.getMessage());
        }
        finally {
            if (resource != null) {
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
        }
    }
}

