/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Transient;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class PreferenceGroup
extends BasePreferenceGroup {
    private static final long serialVersionUID = 1L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public PreferenceGroup() {
    }

    public PreferenceGroup(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public Set<TimePref> getTimePreferences() {
        return this.getPreferences(TimePref.class);
    }

    @Transient
    public Set<TimePattern> getTimePatterns() {
        Set<TimePref> timePrefs = this.getTimePreferences();
        if (timePrefs == null) {
            return null;
        }
        TreeSet<TimePattern> ret = new TreeSet<TimePattern>();
        for (TimePref tp : timePrefs) {
            if (tp.getTimePattern() == null) continue;
            ret.add(tp.getTimePattern());
        }
        return ret;
    }

    @Transient
    public Set getEffectiveTimePreferences() {
        return this.effectivePreferences(TimePref.class);
    }

    public Set effectiveTimePatterns() {
        Set timePrefs = this.getEffectiveTimePreferences();
        if (timePrefs == null) {
            return null;
        }
        TreeSet<TimePattern> ret = new TreeSet<TimePattern>();
        for (TimePref tp : timePrefs) {
            if (tp.getTimePattern() == null) continue;
            ret.add(tp.getTimePattern());
        }
        return ret;
    }

    @Transient
    public Set<RoomPref> getRoomPreferences() {
        return this.getPreferences(RoomPref.class);
    }

    @Transient
    public Set getEffectiveRoomPreferences() {
        return this.effectivePreferences(RoomPref.class);
    }

    @Transient
    public Set<BuildingPref> getBuildingPreferences() {
        return this.getPreferences(BuildingPref.class);
    }

    @Transient
    public Set getEffectiveBuildingPreferences() {
        return this.effectivePreferences(BuildingPref.class);
    }

    @Transient
    public Set<RoomFeaturePref> getRoomFeaturePreferences() {
        return this.getPreferences(RoomFeaturePref.class);
    }

    @Transient
    public Set<RoomGroupPref> getRoomGroupPreferences() {
        return this.getPreferences(RoomGroupPref.class);
    }

    @Transient
    public Set getEffectiveRoomFeaturePreferences() {
        return this.effectivePreferences(RoomFeaturePref.class);
    }

    @Transient
    public Set getDistributionPreferences() {
        return this.getPreferences(DistributionPref.class);
    }

    @Transient
    public Set getEffectiveDistributionPreferences() {
        return this.effectivePreferences(DistributionPref.class);
    }

    @Transient
    public Set getDatePatternPreferences() {
        return this.getPreferences(DatePatternPref.class);
    }

    private String htmlForPrefs(ClassAssignmentProxy.AssignmentInfo assignment, Set prefList, boolean timeVertical, boolean gridAsText, String timeGridSize, String nameFormat) {
        return this.htmlForPrefs(assignment, prefList, timeVertical, gridAsText, timeGridSize, nameFormat, ApplicationProperty.PreferencesHighlighClassPreferences.isTrue());
    }

    private String htmlForPrefs(ClassAssignmentProxy.AssignmentInfo assignment, Set prefList, boolean timeVertical, boolean gridAsText, String timeGridSize, String nameFormat, boolean highlightClassPrefs) {
        StringBuffer sb = new StringBuffer();
        if (prefList != null && !prefList.isEmpty()) {
            if (prefList.toArray()[0] instanceof TimePref) {
                sb.append(this.htmlForTimePrefs(assignment, prefList, timeVertical, gridAsText, timeGridSize, highlightClassPrefs));
            } else {
                Iterator it = prefList.iterator();
                Preference aPref = null;
                boolean notFirst = false;
                while (it.hasNext()) {
                    if (notFirst) {
                        sb.append("<BR>");
                    } else {
                        notFirst = true;
                    }
                    aPref = (Preference)it.next();
                    sb.append(aPref.preferenceHtml(nameFormat, highlightClassPrefs));
                }
            }
        }
        return sb.toString();
    }

    private String htmlForPrefs(Assignment assignment, Set prefList) {
        return this.htmlForTimePrefs(assignment, prefList, false, false, null, ApplicationProperty.PreferencesHighlighClassPreferences.isTrue());
    }

    private String htmlForTimePrefs(ClassAssignmentProxy.AssignmentInfo assignment, Set timePrefList, boolean timeVertical, boolean gridAsText, String timeGridSize, boolean highlightClassPrefs) {
        StringBuffer sb = new StringBuffer();
        Iterator i = timePrefList.iterator();
        while (i.hasNext()) {
            TimePref tp = (TimePref)i.next();
            RequiredTimeTable rtt = tp.getRequiredTimeTable(assignment == null ? null : assignment.getTimeLocation());
            Object owner = "";
            owner = tp.getOwner() != null && tp.getOwner() instanceof Class_ ? " (" + MSG.prefOwnerClass() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof SchedulingSubpart ? " (" + MSG.prefOwnerSchedulingSubpart() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof DepartmentalInstructor ? " (" + MSG.prefOwnerInstructor() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof Exam ? " (" + MSG.prefOwnerExamination() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof Department ? " (" + MSG.prefOwnerDepartment() + ")" : (tp.getOwner() != null && tp.getOwner() instanceof Session ? " (" + MSG.prefOwnerSession() + ")" : " (" + MSG.prefOwnerCombined() + ")")))));
            String hint = rtt.print(false, timeVertical, true, false, rtt.getModel().getName() + (String)owner).replace(");\n</script>", "").replace("<script language=\"javascript\">\ndocument.write(", "").replace("\n", " ");
            if (gridAsText || rtt.getModel().isExactTime()) {
                sb.append("<span onmouseover=\"showGwtHint(this, " + hint + ");\" onmouseout=\"hideGwtHint();\" " + (tp.getOwner() != null && tp.getOwner() instanceof Class_ && highlightClassPrefs ? " style='background: #ffa;'" : "") + ">" + rtt.getModel().toString().replaceAll(", ", "<br>") + "</span>");
            } else {
                rtt.getModel().setDefaultSelection(timeGridSize);
                sb.append("<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&s=" + rtt.getModel().getDefaultSelection() + "&tp=" + tp.getTimePattern().getUniqueId() + "&p=" + rtt.getModel().getPreferences() + (String)(assignment == null || assignment.getTimeLocation() == null ? "" : "&as=" + assignment.getTimeLocation().getStartSlot() + "&ad=" + assignment.getTimeLocation().getDayCode()) + (tp.getOwner() != null && tp.getOwner() instanceof Class_ && highlightClassPrefs ? "&hc=1" : "") + "' onmouseover=\"showGwtHint(this, " + hint + ");\" onmouseout=\"hideGwtHint();\">&nbsp;");
            }
            if (!i.hasNext()) continue;
            sb.append("<br>");
        }
        return sb.toString();
    }

    public abstract String htmlLabel();

    public String effectiveTimePatternHtml() {
        return new String();
    }

    public String getPrefHtmlForPrefType(Class type) {
        return this.htmlForPrefs(null, this.getPreferences(type));
    }

    public String getEffectivePrefHtmlForPrefType(Class type) {
        return this.htmlForPrefs(null, this.effectivePreferences(type), false, false, null, null);
    }

    public String getEffectivePrefHtmlForPrefType(Class type, boolean highlightClassPrefs) {
        return this.htmlForPrefs(null, this.effectivePreferences(type), false, false, null, null, highlightClassPrefs);
    }

    public String getEffectivePrefHtmlForPrefType(Class type, boolean timeVertical, boolean gridAsText, String timeGridSize) {
        return this.htmlForPrefs(null, this.effectivePreferences(type), timeVertical, gridAsText, timeGridSize, null);
    }

    public String getEffectivePrefHtmlForPrefType(Class type, String nameFormat) {
        return this.htmlForPrefs(null, this.effectivePreferences(type), false, false, null, nameFormat);
    }

    public String getEffectivePrefHtmlForPrefType(Class type, String nameFormat, boolean highlightClassPrefs) {
        return this.htmlForPrefs(null, this.effectivePreferences(type), false, false, null, nameFormat, highlightClassPrefs);
    }

    public String getEffectivePrefHtmlForPrefType(ClassAssignmentProxy.AssignmentInfo assignment, Class type, boolean timeVertical, boolean gridAsText, String timeGridSize) {
        return this.htmlForPrefs(assignment, this.effectivePreferences(type), timeVertical, gridAsText, timeGridSize, null);
    }

    public String getEffectivePrefHtmlForPrefType(ClassAssignmentProxy.AssignmentInfo assignment, Class type, boolean timeVertical, boolean gridAsText, String timeGridSize, boolean highlightClassPrefs) {
        return this.htmlForPrefs(assignment, this.effectivePreferences(type), timeVertical, gridAsText, timeGridSize, null, highlightClassPrefs);
    }

    @Transient
    public Class getInstanceOf() {
        return PreferenceGroup.class;
    }

    public <T> Set<T> getPreferences(Class<T> type) {
        return this.getPreferences(type, null);
    }

    public Set getPreferences(Class type, PreferenceGroup appliesTo) {
        TreeSet<Preference> ret = new TreeSet<Preference>();
        Iterator<Preference> i = null;
        try {
            i = this.getPreferences().iterator();
        }
        catch (ObjectNotFoundException e) {
            Debug.error("Exception " + e.getMessage() + " seen for " + String.valueOf(this));
            new _RootDAO().getSession().refresh((Object)this);
            i = this.getPreferences() != null ? this.getPreferences().iterator() : null;
        }
        catch (Exception e) {
            i = null;
        }
        if (i == null) {
            return ret;
        }
        while (i.hasNext()) {
            Preference preference = i.next();
            if (appliesTo != null && !preference.appliesTo(appliesTo) || !type.isInstance(preference)) continue;
            ret.add(preference);
        }
        return ret;
    }

    public Set effectivePreferences(Class type, Vector leadInstructors) {
        return this.effectivePreferences(type, leadInstructors, TimePref.class.equals((Object)type));
    }

    public Set effectivePreferences(Class type, Vector leadInstructors, boolean fixDurationInTimePreferences) {
        return this.effectivePreferences(type, fixDurationInTimePreferences);
    }

    public <T> Set<T> effectivePreferences(Class<T> type) {
        return this.effectivePreferences(type, TimePref.class.equals(type));
    }

    public Set effectivePreferences(Class type, boolean fixDurationInTimePreferences) {
        return this.getPreferences(type, null);
    }

    public DatePattern effectiveDatePattern() {
        return null;
    }

    @Transient
    public Set<Location> getAvailableRooms() {
        return new TreeSet<Location>();
    }

    @Transient
    public Set<Building> getAvailableBuildings() {
        TreeSet<Building> bldgs = new TreeSet<Building>();
        for (Location location : this.getAvailableRooms()) {
            if (!(location instanceof Room)) continue;
            bldgs.add(((Room)location).getBuilding());
        }
        return bldgs;
    }

    @Transient
    public abstract Session getSession();

    @Transient
    public Set<RoomFeature> getAvailableRoomFeatures() {
        return new TreeSet<RoomFeature>(RoomFeature.getAllGlobalRoomFeatures(this.getSession()));
    }

    @Transient
    public Set<RoomGroup> getAvailableRoomGroups() {
        return new TreeSet<RoomGroup>(RoomGroup.getAllGlobalRoomGroups(this.getSession()));
    }

    @Transient
    public Set getAvailableCourses() {
        return new TreeSet();
    }

    @Transient
    public Set getAvailableAttributeTypes() {
        return new TreeSet();
    }

    @Transient
    public Set getAvailableAttributes() {
        return new TreeSet();
    }

    @Transient
    public Set getExamPeriodPreferences() {
        return this.getPreferences(ExamPeriodPref.class);
    }

    @Transient
    public Set getEffectiveExamPeriodPreferences() {
        return this.effectivePreferences(ExamPeriodPref.class);
    }

    @Transient
    public abstract Department getDepartment();

    @Transient
    public boolean isInstructorAssignmentNeeded() {
        return false;
    }
}

