/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.TreeSet;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseItypeDesc;
import org.unitime.timetable.model.dao.ItypeDescDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="itype_desc")
public class ItypeDesc
extends BaseItypeDesc
implements Comparable<Object> {
    private static final long serialVersionUID = 1L;
    public static String[] sBasicTypes = new String[]{"Extended", "Basic"};
    public static String ITYPE_ATTR_NAME = "itypesList";

    public static TreeSet<ItypeDesc> findAll(boolean basic) {
        return new TreeSet<ItypeDesc>(ItypeDescDAO.getInstance().getSession().createQuery("select i from ItypeDesc i" + (basic ? " where i.basic = true" : ""), ItypeDesc.class).setCacheable(true).list());
    }

    @Transient
    public String getBasicType() {
        return sBasicTypes[this.getBasic() != false ? 1 : 0];
    }

    @Override
    public int compareTo(Object o) {
        if (o == null || !(o instanceof ItypeDesc)) {
            return -1;
        }
        return this.getItype().compareTo(((ItypeDesc)o).getItype());
    }

    public static ItypeDesc findForReference(String reference, Session hibSession) {
        return (ItypeDesc)hibSession.createQuery("from ItypeDesc i where i.sis_ref = :ref", ItypeDesc.class).setParameter("ref", (Object)reference).setCacheable(true).uniqueResult();
    }
}

