/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class CourseRequestInterface
extends OnlineSectioningInterface.StudentSectioningContext
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<Request> iCourses = new ArrayList();
    private ArrayList<Request> iAlternatives = new ArrayList();
    private boolean iSaved = false;
    private boolean iNoChange = false;
    private boolean iAllowTimeConf = false;
    private boolean iAllowRoomConf = false;
    private boolean iLinkedConf = false;
    private boolean iDeadlineConf = false;
    private Boolean iUpdateLastRequest = null;
    private RequestedCourse iLastCourse = null;
    private List<CourseMessage> iConfirmations = null;
    private Float iMaxCredit = null;
    private Float iMaxCreditOverride = null;
    private RequestedCourseStatus iMaxCreditOverrideStatus = null;
    private String iMaxCreditOverrideExternalId = null;
    private Date iMaxCreditOverrideTimeStamp = null;
    private String iCreditWarning = null;
    private String iCreditNote = null;
    private String iErrorMessage = null;
    private String iSpecRegDashboardUrl = null;
    private String iRequestorNote = null;
    private List<String> iRequestorNoteSuggestions = null;
    private String iRequestId = null;
    private String iPopupMessage = null;
    private Boolean iPinReleased = null;
    private OnlineSectioningInterface.WaitListMode iMode = null;
    private CheckCoursesResponse iWaitListChecks = null;
    private String iChangedBy = null;
    private Date iTimeStamp = null;

    public CourseRequestInterface() {
    }

    public CourseRequestInterface(OnlineSectioningInterface.StudentSectioningContext cx) {
        super(cx);
    }

    public ArrayList<Request> getCourses() {
        return this.iCourses;
    }

    public Request getCourse(int index) {
        if (this.iCourses != null && index < this.iCourses.size()) {
            return this.iCourses.get(index);
        }
        return null;
    }

    public ArrayList<Request> getAlternatives() {
        return this.iAlternatives;
    }

    public Request getAlternative(int index) {
        if (this.iAlternatives != null && index < this.iAlternatives.size()) {
            return this.iAlternatives.get(index);
        }
        return null;
    }

    public void addCourseCriticalFirst(Request request) {
        if (request.isCritical() || request.isImportant() || request.isVital()) {
            int lastCritical = -1;
            for (int i = 0; i < this.getCourses().size(); ++i) {
                if (!this.getCourses().get(i).isCritical() && !this.getCourses().get(i).isImportant() && !this.getCourses().get(i).isVital()) continue;
                lastCritical = i;
            }
            this.getCourses().add(lastCritical + 1, request);
        } else {
            this.getCourses().add(request);
        }
    }

    public boolean isActive(Long courseId) {
        if (courseId == null) {
            return false;
        }
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!courseId.equals(rc.getCourseId()) || rc.isInactive()) continue;
                return true;
            }
        }
        for (Request r : this.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!courseId.equals(rc.getCourseId()) || rc.isInactive()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canWaitList(Long courseId) {
        if (courseId == null) {
            return false;
        }
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!courseId.equals(rc.getCourseId())) continue;
                return r.isCanWaitList();
            }
        }
        return false;
    }

    public boolean isWaitListed(Long courseId) {
        if (courseId == null) {
            return false;
        }
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse() || !r.isWaitList()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!courseId.equals(rc.getCourseId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean sameWaitListedCourses(CourseRequestInterface other) {
        if (other == null) {
            return false;
        }
        int nrWaitListed = 0;
        block0: for (Request r : this.getCourses()) {
            if (!r.isWaitList()) continue;
            ++nrWaitListed;
            for (Request o : other.getCourses()) {
                if (!o.isWaitList() || !r.sameCourses(o)) continue;
                continue block0;
            }
            return false;
        }
        for (Request o : other.getCourses()) {
            if (!o.isWaitList()) continue;
            --nrWaitListed;
        }
        return nrWaitListed == 0;
    }

    public boolean isSaved() {
        return this.iSaved;
    }

    public void setSaved(boolean saved) {
        this.iSaved = saved;
    }

    public boolean isNoChange() {
        return this.iNoChange;
    }

    public void setNoChange(boolean noChange) {
        this.iNoChange = noChange;
    }

    public boolean areTimeConflictsAllowed() {
        return this.iAllowTimeConf;
    }

    public void setTimeConflictsAllowed(boolean allow) {
        this.iAllowTimeConf = allow;
    }

    public boolean areSpaceConflictsAllowed() {
        return this.iAllowRoomConf;
    }

    public void setSpaceConflictsAllowed(boolean allow) {
        this.iAllowRoomConf = allow;
    }

    public boolean areLinkedConflictsAllowed() {
        return this.iLinkedConf;
    }

    public void setLinkedConflictsAllowed(boolean allow) {
        this.iLinkedConf = allow;
    }

    public boolean areDeadlineConflictsAllowed() {
        return this.iDeadlineConf;
    }

    public void setDeadlineConflictsAllowed(boolean allow) {
        this.iDeadlineConf = allow;
    }

    public boolean isUpdateLastRequest() {
        return this.iUpdateLastRequest == null || this.iUpdateLastRequest != false;
    }

    public void setUpdateLastRequest(boolean updateLastRequest) {
        this.iUpdateLastRequest = updateLastRequest;
    }

    public boolean isEmpty() {
        return this.iCourses.isEmpty() && this.iAlternatives.isEmpty();
    }

    public boolean hasMaxCredit() {
        return this.iMaxCredit != null;
    }

    public void setMaxCredit(Float maxCredit) {
        this.iMaxCredit = maxCredit;
    }

    public Float getMaxCredit() {
        return this.iMaxCredit;
    }

    public boolean hasMaxCreditOverride() {
        return this.iMaxCreditOverride != null;
    }

    public void setMaxCreditOverride(Float maxCreditOverride) {
        this.iMaxCreditOverride = maxCreditOverride;
    }

    public Float getMaxCreditOverride() {
        return this.iMaxCreditOverride;
    }

    public void setMaxCreditOverrideStatus(RequestedCourseStatus status) {
        this.iMaxCreditOverrideStatus = status;
    }

    public RequestedCourseStatus getMaxCreditOverrideStatus() {
        return this.iMaxCreditOverrideStatus;
    }

    public void setMaxCreditOverrideExternalId(String externalId) {
        this.iMaxCreditOverrideExternalId = externalId;
    }

    public String getMaxCreditOverrideExternalId() {
        return this.iMaxCreditOverrideExternalId;
    }

    public void setMaxCreditOverrideTimeStamp(Date timeStamp) {
        this.iMaxCreditOverrideTimeStamp = timeStamp;
    }

    public Date getMaxCreditOverrideTimeStamp() {
        return this.iMaxCreditOverrideTimeStamp;
    }

    public boolean hasCreditWarning() {
        return this.iCreditWarning != null && !this.iCreditWarning.isEmpty();
    }

    public String getCreditWarning() {
        return this.iCreditWarning;
    }

    public void setCreditWarning(String warning) {
        this.iCreditWarning = warning;
    }

    public boolean hasCreditNote() {
        return this.iCreditNote != null && !this.iCreditNote.isEmpty() && !" ".equals(this.iCreditNote);
    }

    public String getCreditNote() {
        return this.iCreditNote;
    }

    public void setCreditNote(String note) {
        this.iCreditNote = note;
    }

    public boolean hasPopupMessage() {
        return this.iPopupMessage != null && !this.iPopupMessage.isEmpty();
    }

    public void setPopupMessage(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        if (this.iPopupMessage == null) {
            this.iPopupMessage = message;
        } else if (!this.iPopupMessage.contains(message)) {
            this.iPopupMessage = this.iPopupMessage + "\n" + message;
        }
    }

    public String getPopupMessage() {
        return this.iPopupMessage;
    }

    public boolean addCourse(RequestedCourse course) {
        this.iLastCourse = course;
        RequestPriority rp = this.getRequestPriority(course);
        if (rp != null) {
            if (rp.getRequest().getRequestedCourse(rp.getChoice()).isInactive()) {
                this.dropCourse(course);
            } else {
                return false;
            }
        }
        for (Request r : this.getCourses()) {
            if (!r.isEmpty()) continue;
            r.addRequestedCourse(course);
            return true;
        }
        Request r = new Request();
        r.addRequestedCourse(course);
        this.getCourses().add(r);
        return true;
    }

    public boolean dropCourse(RequestedCourse course) {
        Request r;
        this.iLastCourse = course;
        Iterator<Request> j = this.getCourses().iterator();
        while (j.hasNext()) {
            r = j.next();
            if (!r.hasRequestedCourse(course)) continue;
            Iterator<RequestedCourse> i = r.getRequestedCourse().iterator();
            while (i.hasNext()) {
                if (!course.equals(i.next())) continue;
                i.remove();
            }
            if (!r.hasRequestedCourse()) {
                j.remove();
            }
            return true;
        }
        j = this.getAlternatives().iterator();
        while (j.hasNext()) {
            r = j.next();
            if (!r.hasRequestedCourse(course)) continue;
            Iterator<RequestedCourse> i = r.getRequestedCourse().iterator();
            while (i.hasNext()) {
                if (!course.equals(i.next())) continue;
                i.remove();
            }
            if (!r.hasRequestedCourse()) {
                j.remove();
            }
            return true;
        }
        return false;
    }

    public boolean hasLastCourse() {
        return this.iLastCourse != null;
    }

    public RequestedCourse getLastCourse() {
        return this.iLastCourse;
    }

    private RequestPriority __getRequestPriority(Object course) {
        int i;
        if (course == null) {
            return null;
        }
        int priority = 1;
        for (Request r : this.getCourses()) {
            if (r.hasRequestedCourse()) {
                for (i = 0; i < r.getRequestedCourse().size(); ++i) {
                    if (!r.getRequestedCourse(i).equals(course)) continue;
                    return new RequestPriority(false, priority, i, r);
                }
            }
            ++priority;
        }
        priority = 1;
        for (Request r : this.getAlternatives()) {
            if (r.hasRequestedCourse()) {
                for (i = 0; i < r.getRequestedCourse().size(); ++i) {
                    if (!r.getRequestedCourse(i).equals(course)) continue;
                    return new RequestPriority(true, priority, i, r);
                }
            }
            ++priority;
        }
        return null;
    }

    public RequestPriority getRequestPriority(ClassAssignmentInterface.CourseAssignment course) {
        return this.__getRequestPriority(course);
    }

    public RequestPriority getRequestPriority(DegreePlanInterface.DegreeCourseInterface course) {
        return this.__getRequestPriority(course);
    }

    public RequestPriority getRequestPriority(RequestedCourse course) {
        return this.__getRequestPriority(course);
    }

    public float[] getCreditRange(Set<Long> advisorWaitListedCourseIds) {
        Float max;
        Float min;
        ArrayList<Float> mins = new ArrayList<Float>();
        ArrayList<Float> maxs = new ArrayList<Float>();
        int nrCourses = 0;
        float tMin = 0.0f;
        float tMax = 0.0f;
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            min = null;
            max = null;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                if (min == null || min.floatValue() > rc.getCreditMin().floatValue()) {
                    min = rc.getCreditMin();
                }
                if (max != null && !(max.floatValue() < rc.getCreditMax().floatValue())) continue;
                max = rc.getCreditMax();
            }
            if (min == null) continue;
            if (r.isWaitListOrNoSub(this.iMode, advisorWaitListedCourseIds)) {
                tMin += min.floatValue();
                tMax += max.floatValue();
                continue;
            }
            mins.add(min);
            maxs.add(max);
            ++nrCourses;
        }
        for (Request r : this.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            min = null;
            max = null;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                if (min == null || min.floatValue() > rc.getCreditMin().floatValue()) {
                    min = rc.getCreditMin();
                }
                if (max != null && !(max.floatValue() < rc.getCreditMax().floatValue())) continue;
                max = rc.getCreditMax();
            }
            if (min == null) continue;
            mins.add(min);
            maxs.add(max);
        }
        Collections.sort(mins);
        Collections.sort(maxs);
        for (int i = 0; i < nrCourses; ++i) {
            tMin += ((Float)mins.get(i)).floatValue();
            tMax += ((Float)maxs.get(maxs.size() - i - 1)).floatValue();
        }
        return new float[]{tMin, tMax};
    }

    public float getCredit(Set<Long> advisorWaitListedCourseIds) {
        Float credit;
        ArrayList<Float> credits = new ArrayList<Float>();
        int nrCourses = 0;
        float total = 0.0f;
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            credit = null;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue())) continue;
                credit = rc.getCreditMin();
            }
            if (credit == null) continue;
            if (r.isWaitListOrNoSub(this.iMode, advisorWaitListedCourseIds)) {
                total += credit.floatValue();
                continue;
            }
            credits.add(credit);
            ++nrCourses;
        }
        for (Request r : this.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            credit = null;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue())) continue;
                credit = rc.getCreditMin();
            }
            if (credit == null) continue;
            credits.add(credit);
        }
        Collections.sort(credits);
        for (int i = 0; i < nrCourses; ++i) {
            total += ((Float)credits.get(credits.size() - i - 1)).floatValue();
        }
        return total;
    }

    public boolean isPinReleased() {
        return this.iPinReleased != null && this.iPinReleased != false;
    }

    public void setPinReleased(boolean pinReleased) {
        this.iPinReleased = pinReleased;
    }

    public boolean hasReleasedPin() {
        return this.isPinReleased() && this.hasPin();
    }

    public boolean hasChangedBy() {
        return this.iChangedBy != null && !this.iChangedBy.isEmpty();
    }

    public String getChangedBy() {
        return this.iChangedBy;
    }

    public void setChangedBy(String changedBy) {
        this.iChangedBy = changedBy;
    }

    public boolean hasTimeStamp() {
        return this.iTimeStamp != null;
    }

    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date ts) {
        this.iTimeStamp = ts;
    }

    public Set<Long> getWaitListedCourseIds() {
        HashSet<Long> courseIds = new HashSet<Long>();
        for (Request request : this.getCourses()) {
            RequestedCourse rc;
            Iterator<RequestedCourse> iterator;
            if (!request.hasRequestedCourse() || !request.isWaitList() || !(iterator = request.getRequestedCourse().iterator()).hasNext() || !(rc = iterator.next()).hasCourseId()) continue;
            courseIds.add(rc.getCourseId());
        }
        return courseIds;
    }

    public Set<Long> getNoSubCourseIds() {
        HashSet<Long> courseIds = new HashSet<Long>();
        for (Request request : this.getCourses()) {
            RequestedCourse rc;
            Iterator<RequestedCourse> iterator;
            if (!request.hasRequestedCourse() || !request.isNoSub() || !(iterator = request.getRequestedCourse().iterator()).hasNext() || !(rc = iterator.next()).hasCourseId()) continue;
            courseIds.add(rc.getCourseId());
        }
        return courseIds;
    }

    public boolean equals(Object o) {
        int i;
        if (o == null || !(o instanceof CourseRequestInterface)) {
            return false;
        }
        CourseRequestInterface r = (CourseRequestInterface)o;
        if (this.getCourses().size() != r.getCourses().size()) {
            return false;
        }
        for (i = 0; i < this.getCourses().size(); ++i) {
            if (this.getCourse(i).equals(r.getCourse(i))) continue;
            return false;
        }
        if (this.getAlternatives().size() != r.getAlternatives().size()) {
            return false;
        }
        for (i = 0; i < this.getAlternatives().size(); ++i) {
            if (this.getAlternative(i).equals(r.getAlternative(i))) continue;
            return false;
        }
        return true;
    }

    public boolean hasConfirmations() {
        return this.iConfirmations != null && !this.iConfirmations.isEmpty();
    }

    public void addConfirmation(CourseMessage message) {
        if (this.iConfirmations != null) {
            this.iConfirmations = new ArrayList<CourseMessage>();
        }
        this.iConfirmations.add(message);
    }

    public List<CourseMessage> getConfirmations() {
        return this.iConfirmations;
    }

    public void setConfirmations(Collection<CourseMessage> confirmations) {
        this.iConfirmations = confirmations == null ? null : new ArrayList<CourseMessage>(confirmations);
    }

    public void addConfirmations(Collection<CourseMessage> confirmations) {
        if (this.iConfirmations == null || this.iConfirmations.isEmpty()) {
            this.iConfirmations = confirmations == null ? null : new ArrayList<CourseMessage>(confirmations);
        } else if (confirmations != null) {
            this.iConfirmations.addAll(confirmations);
        }
    }

    public List<CourseMessage> getConfirmations(String courseName) {
        ArrayList<CourseMessage> ret = new ArrayList<CourseMessage>();
        if (this.hasConfirmations()) {
            for (CourseMessage m : this.getConfirmations()) {
                if (!m.hasCourse() || !courseName.equals(m.getCourse())) continue;
                ret.add(m);
            }
        }
        return ret;
    }

    public boolean hasConfirmations(String courseName, String ... exclude) {
        if (this.hasConfirmations()) {
            block0: for (CourseMessage m : this.getConfirmations()) {
                if (!m.hasCourse() || !courseName.equals(m.getCourse())) continue;
                for (String e : exclude) {
                    if (e.equals(m.getCode())) continue block0;
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasConfirmations(Long courseId, String ... exclude) {
        if (this.hasConfirmations()) {
            block0: for (CourseMessage m : this.getConfirmations()) {
                if (!m.hasCourseId() || !courseId.equals(m.getCourseId())) continue;
                for (String e : exclude) {
                    if (e.equals(m.getCode())) continue block0;
                }
                return true;
            }
        }
        return false;
    }

    public String getConfirmation(String courseName, String delim, String ... exclude) {
        if (!this.hasConfirmations()) {
            return null;
        }
        Object ret = null;
        if (this.hasConfirmations()) {
            block0: for (CourseMessage m : this.getConfirmations()) {
                if (!m.hasCourse() || !courseName.equals(m.getCourse())) continue;
                for (String e : exclude) {
                    if (e.equals(m.getCode())) continue block0;
                }
                if (ret == null) {
                    ret = m.getMessage();
                    continue;
                }
                ret = (String)ret + delim + m.getMessage();
            }
        }
        return ret;
    }

    public boolean isError(String courseName) {
        if (!this.hasConfirmations()) {
            return false;
        }
        if (this.hasConfirmations()) {
            for (CourseMessage m : this.getConfirmations()) {
                if (!m.hasCourse() || !courseName.equals(m.getCourse()) || !m.isError()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String ret = "CourseRequests(student = " + this.getStudentId() + ", session = " + this.getSessionId() + ", requests = {";
        int idx = 1;
        for (Request r : this.iCourses) {
            ret = ret + "\n   " + idx++ + ". " + String.valueOf(r);
        }
        idx = 1;
        for (Request r : this.iAlternatives) {
            ret = ret + "\n  A" + idx++ + ". " + String.valueOf(r);
        }
        return ret + "\n})";
    }

    public void addConfirmationError(Long courseId, String course, String code, String message, RequestedCourseStatus status, Integer order) {
        if (this.iConfirmations == null) {
            this.iConfirmations = new ArrayList<CourseMessage>();
        }
        CourseMessage m = new CourseMessage();
        m.setCourseId(courseId);
        m.setCourse(course);
        m.setCode(code);
        m.setMessage(message);
        m.setError(true);
        m.setConfirm(null);
        m.setStatus(status);
        m.setOrder(order);
        this.iConfirmations.add(m);
    }

    public void addConfirmationMessage(Long courseId, String course, String code, String message, RequestedCourseStatus status, Integer order) {
        if (this.iConfirmations == null) {
            this.iConfirmations = new ArrayList<CourseMessage>();
        }
        CourseMessage m = new CourseMessage();
        m.setCourseId(courseId);
        m.setCourse(course);
        m.setCode(code);
        m.setMessage(message);
        m.setError(false);
        m.setConfirm(null);
        m.setStatus(status);
        m.setOrder(order);
        this.iConfirmations.add(m);
    }

    public void addConfirmationMessage(Long courseId, String course, String code, String message, Integer order) {
        this.addConfirmationMessage(courseId, course, code, message, null, order);
    }

    public boolean hasErrorMessage() {
        return this.iErrorMessage != null && !this.iErrorMessage.isEmpty();
    }

    public void setErrorMessage(String message) {
        if (this.iErrorMessage == null) {
            this.iErrorMessage = message;
        } else if (!this.iErrorMessage.contains(message)) {
            this.iErrorMessage = this.iErrorMessage + "\n" + message;
        }
    }

    public String getErrorMessaeg() {
        return this.iErrorMessage;
    }

    public String getSpecRegDashboardUrl() {
        return this.iSpecRegDashboardUrl;
    }

    public boolean hasSpecRegDashboardUrl() {
        return this.iSpecRegDashboardUrl != null && !this.iSpecRegDashboardUrl.isEmpty();
    }

    public void setSpecRegDashboardUrl(String url) {
        this.iSpecRegDashboardUrl = url;
    }

    public void setRequestorNote(String note) {
        this.iRequestorNote = note == null ? null : note.replace("<br>", "\n");
    }

    public boolean hasRequestorNote() {
        return this.iRequestorNote != null && !this.iRequestorNote.isEmpty() && !" ".equals(this.iRequestorNote);
    }

    public String getRequestorNote() {
        return this.iRequestorNote;
    }

    public boolean hasRequestorNoteSuggestions() {
        return this.iRequestorNoteSuggestions != null && !this.iRequestorNoteSuggestions.isEmpty();
    }

    public List<String> getRequestorNoteSuggestions() {
        return this.iRequestorNoteSuggestions;
    }

    public void addRequestorNoteSuggestion(String suggestion) {
        if (this.iRequestorNoteSuggestions == null) {
            this.iRequestorNoteSuggestions = new ArrayList<String>();
        }
        this.iRequestorNoteSuggestions.add(suggestion);
    }

    public void setRequestId(String id) {
        this.iRequestId = id;
    }

    public boolean hasRequestId() {
        return this.iRequestId != null && !this.iRequestId.isEmpty() && !" ".equals(this.iRequestId);
    }

    public String getRequestId() {
        return this.iRequestId;
    }

    public boolean updateRequestorNote(String requestId, String note) {
        boolean changed = false;
        if (requestId.equals(this.getRequestId())) {
            this.setRequestorNote(note);
            changed = true;
        }
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!requestId.equals(rc.getRequestId())) continue;
                rc.setRequestorNote(note);
                changed = true;
            }
        }
        for (Request r : this.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!requestId.equals(rc.getRequestId())) continue;
                rc.setRequestorNote(note);
                changed = true;
            }
        }
        return changed;
    }

    public void removeInactiveDuplicates() {
        Iterator<RequestedCourse> i;
        RequestedCourse rc2;
        HashSet<RequestedCourse> activeCourses = new HashSet<RequestedCourse>();
        for (Request r : this.iCourses) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc2 : r.getRequestedCourse()) {
                if (rc2.isInactive() || !rc2.isCourse()) continue;
                activeCourses.add(rc2);
            }
        }
        for (Request r : this.iAlternatives) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc2 : r.getRequestedCourse()) {
                if (rc2.isInactive() || !rc2.isCourse()) continue;
                activeCourses.add(rc2);
            }
        }
        for (Request r : this.iCourses) {
            if (!r.hasRequestedCourse()) continue;
            i = r.getRequestedCourse().iterator();
            while (i.hasNext()) {
                rc2 = i.next();
                if (!rc2.isInactive() || !rc2.isCourse() || !activeCourses.contains(rc2)) continue;
                i.remove();
            }
        }
        for (Request r : this.iAlternatives) {
            if (!r.hasRequestedCourse()) continue;
            i = r.getRequestedCourse().iterator();
            while (i.hasNext()) {
                rc2 = i.next();
                if (!rc2.isInactive() || !rc2.hasCourseId() || !activeCourses.contains(rc2)) continue;
                i.remove();
            }
        }
    }

    public void moveActiveSubstitutionsUp() {
        int nrInactive = 0;
        for (Request request : this.getCourses()) {
            if (!request.isInactive()) continue;
            ++nrInactive;
        }
        Iterator<Request> i = this.getAlternatives().iterator();
        while (i.hasNext() && nrInactive > 0) {
            Request request;
            request = i.next();
            if (!request.isActive()) continue;
            this.getCourses().add(request);
            i.remove();
            --nrInactive;
        }
    }

    public boolean removeDuplicates() {
        RequestedCourse rc;
        Iterator<RequestedCourse> i;
        HashSet<RequestedCourse> courses = new HashSet<RequestedCourse>();
        boolean deleted = false;
        for (Request r : this.iCourses) {
            if (!r.hasRequestedCourse()) continue;
            i = r.getRequestedCourse().iterator();
            while (i.hasNext()) {
                rc = i.next();
                if (!rc.isCourse() || courses.add(rc)) continue;
                i.remove();
                deleted = true;
            }
        }
        for (Request r : this.iAlternatives) {
            if (!r.hasRequestedCourse()) continue;
            i = r.getRequestedCourse().iterator();
            while (i.hasNext()) {
                rc = i.next();
                if (!rc.isCourse() || courses.add(rc)) continue;
                i.remove();
                deleted = true;
            }
        }
        return deleted;
    }

    public boolean applyAdvisorRequests(CourseRequestInterface req) {
        boolean skip;
        if (req == null || req.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Request r : req.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            skip = false;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCourseId() || this.getRequestPriority(rc) == null) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            this.getCourses().add(r);
            changed = true;
        }
        for (Request r : req.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            skip = false;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCourseId() || this.getRequestPriority(rc) == null) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            this.getAlternatives().add(r);
            changed = true;
        }
        return changed;
    }

    public boolean hasWaitListMode() {
        return this.iMode != null;
    }

    public OnlineSectioningInterface.WaitListMode getWaitListMode() {
        if (this.iMode == null) {
            return OnlineSectioningInterface.WaitListMode.None;
        }
        return this.iMode;
    }

    public void setWaitListMode(OnlineSectioningInterface.WaitListMode mode) {
        this.iMode = mode;
    }

    public boolean hasWaitListChecks() {
        return this.iWaitListChecks != null;
    }

    public CheckCoursesResponse getWaitListChecks() {
        return this.iWaitListChecks;
    }

    public void setWaitListChecks(CheckCoursesResponse waitListChecks) {
        this.iWaitListChecks = waitListChecks;
        this.addConfirmations(waitListChecks == null ? null : waitListChecks.getMessages());
        this.setErrorMessage(waitListChecks == null ? null : waitListChecks.getErrorMessage());
        this.setCreditNote(waitListChecks == null ? null : waitListChecks.getCreditNote());
        this.setCreditWarning(waitListChecks == null ? null : waitListChecks.getCreditWarning());
        this.setMaxCreditOverride(waitListChecks == null ? null : waitListChecks.getMaxCreditNeeded());
        this.setMaxCreditOverrideStatus(waitListChecks == null ? null : waitListChecks.getMaxCreditOverrideStatus());
    }

    public RequestedCourseStatus getStatus(String courseName) {
        RequestedCourseStatus status = null;
        if (this.hasConfirmations()) {
            for (CourseMessage m : this.getConfirmations()) {
                if (m.getStatus() == null || !m.hasCourse() || !courseName.equals(m.getCourse()) || status != null && m.getStatus().ordinal() <= status.ordinal()) continue;
                status = m.getStatus();
            }
        }
        if (status != null) {
            return status;
        }
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!courseName.equals(rc.getCourseName()) || rc.isInactive()) continue;
                return rc.getStatus();
            }
        }
        for (Request r : this.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!courseName.equals(rc.getCourseName()) || rc.isInactive()) continue;
                return rc.getStatus();
            }
        }
        return null;
    }

    public RequestedCourseStatus getStatus(Long courseId) {
        if (courseId == null) {
            return null;
        }
        RequestedCourseStatus status = null;
        if (this.hasConfirmations()) {
            for (CourseMessage m : this.getConfirmations()) {
                if (m.getStatus() == null || !m.hasCourse() || !courseId.equals(m.getCourseId()) || status != null && m.getStatus().ordinal() <= status.ordinal()) continue;
                status = m.getStatus();
            }
        }
        if (status != null) {
            return status;
        }
        for (Request r : this.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!courseId.equals(rc.getCourseId()) || rc.isInactive()) continue;
                return rc.getStatus();
            }
        }
        for (Request r : this.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (RequestedCourse rc : r.getRequestedCourse()) {
                if (!courseId.equals(rc.getCourseId()) || rc.isInactive()) continue;
                return rc.getStatus();
            }
        }
        return null;
    }

    public static class RequestedCourse
    implements IsSerializable,
    Serializable,
    Comparable<RequestedCourse> {
        private static final long serialVersionUID = 1L;
        private Long iCourseId;
        private String iCourseName;
        private String iCourseTitle;
        private Boolean iReadOnly = null;
        private Boolean iCanDelete = null;
        private Boolean iCanChangeAlternatives = null;
        private Boolean iCanChangePriority = null;
        private List<FreeTime> iFreeTime;
        private Set<Preference> iSelectedIntructionalMethods;
        private Set<Preference> iSelectedClasses;
        private float[] iCredit = null;
        private RequestedCourseStatus iStatus = null;
        private String iStatusNote = null;
        private String iOverrideExternalId = null;
        private Date iOverrideTimeStamp = null;
        private String iRequestorNote = null;
        private List<String> iRequestorNoteSuggestions = null;
        private String iRequestId = null;
        private Boolean iInactive = null;
        private Boolean iCanWaitList = null;
        private String iWaitListPosition = null;
        private String iChangedBy = null;
        private Date iTimeStamp = null;

        public RequestedCourse() {
        }

        public RequestedCourse(List<FreeTime> freeTime) {
            this.iFreeTime = freeTime;
        }

        public RequestedCourse(ClassAssignmentInterface.CourseAssignment course, boolean showTitle) {
            this.iCourseId = course.getCourseId();
            this.iCourseName = course.hasUniqueName() && !showTitle ? course.getCourseName() : course.getCourseNameWithTitle();
        }

        public RequestedCourse(Long courseId, String courseName) {
            this.iCourseId = courseId;
            this.iCourseName = courseName;
        }

        public RequestedCourse(RequestedCourse rc) {
            this.iCourseId = rc.iCourseId;
            this.iCourseName = rc.iCourseName;
            this.iCourseTitle = rc.iCourseTitle;
            this.iReadOnly = rc.iReadOnly;
            this.iCanDelete = rc.iCanDelete;
            this.iCanChangeAlternatives = rc.iCanChangeAlternatives;
            this.iCanChangePriority = rc.iCanChangePriority;
            if (rc.iFreeTime != null) {
                this.iFreeTime = new ArrayList<FreeTime>();
                for (FreeTime ft : rc.iFreeTime) {
                    this.iFreeTime.add(new FreeTime(ft));
                }
            }
            if (rc.iSelectedIntructionalMethods != null) {
                this.iSelectedIntructionalMethods = new HashSet<Preference>();
                for (Preference p : rc.iSelectedIntructionalMethods) {
                    this.iSelectedIntructionalMethods.add(new Preference(p));
                }
            }
            if (rc.iSelectedClasses != null) {
                this.iSelectedClasses = new HashSet<Preference>();
                for (Preference p : rc.iSelectedClasses) {
                    this.iSelectedClasses.add(new Preference(p));
                }
            }
            this.iCredit = rc.iCredit;
            this.iStatus = rc.iStatus;
            this.iStatusNote = rc.iStatusNote;
            this.iOverrideExternalId = rc.iOverrideExternalId;
            this.iOverrideTimeStamp = rc.iOverrideTimeStamp;
            this.iRequestorNote = rc.iRequestorNote;
            this.iRequestorNoteSuggestions = rc.iRequestorNoteSuggestions;
            this.iRequestId = rc.iRequestId;
            this.iInactive = rc.iInactive;
            this.iCanWaitList = rc.iCanWaitList;
            this.iWaitListPosition = rc.iWaitListPosition;
            this.iChangedBy = rc.iChangedBy;
            this.iTimeStamp = rc.iTimeStamp;
        }

        public boolean isCourse() {
            return this.hasCourseId() || this.hasCourseName();
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public boolean hasCourseId() {
            return this.iCourseId != null;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public String getCourseName() {
            return this.iCourseName;
        }

        public boolean hasCourseName() {
            return this.iCourseName != null && !this.iCourseName.isEmpty();
        }

        public void setCourseName(String courseName) {
            this.iCourseName = courseName;
        }

        public String getCourseTitle() {
            return this.iCourseTitle;
        }

        public boolean hasCourseTitle() {
            return this.iCourseTitle != null && !this.iCourseTitle.isEmpty();
        }

        public void setCourseTitle(String courseTitle) {
            this.iCourseTitle = courseTitle;
        }

        public boolean hasCredit() {
            return this.iCredit != null;
        }

        public float[] getCredit() {
            return this.iCredit;
        }

        public Float getCreditMin() {
            return this.iCredit == null ? null : Float.valueOf(this.iCredit[0]);
        }

        public Float getCreditMax() {
            return this.iCredit == null ? null : Float.valueOf(this.iCredit[1]);
        }

        public void setCredit(Float minCredit, Float maxCredit) {
            float[] fArray;
            if (minCredit == null || maxCredit == null) {
                fArray = null;
            } else {
                float[] fArray2 = new float[2];
                fArray2[0] = minCredit.floatValue();
                fArray = fArray2;
                fArray2[1] = maxCredit.floatValue();
            }
            this.iCredit = fArray;
        }

        public void setCredit(Float credit) {
            float[] fArray;
            if (credit == null) {
                fArray = null;
            } else {
                float[] fArray2 = new float[2];
                fArray2[0] = credit.floatValue();
                fArray = fArray2;
                fArray2[1] = credit.floatValue();
            }
            this.iCredit = fArray;
        }

        public void setCredit(float[] credit) {
            this.iCredit = credit;
        }

        public void setStatus(RequestedCourseStatus status) {
            this.iStatus = status;
        }

        public RequestedCourseStatus getStatus() {
            return this.iStatus;
        }

        public void setStatusNote(String note) {
            this.iStatusNote = note == null ? null : note.replace("<br>", "\n");
        }

        public boolean hasStatusNote() {
            return this.iStatusNote != null && !this.iStatusNote.isEmpty() && !" ".equals(this.iStatusNote);
        }

        public String getStatusNote() {
            return this.iStatusNote;
        }

        public void setRequestorNote(String note) {
            this.iRequestorNote = note == null ? null : note.replace("<br>", "\n");
        }

        public boolean hasRequestorNote() {
            return this.iRequestorNote != null && !this.iRequestorNote.isEmpty() && !" ".equals(this.iRequestorNote);
        }

        public String getRequestorNote() {
            return this.iRequestorNote;
        }

        public boolean hasRequestorNoteSuggestions() {
            return this.iRequestorNoteSuggestions != null && !this.iRequestorNoteSuggestions.isEmpty();
        }

        public List<String> getRequestorNoteSuggestions() {
            return this.iRequestorNoteSuggestions;
        }

        public void addRequestorNoteSuggestion(String suggestion) {
            if (this.iRequestorNoteSuggestions == null) {
                this.iRequestorNoteSuggestions = new ArrayList<String>();
            }
            this.iRequestorNoteSuggestions.add(suggestion);
        }

        public void setRequestId(String id) {
            this.iRequestId = id;
        }

        public boolean hasRequestId() {
            return this.iRequestId != null && !this.iRequestId.isEmpty() && !" ".equals(this.iRequestId);
        }

        public String getRequestId() {
            return this.iRequestId;
        }

        public void setOverrideExternalId(String externalId) {
            this.iOverrideExternalId = externalId;
        }

        public String getOverrideExternalId() {
            return this.iOverrideExternalId;
        }

        public void setOverrideTimeStamp(Date timeStamp) {
            this.iOverrideTimeStamp = timeStamp;
        }

        public Date getOverrideTimeStamp() {
            return this.iOverrideTimeStamp;
        }

        public List<FreeTime> getFreeTime() {
            return this.iFreeTime;
        }

        public boolean isFreeTime() {
            return this.iFreeTime != null && !this.iFreeTime.isEmpty();
        }

        public void setFreeTime(List<FreeTime> freeTime) {
            this.iFreeTime = freeTime;
        }

        public void addFreeTime(FreeTime freeTime) {
            if (this.iFreeTime == null) {
                this.iFreeTime = new ArrayList<FreeTime>();
            }
            this.iFreeTime.add(freeTime);
        }

        public boolean isReadOnly() {
            return this.iReadOnly != null && this.iReadOnly != false;
        }

        public void setReadOnly(Boolean readOnly) {
            this.iReadOnly = readOnly;
        }

        public boolean isCanDelete() {
            return this.iCanDelete == null || this.iCanDelete != false;
        }

        public void setCanDelete(Boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean isCanChangePriority() {
            return this.iCanChangePriority == null || this.iCanChangePriority != false;
        }

        public void setCanChangePriority(Boolean canChangePriority) {
            this.iCanChangePriority = canChangePriority;
        }

        public boolean isCanChangeAlternatives() {
            return this.iCanChangeAlternatives == null || this.iCanChangeAlternatives != false;
        }

        public void setCanChangeAlternatives(Boolean canChangeAlternatives) {
            this.iCanChangeAlternatives = canChangeAlternatives;
        }

        public boolean isInactive() {
            return this.iInactive != null && this.iInactive != false;
        }

        public void setInactive(Boolean inactive) {
            this.iInactive = inactive;
        }

        public boolean isCanWaitList() {
            return this.iCanWaitList != null && this.iCanWaitList != false;
        }

        public void setCanWaitList(Boolean canWaitList) {
            this.iCanWaitList = canWaitList;
        }

        public boolean isCanNoSub() {
            return this.isCourse();
        }

        public boolean isEmpty() {
            return !this.isCourse() && !this.isFreeTime();
        }

        public boolean hasSelectedIntructionalMethods() {
            return this.iSelectedIntructionalMethods != null && !this.iSelectedIntructionalMethods.isEmpty();
        }

        public Set<Preference> getSelectedIntructionalMethods() {
            return this.iSelectedIntructionalMethods;
        }

        public void setSelectedIntructionalMethod(Long id, String text, boolean required, boolean value) {
            this.setSelectedIntructionalMethod(new Preference(id, text, required), value);
        }

        public void setSelectedIntructionalMethod(Preference p, boolean value) {
            if (this.iSelectedIntructionalMethods == null) {
                this.iSelectedIntructionalMethods = new HashSet<Preference>();
            }
            this.iSelectedIntructionalMethods.remove(p);
            if (value) {
                this.iSelectedIntructionalMethods.add(p);
            }
        }

        public boolean isSelectedIntructionalMethod(Long id) {
            if (this.iSelectedIntructionalMethods == null) {
                return false;
            }
            return this.iSelectedIntructionalMethods.contains(new Preference(id));
        }

        public Preference getIntructionalMethodSelection(Long id) {
            if (this.iSelectedIntructionalMethods == null || id == null) {
                return null;
            }
            for (Preference p : this.iSelectedIntructionalMethods) {
                if (!p.getId().equals(id)) continue;
                return p;
            }
            return null;
        }

        public boolean isSelectedIntructionalMethod(Long id, boolean required) {
            if (this.iSelectedIntructionalMethods == null) {
                return false;
            }
            for (Preference p : this.iSelectedIntructionalMethods) {
                if (!p.getId().equals(id) || p.isRequired() != required) continue;
                return true;
            }
            return false;
        }

        public boolean isSelectedIntructionalMethod(Preference p) {
            return this.isSelectedIntructionalMethod(p.getId(), p.isRequired());
        }

        public int getNrSelectedIntructionalMethods() {
            return this.iSelectedIntructionalMethods == null ? 0 : this.iSelectedIntructionalMethods.size();
        }

        public boolean sameSelectedIntructionalMethods(RequestedCourse rc) {
            if (this.getNrSelectedIntructionalMethods() != rc.getNrSelectedIntructionalMethods()) {
                return false;
            }
            if (this.hasSelectedIntructionalMethods()) {
                for (Preference p : this.getSelectedIntructionalMethods()) {
                    if (rc.isSelectedIntructionalMethod(p)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean hasSelectedClasses() {
            return this.iSelectedClasses != null && !this.iSelectedClasses.isEmpty();
        }

        public Set<Preference> getSelectedClasses() {
            return this.iSelectedClasses;
        }

        public void setSelectedClasses(Set<Preference> classes) {
            if (this.iSelectedClasses == null) {
                this.iSelectedClasses = new HashSet<Preference>();
            } else {
                this.iSelectedClasses.clear();
            }
            if (classes != null) {
                this.iSelectedClasses.addAll(classes);
            }
        }

        public void setSelectedClass(Long id, String text, boolean required, boolean value) {
            this.setSelectedClass(new Preference(id, text, required), value);
        }

        public void setSelectedClass(Preference p, boolean value) {
            if (this.iSelectedClasses == null) {
                this.iSelectedClasses = new HashSet<Preference>();
            }
            this.iSelectedClasses.remove(p);
            if (value) {
                this.iSelectedClasses.add(p);
            }
        }

        public boolean isSelectedClass(Long id) {
            if (this.iSelectedClasses == null || id == null) {
                return false;
            }
            return this.iSelectedClasses.contains(new Preference(id));
        }

        public Preference getClassSelection(Long id) {
            if (this.iSelectedClasses == null || id == null) {
                return null;
            }
            for (Preference p : this.iSelectedClasses) {
                if (!p.getId().equals(id)) continue;
                return p;
            }
            return null;
        }

        public boolean isSelectedClass(Long id, boolean required) {
            if (this.iSelectedClasses == null) {
                return false;
            }
            for (Preference p : this.iSelectedClasses) {
                if (!p.getId().equals(id) || p.isRequired() != required) continue;
                return true;
            }
            return false;
        }

        public boolean isSelectedClass(Preference p) {
            return this.isSelectedClass(p.getId(), p.isRequired());
        }

        public int getNrSelectedClasses() {
            return this.iSelectedClasses == null ? 0 : this.iSelectedClasses.size();
        }

        public boolean sameSelectedClasses(RequestedCourse rc) {
            if (this.getNrSelectedClasses() != rc.getNrSelectedClasses()) {
                return false;
            }
            if (this.hasSelectedClasses()) {
                for (Preference p : this.getSelectedClasses()) {
                    if (rc.isSelectedClass(p)) continue;
                    return false;
                }
            }
            return true;
        }

        public void clearSelection() {
            if (this.iSelectedClasses != null) {
                this.iSelectedClasses.clear();
            }
            if (this.iSelectedIntructionalMethods != null) {
                this.iSelectedIntructionalMethods.clear();
            }
        }

        public List<Preference> getRequiredPreferences() {
            ArrayList<Preference> ret = new ArrayList<Preference>();
            if (this.hasSelectedIntructionalMethods()) {
                for (Preference p : this.getSelectedIntructionalMethods()) {
                    if (!p.isRequired()) continue;
                    ret.add(p);
                }
            }
            if (this.hasSelectedClasses()) {
                for (Preference p : this.getSelectedClasses()) {
                    if (!p.isRequired()) continue;
                    ret.add(p);
                }
            }
            return ret;
        }

        public String getWaitListPosition() {
            return this.iWaitListPosition;
        }

        public void setWaitListPosition(String wlPosition) {
            this.iWaitListPosition = wlPosition;
        }

        public boolean hasWaitListPosition() {
            return this.iWaitListPosition != null && !this.iWaitListPosition.isEmpty();
        }

        public boolean hasChangedBy() {
            return this.iChangedBy != null && !this.iChangedBy.isEmpty();
        }

        public String getChangedBy() {
            return this.iChangedBy;
        }

        public void setChangedBy(String changedBy) {
            this.iChangedBy = changedBy;
        }

        public boolean hasTimeStamp() {
            return this.iTimeStamp != null;
        }

        public Date getTimeStamp() {
            return this.iTimeStamp;
        }

        public void setTimeStamp(Date ts) {
            this.iTimeStamp = ts;
        }

        public int hashCode() {
            return (this.isCourse() ? this.getCourseName() : this.toString()).toLowerCase().hashCode();
        }

        public String toString() {
            if (this.isCourse()) {
                return this.getCourseName() + (String)(this.hasSelectedIntructionalMethods() ? " method:" + String.valueOf(this.getSelectedIntructionalMethods()) : "") + (String)(this.hasSelectedClasses() ? " section:" + String.valueOf(this.getSelectedClasses()) : "") + (this.isReadOnly() ? " [S]" : "") + (this.hasCourseId() ? "[i]" : "");
            }
            if (this.isFreeTime()) {
                Object ret = "";
                for (FreeTime ft : this.getFreeTime()) {
                    ret = (String)ret + (((String)ret).isEmpty() ? "" : ", ") + ft.toString();
                }
                return ret;
            }
            return "N/A";
        }

        public String toString(StudentSectioningConstants CONSTANTS) {
            if (this.isCourse()) {
                return this.getCourseName();
            }
            if (this.isFreeTime()) {
                Object display = "";
                String lastDays = null;
                for (FreeTime ft : this.getFreeTime()) {
                    if (((String)display).length() > 0) {
                        display = (String)display + ", ";
                    }
                    String days = ft.getDaysString(CONSTANTS.shortDays(), "");
                    if (ft.getDays().size() == CONSTANTS.freeTimeDays().length && !ft.getDays().contains(5) && !ft.getDays().contains(6)) {
                        days = "";
                    }
                    display = (String)display + (String)(days.isEmpty() || days.equals(lastDays) ? "" : days + " ") + ft.getStartString(CONSTANTS.useAmPm()) + " - " + ft.getEndString(CONSTANTS.useAmPm());
                    lastDays = days;
                }
                return CONSTANTS.freePrefix() + (String)display;
            }
            return "";
        }

        public String toAriaString(StudentSectioningConstants CONSTANTS) {
            if (this.isCourse()) {
                return this.getCourseName();
            }
            if (this.isFreeTime()) {
                Object status = "";
                for (FreeTime ft : this.getFreeTime()) {
                    status = (String)status + (((String)status).isEmpty() ? "" : " ") + ft.toAriaString(CONSTANTS.longDays(), CONSTANTS.useAmPm());
                }
                return status;
            }
            return "";
        }

        public boolean equals(Object o) {
            IsSerializable c;
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return ((String)o).equalsIgnoreCase(this.getCourseName());
            }
            if (o instanceof Long) {
                return ((Long)o).equals(this.getCourseId());
            }
            if (o instanceof RequestedCourse) {
                c = (RequestedCourse)o;
                if (c.hasCourseId() && this.hasCourseId()) {
                    return this.getCourseId().equals(c.getCourseId());
                }
                if (c.hasCourseName() && this.hasCourseName()) {
                    return this.getCourseName().equalsIgnoreCase(c.getCourseName());
                }
                if (c.isFreeTime() && this.isFreeTime()) {
                    return c.getFreeTime().equals(this.getFreeTime());
                }
            }
            if (o instanceof ClassAssignmentInterface.CourseAssignment) {
                c = (ClassAssignmentInterface.CourseAssignment)o;
                if (this.hasCourseId()) {
                    return this.getCourseId().equals(c.getCourseId());
                }
                if (this.hasCourseName()) {
                    return this.getCourseName().equalsIgnoreCase(c.getCourseName()) || this.getCourseName().equalsIgnoreCase(c.getCourseNameWithTitle());
                }
            }
            if (o instanceof DegreePlanInterface.DegreeCourseInterface) {
                c = (DegreePlanInterface.DegreeCourseInterface)o;
                if (this.hasCourseId() && c.getCourseId() != null) {
                    return this.getCourseId().equals(c.getCourseId());
                }
                if (this.hasCourseName()) {
                    return this.getCourseName().equalsIgnoreCase(c.getCourseName()) || this.getCourseName().equalsIgnoreCase(c.getCourseNameWithTitle());
                }
            }
            return false;
        }

        @Override
        public int compareTo(RequestedCourse o) {
            return this.toString().compareToIgnoreCase(o.toString());
        }
    }

    public static enum RequestedCourseStatus implements IsSerializable,
    Serializable
    {
        NEW_REQUEST,
        ENROLLED,
        SAVED,
        OVERRIDE_APPROVED,
        OVERRIDE_CANCELLED,
        OVERRIDE_PENDING,
        OVERRIDE_NEEDED,
        OVERRIDE_REJECTED,
        CREDIT_LOW,
        CREDIT_HIGH,
        OVERRIDE_NOT_NEEDED,
        WAITLIST_INACTIVE;

    }

    public static class CheckCoursesResponse
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Set<CourseMessage> iMessages = new TreeSet<CourseMessage>();
        private Map<Integer, String[]> iConfirmationSetup = null;
        private String iErrorMessage = null;
        private String iCreditWarning = null;
        private String iCreditNote = null;
        private Float iMaxCreditNeeded = null;
        private RequestedCourseStatus iMaxCreditOverrideStatus = null;

        public CheckCoursesResponse() {
        }

        public CheckCoursesResponse(Collection<CourseMessage> messages) {
            if (messages != null && !messages.isEmpty()) {
                this.iMessages = new TreeSet<CourseMessage>(messages);
            }
        }

        public boolean hasMessages() {
            return this.iMessages != null && !this.iMessages.isEmpty();
        }

        public Set<CourseMessage> getMessages() {
            return this.iMessages;
        }

        public void addMessage(CourseMessage message) {
            this.iMessages.add(message);
        }

        public CourseMessage addMessage(Long courseId, String course, String code, String message, Integer confirm, int order) {
            CourseMessage m = new CourseMessage();
            m.setCourseId(courseId);
            m.setCourse(course);
            m.setCode(code);
            m.setMessage(message);
            m.setError(false);
            m.setConfirm(confirm);
            m.setOrder(order);
            this.addMessage(m);
            return m;
        }

        public CourseMessage addMessage(Long courseId, String course, String code, String message, Integer confirm) {
            CourseMessage m = new CourseMessage();
            m.setCourseId(courseId);
            m.setCourse(course);
            m.setCode(code);
            m.setMessage(message);
            m.setError(false);
            m.setConfirm(confirm);
            m.setOrder(0);
            this.addMessage(m);
            return m;
        }

        public CourseMessage addError(Long courseId, String course, String code, String message) {
            CourseMessage m = new CourseMessage();
            m.setCourseId(courseId);
            m.setCourse(course);
            m.setCode(code);
            m.setMessage(message);
            m.setError(true);
            m.setConfirm(null);
            this.addMessage(m);
            return m;
        }

        public CourseMessage addConfirmation(String message, Integer confirm, Integer order) {
            CourseMessage m = new CourseMessage();
            m.setCode("CONF_MSG");
            m.setMessage(message);
            m.setError(false);
            m.setConfirm(confirm);
            m.setOrder(order);
            this.addMessage(m);
            return m;
        }

        public CourseMessage addCheckBox(String message, Integer confirm, Integer order) {
            CourseMessage m = new CourseMessage();
            m.setCode("CHECK_BOX");
            m.setMessage(message);
            m.setError(false);
            m.setConfirm(confirm);
            m.setOrder(order);
            this.addMessage(m);
            return m;
        }

        public boolean isError() {
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.isError()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isOK() {
            return !this.hasMessages();
        }

        public boolean isWarning() {
            return this.hasMessages() && !this.isError();
        }

        public boolean isConfirm() {
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.isConfirm()) continue;
                    return true;
                }
            }
            return false;
        }

        public Set<Integer> getConfirms() {
            TreeSet<Integer> ret = new TreeSet<Integer>();
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.isConfirm()) continue;
                    ret.add(m.getConfirm());
                }
            }
            return ret;
        }

        public Float getMaxCreditNeeded() {
            return this.iMaxCreditNeeded;
        }

        public void setMaxCreditNeeded(Float maxCreditNeeded) {
            this.iMaxCreditNeeded = maxCreditNeeded;
        }

        public List<CourseMessage> getMessages(String courseName) {
            ArrayList<CourseMessage> ret = new ArrayList<CourseMessage>();
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse())) continue;
                    ret.add(m);
                }
            }
            return ret;
        }

        public List<CourseMessage> getMessages(int confirm) {
            ArrayList<CourseMessage> ret = new ArrayList<CourseMessage>();
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || confirm != m.getConfirm()) continue;
                    ret.add(m);
                }
            }
            return ret;
        }

        public String getMessage(String courseName, String delim, String ... exclude) {
            if (!this.hasMessages()) {
                return null;
            }
            Object ret = null;
            if (this.hasMessages()) {
                block0: for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse())) continue;
                    for (String e : exclude) {
                        if (e.equals(m.getCode())) continue block0;
                    }
                    if (ret == null) {
                        ret = m.getMessage();
                        continue;
                    }
                    ret = (String)ret + delim + m.getMessage();
                }
            }
            return ret;
        }

        public RequestedCourseStatus getStatus(String courseName) {
            RequestedCourseStatus status = null;
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (m.getStatus() == null || !m.hasCourse() || !courseName.equals(m.getCourse()) || status != null && m.getStatus().ordinal() <= status.ordinal()) continue;
                    status = m.getStatus();
                }
            }
            return status;
        }

        public String getMessageWithColor(String courseName, String delim, String ... exclude) {
            if (!this.hasMessages()) {
                return null;
            }
            String ret = null;
            if (this.hasMessages()) {
                block0: for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse())) continue;
                    for (String e : exclude) {
                        if (e.equals(m.getCode())) continue block0;
                    }
                    if (ret == null) {
                        ret = (m.isError() ? "<span class='text-red'>" : "<span class='text-orange'>") + m.getMessage() + "</span>";
                        continue;
                    }
                    ret = ret + delim + (m.isError() ? "<span class='text-red'>" : "<span class='text-orange'>") + m.getMessage() + "</span>";
                }
            }
            return ret;
        }

        public boolean hasMessage(String courseName, String code) {
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse()) || !code.equals(m.getCode())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isError(String courseName) {
            if (!this.hasMessages()) {
                return false;
            }
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse()) || !m.isError()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isConfirm(String courseName) {
            if (!this.hasMessages()) {
                return false;
            }
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (!m.hasCourse() || !courseName.equals(m.getCourse()) || !m.isConfirm()) continue;
                    return true;
                }
            }
            return false;
        }

        public String getConfirmations(int confirm, String delim) {
            if (!this.hasMessages()) {
                return null;
            }
            String ret = null;
            if (this.hasMessages()) {
                for (CourseMessage m : this.getMessages()) {
                    if (confirm != m.getConfirm()) continue;
                    if (ret == null) {
                        ret = (String)(m.hasCourse() ? m.getCourse() + ": " : "") + m.getMessage();
                        continue;
                    }
                    ret = ret + delim + (String)(m.hasCourse() ? m.getCourse() + ": " : "") + m.getMessage();
                }
            }
            return ret;
        }

        public void setConfirmation(int confirm, String dialogTitle, String yesButton, String noButton, String yesButtonTitle, String noButtonTitle) {
            if (this.iConfirmationSetup == null) {
                this.iConfirmationSetup = new HashMap<Integer, String[]>();
            }
            this.iConfirmationSetup.put(confirm, new String[]{dialogTitle, yesButton, noButton, yesButtonTitle, noButtonTitle});
        }

        public String getConfirmationTitle(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[0] == null ? defaultTitle : confirmation[0];
        }

        public String getConfirmationYesButton(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[1] == null ? defaultTitle : confirmation[1];
        }

        public String getConfirmationNoButton(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[2] == null ? defaultTitle : confirmation[2];
        }

        public String getConfirmationYesButtonTitle(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[3] == null ? defaultTitle : confirmation[3];
        }

        public String getConfirmationNoButtonTitle(int confirm, String defaultTitle) {
            if (this.iConfirmationSetup == null) {
                return defaultTitle;
            }
            String[] confirmation = this.iConfirmationSetup.get(confirm);
            return confirmation == null || confirmation[4] == null ? defaultTitle : confirmation[4];
        }

        public boolean hasErrorMessage() {
            return this.iErrorMessage != null && !this.iErrorMessage.isEmpty();
        }

        public void setErrorMessage(String message) {
            if (this.iErrorMessage == null) {
                this.iErrorMessage = message;
            } else if (!this.iErrorMessage.contains(message)) {
                this.iErrorMessage = this.iErrorMessage + "\n" + message;
            }
        }

        public String getErrorMessage() {
            return this.iErrorMessage;
        }

        public boolean hasCreditWarning() {
            return this.iCreditWarning != null && !this.iCreditWarning.isEmpty();
        }

        public String getCreditWarning() {
            return this.iCreditWarning;
        }

        public void setCreditWarning(String warning) {
            this.iCreditWarning = warning;
        }

        public boolean hasCreditNote() {
            return this.iCreditNote != null && !this.iCreditNote.isEmpty() && !" ".equals(this.iCreditNote);
        }

        public String getCreditNote() {
            return this.iCreditNote;
        }

        public void setCreditNote(String note) {
            this.iCreditNote = note;
        }

        public void setMaxCreditOverrideStatus(RequestedCourseStatus status) {
            this.iMaxCreditOverrideStatus = status;
        }

        public RequestedCourseStatus getMaxCreditOverrideStatus() {
            return this.iMaxCreditOverrideStatus;
        }

        public String toString() {
            return this.hasMessages() ? this.getMessages().toString() : "[]";
        }
    }

    public static class Request
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<RequestedCourse> iRequestedCourse = null;
        private Boolean iWaitList = false;
        private Boolean iNoSub = false;
        private Integer iCritical = null;
        private Date iTimeStamp = null;
        private Date iWaitListedTimeStamp = null;
        private String iFilter = null;
        private String iAdvisorCredit = null;
        private String iAdvisorNote = null;
        private Long iWaitListSwapWithCourseOfferingId = null;
        private String iChangedBy = null;

        public Request() {
        }

        public Request(Request request) {
            if (request.iRequestedCourse != null) {
                this.iRequestedCourse = new ArrayList<RequestedCourse>();
                for (RequestedCourse rc : request.iRequestedCourse) {
                    this.iRequestedCourse.add(new RequestedCourse(rc));
                }
            }
            this.iWaitList = request.iWaitList;
            this.iNoSub = request.iNoSub;
            this.iCritical = request.iCritical;
            this.iTimeStamp = request.iTimeStamp;
            this.iWaitListedTimeStamp = request.iWaitListedTimeStamp;
            this.iFilter = request.iFilter;
            this.iAdvisorCredit = request.iAdvisorCredit;
            this.iAdvisorNote = request.iAdvisorNote;
            this.iWaitListSwapWithCourseOfferingId = request.iWaitListSwapWithCourseOfferingId;
            this.iChangedBy = request.iChangedBy;
        }

        public List<RequestedCourse> getRequestedCourse() {
            return this.iRequestedCourse;
        }

        public int countRequestedCourses() {
            return this.iRequestedCourse == null ? 0 : this.iRequestedCourse.size();
        }

        public RequestedCourse getRequestedCourse(int index) {
            if (this.iRequestedCourse != null && index < this.iRequestedCourse.size()) {
                return this.iRequestedCourse.get(index);
            }
            return null;
        }

        public RequestedCourse getRequestedCourse(Long courseId) {
            if (this.iRequestedCourse == null) {
                return null;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!courseId.equals(rc.getCourseId())) continue;
                return rc;
            }
            return null;
        }

        public int getIndex(Long courseId) {
            if (this.iRequestedCourse == null) {
                return -1;
            }
            for (int i = 0; i < this.iRequestedCourse.size(); ++i) {
                if (!courseId.equals(this.iRequestedCourse.get(i).getCourseId())) continue;
                return i;
            }
            return -1;
        }

        public boolean hasRequestedCourse() {
            return this.iRequestedCourse != null && !this.iRequestedCourse.isEmpty();
        }

        public void addRequestedCourse(RequestedCourse requestedCourse) {
            if (this.iRequestedCourse == null) {
                this.iRequestedCourse = new ArrayList<RequestedCourse>();
            }
            this.iRequestedCourse.add(requestedCourse);
        }

        public boolean hasRequestedCourse(ClassAssignmentInterface.CourseAssignment course) {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.equals(course)) continue;
                return true;
            }
            return false;
        }

        public boolean hasRequestedCourse(RequestedCourse course) {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.equals(course)) continue;
                return true;
            }
            return false;
        }

        public boolean hasRequestedCourseActive(RequestedCourse course) {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.equals(course) || rc.isInactive()) continue;
                return true;
            }
            return false;
        }

        public RequestedCourse update(RequestedCourse rc) {
            if (this.iRequestedCourse == null) {
                return null;
            }
            for (int i = 0; i < this.iRequestedCourse.size(); ++i) {
                RequestedCourse old = this.iRequestedCourse.get(i);
                if (!rc.equals(old)) continue;
                this.iRequestedCourse.set(i, rc);
                return old;
            }
            return null;
        }

        public boolean isEmpty() {
            return !this.hasRequestedCourse();
        }

        public boolean isReadOnly() {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (!rc.isReadOnly()) continue;
                return true;
            }
            return false;
        }

        public boolean isCanDelete() {
            if (this.iRequestedCourse == null) {
                return true;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (rc.isCanDelete()) continue;
                return false;
            }
            return true;
        }

        public boolean isCanChangePriority() {
            if (this.iRequestedCourse == null) {
                return true;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (rc.isCanChangePriority()) continue;
                return false;
            }
            return true;
        }

        public boolean isCanChangeAlternatives() {
            if (this.iRequestedCourse == null) {
                return true;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (rc.isCanChangeAlternatives()) continue;
                return false;
            }
            return true;
        }

        public boolean hasWaitList() {
            return this.iWaitList != null;
        }

        public boolean isWaitList() {
            return this.iWaitList != null && this.iWaitList != false;
        }

        public void setWaitList(Boolean waitList) {
            this.iWaitList = waitList;
        }

        public boolean isWaitListOrNoSub(OnlineSectioningInterface.WaitListMode wlMode, Set<Long> advisorWaitListedCourseIds) {
            if (wlMode == OnlineSectioningInterface.WaitListMode.WaitList && this.isCanWaitList() && this.iWaitList != null && this.iWaitList.booleanValue()) {
                return true;
            }
            if (wlMode == OnlineSectioningInterface.WaitListMode.NoSubs && this.iNoSub != null && this.iNoSub.booleanValue()) {
                return true;
            }
            if (advisorWaitListedCourseIds != null && this.hasRequestedCourse()) {
                for (RequestedCourse rc : this.getRequestedCourse()) {
                    if (!rc.hasCourseId() || !advisorWaitListedCourseIds.contains(rc.getCourseId())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isCanWaitList() {
            RequestedCourse rc;
            if (this.iRequestedCourse == null) {
                return false;
            }
            Iterator<RequestedCourse> iterator = this.iRequestedCourse.iterator();
            return iterator.hasNext() && (rc = iterator.next()).isCanWaitList();
        }

        public boolean hasCourseId() {
            RequestedCourse rc;
            if (this.iRequestedCourse == null) {
                return false;
            }
            Iterator<RequestedCourse> iterator = this.iRequestedCourse.iterator();
            return iterator.hasNext() && (rc = iterator.next()).hasCourseId();
        }

        public boolean hasNoSub() {
            return this.iNoSub != null;
        }

        public boolean isNoSub() {
            return this.iNoSub != null && this.iNoSub != false;
        }

        public void setNoSub(Boolean noSub) {
            this.iNoSub = noSub;
        }

        public boolean isCanNoSub() {
            RequestedCourse rc;
            if (this.iRequestedCourse == null) {
                return false;
            }
            Iterator<RequestedCourse> iterator = this.iRequestedCourse.iterator();
            return iterator.hasNext() && (rc = iterator.next()).hasCourseId();
        }

        public boolean isWaitlistOrNoSub(OnlineSectioningInterface.WaitListMode wlMode) {
            if (wlMode == OnlineSectioningInterface.WaitListMode.WaitList) {
                return this.isWaitList();
            }
            if (wlMode == OnlineSectioningInterface.WaitListMode.NoSubs) {
                return this.isNoSub();
            }
            return false;
        }

        public boolean hasWaitListSwapWithCourseOfferingId() {
            return this.iWaitListSwapWithCourseOfferingId != null;
        }

        public void setWaitListSwapWithCourseOfferingId(Long courseId) {
            this.iWaitListSwapWithCourseOfferingId = courseId;
        }

        public Long getWaitListSwapWithCourseOfferingId() {
            return this.iWaitListSwapWithCourseOfferingId;
        }

        public boolean hasCritical() {
            return this.iCritical != null;
        }

        public boolean isCritical() {
            return this.iCritical != null && this.iCritical == 1;
        }

        public boolean isImportant() {
            return this.iCritical != null && this.iCritical == 2;
        }

        public boolean isVital() {
            return this.iCritical != null && this.iCritical == 3;
        }

        public boolean isLC() {
            return this.iCritical != null && this.iCritical == 4;
        }

        public boolean isImportantOrMore() {
            return this.iCritical != null && this.iCritical > 0 && this.iCritical != 5;
        }

        public boolean isVisitingF2F() {
            return this.iCritical != null && this.iCritical == 5;
        }

        public Integer getCritical() {
            return this.iCritical;
        }

        public void setCritical(Integer critical) {
            this.iCritical = critical;
        }

        public boolean hasTimeStamp() {
            return this.iTimeStamp != null;
        }

        public Date getTimeStamp() {
            return this.iTimeStamp;
        }

        public void setTimeStamp(Date ts) {
            this.iTimeStamp = ts;
        }

        public boolean hasWaitListedTimeStamp() {
            return this.iWaitListedTimeStamp != null;
        }

        public Date getWaitListedTimeStamp() {
            return this.iWaitListedTimeStamp;
        }

        public void setWaitListedTimeStamp(Date ts) {
            this.iWaitListedTimeStamp = ts;
        }

        public boolean hasFilter() {
            return this.iFilter != null && !this.iFilter.isEmpty();
        }

        public String getFilter() {
            return this.iFilter;
        }

        public void setFilter(String filter) {
            this.iFilter = filter;
        }

        public boolean hasAdvisorCredit() {
            return this.iAdvisorCredit != null && !this.iAdvisorCredit.isEmpty();
        }

        public String getAdvisorCredit() {
            return this.iAdvisorCredit;
        }

        public void setAdvisorCredit(String credit) {
            this.iAdvisorCredit = credit;
        }

        public float getAdvisorCreditMin() {
            if (this.iAdvisorCredit == null || this.iAdvisorCredit.isEmpty()) {
                return 0.0f;
            }
            try {
                return Float.parseFloat(this.iAdvisorCredit.replaceAll("\\s", ""));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.iAdvisorCredit.contains("-")) {
                    try {
                        return Float.parseFloat(this.iAdvisorCredit.substring(0, this.iAdvisorCredit.indexOf(45)).replaceAll("\\s", ""));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
                return 0.0f;
            }
        }

        public float getAdvisorCreditMax() {
            if (this.iAdvisorCredit == null || this.iAdvisorCredit.isEmpty()) {
                return 0.0f;
            }
            try {
                return Float.parseFloat(this.iAdvisorCredit.replaceAll("\\s", ""));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.iAdvisorCredit.contains("-")) {
                    try {
                        return Float.parseFloat(this.iAdvisorCredit.substring(1 + this.iAdvisorCredit.indexOf(45)).replaceAll("\\s", ""));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
                return 0.0f;
            }
        }

        public boolean hasAdvisorNote() {
            return this.iAdvisorNote != null && !this.iAdvisorNote.isEmpty();
        }

        public String getAdvisorNote() {
            return this.iAdvisorNote;
        }

        public void setAdvisorNote(String note) {
            this.iAdvisorNote = note;
        }

        public void addAdvisorNote(String note) {
            if (this.iAdvisorNote == null) {
                this.iAdvisorNote = note;
            } else if (!this.iAdvisorNote.contains(note)) {
                this.iAdvisorNote = this.iAdvisorNote + "\n" + note;
            }
        }

        public List<Long> getCourseIds() {
            ArrayList<Long> ids = new ArrayList<Long>(this.iRequestedCourse == null ? 0 : this.iRequestedCourse.size());
            if (this.iRequestedCourse != null) {
                for (RequestedCourse rc : this.iRequestedCourse) {
                    if (!rc.hasCourseId()) continue;
                    ids.add(rc.getCourseId());
                }
            }
            return ids;
        }

        public boolean isInactive() {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (rc.isInactive()) continue;
                return false;
            }
            return true;
        }

        public boolean isActive() {
            if (this.iRequestedCourse == null) {
                return false;
            }
            for (RequestedCourse rc : this.iRequestedCourse) {
                if (rc.isInactive()) continue;
                return true;
            }
            return false;
        }

        public boolean hasChangedBy() {
            return this.iChangedBy != null && !this.iChangedBy.isEmpty();
        }

        public String getChangedBy() {
            return this.iChangedBy;
        }

        public void setChangedBy(String changedBy) {
            this.iChangedBy = changedBy;
        }

        public String toString() {
            return (this.hasRequestedCourse() ? this.iRequestedCourse.toString() : "-") + (this.isWaitList() ? " (w)" : "");
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Request)) {
                return false;
            }
            Request r = (Request)o;
            if (this.isWaitList() != r.isWaitList() || this.isNoSub() != r.isNoSub() || this.countRequestedCourses() != r.countRequestedCourses()) {
                return false;
            }
            for (int i = 0; i < this.countRequestedCourses(); ++i) {
                RequestedCourse c2;
                RequestedCourse c1 = this.getRequestedCourse(i);
                if (c1.equals(c2 = r.getRequestedCourse(i)) && c1.sameSelectedClasses(c2) && c1.sameSelectedIntructionalMethods(c2)) continue;
                return false;
            }
            if (!(this.hasAdvisorNote() ? this.getAdvisorNote() : "").equals(r.hasAdvisorNote() ? r.getAdvisorNote() : "")) {
                return false;
            }
            if (!(this.hasAdvisorCredit() ? this.getAdvisorCredit() : "").equals(r.hasAdvisorCredit() ? r.getAdvisorCredit() : "")) {
                return false;
            }
            return (this.hasWaitListSwapWithCourseOfferingId() ? this.getWaitListSwapWithCourseOfferingId() : Long.valueOf(0L)).equals(r.hasWaitListSwapWithCourseOfferingId() ? r.getWaitListSwapWithCourseOfferingId() : Long.valueOf(0L));
        }

        public boolean sameCourses(Request r) {
            if (this.countRequestedCourses() != r.countRequestedCourses()) {
                return false;
            }
            for (int i = 0; i < this.countRequestedCourses(); ++i) {
                RequestedCourse c2;
                RequestedCourse c1 = this.getRequestedCourse(i);
                if (c1.equals(c2 = r.getRequestedCourse(i)) && c1.sameSelectedClasses(c2) && c1.sameSelectedIntructionalMethods(c2)) continue;
                return false;
            }
            return (this.hasWaitListSwapWithCourseOfferingId() ? this.getWaitListSwapWithCourseOfferingId() : Long.valueOf(0L)).equals(r.hasWaitListSwapWithCourseOfferingId() ? r.getWaitListSwapWithCourseOfferingId() : Long.valueOf(0L));
        }
    }

    public static class RequestPriority
    implements IsSerializable,
    Serializable,
    Comparable<RequestPriority> {
        private static final long serialVersionUID = 1L;
        private boolean iAlternative = false;
        private int iPriority = 0;
        private int iChoice = 0;
        private Request iRequest;

        RequestPriority(boolean alternative, int priority, int choice, Request request) {
            this.iAlternative = alternative;
            this.iPriority = priority;
            this.iChoice = choice;
            this.iRequest = request;
        }

        public boolean isAlternative() {
            return this.iAlternative;
        }

        public int getPriority() {
            return this.iPriority;
        }

        public int getChoice() {
            return this.iChoice;
        }

        public Request getRequest() {
            return this.iRequest;
        }

        public String toString() {
            if (this.iAlternative) {
                switch (this.iChoice) {
                    case 0: {
                        return "Alt " + this.iPriority + ".";
                    }
                    case 1: {
                        return "Alt " + this.iPriority + "A.";
                    }
                }
                return "Alt " + this.iPriority + "B.";
            }
            switch (this.iChoice) {
                case 0: {
                    return this.iPriority + ".";
                }
                case 1: {
                    return this.iPriority + "A.";
                }
            }
            return this.iPriority + "B.";
        }

        public String toString(StudentSectioningMessages MESSAGES) {
            if (this.iAlternative) {
                switch (this.iChoice) {
                    case 0: {
                        return MESSAGES.degreeRequestedAlternative(this.iPriority);
                    }
                    case 1: {
                        return MESSAGES.degreeRequestedAlternativeFirstAlt(this.iPriority);
                    }
                    case 2: {
                        return MESSAGES.degreeRequestedAlternativeSecondAlt(this.iPriority);
                    }
                }
                return MESSAGES.degreeRequestedCourseAlt(this.iPriority, this.iChoice > 26 ? "" + (char)(65 + (this.iChoice - 27) / 26) + (char)(65 + (this.iChoice - 1) % 26) : "" + (char)(65 + (this.iChoice - 1) % 26));
            }
            switch (this.iChoice) {
                case 0: {
                    return MESSAGES.degreeRequestedCourse(this.iPriority);
                }
                case 1: {
                    return MESSAGES.degreeRequestedCourseFirstAlt(this.iPriority);
                }
                case 2: {
                    return MESSAGES.degreeRequestedCourseSecondAlt(this.iPriority);
                }
            }
            return MESSAGES.degreeRequestedCourseAlt(this.iPriority, this.iChoice > 26 ? "" + (char)(65 + (this.iChoice - 27) / 26) + (char)(65 + (this.iChoice - 1) % 26) : "" + (char)(65 + (this.iChoice - 1) % 26));
        }

        @Override
        public int compareTo(RequestPriority p) {
            if (this.isAlternative() != p.isAlternative()) {
                return this.isAlternative() ? 1 : -1;
            }
            if (this.getPriority() != p.getPriority()) {
                return this.getPriority() < p.getPriority() ? -1 : 1;
            }
            if (this.getChoice() != p.getChoice()) {
                return this.getChoice() < p.getChoice() ? -1 : 1;
            }
            return 0;
        }
    }

    public static class CourseMessage
    implements IsSerializable,
    Serializable,
    Comparable<CourseMessage> {
        private static final long serialVersionUID = 1L;
        private Long iCourseId;
        private String iCourse;
        private boolean iError = true;
        private String iMessage;
        private String iCode;
        private Integer iConfirm;
        private Integer iOrder;
        private RequestedCourseStatus iStatus;
        private List<String> iSuggestions;

        public Long getCourseId() {
            return this.iCourseId;
        }

        public boolean hasCourseId() {
            return this.iCourseId != null;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public boolean hasCourse() {
            return this.iCourse != null && !this.iCourse.isEmpty();
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public boolean isError() {
            return this.iError;
        }

        public void setError(boolean error) {
            this.iError = error;
        }

        public boolean isConfirm() {
            return this.iConfirm != null;
        }

        public void setConfirm(Integer confirm) {
            this.iConfirm = confirm;
        }

        public int getConfirm() {
            return this.iConfirm == null ? -1 : this.iConfirm;
        }

        public void setOrder(Integer order) {
            this.iOrder = order;
        }

        public boolean hasOrder() {
            return this.iOrder != null;
        }

        public int getOrder() {
            return this.iOrder == null ? Integer.MAX_VALUE : this.iOrder;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public boolean hasSuggestions() {
            return this.iSuggestions != null && !this.iSuggestions.isEmpty();
        }

        public List<String> getSuggestions() {
            return this.iSuggestions;
        }

        public void addSuggestion(String suggestion) {
            if (this.iSuggestions == null) {
                this.iSuggestions = new ArrayList<String>();
            }
            this.iSuggestions.add(suggestion);
        }

        public RequestedCourseStatus getStatus() {
            return this.iStatus;
        }

        public CourseMessage setStatus(RequestedCourseStatus status) {
            this.iStatus = status;
            return this;
        }

        public String toString() {
            return (String)(this.hasCourse() ? this.getCourse() + ": " : "") + this.getMessage() + (String)(this.getStatus() == null ? "" : " (" + String.valueOf(this.getStatus()) + ")");
        }

        public int hashCode() {
            return ((String)(this.hasCourse() ? this.getCourse() + ":" + this.getCode() : this.getCode())).hashCode();
        }

        protected int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compareTo(CourseMessage m) {
            int cmp = this.compare(this.getConfirm(), m.getConfirm());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compare(this.getOrder(), m.getOrder());
            if (cmp != 0) {
                return cmp;
            }
            if (this.hasCourse() != m.hasCourse()) {
                return this.hasCourse() ? -1 : 1;
            }
            if (this.hasCourse() && (cmp = this.getCourse().compareTo(m.getCourse())) != 0) {
                return cmp;
            }
            return this.getCode().compareTo(m.getCode());
        }
    }

    public static class Filter
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Date iClassFrom;
        private Date iClassTo;
        private Integer iDaysFrom;
        private Integer iDaysTo;
        private Float iCreditMin;
        private Float iCreditMax;
        private String iInstructor;

        public Date getClassFrom() {
            return this.iClassFrom;
        }

        public void setClassFrom(Date classFrom) {
            this.iClassFrom = classFrom;
        }

        public Date getClassTo() {
            return this.iClassTo;
        }

        public void setClassTo(Date classTo) {
            this.iClassTo = classTo;
        }

        public boolean hasDates() {
            return this.iClassTo != null || this.iClassFrom != null;
        }

        public void setDaysFrom(Integer days) {
            this.iDaysFrom = days;
        }

        public Integer getDaysFrom() {
            return this.iDaysFrom;
        }

        public void setDaysTo(Integer days) {
            this.iDaysTo = days;
        }

        public Integer getDaysTo() {
            return this.iDaysTo;
        }

        public Float getCreditMin() {
            return this.iCreditMin;
        }

        public void setCreditMin(Float creditMin) {
            this.iCreditMin = creditMin;
        }

        public Float getCreditMax() {
            return this.iCreditMax;
        }

        public void setCreditMax(Float creditMax) {
            this.iCreditMax = creditMax;
        }

        public String getInstructor() {
            return this.iInstructor;
        }

        public boolean hasInstructor() {
            return this.iInstructor != null && !this.iInstructor.isEmpty();
        }

        public void setInstructor(String instructor) {
            this.iInstructor = instructor;
        }

        public boolean isEmpty() {
            return this.iClassFrom == null && this.iClassTo == null && this.iCreditMin == null && this.iCreditMax == null && (this.iInstructor == null || this.iInstructor.isEmpty());
        }

        public String toString() {
            Object ret = "";
            if (this.getCreditMin() != null && this.getCreditMax() != null) {
                ret = this.getCreditMin().equals(this.getCreditMax()) ? (String)ret + (((String)ret).isEmpty() ? "" : " ") + "credit:" + this.getCreditMin() : (String)ret + (((String)ret).isEmpty() ? "" : " ") + "credit:" + this.getCreditMin() + ".." + this.getCreditMax();
            } else if (this.getCreditMin() != null) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : " ") + "credit:>=" + this.getCreditMin();
            } else if (this.getCreditMax() != null) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : " ") + "credit:<=" + this.getCreditMax();
            }
            if (this.getClassFrom() != null) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : " ") + "from:" + String.valueOf(this.getClassFrom());
            }
            if (this.getClassTo() != null) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : " ") + "to:" + String.valueOf(this.getClassTo());
            }
            if (this.hasInstructor()) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : " ") + "instructor:" + this.getInstructor();
            }
            return ret;
        }
    }

    public static enum CriticalLevel implements IsSerializable
    {
        Critical,
        Important,
        Vital;

    }

    public static class Preference
    implements IsSerializable,
    Serializable,
    Comparable<Preference> {
        private static final long serialVersionUID = 1L;
        Long iId;
        String iText;
        boolean iRequired;

        public Preference() {
        }

        public Preference(Long id, String text, boolean required) {
            this.iId = id;
            this.iText = text;
            this.iRequired = required;
        }

        public Preference(Long id) {
            this.iId = id;
        }

        public Preference(Preference p) {
            this.iId = p.iId;
            this.iText = p.iText;
            this.iRequired = p.iRequired;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getText() {
            return this.iText;
        }

        public void setText(String text) {
            this.iText = text;
        }

        public boolean isRequired() {
            return this.iRequired;
        }

        public void setRequired(boolean required) {
            this.iRequired = required;
        }

        public String toString() {
            return this.getText() + (this.isRequired() ? "!" : "");
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Preference)) {
                return false;
            }
            return this.getId().equals(((Preference)o).getId());
        }

        @Override
        public int compareTo(Preference p) {
            return this.getText().compareTo(p.getText());
        }
    }

    public static class FreeTime
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ArrayList<Integer> iDays = new ArrayList();
        private int iStart;
        private int iLength;

        public FreeTime() {
        }

        public FreeTime(List<Integer> days, int start, int length) {
            if (days != null) {
                this.iDays.addAll(days);
            }
            this.iStart = start;
            this.iLength = length;
        }

        public FreeTime(FreeTime ft) {
            this.iDays.addAll(ft.iDays);
            this.iStart = ft.iStart;
            this.iLength = ft.iLength;
        }

        public void addDay(int day) {
            this.iDays.add(day);
        }

        public ArrayList<Integer> getDays() {
            return this.iDays;
        }

        public String getDaysString(String[] shortDays, String separator) {
            if (this.iDays == null) {
                return "";
            }
            Object ret = "";
            for (int day : this.iDays) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : separator) + shortDays[day];
            }
            return ret;
        }

        public int getDayCode() {
            int ret = 0;
            for (int day : this.iDays) {
                ret += 1 << 6 - day;
            }
            return ret;
        }

        public int getStart() {
            return this.iStart;
        }

        public void setStart(int startSlot) {
            this.iStart = startSlot;
        }

        public String getStartString(boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public String getEndString(boolean useAmPm) {
            int h = (this.iStart + this.iLength) / 12;
            int m = 5 * ((this.iStart + this.iLength) % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String toString(String[] shortDays, boolean useAmPm) {
            return this.getDaysString(shortDays, "") + " " + this.getStartString(useAmPm) + " - " + this.getEndString(useAmPm);
        }

        public String toString() {
            return "Free " + this.toString(new String[]{"M", "T", "W", "R", "F", "S", "U"}, true);
        }

        public String toAriaString(String[] longDays, boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            String ret = this.getDaysString(longDays, " ") + " from ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (String)(m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            h = (this.iStart + this.iLength) / 12;
            m = 5 * ((this.iStart + this.iLength) % 12);
            ret = ret + " to ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (String)(m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            return ret;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof FreeTime)) {
                return false;
            }
            FreeTime f = (FreeTime)o;
            return f.getStart() == this.getStart() && f.getLength() == this.getLength() && f.getDayCode() == this.getDayCode();
        }
    }
}

